/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Listener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngineExecutor;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@OnlyIn(value=Dist.CLIENT)
public class SoundEngine {
    private static final Marker field_148623_a = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger field_148621_b = LogManager.getLogger();
    private static final Set<ResourceLocation> field_188775_c = Sets.newHashSet();
    public final SoundHandler field_148622_c;
    private final GameSettings field_148619_d;
    private boolean field_148617_f;
    private final SoundSystem field_217937_g = new SoundSystem();
    private final Listener field_217938_h = this.field_217937_g.func_216407_c();
    private final AudioStreamManager field_217939_i;
    private final SoundEngineExecutor field_217940_j = new SoundEngineExecutor();
    private final ChannelManager field_217941_k = new ChannelManager(this.field_217937_g, (Executor)this.field_217940_j);
    private int field_148618_g;
    private final Map<ISound, ChannelManager.Entry> field_217942_m = Maps.newHashMap();
    private final Multimap<SoundCategory, ISound> field_217943_n = HashMultimap.create();
    private final List<ITickableSound> field_148625_l = Lists.newArrayList();
    private final Map<ISound, Integer> field_148626_m = Maps.newHashMap();
    private final Map<ISound, Integer> field_148624_n = Maps.newHashMap();
    private final List<ISoundEventListener> field_188777_o = Lists.newArrayList();
    private final List<ITickableSound> field_229361_s_ = Lists.newArrayList();
    private final List<Sound> field_204261_q = Lists.newArrayList();

    public SoundEngine(SoundHandler p_i50892_1_, GameSettings p_i50892_2_, IResourceManager p_i50892_3_) {
        this.field_148622_c = p_i50892_1_;
        this.field_148619_d = p_i50892_2_;
        this.field_217939_i = new AudioStreamManager(p_i50892_3_);
        ModLoader.get().postEvent((Event)new SoundLoadEvent(this));
    }

    public void func_148596_a() {
        field_188775_c.clear();
        Iterator iterator = Registry.field_212633_v.iterator();
        while (iterator.hasNext()) {
            SoundEvent soundevent = (SoundEvent)((Object)iterator.next());
            ResourceLocation resourcelocation = soundevent.func_187503_a();
            if (this.field_148622_c.func_184398_a(resourcelocation) != null) continue;
            field_148621_b.warn("Missing sound for event: {}", (Object)Registry.field_212633_v.func_177774_c(soundevent));
            field_188775_c.add(resourcelocation);
        }
        this.func_148613_b();
        this.func_148608_i();
        MinecraftForge.EVENT_BUS.post((Event)new SoundLoadEvent(this));
    }

    private synchronized void func_148608_i() {
        if (!this.field_148617_f) {
            try {
                this.field_217937_g.func_216404_a();
                this.field_217938_h.func_216468_b();
                this.field_217938_h.func_216466_a(this.field_148619_d.func_186711_a(SoundCategory.MASTER));
                this.field_217939_i.func_217908_a(this.field_204261_q).thenRun(this.field_204261_q::clear);
                this.field_148617_f = true;
                field_148621_b.info(field_148623_a, "Sound engine started");
            }
            catch (RuntimeException runtimeexception) {
                field_148621_b.error(field_148623_a, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
            }
        }
    }

    private float func_188769_a(@Nullable SoundCategory p_188769_1_) {
        return p_188769_1_ != null && p_188769_1_ != SoundCategory.MASTER ? this.field_148619_d.func_186711_a(p_188769_1_) : 1.0f;
    }

    public void func_188771_a(SoundCategory p_188771_1_, float p_188771_2_) {
        if (this.field_148617_f) {
            if (p_188771_1_ == SoundCategory.MASTER) {
                this.field_217938_h.func_216466_a(p_188771_2_);
            } else {
                this.field_217942_m.forEach((p_217926_1_, p_217926_2_) -> {
                    float f = this.func_188770_e((ISound)p_217926_1_);
                    p_217926_2_.func_217888_a(p_217923_1_ -> {
                        if (f <= 0.0f) {
                            p_217923_1_.func_216418_f();
                        } else {
                            p_217923_1_.func_216430_b(f);
                        }
                    });
                });
            }
        }
    }

    public void func_148613_b() {
        if (this.field_148617_f) {
            this.func_148614_c();
            this.field_217939_i.func_217912_a();
            this.field_217937_g.func_216409_b();
            this.field_148617_f = false;
        }
    }

    public void func_148602_b(ISound p_148602_1_) {
        ChannelManager.Entry channelmanager$entry;
        if (this.field_148617_f && (channelmanager$entry = this.field_217942_m.get(p_148602_1_)) != null) {
            channelmanager$entry.func_217888_a(SoundSource::func_216418_f);
        }
    }

    public void func_148614_c() {
        if (this.field_148617_f) {
            this.field_217940_j.func_213176_a();
            this.field_217942_m.values().forEach(p_217922_0_ -> p_217922_0_.func_217888_a(SoundSource::func_216418_f));
            this.field_217942_m.clear();
            this.field_217941_k.func_217903_b();
            this.field_148626_m.clear();
            this.field_148625_l.clear();
            this.field_217943_n.clear();
            this.field_148624_n.clear();
            this.field_229361_s_.clear();
        }
    }

    public void func_188774_a(ISoundEventListener p_188774_1_) {
        this.field_188777_o.add(p_188774_1_);
    }

    public void func_188773_b(ISoundEventListener p_188773_1_) {
        this.field_188777_o.remove(p_188773_1_);
    }

    public void func_217921_a(boolean p_217921_1_) {
        if (!p_217921_1_) {
            this.func_217927_h();
        }
        this.field_217941_k.func_217899_a();
    }

    private void func_217927_h() {
        ++this.field_148618_g;
        this.field_229361_s_.stream().filter(ISound::func_230510_t_).forEach(this::func_148611_c);
        this.field_229361_s_.clear();
        for (ITickableSound itickablesound : this.field_148625_l) {
            if (!itickablesound.func_230510_t_()) {
                this.func_148602_b((ISound)itickablesound);
            }
            itickablesound.func_73660_a();
            if (itickablesound.func_147667_k()) {
                this.func_148602_b((ISound)itickablesound);
                continue;
            }
            float f = this.func_188770_e((ISound)itickablesound);
            float f1 = this.func_188772_d((ISound)itickablesound);
            Vector3d vector3d = new Vector3d(itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
            ChannelManager.Entry channelmanager$entry = this.field_217942_m.get(itickablesound);
            if (channelmanager$entry == null) continue;
            channelmanager$entry.func_217888_a(p_217924_3_ -> {
                p_217924_3_.func_216430_b(f);
                p_217924_3_.func_216422_a(f1);
                p_217924_3_.func_216420_a(vector3d);
            });
        }
        Iterator<Map.Entry<ISound, ChannelManager.Entry>> iterator = this.field_217942_m.entrySet().iterator();
        while (iterator.hasNext()) {
            int i;
            Map.Entry<ISound, ChannelManager.Entry> entry = iterator.next();
            ChannelManager.Entry channelmanager$entry1 = entry.getValue();
            ISound isound = entry.getKey();
            float f2 = this.field_148619_d.func_186711_a(isound.func_184365_d());
            if (f2 <= 0.0f) {
                channelmanager$entry1.func_217888_a(SoundSource::func_216418_f);
                iterator.remove();
                continue;
            }
            if (!channelmanager$entry1.func_217889_a() || (i = this.field_148624_n.get(isound).intValue()) > this.field_148618_g) continue;
            if (SoundEngine.func_239545_e_(isound)) {
                this.field_148626_m.put(isound, this.field_148618_g + isound.func_147652_d());
            }
            iterator.remove();
            field_148621_b.debug(field_148623_a, "Removed channel {} because it's not playing anymore", (Object)channelmanager$entry1);
            this.field_148624_n.remove(isound);
            try {
                this.field_217943_n.remove((Object)isound.func_184365_d(), (Object)isound);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(isound instanceof ITickableSound)) continue;
            this.field_148625_l.remove(isound);
        }
        Iterator<Map.Entry<ISound, Integer>> iterator1 = this.field_148626_m.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<ISound, Integer> entry1 = iterator1.next();
            if (this.field_148618_g < entry1.getValue()) continue;
            ISound isound1 = entry1.getKey();
            if (isound1 instanceof ITickableSound) {
                ((ITickableSound)isound1).func_73660_a();
            }
            this.func_148611_c(isound1);
            iterator1.remove();
        }
    }

    private static boolean func_239544_d_(ISound p_239544_0_) {
        return p_239544_0_.func_147652_d() > 0;
    }

    private static boolean func_239545_e_(ISound p_239545_0_) {
        return p_239545_0_.func_147657_c() && SoundEngine.func_239544_d_(p_239545_0_);
    }

    private static boolean func_239546_f_(ISound p_239546_0_) {
        return p_239546_0_.func_147657_c() && !SoundEngine.func_239544_d_(p_239546_0_);
    }

    public boolean func_217933_b(ISound p_217933_1_) {
        if (!this.field_148617_f) {
            return false;
        }
        return this.field_148624_n.containsKey(p_217933_1_) && this.field_148624_n.get(p_217933_1_) <= this.field_148618_g ? true : this.field_217942_m.containsKey(p_217933_1_);
    }

    public void func_148611_c(ISound p_148611_1_) {
        if (this.field_148617_f && (p_148611_1_ = ForgeHooksClient.playSound((SoundEngine)this, (ISound)p_148611_1_)) != null && p_148611_1_.func_230510_t_()) {
            SoundEventAccessor soundeventaccessor = p_148611_1_.func_184366_a(this.field_148622_c);
            ResourceLocation resourcelocation = p_148611_1_.func_147650_b();
            if (soundeventaccessor == null) {
                if (field_188775_c.add(resourcelocation)) {
                    field_148621_b.warn(field_148623_a, "Unable to play unknown soundEvent: {}", (Object)resourcelocation);
                }
            } else {
                Sound sound = p_148611_1_.func_184364_b();
                if (sound == SoundHandler.field_147700_a) {
                    if (field_188775_c.add(resourcelocation)) {
                        field_148621_b.warn(field_148623_a, "Unable to play empty soundEvent: {}", (Object)resourcelocation);
                    }
                } else {
                    float f = p_148611_1_.func_147653_e();
                    float f1 = Math.max(f, 1.0f) * (float)sound.func_206255_j();
                    SoundCategory soundcategory = p_148611_1_.func_184365_d();
                    float f2 = this.func_188770_e(p_148611_1_);
                    float f3 = this.func_188772_d(p_148611_1_);
                    ISound.AttenuationType isound$attenuationtype = p_148611_1_.func_147656_j();
                    boolean flag = p_148611_1_.func_217861_m();
                    if (f2 == 0.0f && !p_148611_1_.func_211503_n()) {
                        field_148621_b.debug(field_148623_a, "Skipped playing sound {}, volume was zero.", (Object)sound.func_188719_a());
                    } else {
                        Vector3d vector3d = new Vector3d(p_148611_1_.func_147649_g(), p_148611_1_.func_147654_h(), p_148611_1_.func_147651_i());
                        if (!this.field_188777_o.isEmpty()) {
                            boolean flag1;
                            boolean bl = flag1 = flag || isound$attenuationtype == ISound.AttenuationType.NONE || this.field_217938_h.func_237504_a_().func_72436_e(vector3d) < (double)(f1 * f1);
                            if (flag1) {
                                for (ISoundEventListener isoundeventlistener : this.field_188777_o) {
                                    isoundeventlistener.func_184067_a(p_148611_1_, soundeventaccessor);
                                }
                            } else {
                                field_148621_b.debug(field_148623_a, "Did not notify listeners of soundEvent: {}, it is too far away to hear", (Object)resourcelocation);
                            }
                        }
                        if (this.field_217938_h.func_216467_a() <= 0.0f) {
                            field_148621_b.debug(field_148623_a, "Skipped playing soundEvent: {}, master volume was zero", (Object)resourcelocation);
                        } else {
                            boolean flag2 = SoundEngine.func_239546_f_(p_148611_1_);
                            boolean flag3 = sound.func_188723_h();
                            CompletableFuture completablefuture = this.field_217941_k.func_239534_a_(sound.func_188723_h() ? SoundSystem.Mode.STREAMING : SoundSystem.Mode.STATIC);
                            ChannelManager.Entry channelmanager$entry = (ChannelManager.Entry)completablefuture.join();
                            if (channelmanager$entry == null) {
                                field_148621_b.warn("Failed to create new sound handle");
                            } else {
                                field_148621_b.debug(field_148623_a, "Playing sound {} for event {}", (Object)sound.func_188719_a(), (Object)resourcelocation);
                                this.field_148624_n.put(p_148611_1_, this.field_148618_g + 20);
                                this.field_217942_m.put(p_148611_1_, channelmanager$entry);
                                this.field_217943_n.put((Object)soundcategory, (Object)p_148611_1_);
                                channelmanager$entry.func_217888_a(p_239543_8_ -> {
                                    p_239543_8_.func_216422_a(f3);
                                    p_239543_8_.func_216430_b(f2);
                                    if (isound$attenuationtype == ISound.AttenuationType.LINEAR) {
                                        p_239543_8_.func_216423_c(f1);
                                    } else {
                                        p_239543_8_.func_216419_h();
                                    }
                                    p_239543_8_.func_216425_a(flag2 && !flag3);
                                    p_239543_8_.func_216420_a(vector3d);
                                    p_239543_8_.func_216432_b(flag);
                                });
                                ISound isound = p_148611_1_;
                                if (!flag3) {
                                    this.field_217939_i.func_217909_a(sound.func_188721_b()).thenAccept(p_217934_1_ -> channelmanager$entry.func_217888_a(p_217925_1_ -> {
                                        p_217925_1_.func_216429_a(p_217934_1_);
                                        p_217925_1_.func_216438_c();
                                        MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(this, isound, p_217925_1_));
                                    }));
                                } else {
                                    isound.getStream(this.field_217939_i, sound, flag2).thenAccept(p_217928_1_ -> channelmanager$entry.func_217888_a(p_217935_1_ -> {
                                        p_217935_1_.func_216433_a(p_217928_1_);
                                        p_217935_1_.func_216438_c();
                                        MinecraftForge.EVENT_BUS.post((Event)new PlayStreamingSourceEvent(this, isound, p_217935_1_));
                                    }));
                                }
                                if (p_148611_1_ instanceof ITickableSound) {
                                    this.field_148625_l.add((ITickableSound)p_148611_1_);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_229363_a_(ITickableSound p_229363_1_) {
        this.field_229361_s_.add(p_229363_1_);
    }

    public void func_204259_a(Sound p_204259_1_) {
        this.field_204261_q.add(p_204259_1_);
    }

    private float func_188772_d(ISound p_188772_1_) {
        return MathHelper.func_76131_a((float)p_188772_1_.func_147655_f(), (float)0.5f, (float)2.0f);
    }

    private float func_188770_e(ISound p_188770_1_) {
        return MathHelper.func_76131_a((float)(p_188770_1_.func_147653_e() * this.func_188769_a(p_188770_1_.func_184365_d())), (float)0.0f, (float)1.0f);
    }

    public void func_148610_e() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(p_217929_0_ -> p_217929_0_.forEach(SoundSource::func_216439_d));
        }
    }

    public void func_148604_f() {
        if (this.field_148617_f) {
            this.field_217941_k.func_217897_a(p_217936_0_ -> p_217936_0_.forEach(SoundSource::func_216437_e));
        }
    }

    public void func_148599_a(ISound p_148599_1_, int p_148599_2_) {
        this.field_148626_m.put(p_148599_1_, this.field_148618_g + p_148599_2_);
    }

    public void func_217920_a(ActiveRenderInfo p_217920_1_) {
        if (this.field_148617_f && p_217920_1_.func_216786_h()) {
            Vector3d vector3d = p_217920_1_.func_216785_c();
            Vector3f vector3f = p_217920_1_.func_227996_l_();
            Vector3f vector3f1 = p_217920_1_.func_227997_m_();
            this.field_217940_j.execute(() -> {
                this.field_217938_h.func_216465_a(vector3d);
                this.field_217938_h.func_227580_a_(vector3f, vector3f1);
            });
        }
    }

    public void func_195855_a(@Nullable ResourceLocation p_195855_1_, @Nullable SoundCategory p_195855_2_) {
        if (p_195855_2_ != null) {
            for (ISound isound : this.field_217943_n.get((Object)p_195855_2_)) {
                if (p_195855_1_ != null && !isound.func_147650_b().equals(p_195855_1_)) continue;
                this.func_148602_b(isound);
            }
        } else if (p_195855_1_ == null) {
            this.func_148614_c();
        } else {
            for (ISound isound1 : this.field_217942_m.keySet()) {
                if (!isound1.func_147650_b().equals(p_195855_1_)) continue;
                this.func_148602_b(isound1);
            }
        }
    }

    public String func_217932_f() {
        return this.field_217937_g.func_216402_d();
    }
}

