/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class ModLoadedCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("forge", "mod_loaded");
    private final String modid;

    public ModLoadedCondition(String modid) {
        this.modid = modid;
    }

    @Override
    public ResourceLocation getID() {
        return NAME;
    }

    @Override
    public boolean test() {
        return ModList.get().isLoaded(this.modid);
    }

    public String toString() {
        return "mod_loaded(\"" + this.modid + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ModLoadedCondition> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(JsonObject json, ModLoadedCondition value) {
            json.addProperty("modid", value.modid);
        }

        @Override
        public ModLoadedCondition read(JsonObject json) {
            return new ModLoadedCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"modid"));
        }

        @Override
        public ResourceLocation getID() {
            return NAME;
        }
    }
}

