/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public interface IForgeAdvancementBuilder {
    default public Advancement.Builder self() {
        return (Advancement.Builder)this;
    }

    default public Advancement save(Consumer<Advancement> consumer, ResourceLocation id, ExistingFileHelper fileHelper) {
        boolean canBuild = this.self().func_192058_a(advancementId -> {
            if (fileHelper.exists((ResourceLocation)advancementId, ResourcePackType.SERVER_DATA, ".json", "advancements")) {
                return new Advancement(advancementId, null, null, AdvancementRewards.field_192114_a, (Map)Maps.newHashMap(), (String[][])null);
            }
            return null;
        });
        if (!canBuild) {
            throw new IllegalStateException("Tried to build Advancement without valid Parent!");
        }
        Advancement advancement = this.self().func_192056_a(id);
        consumer.accept(advancement);
        return advancement;
    }
}

