/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModListWidget
extends ExtendedList<ModEntry> {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final int listWidth;
    private ModListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtils.func_76338_a((String)value);
    }

    public ModListWidget(ModListScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        int n = parent.field_230709_l_;
        parent.getFontRenderer().getClass();
        super(minecraft, listWidth, n, top, bottom, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int func_230952_d_() {
        return this.listWidth;
    }

    public int func_230949_c_() {
        return this.listWidth;
    }

    public void refreshList() {
        this.func_230963_j_();
        this.parent.buildModList(arg_0 -> ((ModListWidget)this).func_230513_b_(arg_0), mod -> new ModEntry((ModInfo)mod, this.parent));
    }

    protected void func_230433_a_(MatrixStack mStack) {
        this.parent.func_230446_a_(mStack);
    }

    public class ModEntry
    extends ExtendedList.AbstractListEntry<ModEntry> {
        private final ModInfo modInfo;
        private final ModListScreen parent;

        ModEntry(ModInfo info, ModListScreen parent) {
            this.modInfo = info;
            this.parent = parent;
        }

        public void func_230432_a_(MatrixStack mStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            StringTextComponent name = new StringTextComponent(ModListWidget.stripControlCodes(this.modInfo.getDisplayName()));
            StringTextComponent version = new StringTextComponent(ModListWidget.stripControlCodes(MavenVersionStringHelper.artifactVersionToString(this.modInfo.getVersion())));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.modInfo);
            FontRenderer font = this.parent.getFontRenderer();
            font.func_238422_b_(mStack, LanguageMap.func_74808_a().func_241870_a(ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{font.func_238417_a_((ITextProperties)name, ModListWidget.this.listWidth)})), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            IReorderingProcessor iReorderingProcessor = LanguageMap.func_74808_a().func_241870_a(ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{font.func_238417_a_((ITextProperties)version, ModListWidget.this.listWidth)}));
            float f = left + 3;
            font.getClass();
            font.func_238422_b_(mStack, iReorderingProcessor, f, (float)(top + 2 + 9), 0xCCCCCC);
            if (vercheck.status.shouldDraw()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.pushMatrix();
                AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(ModListWidget.this.getLeft() + ModListWidget.this.field_230670_d_ - 12), (int)(top + entryHeight / 4), (float)(vercheck.status.getSheetOffset() * 8), (float)(vercheck.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16);
                RenderSystem.popMatrix();
            }
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setSelected(this);
            ModListWidget.this.func_241215_a_((AbstractList.AbstractListEntry)this);
            return false;
        }

        public ModInfo getInfo() {
            return this.modInfo;
        }
    }
}

