/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonLaunchHandler
implements ILaunchHandlerService {
    protected static final Logger LOGGER = LogManager.getLogger();

    public abstract Dist getDist();

    public abstract String getNaming();

    public boolean isProduction() {
        return false;
    }

    public boolean isData() {
        return false;
    }

    public abstract LocatedPaths getMinecraftPaths();

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
    }

    protected final Map<String, List<Path>> getModClasses() {
        String modClasses = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse("");
        LOGGER.debug(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modClasses);
        record ExplodedModPath(String modid, Path path) {
        }
        Map<String, List<Path>> modClassPaths = Arrays.stream(modClasses.split(File.pathSeparator)).map(inp -> inp.split("%%", 2)).map(splitString -> new ExplodedModPath(((String[])splitString).length == 1 ? "defaultmodid" : splitString[0], Paths.get(splitString[((String[])splitString).length - 1], new String[0]))).collect(Collectors.groupingBy(ExplodedModPath::modid, Collectors.mapping(ExplodedModPath::path, Collectors.toList())));
        LOGGER.debug(LogMarkers.CORE, "Found supplied mod coordinates [{}]", modClassPaths);
        return modClassPaths;
    }

    public record LocatedPaths(List<Path> minecraftPaths, BiPredicate<String, String> minecraftFilter, List<List<Path>> otherModPaths, List<Path> otherArtifacts) {
    }
}

