/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class Main {
    private static final Logger f_129670_ = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$36;
            boolean $$31;
            OptionSet $$17 = $$1.parse(p_129699_);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.m_127529_();
            if ($$17.has((OptionSpec)$$15)) {
                JvmProfiler.f_185340_.m_183425_(Environment.SERVER);
            }
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            Path $$18 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings $$19 = new DedicatedServerSettings($$18);
            $$19.m_139780_();
            Path $$20 = Paths.get("eula.txt", new String[0]);
            Eula $$21 = new Eula($$20);
            if ($$17.has((OptionSpec)$$3)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)$$18.toAbsolutePath(), (Object)$$20.toAbsolutePath());
                return;
            }
            if (!$$21.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$22 = new File((String)$$17.valueOf((OptionSpec)$$11));
            YggdrasilAuthenticationService $$23 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService $$24 = $$23.createMinecraftSessionService();
            GameProfileRepository $$25 = $$23.createProfileRepository();
            GameProfileCache $$26 = new GameProfileCache($$25, new File($$22, MinecraftServer.f_129742_.getName()));
            String $$27 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$12)).orElse($$19.m_139777_().f_139741_);
            LevelStorageSource $$28 = LevelStorageSource.m_78242_($$22.toPath());
            LevelStorageSource.LevelStorageAccess $$29 = $$28.m_78260_($$27);
            LevelSummary $$30 = $$29.m_78308_();
            if ($$30 != null) {
                if ($$30.m_193020_()) {
                    f_129670_.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$30.m_193021_()) {
                    f_129670_.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if ($$31 = $$17.has((OptionSpec)$$8)) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository $$32 = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource($$29.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_));
            try {
                WorldStem.InitConfig $$33 = new WorldStem.InitConfig($$32, Commands.CommandSelection.DEDICATED, $$19.m_139777_().f_139711_, $$31);
                WorldStem $$34 = WorldStem.m_206911_($$33, () -> {
                    DataPackConfig $$1 = $$29.m_78309_();
                    return $$1 == null ? DataPackConfig.f_45842_ : $$1;
                }, (arg_0, arg_1) -> Main.m_206537_($$29, $$17, (OptionSpec)$$4, $$19, (OptionSpec)$$5, arg_0, arg_1), Util.m_183991_(), Runnable::run).get();
            }
            catch (Exception $$35) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$35);
                $$32.close();
                return;
            }
            $$36.m_206901_();
            RegistryAccess.Frozen $$37 = $$36.f_206894_();
            $$19.m_139777_().m_180927_($$37);
            WorldData $$38 = $$36.f_206895_();
            if ($$17.has((OptionSpec)$$6)) {
                Main.m_195488_($$29, DataFixers.m_14512_(), $$17.has((OptionSpec)$$7), () -> true, $$38.m_5961_());
            }
            $$29.m_78287_($$37, $$38);
            final DedicatedServer $$39 = MinecraftServer.m_129872_(arg_0 -> Main.m_206521_($$29, $$32, (WorldStem)$$36, $$19, $$24, $$25, $$26, $$17, (OptionSpec)$$10, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$40 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$39.m_7570_(true);
                }
            };
            $$40.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook($$40);
        }
        catch (Exception $$41) {
            f_129670_.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$41);
        }
    }

    private static void m_195488_(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, WorldGenSettings p_195493_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader $$5 = new WorldUpgrader(p_195489_, p_195490_, p_195493_, p_195491_);
        Component $$6 = null;
        while (!$$5.m_18829_()) {
            int $$8;
            Component $$7 = $$5.m_18837_();
            if ($$6 != $$7) {
                $$6 = $$7;
                f_129670_.info($$5.m_18837_().getString());
            }
            if (($$8 = $$5.m_18834_()) > 0) {
                int $$9 = $$5.m_18835_() + $$5.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.m_14143_((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!p_195492_.getAsBoolean()) {
                $$5.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer m_206521_(LevelStorageSource.LevelStorageAccess p_206522_, PackRepository p_206523_, WorldStem p_206524_, DedicatedServerSettings p_206525_, MinecraftSessionService p_206526_, GameProfileRepository p_206527_, GameProfileCache p_206528_, OptionSet p_206529_, OptionSpec p_206530_, OptionSpec p_206531_, OptionSpec p_206532_, OptionSpec p_206533_, OptionSpec p_206534_, OptionSpec p_206535_, Thread p_206536_) {
        boolean $$16;
        DedicatedServer $$15 = new DedicatedServer(p_206536_, p_206522_, p_206523_, p_206524_, p_206525_, DataFixers.m_14512_(), p_206526_, p_206527_, p_206528_, LoggerChunkProgressListener::new);
        $$15.m_129981_((String)p_206529_.valueOf(p_206530_));
        $$15.m_129801_((Integer)p_206529_.valueOf(p_206531_));
        $$15.m_129975_(p_206529_.has(p_206532_));
        $$15.m_129948_((String)p_206529_.valueOf(p_206533_));
        boolean bl = $$16 = !p_206529_.has(p_206534_) && !p_206529_.valuesOf(p_206535_).contains("nogui");
        if ($$16 && !GraphicsEnvironment.isHeadless()) {
            $$15.m_139667_();
        }
        return $$15;
    }

    private static /* synthetic */ Pair m_206537_(LevelStorageSource.LevelStorageAccess p_206538_, OptionSet p_206539_, OptionSpec p_206540_, DedicatedServerSettings p_206541_, OptionSpec p_206542_, ResourceManager p_206543_, DataPackConfig p_206544_) {
        WorldGenSettings $$14;
        LevelSettings $$13;
        RegistryAccess.Writable $$7 = RegistryAccess.m_206197_();
        RegistryOps<Tag> $$8 = RegistryOps.m_206813_(NbtOps.f_128958_, $$7, p_206543_);
        WorldData $$9 = p_206538_.m_211747_($$8, p_206544_, $$7.m_211816_());
        if ($$9 != null) {
            return Pair.of((Object)$$9, (Object)$$7.m_203557_());
        }
        if (p_206539_.has(p_206540_)) {
            LevelSettings $$10 = MinecraftServer.f_129743_;
            WorldGenSettings $$11 = WorldGenSettings.m_64645_($$7);
        } else {
            DedicatedServerProperties $$12 = p_206541_.m_139777_();
            $$13 = new LevelSettings($$12.f_139741_, $$12.f_139740_, $$12.f_139752_, $$12.f_139739_, false, new GameRules(), p_206544_);
            $$14 = p_206539_.has(p_206542_) ? $$12.m_180927_($$7).m_64671_() : $$12.m_180927_($$7);
        }
        PrimaryLevelData $$15 = new PrimaryLevelData($$13, $$14, Lifecycle.stable());
        return Pair.of((Object)$$15, (Object)$$7.m_203557_());
    }
}

