/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.Mth;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;

public class LegacyRandomSource
implements BitRandomSource {
    private static final int f_188571_ = 48;
    private static final long f_188572_ = 0xFFFFFFFFFFFFL;
    private static final long f_188573_ = 25214903917L;
    private static final long f_188574_ = 11L;
    private final AtomicLong f_188575_ = new AtomicLong();
    private final MarsagliaPolarGaussian f_188576_ = new MarsagliaPolarGaussian(this);

    public LegacyRandomSource(long p_188578_) {
        this.setSeed(p_188578_);
    }

    @Override
    public RandomSource m_183458_() {
        return new LegacyRandomSource(this.nextLong());
    }

    @Override
    public PositionalRandomFactory m_183423_() {
        return new LegacyPositionalRandomFactory(this.nextLong());
    }

    @Override
    public void setSeed(long p_188585_) {
        if (!this.f_188575_.compareAndSet(this.f_188575_.get(), (p_188585_ ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.m_199417_("LegacyRandomSource", null);
        }
        this.f_188576_.m_188602_();
    }

    @Override
    public int m_183145_(int p_188581_) {
        long $$2;
        long $$1 = this.f_188575_.get();
        if (!this.f_188575_.compareAndSet($$1, $$2 = $$1 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.m_199417_("LegacyRandomSource", null);
        }
        return (int)($$2 >> 48 - p_188581_);
    }

    @Override
    public double nextGaussian() {
        return this.f_188576_.m_188603_();
    }

    public static class LegacyPositionalRandomFactory
    implements PositionalRandomFactory {
        private final long f_188586_;

        public LegacyPositionalRandomFactory(long p_188588_) {
            this.f_188586_ = p_188588_;
        }

        @Override
        public RandomSource m_183161_(int p_188590_, int p_188591_, int p_188592_) {
            long $$3 = Mth.m_14130_(p_188590_, p_188591_, p_188592_);
            long $$4 = $$3 ^ this.f_188586_;
            return new LegacyRandomSource($$4);
        }

        @Override
        public RandomSource m_183211_(String p_188594_) {
            int $$1 = p_188594_.hashCode();
            return new LegacyRandomSource((long)$$1 ^ this.f_188586_);
        }

        @Override
        @VisibleForTesting
        public void m_183502_(StringBuilder p_188596_) {
            p_188596_.append("LegacyPositionalRandomFactory{").append(this.f_188586_).append("}");
        }
    }
}

