/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public interface IForgeFriendlyByteBuf {
    private FriendlyByteBuf self() {
        return (FriendlyByteBuf)this;
    }

    default public <T extends IForgeRegistryEntry<T>> void writeRegistryIdUnsafe(@Nonnull IForgeRegistry<T> registry, @Nonnull T entry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entry);
        this.self().m_130130_(id);
    }

    default public void writeRegistryIdUnsafe(@Nonnull IForgeRegistry<?> registry, @Nonnull ResourceLocation entryKey) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entryKey);
        this.self().m_130130_(id);
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryIdUnsafe(@Nonnull IForgeRegistry<T> registry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = this.self().m_130242_();
        return (T)forgeRegistry.getValue(id);
    }

    default public <T extends IForgeRegistryEntry<T>> void writeRegistryId(@Nonnull T entry) {
        Class<T> regType = Objects.requireNonNull(entry, "Cannot write a null registry entry!").getRegistryType();
        IForgeRegistry<T> retrievedRegistry = RegistryManager.ACTIVE.getRegistry(regType);
        Preconditions.checkArgument((retrievedRegistry != null ? 1 : 0) != 0, (String)"Cannot write registry id for an unknown registry type: %s", (Object)regType.getName());
        ResourceLocation name = retrievedRegistry.getRegistryName();
        Preconditions.checkArgument((boolean)retrievedRegistry.containsValue(entry), (String)"Cannot find %s in %s", entry.getRegistryName() != null ? entry.getRegistryName() : entry, (Object)name);
        ForgeRegistry reg = (ForgeRegistry)retrievedRegistry;
        this.self().m_130085_(name);
        this.self().m_130130_(reg.getID(entry));
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryId() {
        ResourceLocation location = this.self().m_130281_();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(location);
        return (T)registry.getValue(this.self().m_130242_());
    }

    default public <T extends IForgeRegistryEntry<T>> T readRegistryIdSafe(Class<? super T> registrySuperType) {
        T value = this.readRegistryId();
        if (!value.getRegistryType().equals(registrySuperType)) {
            throw new IllegalArgumentException("Attempted to read an registryValue of the wrong type from the Buffer!");
        }
        return value;
    }

    default public void writeFluidStack(FluidStack stack) {
        if (stack.isEmpty()) {
            this.self().writeBoolean(false);
        } else {
            this.self().writeBoolean(true);
            stack.writeToPacket(this.self());
        }
    }

    default public FluidStack readFluidStack() {
        return !this.self().readBoolean() ? FluidStack.EMPTY : FluidStack.readFromPacket(this.self());
    }
}

