/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ToolAction;

public class CanToolPerformAction
implements LootItemCondition {
    public static final LootItemConditionType LOOT_CONDITION_TYPE = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    final ToolAction action;

    public CanToolPerformAction(ToolAction action) {
        this.action = action;
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return LOOT_CONDITION_TYPE;
    }

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81463_);
    }

    public boolean test(LootContext lootContext) {
        ItemStack itemstack = (ItemStack)lootContext.m_78953_(LootContextParams.f_81463_);
        return itemstack != null && itemstack.canPerformAction(this.action);
    }

    public static LootItemCondition.Builder canToolPerformAction(ToolAction action) {
        return () -> new CanToolPerformAction(action);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<CanToolPerformAction> {
        public void serialize(JsonObject json, CanToolPerformAction itemCondition, @Nonnull JsonSerializationContext context) {
            json.addProperty("action", itemCondition.action.name());
        }

        @Nonnull
        public CanToolPerformAction deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new CanToolPerformAction(ToolAction.get(json.get("action").getAsString()));
        }
    }
}

