/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class PotionEvent
extends LivingEvent {
    @Nullable
    protected final MobEffectInstance effect;

    public PotionEvent(LivingEntity living, MobEffectInstance effect) {
        super(living);
        this.effect = effect;
    }

    @Nullable
    public MobEffectInstance getPotionEffect() {
        return this.effect;
    }

    public static class PotionExpiryEvent
    extends PotionEvent {
        public PotionExpiryEvent(LivingEntity living, MobEffectInstance effect) {
            super(living, effect);
        }
    }

    public static class PotionAddedEvent
    extends PotionEvent {
        private final MobEffectInstance oldEffect;
        private final Entity source;

        public PotionAddedEvent(LivingEntity living, MobEffectInstance oldEffect, MobEffectInstance newEffect, Entity source) {
            super(living, newEffect);
            this.oldEffect = oldEffect;
            this.source = source;
        }

        @Override
        @Nonnull
        public MobEffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }

        @Nullable
        public MobEffectInstance getOldPotionEffect() {
            return this.oldEffect;
        }

        @Nullable
        public Entity getPotionSource() {
            return this.source;
        }
    }

    @Event.HasResult
    public static class PotionApplicableEvent
    extends PotionEvent {
        public PotionApplicableEvent(LivingEntity living, MobEffectInstance effect) {
            super(living, effect);
        }

        @Override
        @Nonnull
        public MobEffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }
    }

    @Cancelable
    public static class PotionRemoveEvent
    extends PotionEvent {
        private final MobEffect potion;

        public PotionRemoveEvent(LivingEntity living, MobEffect potion) {
            super(living, living.m_21124_(potion));
            this.potion = potion;
        }

        public PotionRemoveEvent(LivingEntity living, MobEffectInstance effect) {
            super(living, effect);
            this.potion = effect.m_19544_();
        }

        public MobEffect getPotion() {
            return this.potion;
        }

        @Override
        @Nullable
        public MobEffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }
    }
}

