/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final LevelAccessor world;
    private final BlockPos pos;
    private final BlockState state;

    public BlockEvent(LevelAccessor world, BlockPos pos, BlockState state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public static class BlockToolModificationEvent
    extends BlockEvent {
        private final UseOnContext context;
        private final ToolAction toolAction;
        private final boolean simulate;
        private BlockState state;

        public BlockToolModificationEvent(BlockState originalState, @Nonnull UseOnContext context, ToolAction toolAction, boolean simulate) {
            super((LevelAccessor)context.m_43725_(), context.m_8083_(), originalState);
            this.context = context;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = simulate;
        }

        BlockToolModificationEvent(LevelAccessor level, BlockPos pos, BlockState originalState, ToolAction toolAction) {
            super(level, pos, originalState);
            this.context = null;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = false;
        }

        @Nullable
        public Player getPlayer() {
            return this.context.m_43723_();
        }

        public ItemStack getHeldItemStack() {
            return this.context.m_43722_();
        }

        public ToolAction getToolAction() {
            return this.toolAction;
        }

        public boolean isSimulated() {
            return this.simulate;
        }

        @Nullable
        public UseOnContext getContext() {
            return this.context;
        }

        public void setFinalState(@Nullable BlockState finalState) {
            this.state = finalState;
        }

        public BlockState getFinalState() {
            return this.state;
        }
    }

    @Cancelable
    @Deprecated(forRemoval=true, since="1.18.2")
    public static class BlockToolInteractEvent
    extends BlockToolModificationEvent {
        private final Player player;
        private final ItemStack stack;

        public BlockToolInteractEvent(BlockState originalState, @Nonnull UseOnContext context, ToolAction toolAction) {
            super(originalState, context, toolAction, false);
            this.player = context.m_43723_();
            this.stack = context.m_43722_();
        }

        public BlockToolInteractEvent(LevelAccessor world, BlockPos pos, BlockState originalState, Player player, ItemStack stack, ToolAction toolAction) {
            super(world, pos, originalState, toolAction);
            this.player = player;
            this.stack = stack;
        }

        @Override
        @Nonnull
        public Player getPlayer() {
            return this.player;
        }

        @Override
        public ItemStack getHeldItemStack() {
            return this.stack;
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final PortalShape size;

        public PortalSpawnEvent(LevelAccessor world, BlockPos pos, BlockState state, PortalShape size) {
            super(world, pos, state);
            this.size = size;
        }

        public PortalShape getPortalSize() {
            return this.size;
        }
    }

    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEvent {
        private final Entity entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(Level world, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
            super((LevelAccessor)world, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(Level world, BlockPos pos, BlockState state) {
            super((LevelAccessor)world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final BlockState originalState;

            public Post(Level world, BlockPos pos, BlockState original, BlockState state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public BlockState getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(Level world, BlockPos pos, BlockState state) {
                super(world, pos, state);
            }
        }
    }

    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEvent {
        private final BlockPos liquidPos;
        private BlockState newState;
        private BlockState origState;

        public FluidPlaceBlockEvent(LevelAccessor world, BlockPos pos, BlockPos liquidPos, BlockState state) {
            super(world, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = world.m_8055_(pos);
        }

        public BlockPos getLiquidPos() {
            return this.liquidPos;
        }

        public BlockState getNewState() {
            return this.newState;
        }

        public void setNewState(BlockState state) {
            this.newState = state;
        }

        public BlockState getOriginalState() {
            return this.origState;
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends Event {
        private final LevelReader world;
        private final BlockPos pos;
        private final BlockState state;

        public CreateFluidSourceEvent(LevelReader world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        public LevelReader getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<Direction> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(Level world, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
            super((LevelAccessor)world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<Direction> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class EntityMultiPlaceEvent
    extends EntityPlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshots.get(0), placedAgainst, entity);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created EntityMultiPlaceEvent - [PlacedAgainst: %s ][Entity: %s ]\n", placedAgainst, entity);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class EntityPlaceEvent
    extends BlockEvent {
        private final Entity entity;
        private final BlockSnapshot blockSnapshot;
        private final BlockState placedBlock;
        private final BlockState placedAgainst;

        public EntityPlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshot.getLevel(), blockSnapshot.getPos(), !(entity instanceof Player) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock());
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof Player) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created EntityPlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][Entity: %s ]\n", this.getPlacedBlock(), placedAgainst, entity);
            }
        }

        @Nullable
        public Entity getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public BlockState getPlacedBlock() {
            return this.placedBlock;
        }

        public BlockState getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final Player player;
        private int exp;

        public BreakEvent(Level world, BlockPos pos, BlockState state, Player player) {
            super((LevelAccessor)world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.isCorrectToolForDrops(state, player)) {
                this.exp = 0;
            } else {
                int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
                int silkTouchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
                this.exp = state.getExpDrop((LevelReader)world, pos, fortuneLevel, silkTouchLevel);
            }
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }
}

