/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldGenSettingsComponent
implements Widget {
    private static final Logger f_101381_ = LogUtils.getLogger();
    private static final Component f_101382_ = new TranslatableComponent("generator.custom");
    private static final Component f_101383_ = new TranslatableComponent("generator.amplified.info");
    private static final Component f_101384_ = new TranslatableComponent("selectWorld.mapFeatures.info");
    private static final Component f_170243_ = new TranslatableComponent("selectWorld.import_worldgen_settings.select_file");
    private MultiLineLabel f_101385_ = MultiLineLabel.f_94331_;
    private Font f_101386_;
    private int f_101387_;
    private EditBox f_101388_;
    private CycleButton<Boolean> f_101389_;
    private CycleButton<Boolean> f_101380_;
    private CycleButton<WorldPreset> f_101390_;
    private Button f_170244_;
    private Button f_101391_;
    private Button f_101392_;
    private RegistryAccess.Frozen f_101393_;
    private WorldGenSettings f_101394_;
    private Optional<WorldPreset> f_101395_;
    private OptionalLong f_101396_;

    public WorldGenSettingsComponent(RegistryAccess.Frozen p_205452_, WorldGenSettings p_205453_, Optional<WorldPreset> p_205454_, OptionalLong p_205455_) {
        this.f_101393_ = p_205452_;
        this.f_101394_ = p_205453_;
        this.f_101395_ = p_205454_;
        this.f_101396_ = p_205455_;
    }

    public void m_101429_(CreateWorldScreen p_101430_, Minecraft p_101431_, Font p_101432_) {
        this.f_101386_ = p_101432_;
        this.f_101387_ = p_101430_.f_96543_;
        this.f_101388_ = new EditBox(this.f_101386_, this.f_101387_ / 2 - 100, 60, 200, 20, (Component)new TranslatableComponent("selectWorld.enterSeed"));
        this.f_101388_.m_94144_(WorldGenSettingsComponent.m_101447_(this.f_101396_));
        this.f_101388_.m_94151_(p_101465_ -> {
            this.f_101396_ = WorldGenSettings.m_202192_(this.f_101388_.m_94155_());
        });
        p_101430_.m_7787_(this.f_101388_);
        int i = this.f_101387_ / 2 - 155;
        int j = this.f_101387_ / 2 + 5;
        this.f_101389_ = p_101430_.m_142416_(CycleButton.m_168916_((boolean)this.f_101394_.m_64657_()).m_168959_(p_170280_ -> CommonComponents.m_178398_((Component)p_170280_.m_168904_(), (Component)new TranslatableComponent("selectWorld.mapFeatures.info"))).m_168936_(i, 100, 150, 20, (Component)new TranslatableComponent("selectWorld.mapFeatures"), (p_170282_, p_170283_) -> {
            this.f_101394_ = this.f_101394_.m_64672_();
        }));
        this.f_101389_.f_93624_ = false;
        this.f_101390_ = p_101430_.m_142416_(CycleButton.m_168894_(WorldPreset::m_101523_).m_168952_(WorldPreset.f_101508_.stream().filter(WorldPreset::m_170301_).collect(Collectors.toList()), WorldPreset.f_101508_).m_168959_(p_170264_ -> p_170264_.m_168883_() == WorldPreset.f_101507_ ? CommonComponents.m_178398_((Component)p_170264_.m_168904_(), (Component)f_101383_) : p_170264_.m_168904_()).m_168936_(j, 100, 150, 20, (Component)new TranslatableComponent("selectWorld.mapType"), (p_170274_, p_170275_) -> {
            this.f_101395_ = Optional.of(p_170275_);
            this.f_101394_ = p_170275_.m_205485_(this.f_101393_, this.f_101394_.m_64619_(), this.f_101394_.m_64657_(), this.f_101394_.m_64660_());
            p_101430_.m_170204_();
        }));
        this.f_101395_.ifPresent(arg_0 -> this.f_101390_.m_168892_(arg_0));
        this.f_101390_.f_93624_ = false;
        this.f_170244_ = p_101430_.m_142416_(new Button(j, 100, 150, 20, (Component)CommonComponents.m_178393_((Component)new TranslatableComponent("selectWorld.mapType"), (Component)f_101382_), p_170262_ -> {}));
        this.f_170244_.f_93623_ = false;
        this.f_170244_.f_93624_ = false;
        this.f_101391_ = p_101430_.m_142416_(new Button(j, 120, 150, 20, (Component)new TranslatableComponent("selectWorld.customizeType"), p_170248_ -> {
            WorldPreset.PresetEditor worldpreset$preseteditor = WorldPreset.f_101509_.get(this.f_101395_);
            if ((worldpreset$preseteditor = ForgeHooksClient.getPresetEditor(this.f_101395_, (WorldPreset.PresetEditor)worldpreset$preseteditor)) != null) {
                p_101431_.m_91152_(worldpreset$preseteditor.m_101642_(p_101430_, this.f_101394_));
            }
        }));
        this.f_101391_.f_93624_ = false;
        this.f_101380_ = p_101430_.m_142416_(CycleButton.m_168916_((this.f_101394_.m_64660_() && !p_101430_.f_100845_ ? 1 : 0) != 0).m_168936_(i, 151, 150, 20, (Component)new TranslatableComponent("selectWorld.bonusItems"), (p_170266_, p_170267_) -> {
            this.f_101394_ = this.f_101394_.m_64673_();
        }));
        this.f_101380_.f_93624_ = false;
        this.f_101392_ = p_101430_.m_142416_(new Button(i, 185, 150, 20, (Component)new TranslatableComponent("selectWorld.import_worldgen_settings"), p_170271_ -> {
            block22: {
                String s = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)f_170243_.getString(), (CharSequence)null, (PointerBuffer)null, (CharSequence)null, (boolean)false);
                if (s != null) {
                    DataResult dataresult;
                    RegistryAccess.Writable registryaccess$writable;
                    block21: {
                        registryaccess$writable = RegistryAccess.m_206197_();
                        try (PackRepository packrepository = new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource(), new FolderRepositorySource(p_101430_.m_100968_().toFile(), PackSource.f_10529_)});){
                            MinecraftServer.m_129819_(packrepository, p_170269_.f_100846_, false);
                            try (MultiPackResourceManager closeableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, packrepository.m_10525_());){
                                RegistryOps dynamicops = RegistryOps.m_206813_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess.Writable)registryaccess$writable, (ResourceManager)closeableresourcemanager);
                                try (BufferedReader bufferedreader = Files.newBufferedReader(Paths.get(s, new String[0]));){
                                    JsonElement jsonelement = JsonParser.parseReader((Reader)bufferedreader);
                                    dataresult = WorldGenSettings.f_64600_.parse((DynamicOps)dynamicops, (Object)jsonelement);
                                }
                                catch (Exception exception) {
                                    dataresult = DataResult.error((String)("Failed to parse file: " + exception.getMessage()));
                                }
                                if (!dataresult.error().isPresent()) {
                                    break block21;
                                }
                                TranslatableComponent component1 = new TranslatableComponent("selectWorld.import_worldgen_settings.failure");
                                String s1 = ((DataResult.PartialResult)dataresult.error().get()).message();
                                f_101381_.error("Error parsing world settings: {}", (Object)s1);
                                TextComponent component = new TextComponent(s1);
                                p_101431_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)p_101431_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.WORLD_GEN_SETTINGS_TRANSFER, (Component)component1, (Component)component));
                                break block22;
                            }
                        }
                    }
                    Lifecycle lifecycle = dataresult.lifecycle();
                    dataresult.resultOrPartial(arg_0 -> ((Logger)f_101381_).error(arg_0)).ifPresent(p_205461_ -> {
                        BooleanConsumer booleanconsumer = p_205467_ -> {
                            p_101431_.m_91152_(p_101430_);
                            if (p_205467_) {
                                this.m_205468_(registryaccess$writable.m_203557_(), (WorldGenSettings)p_205461_);
                            }
                        };
                        if (lifecycle == Lifecycle.stable()) {
                            this.m_205468_(registryaccess$writable.m_203557_(), (WorldGenSettings)p_205461_);
                        } else if (lifecycle == Lifecycle.experimental()) {
                            p_101431_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)new TranslatableComponent("selectWorld.import_worldgen_settings.experimental.title"), (Component)new TranslatableComponent("selectWorld.import_worldgen_settings.experimental.question")));
                        } else {
                            p_101431_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)new TranslatableComponent("selectWorld.import_worldgen_settings.deprecated.title"), (Component)new TranslatableComponent("selectWorld.import_worldgen_settings.deprecated.question")));
                        }
                    });
                    return;
                }
            }
        }));
        this.f_101392_.f_93624_ = false;
        this.f_101385_ = MultiLineLabel.m_94341_((Font)p_101432_, (FormattedText)f_101383_, (int)this.f_101390_.m_5711_());
    }

    private void m_205468_(RegistryAccess.Frozen p_205469_, WorldGenSettings p_205470_) {
        this.f_101393_ = p_205469_;
        this.f_101394_ = p_205470_;
        this.f_101395_ = WorldPreset.m_101524_(p_205470_);
        this.m_170289_(true);
        this.f_101396_ = OptionalLong.of(p_205470_.m_64619_());
        this.f_101388_.m_94144_(WorldGenSettingsComponent.m_101447_(this.f_101396_));
    }

    public void m_101469_() {
        this.f_101388_.m_94120_();
    }

    public void m_6305_(PoseStack p_101407_, int p_101408_, int p_101409_, float p_101410_) {
        if (this.f_101389_.f_93624_) {
            this.f_101386_.m_92763_(p_101407_, f_101384_, (float)(this.f_101387_ / 2 - 150), 122.0f, -6250336);
        }
        this.f_101388_.m_6305_(p_101407_, p_101408_, p_101409_, p_101410_);
        if (this.f_101395_.equals(Optional.of(WorldPreset.f_101507_))) {
            this.f_101385_.m_6516_(p_101407_, this.f_101390_.f_93620_ + 2, this.f_101390_.f_93621_ + 22, 9, 0xA0A0A0);
        }
    }

    public void m_101404_(WorldGenSettings p_101405_) {
        this.f_101394_ = p_101405_;
    }

    private static String m_101447_(OptionalLong p_101448_) {
        return p_101448_.isPresent() ? Long.toString(p_101448_.getAsLong()) : "";
    }

    public WorldGenSettings m_101454_(boolean p_101455_) {
        OptionalLong optionallong = WorldGenSettings.m_202192_(this.f_101388_.m_94155_());
        return this.f_101394_.m_64654_(p_101455_, optionallong);
    }

    public boolean m_101403_() {
        return this.f_101394_.m_64668_();
    }

    public void m_170287_(boolean p_170288_) {
        this.m_170289_(p_170288_);
        if (this.f_101394_.m_64668_()) {
            this.f_101389_.f_93624_ = false;
            this.f_101380_.f_93624_ = false;
            this.f_101391_.f_93624_ = false;
            this.f_101392_.f_93624_ = false;
        } else {
            this.f_101389_.f_93624_ = p_170288_;
            this.f_101380_.f_93624_ = p_170288_;
            this.f_101391_.f_93624_ = p_170288_ && (WorldPreset.f_101509_.containsKey(this.f_101395_) || ForgeHooksClient.hasPresetEditor(this.f_101395_));
            this.f_101392_.f_93624_ = p_170288_;
        }
        this.f_101388_.m_94194_(p_170288_);
    }

    private void m_170289_(boolean p_170290_) {
        if (this.f_101395_.isPresent()) {
            this.f_101390_.f_93624_ = p_170290_;
            this.f_170244_.f_93624_ = false;
        } else {
            this.f_101390_.f_93624_ = false;
            this.f_170244_.f_93624_ = p_170290_;
        }
    }

    public RegistryAccess m_205473_() {
        return this.f_101393_;
    }

    void m_205471_(WorldStem p_205472_) {
        this.f_101394_ = p_205472_.f_206895_().m_5961_();
        this.f_101393_ = p_205472_.f_206894_();
    }

    public void m_170291_() {
        this.f_101380_.f_93623_ = false;
        this.f_101380_.m_168892_((Object)false);
    }

    public void m_170292_() {
        this.f_101380_.f_93623_ = true;
        this.f_101380_.m_168892_((Object)this.f_101394_.m_64660_());
    }
}

