/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.JigsawBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.MinecartCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.gui.screens.inventory.StructureBlockEditScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.BubbleColumnAmbientSoundHandler;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.RidingMinecartSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundHandler;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundInstances;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayer
extends AbstractClientPlayer {
    private static final int f_172525_ = 20;
    private static final int f_172526_ = 600;
    private static final int f_172527_ = 100;
    private static final float f_172528_ = 0.6f;
    private static final double f_172529_ = 0.35;
    private static final double f_197409_ = 0.13962633907794952;
    public final ClientPacketListener f_108617_;
    private final StatsCounter f_108591_;
    private final ClientRecipeBook f_108592_;
    private final List<AmbientSoundHandler> f_108593_ = Lists.newArrayList();
    private int f_108594_ = 0;
    private double f_108595_;
    private double f_108596_;
    private double f_108597_;
    private float f_108598_;
    private float f_108599_;
    private boolean f_108600_;
    private boolean f_108601_;
    private boolean f_108602_;
    private boolean f_108603_;
    private int f_108604_;
    private boolean f_108605_;
    @Nullable
    private String f_108606_;
    public Input f_108618_;
    protected final Minecraft f_108619_;
    protected int f_108583_;
    public int f_108584_;
    public float f_108585_;
    public float f_108586_;
    public float f_108587_;
    public float f_108588_;
    private int f_108607_;
    private float f_108608_;
    public float f_108589_;
    public float f_108590_;
    private boolean f_108609_;
    @Nullable
    private InteractionHand f_108610_;
    private boolean f_108611_;
    private boolean f_108612_ = true;
    private int f_108613_;
    private boolean f_108614_;
    private int f_108615_;
    private boolean f_108616_ = true;

    public LocalPlayer(Minecraft p_108621_, ClientLevel p_108622_, ClientPacketListener p_108623_, StatsCounter p_108624_, ClientRecipeBook p_108625_, boolean p_108626_, boolean p_108627_) {
        super(p_108622_, p_108623_.m_105144_());
        this.f_108619_ = p_108621_;
        this.f_108617_ = p_108623_;
        this.f_108591_ = p_108624_;
        this.f_108592_ = p_108625_;
        this.f_108602_ = p_108626_;
        this.f_108603_ = p_108627_;
        this.f_108593_.add((AmbientSoundHandler)new UnderwaterAmbientSoundHandler(this, p_108621_.m_91106_()));
        this.f_108593_.add((AmbientSoundHandler)new BubbleColumnAmbientSoundHandler(this));
        this.f_108593_.add((AmbientSoundHandler)new BiomeAmbientSoundsHandler(this, p_108621_.m_91106_(), p_108622_.m_7062_()));
    }

    @Override
    public boolean m_6469_(DamageSource p_108662_, float p_108663_) {
        ForgeHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_108662_, (float)p_108663_);
        return false;
    }

    @Override
    public void m_5634_(float p_108708_) {
    }

    @Override
    public boolean m_7998_(Entity p_108667_, boolean p_108668_) {
        if (!super.m_7998_(p_108667_, p_108668_)) {
            return false;
        }
        if (p_108667_ instanceof AbstractMinecart) {
            this.f_108619_.m_91106_().m_120367_((SoundInstance)new RidingMinecartSoundInstance((Player)this, (AbstractMinecart)p_108667_, true));
            this.f_108619_.m_91106_().m_120367_((SoundInstance)new RidingMinecartSoundInstance((Player)this, (AbstractMinecart)p_108667_, false));
        }
        return true;
    }

    @Override
    public void m_6038_() {
        super.m_6038_();
        this.f_108611_ = false;
    }

    @Override
    public float m_5686_(float p_108742_) {
        return this.m_146909_();
    }

    @Override
    public float m_5675_(float p_108753_) {
        return this.m_20159_() ? super.m_5675_(p_108753_) : this.m_146908_();
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.m_151577_(this.m_146903_(), this.m_146907_())) {
            super.m_8119_();
            if (this.m_20159_()) {
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.Rot(this.m_146908_(), this.m_146909_(), this.f_19861_));
                this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerInputPacket(this.f_20900_, this.f_20902_, this.f_108618_.f_108572_, this.f_108618_.f_108573_));
                Entity entity = this.m_20201_();
                if (entity != this && entity.m_6109_()) {
                    this.f_108617_.m_104955_((Packet<?>)new ServerboundMoveVehiclePacket(entity));
                }
            } else {
                this.m_108640_();
            }
            for (AmbientSoundHandler ambientsoundhandler : this.f_108593_) {
                ambientsoundhandler.m_7551_();
            }
        }
    }

    public float m_108762_() {
        for (AmbientSoundHandler ambientsoundhandler : this.f_108593_) {
            if (!(ambientsoundhandler instanceof BiomeAmbientSoundsHandler)) continue;
            return ((BiomeAmbientSoundsHandler)ambientsoundhandler).m_119654_();
        }
        return 0.0f;
    }

    private void m_108640_() {
        boolean flag3;
        boolean flag = this.m_20142_();
        if (flag != this.f_108603_) {
            ServerboundPlayerCommandPacket.Action serverboundplayercommandpacket$action = flag ? ServerboundPlayerCommandPacket.Action.START_SPRINTING : ServerboundPlayerCommandPacket.Action.STOP_SPRINTING;
            this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, serverboundplayercommandpacket$action));
            this.f_108603_ = flag;
        }
        if ((flag3 = this.m_6144_()) != this.f_108602_) {
            ServerboundPlayerCommandPacket.Action serverboundplayercommandpacket$action1 = flag3 ? ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY : ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY;
            this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, serverboundplayercommandpacket$action1));
            this.f_108602_ = flag3;
        }
        if (this.m_108636_()) {
            boolean flag2;
            double d4 = this.m_20185_() - this.f_108595_;
            double d0 = this.m_20186_() - this.f_108596_;
            double d1 = this.m_20189_() - this.f_108597_;
            double d2 = this.m_146908_() - this.f_108598_;
            double d3 = this.m_146909_() - this.f_108599_;
            ++this.f_108604_;
            boolean flag1 = Mth.m_211592_((double)d4, (double)d0, (double)d1) > Mth.m_144952_((double)2.0E-4) || this.f_108604_ >= 20;
            boolean bl = flag2 = d2 != 0.0 || d3 != 0.0;
            if (this.m_20159_()) {
                Vec3 vec3 = this.m_20184_();
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.PosRot(vec3.f_82479_, -999.0, vec3.f_82481_, this.m_146908_(), this.m_146909_(), this.f_19861_));
                flag1 = false;
            } else if (flag1 && flag2) {
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.PosRot(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_(), this.f_19861_));
            } else if (flag1) {
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.Pos(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19861_));
            } else if (flag2) {
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.Rot(this.m_146908_(), this.m_146909_(), this.f_19861_));
            } else if (this.f_108600_ != this.f_19861_) {
                this.f_108617_.m_104955_((Packet<?>)new ServerboundMovePlayerPacket.StatusOnly(this.f_19861_));
            }
            if (flag1) {
                this.f_108595_ = this.m_20185_();
                this.f_108596_ = this.m_20186_();
                this.f_108597_ = this.m_20189_();
                this.f_108604_ = 0;
            }
            if (flag2) {
                this.f_108598_ = this.m_146908_();
                this.f_108599_ = this.m_146909_();
            }
            this.f_108600_ = this.f_19861_;
            this.f_108612_ = this.f_108619_.f_91066_.f_92036_;
        }
    }

    public boolean m_108700_(boolean p_108701_) {
        ServerboundPlayerActionPacket.Action serverboundplayeractionpacket$action = p_108701_ ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
        ItemStack itemstack = this.m_150109_().m_182403_(p_108701_);
        this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerActionPacket(serverboundplayeractionpacket$action, BlockPos.f_121853_, Direction.DOWN));
        return !itemstack.m_41619_();
    }

    public void m_108739_(String p_108740_) {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundChatPacket(p_108740_));
    }

    @Override
    public void m_6674_(InteractionHand p_108660_) {
        super.m_6674_(p_108660_);
        this.f_108617_.m_104955_((Packet<?>)new ServerboundSwingPacket(p_108660_));
    }

    @Override
    public void m_7583_() {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
    }

    @Override
    protected void m_6475_(DamageSource p_108729_, float p_108730_) {
        if (!this.m_6673_(p_108729_)) {
            this.m_21153_(this.m_21223_() - p_108730_);
        }
    }

    @Override
    public void m_6915_() {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundContainerClosePacket(this.f_36096_.f_38840_));
        this.m_108763_();
    }

    public void m_108763_() {
        super.m_6915_();
        this.f_108619_.m_91152_(null);
    }

    public void m_108760_(float p_108761_) {
        if (this.f_108605_) {
            float f = this.m_21223_() - p_108761_;
            if (f <= 0.0f) {
                this.m_21153_(p_108761_);
                if (f < 0.0f) {
                    this.f_19802_ = 10;
                }
            } else {
                this.f_20898_ = f;
                this.f_19802_ = 20;
                this.m_21153_(p_108761_);
                this.f_20916_ = this.f_20917_ = 10;
            }
        } else {
            this.m_21153_(p_108761_);
            this.f_108605_ = true;
        }
    }

    @Override
    public void m_6885_() {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerAbilitiesPacket(this.m_150110_()));
    }

    @Override
    public boolean m_7578_() {
        return true;
    }

    @Override
    public boolean m_5791_() {
        return !this.m_150110_().f_35935_ && super.m_5791_();
    }

    @Override
    public boolean m_5843_() {
        return !this.m_150110_().f_35935_ && super.m_5843_();
    }

    @Override
    public boolean m_6039_() {
        return !this.m_150110_().f_35935_ && super.m_6039_();
    }

    protected void m_108765_() {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.START_RIDING_JUMP, Mth.m_14143_((float)(this.m_108634_() * 100.0f))));
    }

    public void m_108628_() {
        this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.OPEN_INVENTORY));
    }

    public void m_108748_(@Nullable String p_108749_) {
        this.f_108606_ = p_108749_;
    }

    @Nullable
    public String m_108629_() {
        return this.f_108606_;
    }

    public StatsCounter m_108630_() {
        return this.f_108591_;
    }

    public ClientRecipeBook m_108631_() {
        return this.f_108592_;
    }

    public void m_108675_(Recipe<?> p_108676_) {
        if (this.f_108592_.m_12717_(p_108676_)) {
            this.f_108592_.m_12721_(p_108676_);
            this.f_108617_.m_104955_((Packet<?>)new ServerboundRecipeBookSeenRecipePacket(p_108676_));
        }
    }

    @Override
    public int m_8088_() {
        return this.f_108594_;
    }

    public void m_108648_(int p_108649_) {
        this.f_108594_ = p_108649_;
    }

    @Override
    public void m_5661_(Component p_108696_, boolean p_108697_) {
        if (p_108697_) {
            this.f_108619_.f_91065_.m_93063_(p_108696_, false);
        } else {
            this.f_108619_.f_91065_.m_93076_().m_93785_(p_108696_);
        }
    }

    private void m_108704_(double p_108705_, double p_108706_) {
        BlockPos blockpos = new BlockPos(p_108705_, this.m_20186_(), p_108706_);
        if (this.m_108746_(blockpos)) {
            Direction[] adirection;
            double d0 = p_108705_ - (double)blockpos.m_123341_();
            double d1 = p_108706_ - (double)blockpos.m_123343_();
            Direction direction = null;
            double d2 = Double.MAX_VALUE;
            for (Direction direction1 : adirection = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
                double d4;
                double d3 = direction1.m_122434_().m_6150_(d0, 0.0, d1);
                double d = d4 = direction1.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                if (!(d4 < d2) || this.m_108746_(blockpos.m_142300_(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                Vec3 vec3 = this.m_20184_();
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.m_20334_(0.1 * (double)direction.m_122429_(), vec3.f_82480_, vec3.f_82481_);
                } else {
                    this.m_20334_(vec3.f_82479_, vec3.f_82480_, 0.1 * (double)direction.m_122431_());
                }
            }
        }
    }

    private boolean m_108746_(BlockPos p_108747_) {
        AABB aabb = this.m_142469_();
        AABB aabb1 = new AABB((double)p_108747_.m_123341_(), aabb.f_82289_, (double)p_108747_.m_123343_(), (double)p_108747_.m_123341_() + 1.0, aabb.f_82292_, (double)p_108747_.m_123343_() + 1.0).m_82406_(1.0E-7);
        return this.f_19853_.m_186437_(this, aabb1);
    }

    @Override
    public void m_6858_(boolean p_108751_) {
        super.m_6858_(p_108751_);
        this.f_108584_ = 0;
    }

    public void m_108644_(float p_108645_, int p_108646_, int p_108647_) {
        this.f_36080_ = p_108645_;
        this.f_36079_ = p_108646_;
        this.f_36078_ = p_108647_;
    }

    @Override
    public void m_6352_(Component p_108693_, UUID p_108694_) {
        this.f_108619_.f_91065_.m_93076_().m_93785_(p_108693_);
    }

    @Override
    public void m_7822_(byte p_108643_) {
        if (p_108643_ >= 24 && p_108643_ <= 28) {
            this.m_108648_(p_108643_ - 24);
        } else {
            super.m_7822_(p_108643_);
        }
    }

    public void m_108711_(boolean p_108712_) {
        this.f_108616_ = p_108712_;
    }

    public boolean m_108632_() {
        return this.f_108616_;
    }

    @Override
    public void m_5496_(SoundEvent p_108651_, float p_108652_, float p_108653_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)this, (SoundEvent)p_108651_, (SoundSource)this.m_5720_(), (float)p_108652_, (float)p_108653_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_108651_ = event.getSound();
        p_108652_ = event.getVolume();
        p_108653_ = event.getPitch();
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), p_108651_, this.m_5720_(), p_108652_, p_108653_, false);
    }

    @Override
    public void m_6330_(SoundEvent p_108655_, SoundSource p_108656_, float p_108657_, float p_108658_) {
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), p_108655_, p_108656_, p_108657_, p_108658_, false);
    }

    @Override
    public boolean m_6142_() {
        return true;
    }

    @Override
    public void m_6672_(InteractionHand p_108718_) {
        ItemStack itemstack = this.m_21120_(p_108718_);
        if (!itemstack.m_41619_() && !this.m_6117_()) {
            super.m_6672_(p_108718_);
            this.f_108609_ = true;
            this.f_108610_ = p_108718_;
        }
    }

    @Override
    public boolean m_6117_() {
        return this.f_108609_;
    }

    @Override
    public void m_5810_() {
        super.m_5810_();
        this.f_108609_ = false;
    }

    @Override
    public InteractionHand m_7655_() {
        return Objects.requireNonNullElse(this.f_108610_, InteractionHand.MAIN_HAND);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_108699_) {
        super.m_7350_(p_108699_);
        if (f_20909_.equals(p_108699_)) {
            InteractionHand interactionhand;
            boolean flag = ((Byte)this.f_19804_.m_135370_(f_20909_) & 1) > 0;
            InteractionHand interactionHand = interactionhand = ((Byte)this.f_19804_.m_135370_(f_20909_) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if (flag && !this.f_108609_) {
                this.m_6672_(interactionhand);
            } else if (!flag && this.f_108609_) {
                this.m_5810_();
            }
        }
        if (f_19805_.equals(p_108699_) && this.m_21255_() && !this.f_108614_) {
            this.f_108619_.m_91106_().m_120367_((SoundInstance)new ElytraOnPlayerSoundInstance(this));
        }
    }

    public boolean m_108633_() {
        Entity entity = this.m_20202_();
        return this.m_20159_() && entity instanceof PlayerRideableJumping && ((PlayerRideableJumping)entity).m_7132_();
    }

    public float m_108634_() {
        return this.f_108608_;
    }

    @Override
    public void m_7739_(SignBlockEntity p_108684_) {
        this.f_108619_.m_91152_((Screen)new SignEditScreen(p_108684_, this.f_108619_.m_167974_()));
    }

    @Override
    public void m_7907_(BaseCommandBlock p_108678_) {
        this.f_108619_.m_91152_((Screen)new MinecartCommandBlockEditScreen(p_108678_));
    }

    @Override
    public void m_7698_(CommandBlockEntity p_108680_) {
        this.f_108619_.m_91152_((Screen)new CommandBlockEditScreen(p_108680_));
    }

    @Override
    public void m_5966_(StructureBlockEntity p_108686_) {
        this.f_108619_.m_91152_((Screen)new StructureBlockEditScreen(p_108686_));
    }

    @Override
    public void m_7569_(JigsawBlockEntity p_108682_) {
        this.f_108619_.m_91152_((Screen)new JigsawBlockEditScreen(p_108682_));
    }

    @Override
    public void m_6986_(ItemStack p_108673_, InteractionHand p_108674_) {
        if (p_108673_.m_150930_(Items.f_42614_)) {
            this.f_108619_.m_91152_((Screen)new BookEditScreen((Player)this, p_108673_, p_108674_));
        }
    }

    @Override
    public void m_5704_(Entity p_108665_) {
        this.f_108619_.f_91061_.m_107329_(p_108665_, (ParticleOptions)ParticleTypes.f_123797_);
    }

    @Override
    public void m_5700_(Entity p_108710_) {
        this.f_108619_.f_91061_.m_107329_(p_108710_, (ParticleOptions)ParticleTypes.f_123808_);
    }

    @Override
    public boolean m_6144_() {
        return this.f_108618_ != null && this.f_108618_.f_108573_;
    }

    @Override
    public boolean m_6047_() {
        return this.f_108601_;
    }

    public boolean m_108635_() {
        return this.m_6047_() || this.m_20143_();
    }

    @Override
    public void m_6140_() {
        super.m_6140_();
        if (this.m_108636_()) {
            this.f_20900_ = this.f_108618_.f_108566_;
            this.f_20902_ = this.f_108618_.f_108567_;
            this.f_20899_ = this.f_108618_.f_108572_;
            this.f_108587_ = this.f_108585_;
            this.f_108588_ = this.f_108586_;
            this.f_108586_ += (this.m_146909_() - this.f_108586_) * 0.5f;
            this.f_108585_ += (this.m_146908_() - this.f_108585_) * 0.5f;
        }
    }

    protected boolean m_108636_() {
        return this.f_108619_.m_91288_() == this;
    }

    public void m_172530_() {
        this.m_20124_(Pose.STANDING);
        if (this.f_19853_ != null) {
            for (double d0 = this.m_20186_(); d0 > (double)this.f_19853_.m_141937_() && d0 < (double)this.f_19853_.m_151558_(); d0 += 1.0) {
                this.m_6034_(this.m_20185_(), d0, this.m_20189_());
                if (this.f_19853_.m_45786_(this)) break;
            }
            this.m_20256_(Vec3.f_82478_);
            this.m_146926_(0.0f);
        }
        this.m_21153_(this.m_21233_());
        this.f_20919_ = 0;
    }

    @Override
    public void m_8107_() {
        ItemStack itemstack;
        boolean flag4;
        ++this.f_108584_;
        if (this.f_108583_ > 0) {
            --this.f_108583_;
        }
        this.m_108641_();
        boolean flag = this.f_108618_.f_108572_;
        boolean flag1 = this.f_108618_.f_108573_;
        boolean flag2 = this.m_108733_();
        this.f_108601_ = !this.m_150110_().f_35935_ && !this.m_6069_() && this.m_20175_(Pose.CROUCHING) && (this.m_6144_() || !this.m_5803_() && !this.m_20175_(Pose.STANDING));
        this.f_108618_.m_7606_(this.m_108635_());
        ForgeHooksClient.onMovementInputUpdate((Player)this, (Input)this.f_108618_);
        this.f_108619_.m_91301_().m_120586_(this.f_108618_);
        if (this.m_6117_() && !this.m_20159_()) {
            this.f_108618_.f_108566_ *= 0.2f;
            this.f_108618_.f_108567_ *= 0.2f;
            this.f_108583_ = 0;
        }
        boolean flag3 = false;
        if (this.f_108613_ > 0) {
            --this.f_108613_;
            flag3 = true;
            this.f_108618_.f_108572_ = true;
        }
        if (!this.f_19794_) {
            this.m_108704_(this.m_20185_() - (double)this.m_20205_() * 0.35, this.m_20189_() + (double)this.m_20205_() * 0.35);
            this.m_108704_(this.m_20185_() - (double)this.m_20205_() * 0.35, this.m_20189_() - (double)this.m_20205_() * 0.35);
            this.m_108704_(this.m_20185_() + (double)this.m_20205_() * 0.35, this.m_20189_() - (double)this.m_20205_() * 0.35);
            this.m_108704_(this.m_20185_() + (double)this.m_20205_() * 0.35, this.m_20189_() + (double)this.m_20205_() * 0.35);
        }
        if (flag1) {
            this.f_108583_ = 0;
        }
        boolean bl = flag4 = (float)this.m_36324_().m_38702_() > 6.0f || this.m_150110_().f_35936_;
        if (!(!this.f_19861_ && !this.m_5842_() || flag1 || flag2 || !this.m_108733_() || this.m_20142_() || !flag4 || this.m_6117_() || this.m_21023_(MobEffects.f_19610_))) {
            if (this.f_108583_ <= 0 && !this.f_108619_.f_91066_.f_92091_.m_90857_()) {
                this.f_108583_ = 7;
            } else {
                this.m_6858_(true);
            }
        }
        if (!this.m_20142_() && (!this.m_20069_() || this.m_5842_()) && this.m_108733_() && flag4 && !this.m_6117_() && !this.m_21023_(MobEffects.f_19610_) && this.f_108619_.f_91066_.f_92091_.m_90857_()) {
            this.m_6858_(true);
        }
        if (this.m_20142_()) {
            boolean flag6;
            boolean flag5 = !this.f_108618_.m_108577_() || !flag4;
            boolean bl2 = flag6 = flag5 || this.f_19862_ && !this.f_185931_ || this.m_20069_() && !this.m_5842_();
            if (this.m_6069_()) {
                if (!this.f_19861_ && !this.f_108618_.f_108573_ && flag5 || !this.m_20069_()) {
                    this.m_6858_(false);
                }
            } else if (flag6) {
                this.m_6858_(false);
            }
        }
        boolean flag7 = false;
        if (this.m_150110_().f_35936_) {
            if (this.f_108619_.f_91072_.m_105293_()) {
                if (!this.m_150110_().f_35935_) {
                    this.m_150110_().f_35935_ = true;
                    flag7 = true;
                    this.m_6885_();
                }
            } else if (!flag && this.f_108618_.f_108572_ && !flag3) {
                if (this.f_36098_ == 0) {
                    this.f_36098_ = 7;
                } else if (!this.m_6069_()) {
                    this.m_150110_().f_35935_ = !this.m_150110_().f_35935_;
                    flag7 = true;
                    this.m_6885_();
                    this.f_36098_ = 0;
                }
            }
        }
        if (this.f_108618_.f_108572_ && !flag7 && !flag && !this.m_150110_().f_35935_ && !this.m_20159_() && !this.m_6147_() && (itemstack = this.m_6844_(EquipmentSlot.CHEST)).canElytraFly(this) && this.m_36319_()) {
            this.f_108617_.m_104955_((Packet<?>)new ServerboundPlayerCommandPacket((Entity)this, ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
        }
        this.f_108614_ = this.m_21255_();
        if (this.m_20069_() && this.f_108618_.f_108573_ && this.m_6129_()) {
            this.m_21208_();
        }
        if (this.m_204029_(FluidTags.f_13131_)) {
            int i = this.m_5833_() ? 10 : 1;
            this.f_108615_ = Mth.m_14045_((int)(this.f_108615_ + i), (int)0, (int)600);
        } else if (this.f_108615_ > 0) {
            this.m_204029_(FluidTags.f_13131_);
            this.f_108615_ = Mth.m_14045_((int)(this.f_108615_ - 10), (int)0, (int)600);
        }
        if (this.m_150110_().f_35935_ && this.m_108636_()) {
            int j = 0;
            if (this.f_108618_.f_108573_) {
                --j;
            }
            if (this.f_108618_.f_108572_) {
                ++j;
            }
            if (j != 0) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)((float)j * this.m_150110_().m_35942_() * 3.0f), 0.0));
            }
        }
        if (this.m_108633_()) {
            PlayerRideableJumping playerrideablejumping = (PlayerRideableJumping)this.m_20202_();
            if (this.f_108607_ < 0) {
                ++this.f_108607_;
                if (this.f_108607_ == 0) {
                    this.f_108608_ = 0.0f;
                }
            }
            if (flag && !this.f_108618_.f_108572_) {
                this.f_108607_ = -10;
                playerrideablejumping.m_7888_(Mth.m_14143_((float)(this.m_108634_() * 100.0f)));
                this.m_108765_();
            } else if (!flag && this.f_108618_.f_108572_) {
                this.f_108607_ = 0;
                this.f_108608_ = 0.0f;
            } else if (flag) {
                ++this.f_108607_;
                this.f_108608_ = this.f_108607_ < 10 ? (float)this.f_108607_ * 0.1f : 0.8f + 2.0f / (float)(this.f_108607_ - 9) * 0.1f;
            }
        } else {
            this.f_108608_ = 0.0f;
        }
        super.m_8107_();
        if (this.f_19861_ && this.m_150110_().f_35935_ && !this.f_108619_.f_91072_.m_105293_()) {
            this.m_150110_().f_35935_ = false;
            this.m_6885_();
        }
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void m_108641_() {
        this.f_108590_ = this.f_108589_;
        if (this.f_19817_) {
            if (!(this.f_108619_.f_91080_ == null || this.f_108619_.f_91080_.m_7043_() || this.f_108619_.f_91080_ instanceof DeathScreen || this.f_108619_.f_91080_ instanceof ReceivingLevelScreen)) {
                if (this.f_108619_.f_91080_ instanceof AbstractContainerScreen) {
                    this.m_6915_();
                }
                this.f_108619_.m_91152_(null);
            }
            if (this.f_108589_ == 0.0f) {
                this.f_108619_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12288_, (float)(this.f_19796_.nextFloat() * 0.4f + 0.8f), (float)0.25f));
            }
            this.f_108589_ += 0.0125f;
            if (this.f_108589_ >= 1.0f) {
                this.f_108589_ = 1.0f;
            }
            this.f_19817_ = false;
        } else if (this.m_21023_(MobEffects.f_19604_) && this.m_21124_(MobEffects.f_19604_).m_19557_() > 60) {
            this.f_108589_ += 0.006666667f;
            if (this.f_108589_ > 1.0f) {
                this.f_108589_ = 1.0f;
            }
        } else {
            if (this.f_108589_ > 0.0f) {
                this.f_108589_ -= 0.05f;
            }
            if (this.f_108589_ < 0.0f) {
                this.f_108589_ = 0.0f;
            }
        }
        this.m_8021_();
    }

    @Override
    public void m_6083_() {
        super.m_6083_();
        if (this.m_36342_() && this.m_20159_()) {
            this.f_108618_.f_108573_ = false;
        }
        this.f_108611_ = false;
        if (this.m_20202_() instanceof Boat) {
            Boat boat = (Boat)this.m_20202_();
            boat.m_38342_(this.f_108618_.f_108570_, this.f_108618_.f_108571_, this.f_108618_.f_108568_, this.f_108618_.f_108569_);
            this.f_108611_ |= this.f_108618_.f_108570_ || this.f_108618_.f_108571_ || this.f_108618_.f_108568_ || this.f_108618_.f_108569_;
        }
    }

    public boolean m_108637_() {
        return this.f_108611_;
    }

    @Override
    @Nullable
    public MobEffectInstance m_6234_(@Nullable MobEffect p_108720_) {
        if (p_108720_ == MobEffects.f_19604_) {
            this.f_108590_ = 0.0f;
            this.f_108589_ = 0.0f;
        }
        return super.m_6234_(p_108720_);
    }

    @Override
    public void m_6478_(MoverType p_108670_, Vec3 p_108671_) {
        double d0 = this.m_20185_();
        double d1 = this.m_20189_();
        super.m_6478_(p_108670_, p_108671_);
        this.m_108743_((float)(this.m_20185_() - d0), (float)(this.m_20189_() - d1));
    }

    public boolean m_108638_() {
        return this.f_108612_;
    }

    protected void m_108743_(float p_108744_, float p_108745_) {
        if (this.m_108731_()) {
            Vec3 vec3 = this.m_20182_();
            Vec3 vec31 = vec3.m_82520_((double)p_108744_, 0.0, (double)p_108745_);
            Vec3 vec32 = new Vec3((double)p_108744_, 0.0, (double)p_108745_);
            float f = this.m_6113_();
            float f1 = (float)vec32.m_82556_();
            if (f1 <= 0.001f) {
                Vec2 vec2 = this.f_108618_.m_108575_();
                float f2 = f * vec2.f_82470_;
                float f3 = f * vec2.f_82471_;
                float f4 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f5 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                vec32 = new Vec3((double)(f2 * f5 - f3 * f4), vec32.f_82480_, (double)(f3 * f5 + f2 * f4));
                f1 = (float)vec32.m_82556_();
                if (f1 <= 0.001f) {
                    return;
                }
            }
            float f12 = Mth.m_14195_((float)f1);
            Vec3 vec312 = vec32.m_82490_((double)f12);
            Vec3 vec313 = this.m_20156_();
            float f13 = (float)(vec313.f_82479_ * vec312.f_82479_ + vec313.f_82481_ * vec312.f_82481_);
            if (!(f13 < -0.15f)) {
                BlockState blockstate1;
                CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
                BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_());
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_60742_((BlockGetter)((Object)this.f_19853_), blockpos, collisioncontext).m_83281_() && (blockstate1 = this.f_19853_.m_8055_(blockpos = blockpos.m_7494_())).m_60742_((BlockGetter)((Object)this.f_19853_), blockpos, collisioncontext).m_83281_()) {
                    float f14;
                    float f6 = 7.0f;
                    float f7 = 1.2f;
                    if (this.m_21023_(MobEffects.f_19603_)) {
                        f7 += (float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.75f;
                    }
                    float f8 = Math.max(f * 7.0f, 1.0f / f12);
                    Vec3 vec34 = vec31.m_82549_(vec312.m_82490_((double)f8));
                    float f9 = this.m_20205_();
                    float f10 = this.m_20206_();
                    AABB aabb = new AABB(vec3, vec34.m_82520_(0.0, (double)f10, 0.0)).m_82377_((double)f9, 0.0, (double)f9);
                    Vec3 $$23 = vec3.m_82520_(0.0, (double)0.51f, 0.0);
                    vec34 = vec34.m_82520_(0.0, (double)0.51f, 0.0);
                    Vec3 vec35 = vec312.m_82537_(new Vec3(0.0, 1.0, 0.0));
                    Vec3 vec36 = vec35.m_82490_((double)(f9 * 0.5f));
                    Vec3 vec37 = $$23.m_82546_(vec36);
                    Vec3 vec38 = vec34.m_82546_(vec36);
                    Vec3 vec39 = $$23.m_82549_(vec36);
                    Vec3 vec310 = vec34.m_82549_(vec36);
                    Iterable iterable = this.f_19853_.m_186431_(this, aabb);
                    Iterator iterator = StreamSupport.stream(iterable.spliterator(), false).flatMap(p_194296_ -> p_194296_.m_83299_().stream()).iterator();
                    float f11 = Float.MIN_VALUE;
                    while (iterator.hasNext()) {
                        AABB aabb1 = (AABB)iterator.next();
                        if (!aabb1.m_82335_(vec37, vec38) && !aabb1.m_82335_(vec39, vec310)) continue;
                        f11 = (float)aabb1.f_82292_;
                        Vec3 vec311 = aabb1.m_82399_();
                        BlockPos blockpos1 = new BlockPos(vec311);
                        int i = 1;
                        while ((float)i < f7) {
                            BlockState blockstate3;
                            BlockPos blockpos2 = blockpos1.m_6630_(i);
                            BlockState blockstate2 = this.f_19853_.m_8055_(blockpos2);
                            VoxelShape voxelshape = blockstate2.m_60742_((BlockGetter)((Object)this.f_19853_), blockpos2, collisioncontext);
                            if (!voxelshape.m_83281_() && (double)(f11 = (float)voxelshape.m_83297_(Direction.Axis.Y) + (float)blockpos2.m_123342_()) - this.m_20186_() > (double)f7) {
                                return;
                            }
                            if (i > 1 && !(blockstate3 = this.f_19853_.m_8055_(blockpos = blockpos.m_7494_())).m_60742_((BlockGetter)((Object)this.f_19853_), blockpos, collisioncontext).m_83281_()) {
                                return;
                            }
                            ++i;
                        }
                        break block0;
                    }
                    if (f11 != Float.MIN_VALUE && !((f14 = (float)((double)f11 - this.m_20186_())) <= 0.5f) && !(f14 > f7)) {
                        this.f_108613_ = 1;
                    }
                }
            }
        }
    }

    @Override
    protected boolean m_196406_(Vec3 p_197411_) {
        float f = this.m_146908_() * ((float)Math.PI / 180);
        double d0 = Mth.m_14031_((float)f);
        double d1 = Mth.m_14089_((float)f);
        double d2 = (double)this.f_20900_ * d1 - (double)this.f_20902_ * d0;
        double d3 = (double)this.f_20902_ * d1 + (double)this.f_20900_ * d0;
        double d4 = Mth.m_144952_((double)d2) + Mth.m_144952_((double)d3);
        double d5 = Mth.m_144952_((double)p_197411_.f_82479_) + Mth.m_144952_((double)p_197411_.f_82481_);
        if (!(d4 < (double)1.0E-5f) && !(d5 < (double)1.0E-5f)) {
            double d6 = d2 * p_197411_.f_82479_ + d3 * p_197411_.f_82481_;
            double d7 = Math.acos(d6 / Math.sqrt(d4 * d5));
            return d7 < 0.13962633907794952;
        }
        return false;
    }

    private boolean m_108731_() {
        return this.m_108638_() && this.f_108613_ <= 0 && this.f_19861_ && !this.m_36343_() && !this.m_20159_() && this.m_108732_() && (double)this.m_20098_() >= 1.0;
    }

    private boolean m_108732_() {
        Vec2 vec2 = this.f_108618_.m_108575_();
        return vec2.f_82470_ != 0.0f || vec2.f_82471_ != 0.0f;
    }

    private boolean m_108733_() {
        double d0 = 0.8;
        return this.m_5842_() ? this.f_108618_.m_108577_() : (double)this.f_108618_.f_108567_ >= 0.8;
    }

    public float m_108639_() {
        if (!this.m_204029_(FluidTags.f_13131_)) {
            return 0.0f;
        }
        float f = 600.0f;
        float f1 = 100.0f;
        if ((float)this.f_108615_ >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.m_14036_((float)((float)this.f_108615_ / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.f_108615_ < 100.0f ? 0.0f : Mth.m_14036_((float)(((float)this.f_108615_ - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    @Override
    public boolean m_5842_() {
        return this.f_36076_;
    }

    @Override
    protected boolean m_7602_() {
        boolean flag = this.f_36076_;
        boolean flag1 = super.m_7602_();
        if (this.m_5833_()) {
            return this.f_36076_;
        }
        if (!flag && flag1) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12537_, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            this.f_108619_.m_91106_().m_120367_((SoundInstance)new UnderwaterAmbientSoundInstances.UnderwaterAmbientSoundInstance(this));
        }
        if (flag && !flag1) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12590_, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.f_36076_;
    }

    @Override
    public Vec3 m_7398_(float p_108758_) {
        if (this.f_108619_.f_91066_.m_92176_().m_90612_()) {
            float f = Mth.m_14179_((float)(p_108758_ * 0.5f), (float)this.m_146908_(), (float)this.f_19859_) * ((float)Math.PI / 180);
            float f1 = Mth.m_14179_((float)(p_108758_ * 0.5f), (float)this.m_146909_(), (float)this.f_19860_) * ((float)Math.PI / 180);
            double d0 = this.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0;
            Vec3 vec3 = new Vec3(0.39 * d0, -0.6, 0.3);
            return vec3.m_82496_(-f1).m_82524_(-f).m_82549_(this.m_20299_(p_108758_));
        }
        return super.m_7398_(p_108758_);
    }

    public void updateSyncFields(LocalPlayer old) {
        this.f_108595_ = old.f_108595_;
        this.f_108596_ = old.f_108596_;
        this.f_108597_ = old.f_108597_;
        this.f_108598_ = old.f_108598_;
        this.f_108599_ = old.f_108599_;
        this.f_108600_ = old.f_108600_;
        this.f_108602_ = old.f_108602_;
        this.f_108603_ = old.f_108603_;
        this.f_108604_ = old.f_108604_;
    }

    @Override
    public void m_141945_(ItemStack p_172532_, ItemStack p_172533_, ClickAction p_172534_) {
        this.f_108619_.m_91301_().m_175024_(p_172532_, p_172533_, p_172534_);
    }
}

