/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger f_13445_ = LogUtils.getLogger();
    private static final Gson f_13446_ = new Gson();
    private static final String f_144491_ = ".json";
    private static final int f_13447_ = ".json".length();
    private final Function<ResourceLocation, Optional<T>> f_13448_;
    private final String f_13449_;

    public TagLoader(Function<ResourceLocation, Optional<T>> p_144493_, String p_144494_) {
        this.f_13448_ = p_144493_;
        this.f_13449_ = p_144494_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ResourceLocation, Tag.Builder> m_144495_(ResourceManager p_144496_) {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation resourcelocation : p_144496_.m_6540_(this.f_13449_, p_144506_ -> p_144506_.endsWith(f_144491_))) {
            String s = resourcelocation.m_135815_();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.m_135827_(), s.substring(this.f_13449_.length() + 1, s.length() - f_13447_));
            try {
                for (Resource resource : p_144496_.m_7396_(resourcelocation)) {
                    try {
                        InputStream inputstream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                            JsonObject jsonobject = (JsonObject)GsonHelper.m_13776_((Gson)f_13446_, (Reader)reader, JsonObject.class);
                            if (jsonobject == null) {
                                f_13445_.error("Couldn't load tag list {} from {} in data pack {} as it is empty or null", new Object[]{resourcelocation1, resourcelocation, resource.m_7816_()});
                                continue;
                            }
                            map.computeIfAbsent(resourcelocation1, p_144555_ -> Tag.Builder.m_13304_()).m_13312_(jsonobject, resource.m_7816_());
                        }
                        finally {
                            if (inputstream == null) continue;
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException ioexception) {
                        f_13445_.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourcelocation1, resourcelocation, resource.m_7816_(), ioexception});
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException ioexception1) {
                f_13445_.error("Couldn't read tag list {} from {}", new Object[]{resourcelocation1, resourcelocation, ioexception1});
            }
        }
        return map;
    }

    private static void m_144523_(Map<ResourceLocation, Tag.Builder> p_144524_, Multimap<ResourceLocation, ResourceLocation> p_144525_, Set<ResourceLocation> p_144526_, ResourceLocation p_144527_, BiConsumer<ResourceLocation, Tag.Builder> p_144528_) {
        if (p_144526_.add(p_144527_)) {
            p_144525_.get((Object)p_144527_).forEach(p_144514_ -> TagLoader.m_144523_(p_144524_, p_144525_, p_144526_, p_144514_, p_144528_));
            Tag.Builder tag$builder = p_144524_.get(p_144527_);
            if (tag$builder != null) {
                p_144528_.accept(p_144527_, tag$builder);
            }
        }
    }

    private static boolean m_144501_(Multimap<ResourceLocation, ResourceLocation> p_144502_, ResourceLocation p_144503_, ResourceLocation p_144504_) {
        Collection collection = p_144502_.get((Object)p_144504_);
        return collection.contains(p_144503_) ? true : collection.stream().anyMatch(p_144567_ -> TagLoader.m_144501_(p_144502_, p_144503_, p_144567_));
    }

    private static void m_144550_(Multimap<ResourceLocation, ResourceLocation> p_144551_, ResourceLocation p_144552_, ResourceLocation p_144553_) {
        if (!TagLoader.m_144501_(p_144551_, p_144552_, p_144553_)) {
            p_144551_.put((Object)p_144552_, (Object)p_144553_);
        }
    }

    public Map<ResourceLocation, Tag<T>> m_203898_(Map<ResourceLocation, Tag.Builder> p_203899_) {
        HashMap map = Maps.newHashMap();
        Function<ResourceLocation, Tag> function = map::get;
        Function<ResourceLocation, Object> function1 = p_144540_ -> this.f_13448_.apply((ResourceLocation)p_144540_).orElse(null);
        HashMultimap multimap = HashMultimap.create();
        p_203899_.forEach((arg_0, arg_1) -> TagLoader.m_144546_((Multimap)multimap, arg_0, arg_1));
        p_203899_.forEach((arg_0, arg_1) -> TagLoader.m_144497_((Multimap)multimap, arg_0, arg_1));
        HashSet set = Sets.newHashSet();
        p_203899_.keySet().forEach(arg_0 -> TagLoader.m_144515_(p_203899_, (Multimap)multimap, set, function, function1, map, arg_0));
        return map;
    }

    public Map<ResourceLocation, Tag<T>> m_203900_(ResourceManager p_203901_) {
        return this.m_203898_(this.m_144495_(p_203901_));
    }

    private static /* synthetic */ void m_144515_(Map p_144516_, Multimap p_144517_, Set p_144518_, Function p_144519_, Function p_144520_, Map p_144521_, ResourceLocation p_144522_) {
        TagLoader.m_144523_(p_144516_, (Multimap<ResourceLocation, ResourceLocation>)p_144517_, p_144518_, p_144522_, (p_144537_, p_144538_) -> p_144538_.m_144371_(p_144519_, p_144520_).ifLeft(p_144543_ -> f_13445_.error("Couldn't load tag {} as it is missing following references: {}", p_144537_, (Object)p_144543_.stream().map(Objects::toString).collect(Collectors.joining(", \n\t")))).ifRight(p_144532_ -> p_144521_.put(p_144537_, p_144532_)));
    }

    private static /* synthetic */ void m_144497_(Multimap p_144498_, ResourceLocation p_144499_, Tag.Builder p_144500_) {
        p_144500_.m_144374_(p_144559_ -> TagLoader.m_144550_((Multimap<ResourceLocation, ResourceLocation>)p_144498_, p_144499_, p_144559_));
    }

    private static /* synthetic */ void m_144546_(Multimap p_144547_, ResourceLocation p_144548_, Tag.Builder p_144549_) {
        p_144549_.m_144366_(p_144563_ -> TagLoader.m_144550_((Multimap<ResourceLocation, ResourceLocation>)p_144547_, p_144548_, p_144563_));
    }
}

