/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;

public abstract class AbstractMinecart
extends Entity
implements IForgeAbstractMinecart {
    private static final EntityDataAccessor<Integer> f_38079_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_38080_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> f_38081_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_38082_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_38083_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> f_38084_ = SynchedEntityData.m_135353_(AbstractMinecart.class, EntityDataSerializers.f_135035_);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> f_38067_ = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float f_150249_ = 0.95f;
    private boolean f_38068_;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> f_38069_ = Util.m_137469_(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.m_122436_();
        Vec3i vec3i1 = Direction.EAST.m_122436_();
        Vec3i vec3i2 = Direction.NORTH.m_122436_();
        Vec3i vec3i3 = Direction.SOUTH.m_122436_();
        Vec3i vec3i4 = vec3i.m_7495_();
        Vec3i vec3i5 = vec3i1.m_7495_();
        Vec3i vec3i6 = vec3i2.m_7495_();
        Vec3i vec3i7 = vec3i3.m_7495_();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });
    private static IMinecartCollisionHandler COLLISIONS = null;
    private int f_38070_;
    private double f_38071_;
    private double f_38072_;
    private double f_38073_;
    private double f_38074_;
    private double f_38075_;
    private double f_38076_;
    private double f_38077_;
    private double f_38078_;
    private boolean canBePushed = true;
    private boolean canUseRail = true;
    private float currentSpeedCapOnRail = this.getMaxCartSpeedOnRail();
    private float maxSpeedAirLateral = 0.4f;
    private float maxSpeedAirVertical = -1.0f;
    private double dragAir = 0.95f;

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.f_19850_ = true;
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.m_6034_(p_38092_, p_38093_, p_38094_);
        this.f_19854_ = p_38092_;
        this.f_19855_ = p_38093_;
        this.f_19856_ = p_38094_;
    }

    public IMinecartCollisionHandler getCollisionHandler() {
        return COLLISIONS;
    }

    public static void registerCollisionHandler(@Nullable IMinecartCollisionHandler handler) {
        COLLISIONS = handler;
    }

    public static AbstractMinecart m_38119_(Level p_38120_, double p_38121_, double p_38122_, double p_38123_, Type p_38124_) {
        if (p_38124_ == Type.CHEST) {
            return new MinecartChest(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.FURNACE) {
            return new MinecartFurnace(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.TNT) {
            return new MinecartTNT(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.SPAWNER) {
            return new MinecartSpawner(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        if (p_38124_ == Type.HOPPER) {
            return new MinecartHopper(p_38120_, p_38121_, p_38122_, p_38123_);
        }
        return p_38124_ == Type.COMMAND_BLOCK ? new MinecartCommandBlock(p_38120_, p_38121_, p_38122_, p_38123_) : new Minecart(p_38120_, p_38121_, p_38122_, p_38123_);
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(f_38079_, 0);
        this.f_19804_.m_135372_(f_38080_, 1);
        this.f_19804_.m_135372_(f_38081_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_38082_, Block.m_49956_(Blocks.f_50016_.m_49966_()));
        this.f_19804_.m_135372_(f_38083_, 6);
        this.f_19804_.m_135372_(f_38084_, false);
    }

    @Override
    public boolean m_7337_(Entity p_38168_) {
        return Boat.m_38323_(this, p_38168_);
    }

    @Override
    public boolean m_6094_() {
        return this.canBePushed;
    }

    @Override
    protected Vec3 m_7643_(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.m_21289_(super.m_7643_(p_38132_, p_38133_));
    }

    @Override
    public double m_6048_() {
        return 0.0;
    }

    @Override
    public Vec3 m_7688_(LivingEntity p_38145_) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(p_38145_);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = p_38145_.m_7431_();
        for (Pose pose : immutablelist) {
            EntityDimensions entitydimensions = p_38145_.m_6972_(pose);
            float f = Math.min(entitydimensions.f_20377_, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)f_38067_.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] aint1 : aint) {
                    Vec3 vec3;
                    AABB aabb;
                    blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_() + i, blockpos.m_123343_() + aint1[1]);
                    double d0 = this.f_19853_.m_45564_(DismountHelper.m_38446_((BlockGetter)((Object)this.f_19853_), (BlockPos)blockpos$mutableblockpos), () -> DismountHelper.m_38446_((BlockGetter)((Object)this.f_19853_), (BlockPos)blockpos$mutableblockpos.m_7495_()));
                    if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)p_38145_, (AABB)(aabb = new AABB((double)(-f), 0.0, (double)(-f), (double)f, (double)entitydimensions.f_20378_, (double)f)).m_82383_(vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0)))) continue;
                    p_38145_.m_20124_(pose);
                    return vec3;
                }
            }
        }
        double d1 = this.m_142469_().f_82292_;
        blockpos$mutableblockpos.m_122169_((double)blockpos.m_123341_(), d1, (double)blockpos.m_123343_());
        for (Pose pose1 : immutablelist) {
            double d2 = p_38145_.m_6972_((Pose)pose1).f_20378_;
            int j = Mth.m_14165_((double)(d1 - (double)blockpos$mutableblockpos.m_123342_() + d2));
            double d3 = DismountHelper.m_38463_((BlockPos)blockpos$mutableblockpos, (int)j, p_38149_ -> this.f_19853_.m_8055_((BlockPos)p_38149_).m_60812_((BlockGetter)((Object)this.f_19853_), (BlockPos)p_38149_));
            if (!(d1 + d2 <= d3)) continue;
            p_38145_.m_20124_(pose1);
            break;
        }
        return super.m_7688_(p_38145_);
    }

    @Override
    public boolean m_6469_(DamageSource p_38117_, float p_38118_) {
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean flag;
            if (this.m_6673_(p_38117_)) {
                return false;
            }
            this.m_38160_(-this.m_38177_());
            this.m_38154_(10);
            this.m_5834_();
            this.m_38109_(this.m_38169_() + p_38118_ * 10.0f);
            this.m_146852_(GameEvent.f_157808_, p_38117_.m_7639_());
            boolean bl = flag = p_38117_.m_7639_() instanceof Player && ((Player)p_38117_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.m_38169_() > 40.0f) {
                this.m_20153_();
                if (flag && !this.m_8077_()) {
                    this.m_146870_();
                } else {
                    this.m_7617_(p_38117_);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected float m_6041_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_142538_());
        return blockstate.m_204336_(BlockTags.f_13034_) ? 1.0f : super.m_6041_();
    }

    public void m_7617_(DamageSource p_38115_) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = new ItemStack(Items.f_42449_);
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
        }
    }

    @Override
    public void m_6053_() {
        this.m_38160_(-this.m_38177_());
        this.m_38154_(10);
        this.m_38109_(this.m_38169_() + this.m_38169_() * 10.0f);
    }

    @Override
    public boolean m_6087_() {
        return !this.m_146910_();
    }

    private static Pair<Vec3i, Vec3i> m_38125_(RailShape p_38126_) {
        return f_38069_.get(p_38126_);
    }

    @Override
    public Direction m_6374_() {
        return this.f_38068_ ? this.m_6350_().m_122424_().m_122427_() : this.m_6350_().m_122427_();
    }

    @Override
    public void m_8119_() {
        if (this.m_38176_() > 0) {
            this.m_38154_(this.m_38176_() - 1);
        }
        if (this.m_38169_() > 0.0f) {
            this.m_38109_(this.m_38169_() - 1.0f);
        }
        this.m_146871_();
        this.m_20157_();
        if (this.f_19853_.f_46443_) {
            if (this.f_38070_ > 0) {
                double d5 = this.m_20185_() + (this.f_38071_ - this.m_20185_()) / (double)this.f_38070_;
                double d6 = this.m_20186_() + (this.f_38072_ - this.m_20186_()) / (double)this.f_38070_;
                double d7 = this.m_20189_() + (this.f_38073_ - this.m_20189_()) / (double)this.f_38070_;
                double d2 = Mth.m_14175_((double)(this.f_38074_ - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_38070_);
                this.m_146926_(this.m_146909_() + (float)(this.f_38075_ - (double)this.m_146909_()) / (float)this.f_38070_);
                --this.f_38070_;
                this.m_6034_(d5, d6, d7);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
        } else {
            double d4;
            int j;
            int i;
            int k;
            if (!this.m_20068_()) {
                double d0 = this.m_20069_() ? -0.005 : -0.04;
                this.m_20256_(this.m_20184_().m_82520_(0.0, d0, 0.0));
            }
            if (this.f_19853_.m_8055_(new BlockPos(k = Mth.m_14107_((double)this.m_20185_()), (i = Mth.m_14107_((double)this.m_20186_())) - 1, j = Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                --i;
            }
            BlockPos blockpos = new BlockPos(k, i, j);
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (this.canUseRail() && BaseRailBlock.m_49416_(blockstate)) {
                this.m_6401_(blockpos, blockstate);
                if (blockstate.m_60734_() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.m_60734_()).isActivatorRail()) {
                    this.m_6025_(k, i, j, (Boolean)blockstate.m_61143_((Property)PoweredRailBlock.f_55215_));
                }
            } else {
                this.m_38163_();
            }
            this.m_20101_();
            this.m_146926_(0.0f);
            double d1 = this.f_19854_ - this.m_20185_();
            double d3 = this.f_19856_ - this.m_20189_();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI));
                if (this.f_38068_) {
                    this.m_146922_(this.m_146908_() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.m_14177_((float)(this.m_146908_() - this.f_19859_))) < -170.0 || d4 >= 170.0) {
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_38068_ = !this.f_38068_;
            }
            this.m_19915_(this.m_146908_(), this.m_146909_());
            AABB box = this.getCollisionHandler() != null ? this.getCollisionHandler().getMinecartCollisionBox(this) : this.m_142469_().m_82377_((double)0.2f, 0.0, (double)0.2f);
            if (this.canBeRidden() && this.m_20184_().m_165925_() > 0.01) {
                List<Entity> list = this.f_19853_.m_6249_(this, box, EntitySelector.m_20421_((Entity)this));
                if (!list.isEmpty()) {
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = list.get(l);
                        if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.m_20160_() || entity1.m_20159_())) {
                            entity1.m_20329_(this);
                            continue;
                        }
                        entity1.m_7334_(this);
                    }
                }
            } else {
                for (Entity entity : this.f_19853_.m_45933_(this, box)) {
                    if (this.m_20363_(entity) || !entity.m_6094_() || !(entity instanceof AbstractMinecart)) continue;
                    entity.m_7334_(this);
                }
            }
            this.m_20073_();
            if (this.m_20077_()) {
                this.m_20093_();
                this.f_19789_ *= 0.5f;
            }
            this.f_19803_ = false;
        }
    }

    protected double m_7097_() {
        return (this.m_20069_() ? 4.0 : 8.0) / 20.0;
    }

    public void m_6025_(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    protected void m_38163_() {
        double d0 = this.f_19861_ ? this.m_7097_() : (double)this.getMaxSpeedAirLateral();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(Mth.m_14008_((double)vec3.f_82479_, (double)(-d0), (double)d0), vec3.f_82480_, Mth.m_14008_((double)vec3.f_82481_, (double)(-d0), (double)d0));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        if (this.getMaxSpeedAirVertical() > 0.0f && this.m_20184_().f_82480_ > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.m_20184_().f_82479_) < (double)0.3f && Math.abs(this.m_20184_().f_82481_) < (double)0.3f) {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)0.15f, this.m_20184_().f_82481_));
            } else {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)this.getMaxSpeedAirVertical(), this.m_20184_().f_82481_));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(this.getDragAir()));
        }
    }

    protected void m_6401_(BlockPos p_38156_, BlockState p_38157_) {
        double d14;
        this.m_183634_();
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        Vec3 vec3 = this.m_38179_(d0, d1, d2);
        d1 = p_38156_.m_123342_();
        boolean flag = false;
        boolean flag1 = false;
        BaseRailBlock baserailblock = (BaseRailBlock)p_38157_.m_60734_();
        if (baserailblock instanceof PoweredRailBlock && !((PoweredRailBlock)baserailblock).isActivatorRail()) {
            flag = (Boolean)p_38157_.m_61143_((Property)PoweredRailBlock.f_55215_);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.m_20069_()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.m_20184_();
        RailShape railshape = ((BaseRailBlock)p_38157_.m_60734_()).getRailDirection(p_38157_, (BlockGetter)((Object)this.f_19853_), p_38156_, this);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.m_20256_(vec31.m_82520_(-1.0 * this.getSlopeAdjustment(), 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.m_20256_(vec31.m_82520_(this.getSlopeAdjustment(), 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, this.getSlopeAdjustment()));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, -1.0 * this.getSlopeAdjustment()));
                d1 += 1.0;
            }
        }
        vec31 = this.m_20184_();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.m_38125_(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.m_123341_() - vec3i.m_123341_();
        double d5 = vec3i1.m_123343_() - vec3i.m_123343_();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.f_82479_ * d4 + vec31.f_82481_ * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.m_165924_());
        vec31 = new Vec3(d8 * d4 / d6, vec31.f_82480_, d8 * d5 / d6);
        this.m_20256_(vec31);
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Vec3 vec32 = entity.m_20184_();
            double d9 = vec32.m_165925_();
            double d11 = this.m_20184_().m_165925_();
            if (d9 > 1.0E-4 && d11 < 0.01) {
                this.m_20256_(this.m_20184_().m_82520_(vec32.f_82479_ * 0.1, 0.0, vec32.f_82481_ * 0.1));
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            double d22 = this.m_20184_().m_165924_();
            if (d22 < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)p_38156_.m_123341_() + 0.5 + (double)vec3i.m_123341_() * 0.5;
        double d10 = (double)p_38156_.m_123343_() + 0.5 + (double)vec3i.m_123343_() * 0.5;
        double d12 = (double)p_38156_.m_123341_() + 0.5 + (double)vec3i1.m_123341_() * 0.5;
        double d13 = (double)p_38156_.m_123343_() + 0.5 + (double)vec3i1.m_123343_() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)p_38156_.m_123343_();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)p_38156_.m_123341_();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.m_6034_(d0, d1, d2);
        this.moveMinecartOnRail(p_38156_);
        if (vec3i.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - p_38156_.m_123341_() == vec3i.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - p_38156_.m_123343_() == vec3i.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i.m_123342_(), this.m_20189_());
        } else if (vec3i1.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - p_38156_.m_123341_() == vec3i1.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - p_38156_.m_123343_() == vec3i1.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i1.m_123342_(), this.m_20189_());
        }
        this.m_7114_();
        Vec3 vec33 = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (vec33 != null && vec3 != null) {
            double d17 = (vec3.f_82480_ - vec33.f_82480_) * 0.05;
            Vec3 vec34 = this.m_20184_();
            double d18 = vec34.m_165924_();
            if (d18 > 0.0) {
                this.m_20256_(vec34.m_82542_((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            this.m_6034_(this.m_20185_(), vec33.f_82480_, this.m_20189_());
        }
        int j = Mth.m_14107_((double)this.m_20185_());
        int i = Mth.m_14107_((double)this.m_20189_());
        if (j != p_38156_.m_123341_() || i != p_38156_.m_123343_()) {
            Vec3 vec35 = this.m_20184_();
            double d26 = vec35.m_165924_();
            this.m_20334_(d26 * (double)(j - p_38156_.m_123341_()), vec35.f_82480_, d26 * (double)(i - p_38156_.m_123343_()));
        }
        if (this.shouldDoRailFunctions()) {
            baserailblock.onMinecartPass(p_38157_, this.f_19853_, p_38156_, this);
        }
        if (flag && this.shouldDoRailFunctions()) {
            Vec3 vec36 = this.m_20184_();
            double d27 = vec36.m_165924_();
            if (d27 > 0.01) {
                double d19 = 0.06;
                this.m_20256_(vec36.m_82520_(vec36.f_82479_ / d27 * 0.06, 0.0, vec36.f_82481_ / d27 * 0.06));
            } else {
                Vec3 vec37 = this.m_20184_();
                double d20 = vec37.f_82479_;
                double d21 = vec37.f_82481_;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.m_38129_(p_38156_.m_142125_())) {
                        d20 = 0.02;
                    } else if (this.m_38129_(p_38156_.m_142126_())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.m_38129_(p_38156_.m_142127_())) {
                        d21 = 0.02;
                    } else if (this.m_38129_(p_38156_.m_142128_())) {
                        d21 = -0.02;
                    }
                }
                this.m_20334_(d20, vec37.f_82480_, d21);
            }
        }
    }

    private boolean m_38129_(BlockPos p_38130_) {
        return this.f_19853_.m_8055_(p_38130_).m_60796_((BlockGetter)((Object)this.f_19853_), p_38130_);
    }

    protected void m_7114_() {
        double d0 = this.m_20160_() ? 0.997 : 0.96;
        Vec3 vec3 = this.m_20184_();
        vec3 = vec3.m_82542_(d0, 0.0, d0);
        if (this.m_20069_()) {
            vec3 = vec3.m_82490_((double)0.95f);
        }
        this.m_20256_(vec3);
    }

    @Nullable
    public Vec3 m_38096_(double p_38097_, double p_38098_, double p_38099_, double p_38100_) {
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.m_14107_((double)p_38097_);
        if (this.f_19853_.m_8055_(new BlockPos(i, (j = Mth.m_14107_((double)p_38098_)) - 1, k = Mth.m_14107_((double)p_38099_))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        if (BaseRailBlock.m_49416_(blockstate = this.f_19853_.m_8055_(new BlockPos(i, j, k)))) {
            RailShape railshape = ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)((Object)this.f_19853_), new BlockPos(i, j, k), this);
            p_38098_ = j;
            if (railshape.m_61745_()) {
                p_38098_ = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.m_38125_(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = vec3i1.m_123341_() - vec3i.m_123341_();
            double d1 = vec3i1.m_123343_() - vec3i.m_123343_();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (vec3i.m_123342_() != 0 && Mth.m_14107_((double)(p_38097_ += (d0 /= d2) * p_38100_)) - i == vec3i.m_123341_() && Mth.m_14107_((double)(p_38099_ += (d1 /= d2) * p_38100_)) - k == vec3i.m_123343_()) {
                p_38098_ += (double)vec3i.m_123342_();
            } else if (vec3i1.m_123342_() != 0 && Mth.m_14107_((double)p_38097_) - i == vec3i1.m_123341_() && Mth.m_14107_((double)p_38099_) - k == vec3i1.m_123343_()) {
                p_38098_ += (double)vec3i1.m_123342_();
            }
            return this.m_38179_(p_38097_, p_38098_, p_38099_);
        }
        return null;
    }

    @Nullable
    public Vec3 m_38179_(double p_38180_, double p_38181_, double p_38182_) {
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.m_14107_((double)p_38180_);
        if (this.f_19853_.m_8055_(new BlockPos(i, (j = Mth.m_14107_((double)p_38181_)) - 1, k = Mth.m_14107_((double)p_38182_))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        if (BaseRailBlock.m_49416_(blockstate = this.f_19853_.m_8055_(new BlockPos(i, j, k)))) {
            double d9;
            RailShape railshape = ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)((Object)this.f_19853_), new BlockPos(i, j, k), this);
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.m_38125_(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = (double)i + 0.5 + (double)vec3i.m_123341_() * 0.5;
            double d1 = (double)j + 0.0625 + (double)vec3i.m_123342_() * 0.5;
            double d2 = (double)k + 0.5 + (double)vec3i.m_123343_() * 0.5;
            double d3 = (double)i + 0.5 + (double)vec3i1.m_123341_() * 0.5;
            double d4 = (double)j + 0.0625 + (double)vec3i1.m_123342_() * 0.5;
            double d5 = (double)k + 0.5 + (double)vec3i1.m_123343_() * 0.5;
            double d6 = d3 - d0;
            double d7 = (d4 - d1) * 2.0;
            double d8 = d5 - d2;
            if (d6 == 0.0) {
                d9 = p_38182_ - (double)k;
            } else if (d8 == 0.0) {
                d9 = p_38180_ - (double)i;
            } else {
                double d10 = p_38180_ - d0;
                double d11 = p_38182_ - d2;
                d9 = (d10 * d6 + d11 * d8) * 2.0;
            }
            p_38180_ = d0 + d6 * d9;
            p_38181_ = d1 + d7 * d9;
            p_38182_ = d2 + d8 * d9;
            if (d7 < 0.0) {
                p_38181_ += 1.0;
            } else if (d7 > 0.0) {
                p_38181_ += 0.5;
            }
            return new Vec3(p_38180_, p_38181_, p_38182_);
        }
        return null;
    }

    @Override
    public AABB m_6921_() {
        AABB aabb = this.m_142469_();
        return this.m_38184_() ? aabb.m_82400_((double)Math.abs(this.m_38183_()) / 16.0) : aabb;
    }

    @Override
    protected void m_7378_(CompoundTag p_38137_) {
        if (p_38137_.m_128471_("CustomDisplayTile")) {
            this.m_38146_(NbtUtils.m_129241_((CompoundTag)p_38137_.m_128469_("DisplayState")));
            this.m_38174_(p_38137_.m_128451_("DisplayOffset"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag p_38151_) {
        if (this.m_38184_()) {
            p_38151_.m_128379_("CustomDisplayTile", true);
            p_38151_.m_128365_("DisplayState", NbtUtils.m_129202_((BlockState)this.m_38178_()));
            p_38151_.m_128405_("DisplayOffset", this.m_38183_());
        }
    }

    @Override
    public void m_7334_(Entity p_38165_) {
        double d1;
        double d0;
        double d2;
        if (this.getCollisionHandler() != null) {
            this.getCollisionHandler().onEntityCollision(this, p_38165_);
            return;
        }
        if (!(this.f_19853_.f_46443_ || p_38165_.f_19794_ || this.f_19794_ || this.m_20363_(p_38165_) || !((d2 = (d0 = p_38165_.m_20185_() - this.m_20185_()) * d0 + (d1 = p_38165_.m_20189_() - this.m_20189_()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                Vec3 vec31;
                double d5;
                double d4 = p_38165_.m_20185_() - this.m_20185_();
                Vec3 vec3 = new Vec3(d4, 0.0, d5 = p_38165_.m_20189_() - this.m_20189_()).m_82541_();
                double d6 = Math.abs(vec3.m_82526_(vec31 = new Vec3((double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).m_82541_()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3 vec32 = this.m_20184_();
                Vec3 vec33 = p_38165_.m_20184_();
                if (((AbstractMinecart)p_38165_).isPoweredCart() && !this.isPoweredCart()) {
                    this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(vec33.f_82479_ - d0, 0.0, vec33.f_82481_ - d1);
                    p_38165_.m_20256_(vec33.m_82542_(0.95, 1.0, 0.95));
                } else if (!((AbstractMinecart)p_38165_).isPoweredCart() && this.isPoweredCart()) {
                    p_38165_.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                    p_38165_.m_5997_(vec32.f_82479_ + d0, 0.0, vec32.f_82481_ + d1);
                    this.m_20256_(vec32.m_82542_(0.95, 1.0, 0.95));
                } else {
                    double d7 = (vec33.f_82479_ + vec32.f_82479_) / 2.0;
                    double d8 = (vec33.f_82481_ + vec32.f_82481_) / 2.0;
                    this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(d7 - d0, 0.0, d8 - d1);
                    p_38165_.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                    p_38165_.m_5997_(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.m_5997_(-d0, 0.0, -d1);
                p_38165_.m_5997_(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    public void m_6453_(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_, boolean p_38108_) {
        this.f_38071_ = p_38102_;
        this.f_38072_ = p_38103_;
        this.f_38073_ = p_38104_;
        this.f_38074_ = p_38105_;
        this.f_38075_ = p_38106_;
        this.f_38070_ = p_38107_ + 2;
        this.m_20334_(this.f_38076_, this.f_38077_, this.f_38078_);
    }

    @Override
    public void m_6001_(double p_38171_, double p_38172_, double p_38173_) {
        this.f_38076_ = p_38171_;
        this.f_38077_ = p_38172_;
        this.f_38078_ = p_38173_;
        this.m_20334_(this.f_38076_, this.f_38077_, this.f_38078_);
    }

    public void m_38109_(float p_38110_) {
        this.f_19804_.m_135381_(f_38081_, Float.valueOf(p_38110_));
    }

    public float m_38169_() {
        return this.f_19804_.m_135370_(f_38081_).floatValue();
    }

    public void m_38154_(int p_38155_) {
        this.f_19804_.m_135381_(f_38079_, p_38155_);
    }

    public int m_38176_() {
        return this.f_19804_.m_135370_(f_38079_);
    }

    public void m_38160_(int p_38161_) {
        this.f_19804_.m_135381_(f_38080_, p_38161_);
    }

    public int m_38177_() {
        return this.f_19804_.m_135370_(f_38080_);
    }

    public abstract Type m_6064_();

    public BlockState m_38178_() {
        return !this.m_38184_() ? this.m_6390_() : Block.m_49803_(this.m_20088_().m_135370_(f_38082_));
    }

    public BlockState m_6390_() {
        return Blocks.f_50016_.m_49966_();
    }

    public int m_38183_() {
        return !this.m_38184_() ? this.m_7144_() : this.m_20088_().m_135370_(f_38083_).intValue();
    }

    public int m_7144_() {
        return 6;
    }

    public void m_38146_(BlockState p_38147_) {
        this.m_20088_().m_135381_(f_38082_, Block.m_49956_(p_38147_));
        this.m_38138_(true);
    }

    public void m_38174_(int p_38175_) {
        this.m_20088_().m_135381_(f_38083_, p_38175_);
        this.m_38138_(true);
    }

    public boolean m_38184_() {
        return this.m_20088_().m_135370_(f_38084_);
    }

    public void m_38138_(boolean p_38139_) {
        this.m_20088_().m_135381_(f_38084_, p_38139_);
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean value) {
        this.canUseRail = value;
    }

    public float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedCapOnRail;
    }

    public void setCurrentCartSpeedCapOnRail(float value) {
        this.currentSpeedCapOnRail = Math.min(value, this.getMaxCartSpeedOnRail());
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public double getMaxSpeedWithRail() {
        if (!this.canUseRail()) {
            return this.m_7097_();
        }
        BlockPos pos = this.getCurrentRailPosition();
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!state.m_204336_(BlockTags.f_13034_)) {
            return this.m_7097_();
        }
        float railMaxSpeed = ((BaseRailBlock)state.m_60734_()).getRailMaxSpeed(state, this.f_19853_, pos, this);
        return Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
    }

    public void moveMinecartOnRail(BlockPos pos) {
        AbstractMinecart mc = this;
        double d24 = mc.m_20160_() ? 0.75 : 1.0;
        double d25 = mc.getMaxSpeedWithRail();
        Vec3 vec3d1 = mc.m_20184_();
        mc.m_6478_(MoverType.SELF, new Vec3(Mth.m_14008_((double)(d24 * vec3d1.f_82479_), (double)(-d25), (double)d25), 0.0, Mth.m_14008_((double)(d24 * vec3d1.f_82481_), (double)(-d25), (double)d25)));
    }

    @Override
    public ItemStack m_142340_() {
        Item item = switch (this.m_6064_()) {
            case Type.FURNACE -> Items.f_42520_;
            case Type.CHEST -> Items.f_42519_;
            case Type.TNT -> Items.f_42693_;
            case Type.HOPPER -> Items.f_42694_;
            case Type.COMMAND_BLOCK -> Items.f_42657_;
            default -> Items.f_42449_;
        };
        if (item == null) {
            return this.getCartItem();
        }
        return new ItemStack(item);
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type RIDEABLE = new Type();
        public static final /* enum */ Type CHEST = new Type();
        public static final /* enum */ Type FURNACE = new Type();
        public static final /* enum */ Type TNT = new Type();
        public static final /* enum */ Type SPAWNER = new Type();
        public static final /* enum */ Type HOPPER = new Type();
        public static final /* enum */ Type COMMAND_BLOCK = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_38200_) {
            return Enum.valueOf(Type.class, p_38200_);
        }

        private static /* synthetic */ Type[] m_150253_() {
            return new Type[]{RIDEABLE, CHEST, FURNACE, TNT, SPAWNER, HOPPER, COMMAND_BLOCK};
        }

        static {
            $VALUES = Type.m_150253_();
        }
    }
}

