/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class Biome
extends ForgeRegistryEntry.UncheckedRegistryEntry<Biome> {
    public static final Codec<Biome> f_47429_ = RecordCodecBuilder.create(p_186636_ -> p_186636_.group((App)ClimateSettings.f_47679_.forGetter(p_151717_ -> p_151717_.f_47437_), (App)BiomeCategory.f_47631_.fieldOf("category").forGetter(p_151715_ -> p_151715_.f_47442_), (App)BiomeSpecialEffects.f_47926_.fieldOf("effects").forGetter(p_186644_ -> p_186644_.f_47443_), (App)BiomeGenerationSettings.f_47778_.forGetter(p_186642_ -> p_186642_.f_47438_), (App)MobSpawnSettings.f_48327_.forGetter(p_186640_ -> p_186640_.f_47439_), (App)ResourceLocation.f_135803_.optionalFieldOf("forge:registry_name").forGetter(b -> Optional.ofNullable(b.getRegistryName()))).apply((Applicative)p_186636_, (climate, category, effects, gen, spawns, name) -> ForgeHooks.enhanceBiome((ResourceLocation)name.orElse(null), (ClimateSettings)climate, (BiomeCategory)((Object)((Object)category)), (BiomeSpecialEffects)effects, (BiomeGenerationSettings)gen, (MobSpawnSettings)spawns, (RecordCodecBuilder.Instance)p_186636_, Biome::new)));
    public static final Codec<Biome> f_47430_ = RecordCodecBuilder.create(p_186632_ -> p_186632_.group((App)ClimateSettings.f_47679_.forGetter(p_186638_ -> p_186638_.f_47437_), (App)BiomeCategory.f_47631_.fieldOf("category").forGetter(p_186634_ -> p_186634_.f_47442_), (App)BiomeSpecialEffects.f_47926_.fieldOf("effects").forGetter(p_186630_ -> p_186630_.f_47443_)).apply((Applicative)p_186632_, (p_186626_, p_186627_, p_186628_) -> new Biome((ClimateSettings)p_186626_, (BiomeCategory)((Object)((Object)p_186627_)), (BiomeSpecialEffects)p_186628_, BiomeGenerationSettings.f_47777_, MobSpawnSettings.f_48326_)));
    public static final Codec<Holder<Biome>> f_47431_ = RegistryFileCodec.m_135589_(Registry.f_122885_, f_47429_);
    public static final Codec<HolderSet<Biome>> f_47432_ = RegistryCodecs.m_206279_(Registry.f_122885_, f_47429_);
    private static final PerlinSimplexNoise f_47435_ = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));
    static final PerlinSimplexNoise f_47436_ = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(3456L)), (List)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final PerlinSimplexNoise f_47433_ = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (List)ImmutableList.of((Object)0));
    private static final int f_151655_ = 1024;
    private final ClimateSettings f_47437_;
    private final BiomeGenerationSettings f_47438_;
    private final MobSpawnSettings f_47439_;
    private final BiomeCategory f_47442_;
    private final BiomeSpecialEffects f_47443_;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> f_47444_ = ThreadLocal.withInitial(() -> Util.m_137537_(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_47580_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    Biome(ClimateSettings p_186620_, BiomeCategory p_186621_, BiomeSpecialEffects p_186622_, BiomeGenerationSettings p_186623_, MobSpawnSettings p_186624_) {
        this.f_47437_ = p_186620_;
        this.f_47438_ = p_186623_;
        this.f_47439_ = p_186624_;
        this.f_47442_ = p_186621_;
        this.f_47443_ = p_186622_;
    }

    public int m_47463_() {
        return this.f_47443_.m_47978_();
    }

    public MobSpawnSettings m_47518_() {
        return this.f_47439_;
    }

    public Precipitation m_47530_() {
        return this.f_47437_.f_47680_;
    }

    public boolean m_47533_() {
        return this.m_47548_() > 0.85f;
    }

    private float m_47528_(BlockPos p_47529_) {
        float f = this.f_47437_.f_47682_.m_8117_(p_47529_, this.m_47554_());
        if (p_47529_.m_123342_() > 80) {
            float f1 = (float)(f_47435_.m_75449_((double)((float)p_47529_.m_123341_() / 8.0f), (double)((float)p_47529_.m_123343_() / 8.0f), false) * 8.0);
            return f - (f1 + (float)p_47529_.m_123342_() - 80.0f) * 0.05f / 40.0f;
        }
        return f;
    }

    @Deprecated
    private float m_47505_(BlockPos p_47506_) {
        long i = p_47506_.m_121878_();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.f_47444_.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.m_47528_(p_47506_);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean m_47477_(LevelReader p_47478_, BlockPos p_47479_) {
        return this.m_47480_(p_47478_, p_47479_, true);
    }

    public boolean m_47480_(LevelReader p_47481_, BlockPos p_47482_, boolean p_47483_) {
        if (this.m_198906_(p_47482_)) {
            return false;
        }
        if (p_47482_.m_123342_() >= p_47481_.m_141937_() && p_47482_.m_123342_() < p_47481_.m_151558_() && p_47481_.m_45517_(LightLayer.BLOCK, p_47482_) < 10) {
            BlockState blockstate = p_47481_.m_8055_(p_47482_);
            FluidState fluidstate = p_47481_.m_6425_(p_47482_);
            if (fluidstate.m_76152_() == Fluids.f_76193_ && blockstate.m_60734_() instanceof LiquidBlock) {
                boolean flag;
                if (!p_47483_) {
                    return true;
                }
                boolean bl = flag = p_47481_.m_46801_(p_47482_.m_142125_()) && p_47481_.m_46801_(p_47482_.m_142126_()) && p_47481_.m_46801_(p_47482_.m_142127_()) && p_47481_.m_46801_(p_47482_.m_142128_());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean m_198904_(BlockPos p_198905_) {
        return !this.m_198906_(p_198905_);
    }

    public boolean m_198906_(BlockPos p_198907_) {
        return this.m_47505_(p_198907_) >= 0.15f;
    }

    public boolean m_198908_(BlockPos p_198909_) {
        return this.m_47505_(p_198909_) > 0.1f;
    }

    public boolean m_198910_(BlockPos p_198911_) {
        return this.m_47505_(p_198911_) > 1.0f;
    }

    public boolean m_47519_(LevelReader p_47520_, BlockPos p_47521_) {
        BlockState blockstate;
        if (this.m_198906_(p_47521_)) {
            return false;
        }
        return p_47521_.m_123342_() >= p_47520_.m_141937_() && p_47521_.m_123342_() < p_47520_.m_151558_() && p_47520_.m_45517_(LightLayer.BLOCK, p_47521_) < 10 && (blockstate = p_47520_.m_8055_(p_47521_)).m_60795_() && Blocks.f_50125_.m_49966_().m_60710_(p_47520_, p_47521_);
    }

    public BiomeGenerationSettings m_47536_() {
        return this.f_47438_;
    }

    public int m_47539_() {
        return this.f_47443_.m_47967_();
    }

    public int m_47464_(double p_47465_, double p_47466_) {
        int i = this.f_47443_.m_47984_().orElseGet(this::m_47570_);
        return this.f_47443_.m_47987_().m_6583_(p_47465_, p_47466_, i);
    }

    private int m_47570_() {
        double d0 = Mth.m_14036_((float)this.f_47437_.f_47681_, (float)0.0f, (float)1.0f);
        double d1 = Mth.m_14036_((float)this.f_47437_.f_47683_, (float)0.0f, (float)1.0f);
        return GrassColor.m_46415_((double)d0, (double)d1);
    }

    public int m_47542_() {
        return this.f_47443_.m_47981_().orElseGet(this::m_47571_);
    }

    private int m_47571_() {
        double d0 = Mth.m_14036_((float)this.f_47437_.f_47681_, (float)0.0f, (float)1.0f);
        double d1 = Mth.m_14036_((float)this.f_47437_.f_47683_, (float)0.0f, (float)1.0f);
        return FoliageColor.m_46107_((double)d0, (double)d1);
    }

    public final float m_47548_() {
        return this.f_47437_.f_47683_;
    }

    public final float m_47554_() {
        return this.f_47437_.f_47681_;
    }

    public BiomeSpecialEffects m_47557_() {
        return this.f_47443_;
    }

    public final int m_47560_() {
        return this.f_47443_.m_47972_();
    }

    public final int m_47561_() {
        return this.f_47443_.m_47975_();
    }

    public Optional<AmbientParticleSettings> m_47562_() {
        return this.f_47443_.m_47990_();
    }

    public Optional<SoundEvent> m_47563_() {
        return this.f_47443_.m_47993_();
    }

    public Optional<AmbientMoodSettings> m_47564_() {
        return this.f_47443_.m_47996_();
    }

    public Optional<AmbientAdditionsSettings> m_47565_() {
        return this.f_47443_.m_47999_();
    }

    public Optional<Music> m_47566_() {
        return this.f_47443_.m_48002_();
    }

    BiomeCategory m_47567_() {
        return this.f_47442_;
    }

    @Deprecated
    public static BiomeCategory m_204183_(Holder<Biome> p_204184_) {
        return p_204184_.m_203334_().m_47567_();
    }

    public static class ClimateSettings {
        public static final MapCodec<ClimateSettings> f_47679_ = RecordCodecBuilder.mapCodec(p_47699_ -> p_47699_.group((App)Precipitation.f_47717_.fieldOf("precipitation").forGetter(p_151739_ -> p_151739_.f_47680_), (App)Codec.FLOAT.fieldOf("temperature").forGetter(p_151737_ -> Float.valueOf(p_151737_.f_47681_)), (App)TemperatureModifier.f_47737_.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(p_151735_ -> p_151735_.f_47682_), (App)Codec.FLOAT.fieldOf("downfall").forGetter(p_151733_ -> Float.valueOf(p_151733_.f_47683_))).apply((Applicative)p_47699_, ClimateSettings::new));
        public final Precipitation f_47680_;
        public final float f_47681_;
        public final TemperatureModifier f_47682_;
        public final float f_47683_;

        public ClimateSettings(Precipitation p_47686_, float p_47687_, TemperatureModifier p_47688_, float p_47689_) {
            this.f_47680_ = p_47686_;
            this.f_47681_ = p_47687_;
            this.f_47682_ = p_47688_;
            this.f_47683_ = p_47689_;
        }
    }

    public static final class BiomeCategory
    extends Enum<BiomeCategory>
    implements StringRepresentable {
        public static final /* enum */ BiomeCategory NONE = new BiomeCategory("none");
        public static final /* enum */ BiomeCategory TAIGA = new BiomeCategory("taiga");
        public static final /* enum */ BiomeCategory EXTREME_HILLS = new BiomeCategory("extreme_hills");
        public static final /* enum */ BiomeCategory JUNGLE = new BiomeCategory("jungle");
        public static final /* enum */ BiomeCategory MESA = new BiomeCategory("mesa");
        public static final /* enum */ BiomeCategory PLAINS = new BiomeCategory("plains");
        public static final /* enum */ BiomeCategory SAVANNA = new BiomeCategory("savanna");
        public static final /* enum */ BiomeCategory ICY = new BiomeCategory("icy");
        public static final /* enum */ BiomeCategory THEEND = new BiomeCategory("the_end");
        public static final /* enum */ BiomeCategory BEACH = new BiomeCategory("beach");
        public static final /* enum */ BiomeCategory FOREST = new BiomeCategory("forest");
        public static final /* enum */ BiomeCategory OCEAN = new BiomeCategory("ocean");
        public static final /* enum */ BiomeCategory DESERT = new BiomeCategory("desert");
        public static final /* enum */ BiomeCategory RIVER = new BiomeCategory("river");
        public static final /* enum */ BiomeCategory SWAMP = new BiomeCategory("swamp");
        public static final /* enum */ BiomeCategory MUSHROOM = new BiomeCategory("mushroom");
        public static final /* enum */ BiomeCategory NETHER = new BiomeCategory("nether");
        public static final /* enum */ BiomeCategory UNDERGROUND = new BiomeCategory("underground");
        public static final /* enum */ BiomeCategory MOUNTAIN = new BiomeCategory("mountain");
        public static final Codec<BiomeCategory> f_47631_;
        private static final Map<String, BiomeCategory> f_47632_;
        private final String f_47633_;
        private static final /* synthetic */ BiomeCategory[] $VALUES;

        public static BiomeCategory[] values() {
            return (BiomeCategory[])$VALUES.clone();
        }

        public static BiomeCategory valueOf(String p_47647_) {
            return Enum.valueOf(BiomeCategory.class, p_47647_);
        }

        private BiomeCategory(String p_47639_) {
            this.f_47633_ = p_47639_;
        }

        public String m_47645_() {
            return this.f_47633_;
        }

        public static BiomeCategory m_47643_(String p_47644_) {
            return f_47632_.get(p_47644_);
        }

        public String m_7912_() {
            return this.f_47633_;
        }

        private static /* synthetic */ BiomeCategory[] m_151720_() {
            return new BiomeCategory[]{NONE, TAIGA, EXTREME_HILLS, JUNGLE, MESA, PLAINS, SAVANNA, ICY, THEEND, BEACH, FOREST, OCEAN, DESERT, RIVER, SWAMP, MUSHROOM, NETHER, UNDERGROUND, MOUNTAIN};
        }

        static {
            $VALUES = BiomeCategory.m_151720_();
            f_47631_ = StringRepresentable.m_14350_(BiomeCategory::values, BiomeCategory::m_47643_);
            f_47632_ = Arrays.stream(BiomeCategory.values()).collect(Collectors.toMap(BiomeCategory::m_47645_, p_47642_ -> p_47642_));
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements StringRepresentable {
        public static final /* enum */ Precipitation NONE = new Precipitation("none");
        public static final /* enum */ Precipitation RAIN = new Precipitation("rain");
        public static final /* enum */ Precipitation SNOW = new Precipitation("snow");
        public static final Codec<Precipitation> f_47717_;
        private static final Map<String, Precipitation> f_47718_;
        private final String f_47719_;
        private static final /* synthetic */ Precipitation[] $VALUES;

        public static Precipitation[] values() {
            return (Precipitation[])$VALUES.clone();
        }

        public static Precipitation valueOf(String p_47733_) {
            return Enum.valueOf(Precipitation.class, p_47733_);
        }

        private Precipitation(String p_47725_) {
            this.f_47719_ = p_47725_;
        }

        public String m_47731_() {
            return this.f_47719_;
        }

        public static Precipitation m_47729_(String p_47730_) {
            return f_47718_.get(p_47730_);
        }

        public String m_7912_() {
            return this.f_47719_;
        }

        private static /* synthetic */ Precipitation[] m_151740_() {
            return new Precipitation[]{NONE, RAIN, SNOW};
        }

        static {
            $VALUES = Precipitation.m_151740_();
            f_47717_ = StringRepresentable.m_14350_(Precipitation::values, Precipitation::m_47729_);
            f_47718_ = Arrays.stream(Precipitation.values()).collect(Collectors.toMap(Precipitation::m_47731_, p_47728_ -> p_47728_));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements StringRepresentable {
        public static final /* enum */ TemperatureModifier NONE = new TemperatureModifier("none"){

            @Override
            public float m_8117_(BlockPos p_47767_, float p_47768_) {
                return p_47768_;
            }
        };
        public static final /* enum */ TemperatureModifier FROZEN = new TemperatureModifier("frozen"){

            @Override
            public float m_8117_(BlockPos p_47774_, float p_47775_) {
                double d3;
                double d1;
                double d0 = f_47436_.m_75449_((double)p_47774_.m_123341_() * 0.05, (double)p_47774_.m_123343_() * 0.05, false) * 7.0;
                double d2 = d0 + (d1 = f_47433_.m_75449_((double)p_47774_.m_123341_() * 0.2, (double)p_47774_.m_123343_() * 0.2, false));
                if (d2 < 0.3 && (d3 = f_47433_.m_75449_((double)p_47774_.m_123341_() * 0.09, (double)p_47774_.m_123343_() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return p_47775_;
            }
        };
        private final String f_47738_;
        public static final Codec<TemperatureModifier> f_47737_;
        private static final Map<String, TemperatureModifier> f_47739_;
        private static final /* synthetic */ TemperatureModifier[] $VALUES;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])$VALUES.clone();
        }

        public static TemperatureModifier valueOf(String p_47760_) {
            return Enum.valueOf(TemperatureModifier.class, p_47760_);
        }

        public abstract float m_8117_(BlockPos var1, float var2);

        private TemperatureModifier(String p_47745_) {
            this.f_47738_ = p_47745_;
        }

        public String m_47758_() {
            return this.f_47738_;
        }

        public String m_7912_() {
            return this.f_47738_;
        }

        public static TemperatureModifier m_47756_(String p_47757_) {
            return f_47739_.get(p_47757_);
        }

        private static /* synthetic */ TemperatureModifier[] m_151741_() {
            return new TemperatureModifier[]{NONE, FROZEN};
        }

        static {
            $VALUES = TemperatureModifier.m_151741_();
            f_47737_ = StringRepresentable.m_14350_(TemperatureModifier::values, TemperatureModifier::m_47756_);
            f_47739_ = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::m_47758_, p_47753_ -> p_47753_));
        }
    }

    public static class BiomeBuilder {
        @Nullable
        private Precipitation f_47581_;
        @Nullable
        private BiomeCategory f_47582_;
        @Nullable
        private Float f_47585_;
        private TemperatureModifier f_47586_ = TemperatureModifier.NONE;
        @Nullable
        private Float f_47587_;
        @Nullable
        private BiomeSpecialEffects f_47588_;
        @Nullable
        private MobSpawnSettings f_47589_;
        @Nullable
        private BiomeGenerationSettings f_47590_;

        public static BiomeBuilder m_204185_(Biome p_204186_) {
            return new BiomeBuilder().m_47597_(p_204186_.m_47530_()).m_47595_(p_204186_.m_47567_()).m_47609_(p_204186_.m_47554_()).m_47611_(p_204186_.m_47548_()).m_47603_(p_204186_.m_47557_()).m_47601_(p_204186_.m_47536_()).m_47605_(p_204186_.m_47518_());
        }

        public BiomeBuilder m_47597_(Precipitation p_47598_) {
            this.f_47581_ = p_47598_;
            return this;
        }

        public BiomeBuilder m_47595_(BiomeCategory p_47596_) {
            this.f_47582_ = p_47596_;
            return this;
        }

        public BiomeBuilder m_47609_(float p_47610_) {
            this.f_47585_ = Float.valueOf(p_47610_);
            return this;
        }

        public BiomeBuilder m_47611_(float p_47612_) {
            this.f_47587_ = Float.valueOf(p_47612_);
            return this;
        }

        public BiomeBuilder m_47603_(BiomeSpecialEffects p_47604_) {
            this.f_47588_ = p_47604_;
            return this;
        }

        public BiomeBuilder m_47605_(MobSpawnSettings p_47606_) {
            this.f_47589_ = p_47606_;
            return this;
        }

        public BiomeBuilder m_47601_(BiomeGenerationSettings p_47602_) {
            this.f_47590_ = p_47602_;
            return this;
        }

        public BiomeBuilder m_47599_(TemperatureModifier p_47600_) {
            this.f_47586_ = p_47600_;
            return this;
        }

        public Biome m_47592_() {
            if (this.f_47581_ != null && this.f_47582_ != null && this.f_47585_ != null && this.f_47587_ != null && this.f_47588_ != null && this.f_47589_ != null && this.f_47590_ != null) {
                return new Biome(new ClimateSettings(this.f_47581_, this.f_47585_.floatValue(), this.f_47586_, this.f_47587_.floatValue()), this.f_47582_, this.f_47588_, this.f_47590_, this.f_47589_);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + this.f_47581_ + ",\nbiomeCategory=" + this.f_47582_ + ",\ntemperature=" + this.f_47585_ + ",\ntemperatureModifier=" + this.f_47586_ + ",\ndownfall=" + this.f_47587_ + ",\nspecialEffects=" + this.f_47588_ + ",\nmobSpawnSettings=" + this.f_47589_ + ",\ngenerationSettings=" + this.f_47590_ + ",\n}";
        }
    }
}

