/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerPotBlock
extends Block {
    private static final Map<Block, Block> f_53524_ = Maps.newHashMap();
    public static final float f_153266_ = 3.0f;
    protected static final VoxelShape f_53523_ = Block.m_49796_(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block f_53525_ = null;
    private final Map<ResourceLocation, Supplier<? extends Block>> fullPots;
    private final Supplier<FlowerPotBlock> emptyPot;
    private final Supplier<? extends Block> flowerDelegate;

    @Deprecated
    public FlowerPotBlock(Block p_53528_, BlockBehaviour.Properties p_53529_) {
        this(Blocks.f_50276_ == null ? null : () -> (FlowerPotBlock)((Object)((Object)Blocks.f_50276_.delegate.get())), () -> (Block)((Object)((Object)p_53528_.delegate.get())), p_53529_);
        if (Blocks.f_50276_ != null) {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(p_53528_.getRegistryName(), () -> this);
        }
    }

    public FlowerPotBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> p_53528_, BlockBehaviour.Properties properties) {
        super(properties);
        this.flowerDelegate = p_53528_;
        if (emptyPot == null) {
            this.fullPots = Maps.newHashMap();
            this.emptyPot = null;
        } else {
            this.fullPots = Collections.emptyMap();
            this.emptyPot = emptyPot;
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState p_53556_, BlockGetter p_53557_, BlockPos p_53558_, CollisionContext p_53559_) {
        return f_53523_;
    }

    @Override
    public RenderShape m_7514_(BlockState p_53554_) {
        return RenderShape.MODEL;
    }

    @Override
    public InteractionResult m_6227_(BlockState p_53540_, Level p_53541_, BlockPos p_53542_, Player p_53543_, InteractionHand p_53544_, BlockHitResult p_53545_) {
        boolean flag1;
        ItemStack itemstack = p_53543_.m_21120_(p_53544_);
        Item item = itemstack.m_41720_();
        BlockState blockstate = (item instanceof BlockItem ? this.getEmptyPot().fullPots.getOrDefault(((BlockItem)item).m_40614_().getRegistryName(), (Supplier<? extends Block>)Blocks.f_50016_.delegate).get() : Blocks.f_50016_).m_49966_();
        boolean flag = blockstate.m_60713_(Blocks.f_50016_);
        if (flag != (flag1 = this.m_153267_())) {
            if (flag1) {
                p_53541_.m_7731_(p_53542_, blockstate, 3);
                p_53543_.m_36220_(Stats.f_12961_);
                if (!p_53543_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            } else {
                ItemStack itemstack1 = new ItemStack(this.f_53525_);
                if (itemstack.m_41619_()) {
                    p_53543_.m_21008_(p_53544_, itemstack1);
                } else if (!p_53543_.m_36356_(itemstack1)) {
                    p_53543_.m_36176_(itemstack1, false);
                }
                p_53541_.m_7731_(p_53542_, this.getEmptyPot().m_49966_(), 3);
            }
            p_53541_.m_142346_(p_53543_, GameEvent.f_157792_, p_53542_);
            return InteractionResult.m_19078_((boolean)p_53541_.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public ItemStack m_7397_(BlockGetter p_53531_, BlockPos p_53532_, BlockState p_53533_) {
        return this.m_153267_() ? super.m_7397_(p_53531_, p_53532_, p_53533_) : new ItemStack(this.f_53525_);
    }

    private boolean m_153267_() {
        return this.f_53525_ == Blocks.f_50016_;
    }

    @Override
    public BlockState m_7417_(BlockState p_53547_, Direction p_53548_, BlockState p_53549_, LevelAccessor p_53550_, BlockPos p_53551_, BlockPos p_53552_) {
        return p_53548_ == Direction.DOWN && !p_53547_.m_60710_((LevelReader)p_53550_, p_53551_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_53547_, p_53548_, p_53549_, p_53550_, p_53551_, p_53552_);
    }

    public Block m_53560_() {
        return this.flowerDelegate.get();
    }

    @Override
    public boolean m_7357_(BlockState p_53535_, BlockGetter p_53536_, BlockPos p_53537_, PathComputationType p_53538_) {
        return false;
    }

    public FlowerPotBlock getEmptyPot() {
        return this.emptyPot == null ? this : this.emptyPot.get();
    }

    public void addPlant(ResourceLocation flower, Supplier<? extends Block> fullPot) {
        if (this.getEmptyPot() != this) {
            throw new IllegalArgumentException("Cannot add plant to non-empty pot: " + this);
        }
        this.fullPots.put(flower, fullPot);
    }

    public Map<ResourceLocation, Supplier<? extends Block>> getFullPotsView() {
        return Collections.unmodifiableMap(this.fullPots);
    }
}

