/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.common.ForgeHooks;

public final class LevelStem {
    public static final Codec<LevelStem> f_63970_ = RecordCodecBuilder.create(p_63986_ -> ForgeHooks.expandLevelStemCodec((RecordCodecBuilder.Instance)p_63986_, () -> p_63986_.group((App)DimensionType.f_63853_.fieldOf("type").forGetter(LevelStem::m_204521_), (App)ChunkGenerator.f_62136_.fieldOf("generator").forGetter(LevelStem::m_63990_)).apply((Applicative)p_63986_, p_63986_.stable(LevelStem::new))));
    public static final ResourceKey<LevelStem> f_63971_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("overworld"));
    public static final ResourceKey<LevelStem> f_63972_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("the_nether"));
    public static final ResourceKey<LevelStem> f_63973_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("the_end"));
    private static final Set<ResourceKey<LevelStem>> f_63974_ = ImmutableSet.of(f_63971_, f_63972_, f_63973_);
    private final Holder<DimensionType> f_63975_;
    private final ChunkGenerator f_63976_;
    private final boolean useServerSeed;

    public LevelStem(Holder<DimensionType> p_204519_, ChunkGenerator p_204520_) {
        this(p_204519_, p_204520_, false);
    }

    public boolean useServerSeed() {
        return this.useServerSeed;
    }

    public LevelStem(Holder<DimensionType> p_204519_, ChunkGenerator p_204520_, boolean useServerSeed) {
        this.useServerSeed = useServerSeed;
        this.f_63975_ = p_204519_;
        this.f_63976_ = p_204520_;
    }

    public Holder<DimensionType> m_204521_() {
        return this.f_63975_;
    }

    public ChunkGenerator m_63990_() {
        return this.f_63976_;
    }

    public static Registry<LevelStem> m_204525_(Registry<LevelStem> p_204526_) {
        MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental(), null);
        for (ResourceKey<LevelStem> resourceKey : f_63974_) {
            LevelStem levelstem = p_204526_.m_6246_(resourceKey);
            if (levelstem == null) continue;
            writableregistry.m_203505_(resourceKey, levelstem, p_204526_.m_6228_(levelstem));
        }
        for (Map.Entry entry : p_204526_.m_6579_()) {
            ResourceKey resourcekey1 = (ResourceKey)entry.getKey();
            if (f_63974_.contains(resourcekey1)) continue;
            writableregistry.m_203505_(resourcekey1, (LevelStem)entry.getValue(), p_204526_.m_6228_((LevelStem)entry.getValue()));
        }
        return writableregistry;
    }

    public static boolean m_204522_(long p_204523_, Registry<LevelStem> p_204524_) {
        if (p_204524_.m_183450_() != f_63974_.size()) {
            return false;
        }
        Optional<LevelStem> optional = p_204524_.m_123009_(f_63971_);
        Optional<LevelStem> optional1 = p_204524_.m_123009_(f_63972_);
        Optional<LevelStem> optional2 = p_204524_.m_123009_(f_63973_);
        if (!(optional.isEmpty() || optional1.isEmpty() || optional2.isEmpty())) {
            if (!optional.get().m_204521_().m_203565_(DimensionType.f_63845_) && !optional.get().m_204521_().m_203565_(DimensionType.f_63851_)) {
                return false;
            }
            if (!optional1.get().m_204521_().m_203565_(DimensionType.f_63846_)) {
                return false;
            }
            if (!optional2.get().m_204521_().m_203565_(DimensionType.f_63847_)) {
                return false;
            }
            if (optional1.get().m_63990_() instanceof NoiseBasedChunkGenerator && optional2.get().m_63990_() instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noisebasedchunkgenerator = (NoiseBasedChunkGenerator)optional1.get().m_63990_();
                NoiseBasedChunkGenerator noisebasedchunkgenerator1 = (NoiseBasedChunkGenerator)optional2.get().m_63990_();
                if (!noisebasedchunkgenerator.m_64375_(p_204523_, NoiseGeneratorSettings.f_64434_)) {
                    return false;
                }
                if (!noisebasedchunkgenerator1.m_64375_(p_204523_, NoiseGeneratorSettings.f_64435_)) {
                    return false;
                }
                if (!(noisebasedchunkgenerator.m_62218_() instanceof MultiNoiseBiomeSource)) {
                    return false;
                }
                MultiNoiseBiomeSource multinoisebiomesource = (MultiNoiseBiomeSource)noisebasedchunkgenerator.m_62218_();
                if (!multinoisebiomesource.m_187063_(MultiNoiseBiomeSource.Preset.f_48512_)) {
                    return false;
                }
                BiomeSource biomesource = optional.get().m_63990_().m_62218_();
                if (biomesource instanceof MultiNoiseBiomeSource && !((MultiNoiseBiomeSource)biomesource).m_187063_(MultiNoiseBiomeSource.Preset.f_187087_)) {
                    return false;
                }
                if (!(noisebasedchunkgenerator1.m_62218_() instanceof TheEndBiomeSource)) {
                    return false;
                }
                TheEndBiomeSource theendbiomesource = (TheEndBiomeSource)noisebasedchunkgenerator1.m_62218_();
                return theendbiomesource.m_48653_(p_204523_);
            }
            return false;
        }
        return false;
    }
}

