/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.gui.components.spectator.SpectatorGui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

@OnlyIn(value=Dist.CLIENT)
public class Gui
extends GuiComponent {
    protected static final ResourceLocation f_92981_ = new ResourceLocation("textures/misc/vignette.png");
    protected static final ResourceLocation f_92982_ = new ResourceLocation("textures/gui/widgets.png");
    protected static final ResourceLocation f_92983_ = new ResourceLocation("textures/misc/pumpkinblur.png");
    protected static final ResourceLocation f_168665_ = new ResourceLocation("textures/misc/spyglass_scope.png");
    protected static final ResourceLocation f_168666_ = new ResourceLocation("textures/misc/powder_snow_outline.png");
    protected static final Component f_92984_ = Component.m_237115_((String)"demo.demoExpired");
    protected static final Component f_193830_ = Component.m_237115_((String)"menu.savingLevel");
    protected static final int f_168667_ = 0xFFFFFF;
    protected static final float f_168668_ = 5.0f;
    protected static final int f_168669_ = 10;
    protected static final int f_168670_ = 10;
    protected static final String f_168671_ = ": ";
    protected static final float f_168672_ = 0.2f;
    protected static final int f_168673_ = 9;
    protected static final int f_168674_ = 8;
    protected static final float f_193831_ = 0.2f;
    protected final RandomSource f_92985_ = RandomSource.m_216327_();
    protected final Minecraft f_92986_;
    protected final ItemRenderer f_92987_;
    protected final ChatComponent f_92988_;
    protected int f_92989_;
    @Nullable
    protected Component f_92990_;
    protected int f_92991_;
    protected boolean f_92992_;
    protected boolean f_238167_;
    public float f_92980_ = 1.0f;
    protected int f_92993_;
    protected ItemStack f_92994_ = ItemStack.f_41583_;
    protected final DebugScreenOverlay f_92995_;
    protected final SubtitleOverlay f_92996_;
    protected final SpectatorGui f_92997_;
    protected final PlayerTabOverlay f_92998_;
    protected final BossHealthOverlay f_92999_;
    protected int f_93000_;
    @Nullable
    protected Component f_93001_;
    @Nullable
    protected Component f_93002_;
    protected int f_92970_;
    protected int f_92971_;
    protected int f_92972_;
    protected int f_92973_;
    protected int f_92974_;
    protected long f_92975_;
    protected long f_92976_;
    protected int f_92977_;
    protected int f_92978_;
    protected float f_193828_;
    protected float f_193829_;
    protected float f_168664_;

    public Gui(Minecraft p_232355_, ItemRenderer p_232356_) {
        this.f_92986_ = p_232355_;
        this.f_92987_ = p_232356_;
        this.f_92995_ = new DebugScreenOverlay(p_232355_);
        this.f_92997_ = new SpectatorGui(p_232355_);
        this.f_92988_ = new ChatComponent(p_232355_);
        this.f_92998_ = new PlayerTabOverlay(p_232355_, this);
        this.f_92999_ = new BossHealthOverlay(p_232355_);
        this.f_92996_ = new SubtitleOverlay(p_232355_);
        this.m_93006_();
    }

    public void m_93006_() {
        this.f_92970_ = 10;
        this.f_92971_ = 70;
        this.f_92972_ = 20;
    }

    public void m_93030_(PoseStack p_93031_, float p_93032_) {
        float f1;
        Window window = this.f_92986_.m_91268_();
        this.f_92977_ = window.m_85445_();
        this.f_92978_ = window.m_85446_();
        Font font = this.m_93082_();
        RenderSystem.m_69478_();
        if (Minecraft.m_91405_()) {
            this.m_264148_(p_93031_, this.f_92986_.m_91288_());
        } else {
            RenderSystem.m_69482_();
        }
        float f = this.f_92986_.m_91297_();
        this.f_168664_ = Mth.m_14179_((float)(0.5f * f), (float)this.f_168664_, (float)1.125f);
        if (this.f_92986_.f_91066_.m_92176_().m_90612_()) {
            if (this.f_92986_.f_91074_.m_150108_()) {
                this.m_264541_(p_93031_, this.f_168664_);
            } else {
                this.f_168664_ = 0.5f;
                ItemStack itemstack = this.f_92986_.f_91074_.m_150109_().m_36052_(3);
                if (itemstack.m_150930_(Blocks.f_50143_.m_5456_())) {
                    this.m_264571_(p_93031_, f_92983_, 1.0f);
                }
            }
        }
        if (this.f_92986_.f_91074_.m_146888_() > 0) {
            this.m_264571_(p_93031_, f_168666_, this.f_92986_.f_91074_.m_146889_());
        }
        if ((f1 = Mth.m_14179_((float)p_93032_, (float)this.f_92986_.f_91074_.f_108590_, (float)this.f_92986_.f_91074_.f_108589_)) > 0.0f && !this.f_92986_.f_91074_.m_21023_(MobEffects.f_19604_)) {
            this.m_264464_(p_93031_, f1);
        }
        if (this.f_92986_.f_91072_.m_105295_() == GameType.SPECTATOR) {
            this.f_92997_.m_193837_(p_93031_);
        } else if (!this.f_92986_.f_91066_.f_92062_) {
            this.m_93009_(p_93032_, p_93031_);
        }
        if (!this.f_92986_.f_91066_.f_92062_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
            RenderSystem.m_69478_();
            this.m_93080_(p_93031_);
            this.f_92986_.m_91307_().m_6180_("bossHealth");
            this.f_92999_.m_93704_(p_93031_);
            this.f_92986_.m_91307_().m_7238_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
            if (this.f_92986_.f_91072_.m_105205_()) {
                this.m_93083_(p_93031_);
            }
            this.m_93086_(p_93031_);
            RenderSystem.m_69461_();
            int i = this.f_92977_ / 2 - 91;
            PlayerRideableJumping playerrideablejumping = this.f_92986_.f_91074_.m_245714_();
            if (playerrideablejumping != null) {
                this.m_247734_(playerrideablejumping, p_93031_, i);
            } else if (this.f_92986_.f_91072_.m_105288_()) {
                this.m_93071_(p_93031_, i);
            }
            if (this.f_92986_.f_91072_.m_105295_() != GameType.SPECTATOR) {
                this.m_93069_(p_93031_);
            } else if (this.f_92986_.f_91074_.m_5833_()) {
                this.f_92997_.m_94773_(p_93031_);
            }
        }
        if (this.f_92986_.f_91074_.m_36318_() > 0) {
            this.f_92986_.m_91307_().m_6180_("sleep");
            RenderSystem.m_69465_();
            float f2 = this.f_92986_.f_91074_.m_36318_();
            float f5 = f2 / 100.0f;
            if (f5 > 1.0f) {
                f5 = 1.0f - (f2 - 100.0f) / 10.0f;
            }
            int j = (int)(220.0f * f5) << 24 | 0x101020;
            Gui.m_93172_((PoseStack)p_93031_, (int)0, (int)0, (int)this.f_92977_, (int)this.f_92978_, (int)j);
            RenderSystem.m_69482_();
            this.f_92986_.m_91307_().m_7238_();
        }
        if (this.f_92986_.m_91402_()) {
            this.m_93077_(p_93031_);
        }
        this.m_93028_(p_93031_);
        if (this.f_92986_.f_91066_.f_92063_) {
            this.f_92995_.m_94056_(p_93031_);
        }
        if (!this.f_92986_.f_91066_.f_92062_) {
            Objective objective1;
            int k2;
            if (this.f_92990_ != null && this.f_92991_ > 0) {
                this.f_92986_.m_91307_().m_6180_("overlayMessage");
                float f3 = (float)this.f_92991_ - p_93032_;
                int j1 = (int)(f3 * 255.0f / 20.0f);
                if (j1 > 255) {
                    j1 = 255;
                }
                if (j1 > 8) {
                    p_93031_.m_85836_();
                    p_93031_.m_252880_(this.f_92977_ / 2, this.f_92978_ - 68, 0.0f);
                    int l1 = 0xFFFFFF;
                    if (this.f_92992_) {
                        l1 = Mth.m_14169_((float)(f3 / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF;
                    }
                    int k = j1 << 24 & 0xFF000000;
                    int l = font.m_92852_((FormattedText)this.f_92990_);
                    this.m_93039_(p_93031_, font, -4, l, 0xFFFFFF | k);
                    font.m_92763_(p_93031_, this.f_92990_, -l / 2, -4.0f, l1 | k);
                    p_93031_.m_85849_();
                }
                this.f_92986_.m_91307_().m_7238_();
            }
            if (this.f_93001_ != null && this.f_93000_ > 0) {
                this.f_92986_.m_91307_().m_6180_("titleAndSubtitle");
                float f4 = (float)this.f_93000_ - p_93032_;
                int k1 = 255;
                if (this.f_93000_ > this.f_92972_ + this.f_92971_) {
                    float f6 = (float)(this.f_92970_ + this.f_92971_ + this.f_92972_) - f4;
                    k1 = (int)(f6 * 255.0f / (float)this.f_92970_);
                }
                if (this.f_93000_ <= this.f_92972_) {
                    k1 = (int)(f4 * 255.0f / (float)this.f_92972_);
                }
                if ((k1 = Mth.m_14045_((int)k1, (int)0, (int)255)) > 8) {
                    p_93031_.m_85836_();
                    p_93031_.m_252880_(this.f_92977_ / 2, this.f_92978_ / 2, 0.0f);
                    RenderSystem.m_69478_();
                    p_93031_.m_85836_();
                    p_93031_.m_85841_(4.0f, 4.0f, 4.0f);
                    int i2 = k1 << 24 & 0xFF000000;
                    int j2 = font.m_92852_((FormattedText)this.f_93001_);
                    this.m_93039_(p_93031_, font, -10, j2, 0xFFFFFF | i2);
                    font.m_92763_(p_93031_, this.f_93001_, -j2 / 2, -10.0f, 0xFFFFFF | i2);
                    p_93031_.m_85849_();
                    if (this.f_93002_ != null) {
                        p_93031_.m_85836_();
                        p_93031_.m_85841_(2.0f, 2.0f, 2.0f);
                        int l2 = font.m_92852_((FormattedText)this.f_93002_);
                        this.m_93039_(p_93031_, font, 5, l2, 0xFFFFFF | i2);
                        font.m_92763_(p_93031_, this.f_93002_, -l2 / 2, 5.0f, 0xFFFFFF | i2);
                        p_93031_.m_85849_();
                    }
                    RenderSystem.m_69461_();
                    p_93031_.m_85849_();
                }
                this.f_92986_.m_91307_().m_7238_();
            }
            this.f_92996_.m_94642_(p_93031_);
            Scoreboard scoreboard = this.f_92986_.f_91073_.m_6188_();
            Objective objective = null;
            PlayerTeam playerteam = scoreboard.m_83500_(this.f_92986_.f_91074_.m_6302_());
            if (playerteam != null && (k2 = playerteam.m_7414_().m_126656_()) >= 0) {
                objective = scoreboard.m_83416_(3 + k2);
            }
            Objective objective2 = objective1 = objective != null ? objective : scoreboard.m_83416_(1);
            if (objective1 != null) {
                this.m_93036_(p_93031_, objective1);
            }
            RenderSystem.m_69478_();
            int i3 = Mth.m_14107_((double)(this.f_92986_.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_()));
            int i1 = Mth.m_14107_((double)(this.f_92986_.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_()));
            this.f_92986_.m_91307_().m_6180_("chat");
            this.f_92988_.m_247591_(p_93031_, this.f_92989_, i3, i1);
            this.f_92986_.m_91307_().m_7238_();
            objective1 = scoreboard.m_83416_(0);
            if (!this.f_92986_.f_91066_.f_92099_.m_90857_() || this.f_92986_.m_91090_() && this.f_92986_.f_91074_.f_108617_.m_246170_().size() <= 1 && objective1 == null) {
                this.f_92998_.m_94556_(false);
            } else {
                this.f_92998_.m_94556_(true);
                this.f_92998_.m_94544_(p_93031_, this.f_92977_, scoreboard, objective1);
            }
            this.m_193834_(p_93031_);
        }
    }

    protected void m_93039_(PoseStack p_93040_, Font p_93041_, int p_93042_, int p_93043_, int p_93044_) {
        int i = this.f_92986_.f_91066_.m_92170_(0.0f);
        if (i != 0) {
            int j = -p_93043_ / 2;
            Gui.m_93172_((PoseStack)p_93040_, (int)(j - 2), (int)(p_93042_ - 2), (int)(j + p_93043_ + 2), (int)(p_93042_ + 9 + 2), (int)FastColor.ARGB32.m_13657_((int)i, (int)p_93044_));
        }
    }

    public void m_93080_(PoseStack p_93081_) {
        Options options = this.f_92986_.f_91066_;
        if (options.m_92176_().m_90612_() && (this.f_92986_.f_91072_.m_105295_() != GameType.SPECTATOR || this.m_93024_(this.f_92986_.f_91077_))) {
            if (options.f_92063_ && !options.f_92062_ && !this.f_92986_.f_91074_.m_36330_() && !((Boolean)options.m_231824_().m_231551_()).booleanValue()) {
                Camera camera = this.f_92986_.f_91063_.m_109153_();
                PoseStack posestack = RenderSystem.m_157191_();
                posestack.m_85836_();
                posestack.m_252931_(p_93081_.m_85850_().m_252922_());
                posestack.m_252880_(this.f_92977_ / 2, this.f_92978_ / 2, 0.0f);
                posestack.m_252781_(Axis.f_252495_.m_252977_(camera.m_90589_()));
                posestack.m_252781_(Axis.f_252436_.m_252977_(camera.m_90590_()));
                posestack.m_85841_(-1.0f, -1.0f, -1.0f);
                RenderSystem.m_157182_();
                RenderSystem.m_69881_((int)10);
                posestack.m_85849_();
                RenderSystem.m_157182_();
            } else {
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int i = 15;
                Gui.m_93228_((PoseStack)p_93081_, (int)((this.f_92977_ - 15) / 2), (int)((this.f_92978_ - 15) / 2), (int)0, (int)0, (int)15, (int)15);
                if (this.f_92986_.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR) {
                    float f = this.f_92986_.f_91074_.m_36403_(0.0f);
                    boolean flag = false;
                    if (this.f_92986_.f_91076_ != null && this.f_92986_.f_91076_ instanceof LivingEntity && f >= 1.0f) {
                        flag = this.f_92986_.f_91074_.m_36333_() > 5.0f;
                        flag &= this.f_92986_.f_91076_.m_6084_();
                    }
                    int j = this.f_92978_ / 2 - 7 + 16;
                    int k = this.f_92977_ / 2 - 8;
                    if (flag) {
                        Gui.m_93228_((PoseStack)p_93081_, (int)k, (int)j, (int)68, (int)94, (int)16, (int)16);
                    } else if (f < 1.0f) {
                        int l = (int)(f * 17.0f);
                        Gui.m_93228_((PoseStack)p_93081_, (int)k, (int)j, (int)36, (int)94, (int)16, (int)4);
                        Gui.m_93228_((PoseStack)p_93081_, (int)k, (int)j, (int)52, (int)94, (int)l, (int)4);
                    }
                }
                RenderSystem.m_69453_();
            }
        }
    }

    private boolean m_93024_(HitResult p_93025_) {
        if (p_93025_ == null) {
            return false;
        }
        if (p_93025_.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)p_93025_).m_82443_() instanceof MenuProvider;
        }
        if (p_93025_.m_6662_() == HitResult.Type.BLOCK) {
            ClientLevel level = this.f_92986_.f_91073_;
            BlockPos blockpos = ((BlockHitResult)p_93025_).m_82425_();
            return level.m_8055_(blockpos).m_60750_(level, blockpos) != null;
        }
        return false;
    }

    public void m_93028_(PoseStack p_93029_) {
        Collection<MobEffectInstance> collection = this.f_92986_.f_91074_.m_21220_();
        if (!collection.isEmpty()) {
            EffectRenderingInventoryScreen effectrenderinginventoryscreen;
            Screen $$4 = this.f_92986_.f_91080_;
            if ($$4 instanceof EffectRenderingInventoryScreen && (effectrenderinginventoryscreen = (EffectRenderingInventoryScreen)$$4).m_194018_()) {
                return;
            }
            RenderSystem.m_69478_();
            int j1 = 0;
            int k1 = 0;
            MobEffectTextureManager mobeffecttexturemanager = this.f_92986_.m_91306_();
            ArrayList list = Lists.newArrayListWithExpectedSize((int)collection.size());
            RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
            for (MobEffectInstance mobeffectinstance : Ordering.natural().reverse().sortedCopy(collection)) {
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                IClientMobEffectExtensions renderer = IClientMobEffectExtensions.of((MobEffectInstance)mobeffectinstance);
                if (!renderer.isVisibleInGui(mobeffectinstance)) continue;
                RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
                if (!mobeffectinstance.m_19575_()) continue;
                int i = this.f_92977_;
                int j = 1;
                if (this.f_92986_.m_91402_()) {
                    j += 15;
                }
                if (mobeffect.m_19486_()) {
                    i -= 25 * ++j1;
                } else {
                    i -= 25 * ++k1;
                    j += 26;
                }
                float f = 1.0f;
                if (mobeffectinstance.m_19571_()) {
                    Gui.m_93228_((PoseStack)p_93029_, (int)i, (int)j, (int)165, (int)166, (int)24, (int)24);
                } else {
                    Gui.m_93228_((PoseStack)p_93029_, (int)i, (int)j, (int)141, (int)166, (int)24, (int)24);
                    if (mobeffectinstance.m_267633_(200)) {
                        int k = mobeffectinstance.m_19557_();
                        int l = 10 - k / 20;
                        f = Mth.m_14036_((float)((float)k / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)k * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)l / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
                if (renderer.renderGuiIcon(mobeffectinstance, this, p_93029_, i, j, 0.0f, f)) continue;
                TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.m_118732_(mobeffect);
                int i1 = j;
                float f1 = f;
                int i_f = i;
                list.add(() -> {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_247685_());
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
                    Gui.m_93200_((PoseStack)p_93029_, (int)(i_f + 3), (int)(i1 + 3), (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                });
            }
            list.forEach(Runnable::run);
        }
    }

    public void m_93009_(float p_93010_, PoseStack p_93011_) {
        Player player = this.m_93092_();
        if (player != null) {
            float f;
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_92982_);
            ItemStack itemstack = player.m_21206_();
            HumanoidArm humanoidarm = player.m_5737_().m_20828_();
            int i = this.f_92977_ / 2;
            int j = 182;
            int k = 91;
            p_93011_.m_85836_();
            p_93011_.m_252880_(0.0f, 0.0f, -90.0f);
            Gui.m_93228_((PoseStack)p_93011_, (int)(i - 91), (int)(this.f_92978_ - 22), (int)0, (int)0, (int)182, (int)22);
            Gui.m_93228_((PoseStack)p_93011_, (int)(i - 91 - 1 + player.m_150109_().f_35977_ * 20), (int)(this.f_92978_ - 22 - 1), (int)0, (int)22, (int)24, (int)22);
            if (!itemstack.m_41619_()) {
                if (humanoidarm == HumanoidArm.LEFT) {
                    Gui.m_93228_((PoseStack)p_93011_, (int)(i - 91 - 29), (int)(this.f_92978_ - 23), (int)24, (int)22, (int)29, (int)24);
                } else {
                    Gui.m_93228_((PoseStack)p_93011_, (int)(i + 91), (int)(this.f_92978_ - 23), (int)53, (int)22, (int)29, (int)24);
                }
            }
            p_93011_.m_85849_();
            int l = 1;
            for (int i1 = 0; i1 < 9; ++i1) {
                int j1 = i - 90 + i1 * 20 + 2;
                int k1 = this.f_92978_ - 16 - 3;
                this.m_274453_(p_93011_, j1, k1, p_93010_, player, (ItemStack)((Object)player.m_150109_().f_35974_.get(i1)), l++);
            }
            if (!itemstack.m_41619_()) {
                int i2 = this.f_92978_ - 16 - 3;
                if (humanoidarm == HumanoidArm.LEFT) {
                    this.m_274453_(p_93011_, i - 91 - 26, i2, p_93010_, player, itemstack, l++);
                } else {
                    this.m_274453_(p_93011_, i + 91 + 10, i2, p_93010_, player, itemstack, l++);
                }
            }
            RenderSystem.m_69478_();
            if (this.f_92986_.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.HOTBAR && (f = this.f_92986_.f_91074_.m_36403_(0.0f)) < 1.0f) {
                int j2 = this.f_92978_ - 20;
                int k2 = i + 91 + 6;
                if (humanoidarm == HumanoidArm.RIGHT) {
                    k2 = i - 91 - 22;
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                int l1 = (int)(f * 19.0f);
                Gui.m_93228_((PoseStack)p_93011_, (int)k2, (int)j2, (int)0, (int)94, (int)18, (int)18);
                Gui.m_93228_((PoseStack)p_93011_, (int)k2, (int)(j2 + 18 - l1), (int)18, (int)(112 - l1), (int)18, (int)l1);
            }
            RenderSystem.m_69461_();
        }
    }

    public void m_247734_(PlayerRideableJumping p_250242_, PoseStack p_250216_, int p_248942_) {
        this.f_92986_.m_91307_().m_6180_("jumpBar");
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        float f = this.f_92986_.f_91074_.m_108634_();
        int i = 182;
        int j = (int)(f * 183.0f);
        int k = this.f_92978_ - 32 + 3;
        Gui.m_93228_((PoseStack)p_250216_, (int)p_248942_, (int)k, (int)0, (int)84, (int)182, (int)5);
        if (p_250242_.m_245614_() > 0) {
            Gui.m_93228_((PoseStack)p_250216_, (int)p_248942_, (int)k, (int)0, (int)74, (int)182, (int)5);
        } else if (j > 0) {
            Gui.m_93228_((PoseStack)p_250216_, (int)p_248942_, (int)k, (int)0, (int)89, (int)j, (int)5);
        }
        this.f_92986_.m_91307_().m_7238_();
    }

    public void m_93071_(PoseStack p_93072_, int p_93073_) {
        this.f_92986_.m_91307_().m_6180_("expBar");
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int i = this.f_92986_.f_91074_.m_36323_();
        if (i > 0) {
            int j = 182;
            int k = (int)(this.f_92986_.f_91074_.f_36080_ * 183.0f);
            int l = this.f_92978_ - 32 + 3;
            Gui.m_93228_((PoseStack)p_93072_, (int)p_93073_, (int)l, (int)0, (int)64, (int)182, (int)5);
            if (k > 0) {
                Gui.m_93228_((PoseStack)p_93072_, (int)p_93073_, (int)l, (int)0, (int)69, (int)k, (int)5);
            }
        }
        this.f_92986_.m_91307_().m_7238_();
        if (this.f_92986_.f_91074_.f_36078_ > 0) {
            this.f_92986_.m_91307_().m_6180_("expLevel");
            String s = "" + this.f_92986_.f_91074_.f_36078_;
            int i1 = (this.f_92977_ - this.m_93082_().m_92895_(s)) / 2;
            int j1 = this.f_92978_ - 31 - 4;
            this.m_93082_().m_92883_(p_93072_, s, i1 + 1, j1, 0);
            this.m_93082_().m_92883_(p_93072_, s, i1 - 1, j1, 0);
            this.m_93082_().m_92883_(p_93072_, s, i1, j1 + 1, 0);
            this.m_93082_().m_92883_(p_93072_, s, i1, j1 - 1, 0);
            this.m_93082_().m_92883_(p_93072_, s, i1, j1, 8453920);
            this.f_92986_.m_91307_().m_7238_();
        }
    }

    public void m_93069_(PoseStack p_93070_) {
        this.f_92986_.m_91307_().m_6180_("selectedItemName");
        if (this.f_92993_ > 0 && !this.f_92994_.m_41619_()) {
            int l;
            MutableComponent mutablecomponent = Component.m_237119_().m_7220_(this.f_92994_.m_41786_()).m_130938_(this.f_92994_.m_41791_().getStyleModifier());
            if (this.f_92994_.m_41788_()) {
                mutablecomponent.m_130940_(ChatFormatting.ITALIC);
            }
            Component highlightTip = this.f_92994_.getHighlightTip((Component)mutablecomponent);
            int i = this.m_93082_().m_92852_((FormattedText)highlightTip);
            int j = (this.f_92977_ - i) / 2;
            int k = this.f_92978_ - 59;
            if (!this.f_92986_.f_91072_.m_105205_()) {
                k += 14;
            }
            if ((l = (int)((float)this.f_92993_ * 256.0f / 10.0f)) > 255) {
                l = 255;
            }
            if (l > 0) {
                Gui.m_93172_((PoseStack)p_93070_, (int)(j - 2), (int)(k - 2), (int)(j + i + 2), (int)(k + 9 + 2), (int)this.f_92986_.f_91066_.m_92143_(0));
                Font font = IClientItemExtensions.of((ItemStack)this.f_92994_).getFont(this.f_92994_, IClientItemExtensions.FontContext.SELECTED_ITEM_NAME);
                if (font == null) {
                    this.m_93082_().m_92763_(p_93070_, highlightTip, j, k, 0xFFFFFF + (l << 24));
                } else {
                    j = (this.f_92977_ - font.m_92852_((FormattedText)highlightTip)) / 2;
                    font.m_92763_(p_93070_, highlightTip, j, k, 0xFFFFFF + (l << 24));
                }
            }
        }
        this.f_92986_.m_91307_().m_7238_();
    }

    public void m_93077_(PoseStack p_93078_) {
        this.f_92986_.m_91307_().m_6180_("demo");
        Object component = this.f_92986_.f_91073_.m_46467_() >= 120500L ? f_92984_ : Component.m_237110_((String)"demo.remainingTime", (Object[])new Object[]{StringUtil.m_14404_((int)((int)(120500L - this.f_92986_.f_91073_.m_46467_())))});
        int i = this.m_93082_().m_92852_((FormattedText)component);
        this.m_93082_().m_92763_(p_93078_, (Component)component, this.f_92977_ - i - 10, 5.0f, 0xFFFFFF);
        this.f_92986_.m_91307_().m_7238_();
    }

    public void m_93036_(PoseStack p_93037_, Objective p_93038_) {
        int i;
        Scoreboard scoreboard = p_93038_.m_83313_();
        ArrayList collection = scoreboard.m_83498_(p_93038_);
        ArrayList list = collection.stream().filter(p_93027_ -> p_93027_.m_83405_() != null && !p_93027_.m_83405_().startsWith("#")).collect(Collectors.toList());
        collection = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(collection.size() - 15))) : list;
        ArrayList list1 = Lists.newArrayListWithCapacity((int)collection.size());
        Component component = p_93038_.m_83322_();
        int j = i = this.m_93082_().m_92852_((FormattedText)component);
        int k = this.m_93082_().m_92895_(f_168671_);
        for (Score score : collection) {
            PlayerTeam playerteam = scoreboard.m_83500_(score.m_83405_());
            MutableComponent component1 = PlayerTeam.m_83348_((Team)playerteam, (Component)Component.m_237113_((String)score.m_83405_()));
            list1.add(Pair.of((Object)score, (Object)component1));
            j = Math.max(j, this.m_93082_().m_92852_((FormattedText)component1) + k + this.m_93082_().m_92895_(Integer.toString(score.m_83400_())));
        }
        int i2 = collection.size() * 9;
        int j2 = this.f_92978_ / 2 + i2 / 3;
        int k2 = 3;
        int l2 = this.f_92977_ - j - 3;
        int l = 0;
        int i1 = this.f_92986_.f_91066_.m_92170_(0.3f);
        int j1 = this.f_92986_.f_91066_.m_92170_(0.4f);
        for (Pair pair : list1) {
            Score score1 = (Score)pair.getFirst();
            Component component2 = (Component)pair.getSecond();
            String s = "" + ChatFormatting.RED + score1.m_83400_();
            int k1 = j2 - ++l * 9;
            int l1 = this.f_92977_ - 3 + 2;
            Gui.m_93172_((PoseStack)p_93037_, (int)(l2 - 2), (int)k1, (int)l1, (int)(k1 + 9), (int)i1);
            this.m_93082_().m_92889_(p_93037_, component2, l2, k1, -1);
            this.m_93082_().m_92883_(p_93037_, s, l1 - this.m_93082_().m_92895_(s), k1, -1);
            if (l != collection.size()) continue;
            Gui.m_93172_((PoseStack)p_93037_, (int)(l2 - 2), (int)(k1 - 9 - 1), (int)l1, (int)(k1 - 1), (int)j1);
            Gui.m_93172_((PoseStack)p_93037_, (int)(l2 - 2), (int)(k1 - 1), (int)l1, (int)k1, (int)i1);
            this.m_93082_().m_92889_(p_93037_, component, l2 + j / 2 - i / 2, k1 - 9, -1);
        }
    }

    private Player m_93092_() {
        return !(this.f_92986_.m_91288_() instanceof Player) ? null : (Player)this.f_92986_.m_91288_();
    }

    private LivingEntity m_93093_() {
        Player player = this.m_93092_();
        if (player != null) {
            Entity entity = player.m_20202_();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    private int m_93022_(LivingEntity p_93023_) {
        if (p_93023_ != null && p_93023_.m_20152_()) {
            float f = p_93023_.m_21233_();
            int i = (int)(f + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private int m_93012_(int p_93013_) {
        return (int)Math.ceil((double)p_93013_ / 10.0);
    }

    private void m_93083_(PoseStack p_93084_) {
        Player player = this.m_93092_();
        if (player != null) {
            int i = Mth.m_14167_((float)player.m_21223_());
            boolean flag = this.f_92976_ > (long)this.f_92989_ && (this.f_92976_ - (long)this.f_92989_) / 3L % 2L == 1L;
            long j = Util.m_137550_();
            if (i < this.f_92973_ && player.f_19802_ > 0) {
                this.f_92975_ = j;
                this.f_92976_ = this.f_92989_ + 20;
            } else if (i > this.f_92973_ && player.f_19802_ > 0) {
                this.f_92975_ = j;
                this.f_92976_ = this.f_92989_ + 10;
            }
            if (j - this.f_92975_ > 1000L) {
                this.f_92973_ = i;
                this.f_92974_ = i;
                this.f_92975_ = j;
            }
            this.f_92973_ = i;
            int k = this.f_92974_;
            this.f_92985_.m_188584_((long)(this.f_92989_ * 312871));
            FoodData fooddata = player.m_36324_();
            int l = fooddata.m_38702_();
            int i1 = this.f_92977_ / 2 - 91;
            int j1 = this.f_92977_ / 2 + 91;
            int k1 = this.f_92978_ - 39;
            float f = Math.max((float)player.m_21133_(Attributes.f_22276_), (float)Math.max(k, i));
            int l1 = Mth.m_14167_((float)player.m_6103_());
            int i2 = Mth.m_14167_((float)((f + (float)l1) / 2.0f / 10.0f));
            int j2 = Math.max(10 - (i2 - 2), 3);
            int k2 = k1 - (i2 - 1) * j2 - 10;
            int l2 = k1 - 10;
            int i3 = player.m_21230_();
            int j3 = -1;
            if (player.m_21023_(MobEffects.f_19605_)) {
                j3 = this.f_92989_ % Mth.m_14167_((float)(f + 5.0f));
            }
            this.f_92986_.m_91307_().m_6180_("armor");
            for (int k3 = 0; k3 < 10; ++k3) {
                if (i3 <= 0) continue;
                int l3 = i1 + k3 * 8;
                if (k3 * 2 + 1 < i3) {
                    Gui.m_93228_((PoseStack)p_93084_, (int)l3, (int)k2, (int)34, (int)9, (int)9, (int)9);
                }
                if (k3 * 2 + 1 == i3) {
                    Gui.m_93228_((PoseStack)p_93084_, (int)l3, (int)k2, (int)25, (int)9, (int)9, (int)9);
                }
                if (k3 * 2 + 1 <= i3) continue;
                Gui.m_93228_((PoseStack)p_93084_, (int)l3, (int)k2, (int)16, (int)9, (int)9, (int)9);
            }
            this.f_92986_.m_91307_().m_6182_("health");
            this.m_168688_(p_93084_, player, i1, k1, j2, j3, f, i, k, l1, flag);
            LivingEntity livingentity = this.m_93093_();
            int k5 = this.m_93022_(livingentity);
            if (k5 == 0) {
                this.f_92986_.m_91307_().m_6182_("food");
                for (int i4 = 0; i4 < 10; ++i4) {
                    int j4 = k1;
                    int k4 = 16;
                    int l4 = 0;
                    if (player.m_21023_(MobEffects.f_19612_)) {
                        k4 += 36;
                        l4 = 13;
                    }
                    if (player.m_36324_().m_38722_() <= 0.0f && this.f_92989_ % (l * 3 + 1) == 0) {
                        j4 = k1 + (this.f_92985_.m_188503_(3) - 1);
                    }
                    int i5 = j1 - i4 * 8 - 9;
                    Gui.m_93228_((PoseStack)p_93084_, (int)i5, (int)j4, (int)(16 + l4 * 9), (int)27, (int)9, (int)9);
                    if (i4 * 2 + 1 < l) {
                        Gui.m_93228_((PoseStack)p_93084_, (int)i5, (int)j4, (int)(k4 + 36), (int)27, (int)9, (int)9);
                    }
                    if (i4 * 2 + 1 != l) continue;
                    Gui.m_93228_((PoseStack)p_93084_, (int)i5, (int)j4, (int)(k4 + 45), (int)27, (int)9, (int)9);
                }
                l2 -= 10;
            }
            this.f_92986_.m_91307_().m_6182_("air");
            int l5 = player.m_6062_();
            int i6 = Math.min(player.m_20146_(), l5);
            if (player.m_204029_(FluidTags.f_13131_) || i6 < l5) {
                int j6 = this.m_93012_(k5) - 1;
                l2 -= j6 * 10;
                int k6 = Mth.m_14165_((double)((double)(i6 - 2) * 10.0 / (double)l5));
                int l6 = Mth.m_14165_((double)((double)i6 * 10.0 / (double)l5)) - k6;
                for (int j5 = 0; j5 < k6 + l6; ++j5) {
                    if (j5 < k6) {
                        Gui.m_93228_((PoseStack)p_93084_, (int)(j1 - j5 * 8 - 9), (int)l2, (int)16, (int)18, (int)9, (int)9);
                        continue;
                    }
                    Gui.m_93228_((PoseStack)p_93084_, (int)(j1 - j5 * 8 - 9), (int)l2, (int)25, (int)18, (int)9, (int)9);
                }
            }
            this.f_92986_.m_91307_().m_7238_();
        }
    }

    protected void m_168688_(PoseStack p_168689_, Player p_168690_, int p_168691_, int p_168692_, int p_168693_, int p_168694_, float p_168695_, int p_168696_, int p_168697_, int p_168698_, boolean p_168699_) {
        HeartType gui$hearttype = HeartType.m_168732_(p_168690_);
        int i = 9 * (p_168690_.f_19853_.m_6106_().m_5466_() ? 5 : 0);
        int j = Mth.m_14165_((double)((double)p_168695_ / 2.0));
        int k = Mth.m_14165_((double)((double)p_168698_ / 2.0));
        int l = j * 2;
        for (int i1 = j + k - 1; i1 >= 0; --i1) {
            int k2;
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int l1 = p_168691_ + k1 * 8;
            int i2 = p_168692_ - j1 * p_168693_;
            if (p_168696_ + p_168698_ <= 4) {
                i2 += this.f_92985_.m_188503_(2);
            }
            if (i1 < j && i1 == p_168694_) {
                i2 -= 2;
            }
            this.m_168700_(p_168689_, HeartType.CONTAINER, l1, i2, i, p_168699_, false);
            int j2 = i1 * 2;
            boolean bl = flag = i1 >= j;
            if (flag && (k2 = j2 - l) < p_168698_) {
                boolean flag1 = k2 + 1 == p_168698_;
                this.m_168700_(p_168689_, gui$hearttype == HeartType.WITHERED ? gui$hearttype : HeartType.ABSORBING, l1, i2, i, false, flag1);
            }
            if (p_168699_ && j2 < p_168697_) {
                boolean flag2 = j2 + 1 == p_168697_;
                this.m_168700_(p_168689_, gui$hearttype, l1, i2, i, true, flag2);
            }
            if (j2 >= p_168696_) continue;
            boolean flag3 = j2 + 1 == p_168696_;
            this.m_168700_(p_168689_, gui$hearttype, l1, i2, i, false, flag3);
        }
    }

    private void m_168700_(PoseStack p_168701_, HeartType p_168702_, int p_168703_, int p_168704_, int p_168705_, boolean p_168706_, boolean p_168707_) {
        Gui.m_93228_((PoseStack)p_168701_, (int)p_168703_, (int)p_168704_, (int)p_168702_.m_168734_(p_168707_, p_168706_), (int)p_168705_, (int)9, (int)9);
    }

    private void m_93086_(PoseStack p_93087_) {
        int i;
        LivingEntity livingentity = this.m_93093_();
        if (livingentity != null && (i = this.m_93022_(livingentity)) != 0) {
            int j = (int)Math.ceil(livingentity.m_21223_());
            this.f_92986_.m_91307_().m_6182_("mountHealth");
            int k = this.f_92978_ - 39;
            int l = this.f_92977_ / 2 + 91;
            int i1 = k;
            int j1 = 0;
            boolean flag = false;
            while (i > 0) {
                int k1 = Math.min(i, 10);
                i -= k1;
                for (int l1 = 0; l1 < k1; ++l1) {
                    int i2 = 52;
                    int j2 = 0;
                    int k2 = l - l1 * 8 - 9;
                    Gui.m_93228_((PoseStack)p_93087_, (int)k2, (int)i1, (int)(52 + j2 * 9), (int)9, (int)9, (int)9);
                    if (l1 * 2 + 1 + j1 < j) {
                        Gui.m_93228_((PoseStack)p_93087_, (int)k2, (int)i1, (int)88, (int)9, (int)9, (int)9);
                    }
                    if (l1 * 2 + 1 + j1 != j) continue;
                    Gui.m_93228_((PoseStack)p_93087_, (int)k2, (int)i1, (int)97, (int)9, (int)9, (int)9);
                }
                i1 -= 10;
                j1 += 20;
            }
        }
    }

    protected void m_264571_(PoseStack p_265358_, ResourceLocation p_265726_, float p_265119_) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)p_265119_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)p_265726_);
        Gui.m_93143_((PoseStack)p_265358_, (int)0, (int)0, (int)-90, (float)0.0f, (float)0.0f, (int)this.f_92977_, (int)this.f_92978_, (int)this.f_92977_, (int)this.f_92978_);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_264541_(PoseStack p_265563_, float p_265127_) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        float f = Math.min(this.f_92977_, this.f_92978_);
        float f1 = Math.min((float)this.f_92977_ / f, (float)this.f_92978_ / f) * p_265127_;
        int i = Mth.m_14143_((float)(f * f1));
        int j = Mth.m_14143_((float)(f * f1));
        int k = (this.f_92977_ - i) / 2;
        int l = (this.f_92978_ - j) / 2;
        int i1 = k + i;
        int j1 = l + j;
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_168665_);
        Gui.m_93143_((PoseStack)p_265563_, (int)k, (int)l, (int)-90, (float)0.0f, (float)0.0f, (int)i, (int)j, (int)i, (int)j);
        Gui.m_264531_((PoseStack)p_265563_, (int)0, (int)j1, (int)this.f_92977_, (int)this.f_92978_, (int)-90, (int)-16777216);
        Gui.m_264531_((PoseStack)p_265563_, (int)0, (int)0, (int)this.f_92977_, (int)l, (int)-90, (int)-16777216);
        Gui.m_264531_((PoseStack)p_265563_, (int)0, (int)l, (int)k, (int)j1, (int)-90, (int)-16777216);
        Gui.m_264531_((PoseStack)p_265563_, (int)i1, (int)l, (int)this.f_92977_, (int)j1, (int)-90, (int)-16777216);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
    }

    private void m_93020_(Entity p_93021_) {
        if (p_93021_ != null) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_93021_.m_20185_(), (double)p_93021_.m_20188_(), (double)p_93021_.m_20189_());
            float f = LightTexture.m_234316_(p_93021_.f_19853_.m_6042_(), p_93021_.f_19853_.m_46803_(blockpos));
            float f1 = Mth.m_14036_((float)(1.0f - f), (float)0.0f, (float)1.0f);
            this.f_92980_ += (f1 - this.f_92980_) * 0.01f;
        }
    }

    public void m_264148_(PoseStack p_265650_, Entity p_265294_) {
        WorldBorder worldborder = this.f_92986_.f_91073_.m_6857_();
        float f = (float)worldborder.m_61925_(p_265294_);
        double d0 = Math.min(worldborder.m_61966_() * (double)worldborder.m_61967_() * 1000.0, Math.abs(worldborder.m_61961_() - worldborder.m_61959_()));
        double d1 = Math.max((double)worldborder.m_61968_(), d0);
        f = (double)f < d1 ? 1.0f - (float)((double)f / d1) : 0.0f;
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (f > 0.0f) {
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            RenderSystem.m_157429_((float)0.0f, (float)f, (float)f, (float)1.0f);
        } else {
            float f1 = this.f_92980_;
            f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
            RenderSystem.m_157429_((float)f1, (float)f1, (float)f1, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_92981_);
        Gui.m_93143_((PoseStack)p_265650_, (int)0, (int)0, (int)-90, (float)0.0f, (float)0.0f, (int)this.f_92977_, (int)this.f_92978_, (int)this.f_92977_, (int)this.f_92978_);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
    }

    protected void m_264464_(PoseStack p_265769_, float p_265121_) {
        if (p_265121_ < 1.0f) {
            p_265121_ *= p_265121_;
            p_265121_ *= p_265121_;
            p_265121_ = p_265121_ * 0.8f + 0.2f;
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)p_265121_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        TextureAtlasSprite textureatlassprite = this.f_92986_.m_91289_().m_110907_().m_110882_(Blocks.f_50142_.m_49966_());
        Gui.m_93200_((PoseStack)p_265769_, (int)0, (int)0, (int)-90, (int)this.f_92977_, (int)this.f_92978_, (TextureAtlasSprite)textureatlassprite);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void m_274453_(PoseStack p_275705_, int p_275509_, int p_275563_, float p_275329_, Player p_275633_, ItemStack p_275660_, int p_275383_) {
        if (!p_275660_.m_41619_()) {
            float f = (float)p_275660_.m_41612_() - p_275329_;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                p_275705_.m_85836_();
                p_275705_.m_252880_(p_275509_ + 8, p_275563_ + 12, 0.0f);
                p_275705_.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                p_275705_.m_252880_(-(p_275509_ + 8), -(p_275563_ + 12), 0.0f);
            }
            this.f_92987_.m_274301_(p_275705_, p_275633_, p_275660_, p_275509_, p_275563_, p_275383_);
            if (f > 0.0f) {
                p_275705_.m_85849_();
            }
            this.f_92987_.m_274412_(p_275705_, this.f_92986_.f_91062_, p_275660_, p_275509_, p_275563_);
        }
    }

    public void m_193832_(boolean p_193833_) {
        this.m_193836_();
        if (!p_193833_) {
            this.m_93066_();
        }
    }

    private void m_93066_() {
        if (this.f_92991_ > 0) {
            --this.f_92991_;
        }
        if (this.f_93000_ > 0) {
            --this.f_93000_;
            if (this.f_93000_ <= 0) {
                this.f_93001_ = null;
                this.f_93002_ = null;
            }
        }
        ++this.f_92989_;
        Entity entity = this.f_92986_.m_91288_();
        if (entity != null) {
            this.m_93020_(entity);
        }
        if (this.f_92986_.f_91074_ != null) {
            ItemStack itemstack = this.f_92986_.f_91074_.m_150109_().m_36056_();
            if (itemstack.m_41619_()) {
                this.f_92993_ = 0;
            } else if (!this.f_92994_.m_41619_() && itemstack.m_41720_() == this.f_92994_.m_41720_() && itemstack.m_41786_().equals(this.f_92994_.m_41786_()) && itemstack.getHighlightTip(itemstack.m_41786_()).equals(this.f_92994_.getHighlightTip(this.f_92994_.m_41786_()))) {
                if (this.f_92993_ > 0) {
                    --this.f_92993_;
                }
            } else {
                this.f_92993_ = (int)(40.0 * (Double)this.f_92986_.f_91066_.m_264038_().m_231551_());
            }
            this.f_92994_ = itemstack;
        }
        this.f_92988_.m_246602_();
    }

    private void m_193836_() {
        IntegratedServer minecraftserver = this.f_92986_.m_91092_();
        boolean flag = minecraftserver != null && minecraftserver.m_195518_();
        this.f_193829_ = this.f_193828_;
        this.f_193828_ = Mth.m_14179_((float)0.2f, (float)this.f_193828_, (float)(flag ? 1.0f : 0.0f));
    }

    public void m_93055_(Component p_93056_) {
        MutableComponent component = Component.m_237110_((String)"record.nowPlaying", (Object[])new Object[]{p_93056_});
        this.m_93063_((Component)component, true);
        this.f_92986_.m_240477_().m_168785_((Component)component);
    }

    public void m_93063_(Component p_93064_, boolean p_93065_) {
        this.m_238397_(false);
        this.f_92990_ = p_93064_;
        this.f_92991_ = 60;
        this.f_92992_ = p_93065_;
    }

    public void m_238397_(boolean p_238398_) {
        this.f_238167_ = p_238398_;
    }

    public boolean m_238351_() {
        return this.f_238167_ && this.f_92991_ > 0;
    }

    public void m_168684_(int p_168685_, int p_168686_, int p_168687_) {
        if (p_168685_ >= 0) {
            this.f_92970_ = p_168685_;
        }
        if (p_168686_ >= 0) {
            this.f_92971_ = p_168686_;
        }
        if (p_168687_ >= 0) {
            this.f_92972_ = p_168687_;
        }
        if (this.f_93000_ > 0) {
            this.f_93000_ = this.f_92970_ + this.f_92971_ + this.f_92972_;
        }
    }

    public void m_168711_(Component p_168712_) {
        this.f_93002_ = p_168712_;
    }

    public void m_168714_(Component p_168715_) {
        this.f_93001_ = p_168715_;
        this.f_93000_ = this.f_92970_ + this.f_92971_ + this.f_92972_;
    }

    public void m_168713_() {
        this.f_93001_ = null;
        this.f_93002_ = null;
        this.f_93000_ = 0;
    }

    public ChatComponent m_93076_() {
        return this.f_92988_;
    }

    public int m_93079_() {
        return this.f_92989_;
    }

    public Font m_93082_() {
        return this.f_92986_.f_91062_;
    }

    public SpectatorGui m_93085_() {
        return this.f_92997_;
    }

    public PlayerTabOverlay m_93088_() {
        return this.f_92998_;
    }

    public void m_93089_() {
        this.f_92998_.m_94529_();
        this.f_92999_.m_93703_();
        this.f_92986_.m_91300_().m_94919_();
        this.f_92986_.f_91066_.f_92063_ = false;
        this.f_92988_.m_93795_(true);
    }

    public BossHealthOverlay m_93090_() {
        return this.f_92999_;
    }

    public void m_93091_() {
        this.f_92995_.m_94040_();
    }

    private void m_193834_(PoseStack p_193835_) {
        int i;
        if (((Boolean)this.f_92986_.f_91066_.m_231834_().m_231551_()).booleanValue() && (this.f_193828_ > 0.0f || this.f_193829_ > 0.0f) && (i = Mth.m_14143_((float)(255.0f * Mth.m_14036_((float)Mth.m_14179_((float)this.f_92986_.m_91296_(), (float)this.f_193829_, (float)this.f_193828_), (float)0.0f, (float)1.0f)))) > 8) {
            Font font = this.m_93082_();
            int j = font.m_92852_((FormattedText)f_193830_);
            int k = 0xFFFFFF | i << 24 & 0xFF000000;
            font.m_92763_(p_193835_, f_193830_, this.f_92977_ - j - 10, this.f_92978_ - 15, k);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class HeartType
    extends Enum<HeartType> {
        public static final /* enum */ HeartType CONTAINER = new HeartType(0, false);
        public static final /* enum */ HeartType NORMAL = new HeartType(2, true);
        public static final /* enum */ HeartType POISIONED = new HeartType(4, true);
        public static final /* enum */ HeartType WITHERED = new HeartType(6, true);
        public static final /* enum */ HeartType ABSORBING = new HeartType(8, false);
        public static final /* enum */ HeartType FROZEN = new HeartType(9, false);
        private final int f_168722_;
        private final boolean f_168723_;
        private static final /* synthetic */ HeartType[] $VALUES;

        public static HeartType[] values() {
            return (HeartType[])$VALUES.clone();
        }

        public static HeartType valueOf(String p_168738_) {
            return Enum.valueOf(HeartType.class, p_168738_);
        }

        private HeartType(int p_168729_, boolean p_168730_) {
            this.f_168722_ = p_168729_;
            this.f_168723_ = p_168730_;
        }

        public int m_168734_(boolean p_168735_, boolean p_168736_) {
            int i;
            if (this == CONTAINER) {
                i = p_168736_ ? 1 : 0;
            } else {
                int j = p_168735_ ? 1 : 0;
                int k = this.f_168723_ && p_168736_ ? 2 : 0;
                i = j + k;
            }
            return 16 + (this.f_168722_ * 2 + i) * 9;
        }

        static HeartType m_168732_(Player p_168733_) {
            HeartType gui$hearttype = p_168733_.m_21023_(MobEffects.f_19614_) ? POISIONED : (p_168733_.m_21023_(MobEffects.f_19615_) ? WITHERED : (p_168733_.m_146890_() ? FROZEN : NORMAL));
            return gui$hearttype;
        }

        private static /* synthetic */ HeartType[] m_168731_() {
            return new HeartType[]{CONTAINER, NORMAL, POISIONED, WITHERED, ABSORBING, FROZEN};
        }

        static {
            $VALUES = HeartType.m_168731_();
        }
    }
}

