/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.CreativeModeTabSearchRegistry;
import net.minecraftforge.client.gui.CreativeTabsScreenPage;
import net.minecraftforge.common.CreativeModeTabRegistry;

@OnlyIn(value=Dist.CLIENT)
public class CreativeModeInventoryScreen
extends EffectRenderingInventoryScreen<ItemPickerMenu> {
    private static final ResourceLocation f_98504_ = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final String f_169735_ = "textures/gui/container/creative_inventory/tab_";
    private static final String f_169736_ = "CustomCreativeLock";
    private static final int f_169737_ = 5;
    private static final int f_169738_ = 9;
    private static final int f_169739_ = 26;
    private static final int f_169740_ = 32;
    private static final int f_169741_ = 12;
    private static final int f_169742_ = 15;
    static final SimpleContainer f_98505_ = new SimpleContainer(45);
    private static final Component f_98506_ = Component.m_237115_((String)"inventory.binSlot");
    private static final int f_169743_ = 0xFFFFFF;
    private static CreativeModeTab f_98507_ = CreativeModeTabs.m_257543_();
    private float f_98508_;
    private boolean f_98509_;
    private EditBox f_98510_;
    @Nullable
    private List<Slot> f_98511_;
    @Nullable
    private Slot f_98512_;
    private CreativeInventoryListener f_98513_;
    private boolean f_98514_;
    private boolean f_98515_;
    private final Set<TagKey<Item>> f_98516_ = new HashSet<TagKey<Item>>();
    private final boolean f_256872_;
    private final List<CreativeTabsScreenPage> pages = new ArrayList<CreativeTabsScreenPage>();
    private CreativeTabsScreenPage currentPage = new CreativeTabsScreenPage(new ArrayList());

    public CreativeModeInventoryScreen(Player p_259788_, FeatureFlagSet p_260074_, boolean p_259569_) {
        super(new ItemPickerMenu(p_259788_), p_259788_.m_150109_(), CommonComponents.f_237098_);
        p_259788_.f_36096_ = this.f_97732_;
        this.f_96546_ = true;
        this.f_97727_ = 136;
        this.f_97726_ = 195;
        this.f_256872_ = p_259569_;
        CreativeModeTabs.m_269226_(p_260074_, this.m_257869_(p_259788_), (HolderLookup.Provider)p_259788_.f_19853_.m_9598_());
    }

    private boolean m_257869_(Player p_259959_) {
        return p_259959_.m_36337_() && this.f_256872_;
    }

    private void m_257967_(FeatureFlagSet p_259501_, boolean p_259713_, HolderLookup.Provider p_270898_) {
        if (CreativeModeTabs.m_269226_(p_259501_, p_259713_, p_270898_)) {
            for (CreativeModeTab creativemodetab : CreativeModeTabs.m_257478_()) {
                Collection<ItemStack> collection = creativemodetab.m_260957_();
                if (creativemodetab != f_98507_) continue;
                if (creativemodetab.m_257962_() == CreativeModeTab.Type.CATEGORY && collection.isEmpty()) {
                    this.m_98560_(CreativeModeTabs.m_257543_());
                    continue;
                }
                this.m_257687_(collection);
            }
        }
    }

    private void m_257687_(Collection<ItemStack> p_261591_) {
        int i = ((ItemPickerMenu)this.f_97732_).m_257485_(this.f_98508_);
        ((ItemPickerMenu)this.f_97732_).f_98639_.clear();
        if (f_98507_.hasSearchBar()) {
            this.m_98630_();
        } else {
            ((ItemPickerMenu)this.f_97732_).f_98639_.addAll(p_261591_);
        }
        this.f_98508_ = ((ItemPickerMenu)this.f_97732_).m_257538_(i);
        ((ItemPickerMenu)this.f_97732_).m_98642_(this.f_98508_);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null) {
            if (this.f_96541_.f_91074_ != null) {
                this.m_257967_(this.f_96541_.f_91074_.f_108617_.m_247016_(), this.m_257869_(this.f_96541_.f_91074_), (HolderLookup.Provider)this.f_96541_.f_91074_.f_19853_.m_9598_());
            }
            if (!this.f_96541_.f_91072_.m_105290_()) {
                this.f_96541_.m_91152_(new InventoryScreen(this.f_96541_.f_91074_));
            } else {
                this.f_98510_.m_94120_();
            }
        }
    }

    @Override
    protected void m_6597_(@Nullable Slot p_98556_, int p_98557_, int p_98558_, ClickType p_98559_) {
        if (this.m_98553_(p_98556_)) {
            this.f_98510_.m_94201_();
            this.f_98510_.m_94208_(0);
        }
        boolean flag = p_98559_ == ClickType.QUICK_MOVE;
        ClickType clickType = p_98559_ = p_98557_ == -999 && p_98559_ == ClickType.PICKUP ? ClickType.THROW : p_98559_;
        if (p_98556_ == null && f_98507_.m_257962_() != CreativeModeTab.Type.INVENTORY && p_98559_ != ClickType.QUICK_CRAFT) {
            if (!((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_() && this.f_98515_) {
                if (p_98558_ == 0) {
                    this.f_96541_.f_91074_.m_36176_(((ItemPickerMenu)this.f_97732_).m_142621_(), true);
                    this.f_96541_.f_91072_.m_105239_(((ItemPickerMenu)this.f_97732_).m_142621_());
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                }
                if (p_98558_ == 1) {
                    ItemStack itemstack5 = ((ItemPickerMenu)this.f_97732_).m_142621_().m_41620_(1);
                    this.f_96541_.f_91074_.m_36176_(itemstack5, true);
                    this.f_96541_.f_91072_.m_105239_(itemstack5);
                }
            }
        } else {
            if (p_98556_ != null && !p_98556_.m_8010_(this.f_96541_.f_91074_)) {
                return;
            }
            if (p_98556_ == this.f_98512_ && flag) {
                for (int j = 0; j < this.f_96541_.f_91074_.f_36095_.m_38927_().size(); ++j) {
                    this.f_96541_.f_91072_.m_105241_(ItemStack.f_41583_, j);
                }
            } else if (f_98507_.m_257962_() == CreativeModeTab.Type.INVENTORY) {
                if (p_98556_ == this.f_98512_) {
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else if (p_98559_ == ClickType.THROW && p_98556_ != null && p_98556_.m_6657_()) {
                    ItemStack itemstack = p_98556_.m_6201_(p_98558_ == 0 ? 1 : p_98556_.m_7993_().m_41741_());
                    ItemStack itemstack1 = p_98556_.m_7993_();
                    this.f_96541_.f_91074_.m_36176_(itemstack, true);
                    this.f_96541_.f_91072_.m_105239_(itemstack);
                    this.f_96541_.f_91072_.m_105241_(itemstack1, ((SlotWrapper)p_98556_).f_98655_.f_40219_);
                } else if (p_98559_ == ClickType.THROW && !((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_()) {
                    this.f_96541_.f_91074_.m_36176_(((ItemPickerMenu)this.f_97732_).m_142621_(), true);
                    this.f_96541_.f_91072_.m_105239_(((ItemPickerMenu)this.f_97732_).m_142621_());
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else {
                    this.f_96541_.f_91074_.f_36095_.m_150399_(p_98556_ == null ? p_98557_ : ((SlotWrapper)p_98556_).f_98655_.f_40219_, p_98558_, p_98559_, this.f_96541_.f_91074_);
                    this.f_96541_.f_91074_.f_36095_.m_38946_();
                }
            } else if (p_98559_ != ClickType.QUICK_CRAFT && p_98556_.f_40218_ == f_98505_) {
                ItemStack itemstack4 = ((ItemPickerMenu)this.f_97732_).m_142621_();
                ItemStack itemstack7 = p_98556_.m_7993_();
                if (p_98559_ == ClickType.SWAP) {
                    if (!itemstack7.m_41619_()) {
                        ItemStack itemstack10 = itemstack7.m_41777_();
                        itemstack10.m_41764_(itemstack10.m_41741_());
                        this.f_96541_.f_91074_.m_150109_().m_6836_(p_98558_, itemstack10);
                        this.f_96541_.f_91074_.f_36095_.m_38946_();
                    }
                    return;
                }
                if (p_98559_ == ClickType.CLONE) {
                    if (((ItemPickerMenu)this.f_97732_).m_142621_().m_41619_() && p_98556_.m_6657_()) {
                        ItemStack itemstack9 = p_98556_.m_7993_().m_41777_();
                        itemstack9.m_41764_(itemstack9.m_41741_());
                        ((ItemPickerMenu)this.f_97732_).m_142503_(itemstack9);
                    }
                    return;
                }
                if (p_98559_ == ClickType.THROW) {
                    if (!itemstack7.m_41619_()) {
                        ItemStack itemstack8 = itemstack7.m_41777_();
                        itemstack8.m_41764_(p_98558_ == 0 ? 1 : itemstack8.m_41741_());
                        this.f_96541_.f_91074_.m_36176_(itemstack8, true);
                        this.f_96541_.f_91072_.m_105239_(itemstack8);
                    }
                    return;
                }
                if (!itemstack4.m_41619_() && !itemstack7.m_41619_() && itemstack4.m_41656_(itemstack7) && ItemStack.m_41658_(itemstack4, itemstack7)) {
                    if (p_98558_ == 0) {
                        if (flag) {
                            itemstack4.m_41764_(itemstack4.m_41741_());
                        } else if (itemstack4.m_41613_() < itemstack4.m_41741_()) {
                            itemstack4.m_41769_(1);
                        }
                    } else {
                        itemstack4.m_41774_(1);
                    }
                } else if (!itemstack7.m_41619_() && itemstack4.m_41619_()) {
                    ((ItemPickerMenu)this.f_97732_).m_142503_(itemstack7.m_41777_());
                    itemstack4 = ((ItemPickerMenu)this.f_97732_).m_142621_();
                    if (flag) {
                        itemstack4.m_41764_(itemstack4.m_41741_());
                    }
                } else if (p_98558_ == 0) {
                    ((ItemPickerMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                } else {
                    ((ItemPickerMenu)this.f_97732_).m_142621_().m_41774_(1);
                }
            } else if (this.f_97732_ != null) {
                ItemStack itemstack3 = p_98556_ == null ? ItemStack.f_41583_ : ((ItemPickerMenu)this.f_97732_).m_38853_(p_98556_.f_40219_).m_7993_();
                ((ItemPickerMenu)this.f_97732_).m_150399_(p_98556_ == null ? p_98557_ : p_98556_.f_40219_, p_98558_, p_98559_, this.f_96541_.f_91074_);
                if (AbstractContainerMenu.m_38947_(p_98558_) == 2) {
                    for (int k = 0; k < 9; ++k) {
                        this.f_96541_.f_91072_.m_105241_(((ItemPickerMenu)this.f_97732_).m_38853_(45 + k).m_7993_(), 36 + k);
                    }
                } else if (p_98556_ != null) {
                    ItemStack itemstack6 = ((ItemPickerMenu)this.f_97732_).m_38853_(p_98556_.f_40219_).m_7993_();
                    this.f_96541_.f_91072_.m_105241_(itemstack6, p_98556_.f_40219_ - ((ItemPickerMenu)this.f_97732_).f_38839_.size() + 9 + 36);
                    int i = 45 + p_98558_;
                    if (p_98559_ == ClickType.SWAP) {
                        this.f_96541_.f_91072_.m_105241_(itemstack3, i - ((ItemPickerMenu)this.f_97732_).f_38839_.size() + 9 + 36);
                    } else if (p_98559_ == ClickType.THROW && !itemstack3.m_41619_()) {
                        ItemStack itemstack2 = itemstack3.m_41777_();
                        itemstack2.m_41764_(p_98558_ == 0 ? 1 : itemstack2.m_41741_());
                        this.f_96541_.f_91074_.m_36176_(itemstack2, true);
                        this.f_96541_.f_91072_.m_105239_(itemstack2);
                    }
                    this.f_96541_.f_91074_.f_36095_.m_38946_();
                }
            }
        }
    }

    private boolean m_98553_(@Nullable Slot p_98554_) {
        return p_98554_ != null && p_98554_.f_40218_ == f_98505_;
    }

    @Override
    protected void m_7856_() {
        if (this.f_96541_.f_91072_.m_105290_()) {
            super.m_7856_();
            this.pages.clear();
            int tabIndex = 0;
            ArrayList<CreativeModeTab> currentPage = new ArrayList<CreativeModeTab>();
            for (CreativeModeTab sortedCreativeModeTab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
                currentPage.add(sortedCreativeModeTab);
                if (++tabIndex != 10) continue;
                this.pages.add(new CreativeTabsScreenPage(currentPage));
                currentPage = new ArrayList();
                tabIndex = 0;
            }
            if (tabIndex != 0) {
                this.pages.add(new CreativeTabsScreenPage(currentPage));
            }
            this.currentPage = this.pages.isEmpty() ? new CreativeTabsScreenPage(new ArrayList()) : this.pages.get(0);
            if (this.pages.size() > 1) {
                this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> this.setCurrentPage(this.pages.get(Math.max(this.pages.indexOf(this.currentPage) - 1, 0)))).m_252794_(this.f_97735_, this.f_97736_ - 50).m_253046_(20, 20).m_253136_());
                this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)">"), b -> this.setCurrentPage(this.pages.get(Math.min(this.pages.indexOf(this.currentPage) + 1, this.pages.size() - 1)))).m_252794_(this.f_97735_ + this.f_97726_ - 20, this.f_97736_ - 50).m_253046_(20, 20).m_253136_());
            }
            this.currentPage = this.pages.stream().filter(page -> page.getVisibleTabs().contains(f_98507_)).findFirst().orElse(this.currentPage);
            if (!this.currentPage.getVisibleTabs().contains(f_98507_)) {
                f_98507_ = (CreativeModeTab)this.currentPage.getVisibleTabs().get(0);
            }
            this.f_98510_ = new EditBox(this.f_96547_, this.f_97735_ + 82, this.f_97736_ + 6, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
            this.f_98510_.m_94199_(50);
            this.f_98510_.m_94182_(false);
            this.f_98510_.m_94194_(false);
            this.f_98510_.m_94202_(0xFFFFFF);
            this.m_7787_(this.f_98510_);
            CreativeModeTab creativemodetab = f_98507_;
            f_98507_ = CreativeModeTabs.m_257543_();
            this.m_98560_(creativemodetab);
            this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.f_98513_);
            this.f_98513_ = new CreativeInventoryListener(this.f_96541_);
            this.f_96541_.f_91074_.f_36095_.m_38893_((ContainerListener)this.f_98513_);
            if (!f_98507_.m_257497_()) {
                this.m_98560_(CreativeModeTabs.m_257543_());
            }
        } else {
            this.f_96541_.m_91152_(new InventoryScreen(this.f_96541_.f_91074_));
        }
    }

    @Override
    public void m_6574_(Minecraft p_98595_, int p_98596_, int p_98597_) {
        int i = ((ItemPickerMenu)this.f_97732_).m_257485_(this.f_98508_);
        String s = this.f_98510_.m_94155_();
        this.m_6575_(p_98595_, p_98596_, p_98597_);
        this.f_98510_.m_94144_(s);
        if (!this.f_98510_.m_94155_().isEmpty()) {
            this.m_98630_();
        }
        this.f_98508_ = ((ItemPickerMenu)this.f_97732_).m_257538_(i);
        ((ItemPickerMenu)this.f_97732_).m_98642_(this.f_98508_);
    }

    @Override
    public void m_7861_() {
        super.m_7861_();
        if (this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_150109_() != null) {
            this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.f_98513_);
        }
    }

    public boolean m_5534_(char p_98521_, int p_98522_) {
        if (this.f_98514_) {
            return false;
        }
        if (!f_98507_.hasSearchBar()) {
            return false;
        }
        String s = this.f_98510_.m_94155_();
        if (this.f_98510_.m_5534_(p_98521_, p_98522_)) {
            if (!Objects.equals(s, this.f_98510_.m_94155_())) {
                this.m_98630_();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int p_98547_, int p_98548_, int p_98549_) {
        this.f_98514_ = false;
        if (!f_98507_.hasSearchBar()) {
            if (this.f_96541_.f_91066_.f_92098_.m_90832_(p_98547_, p_98548_)) {
                this.f_98514_ = true;
                this.m_98560_(CreativeModeTabs.m_258007_());
                return true;
            }
            return super.m_7933_(p_98547_, p_98548_, p_98549_);
        }
        boolean flag = !this.m_98553_(this.f_97734_) || this.f_97734_.m_6657_();
        boolean flag1 = InputConstants.m_84827_((int)p_98547_, (int)p_98548_).m_84876_().isPresent();
        if (flag && flag1 && this.m_97805_(p_98547_, p_98548_)) {
            this.f_98514_ = true;
            return true;
        }
        String s = this.f_98510_.m_94155_();
        if (this.f_98510_.m_7933_(p_98547_, p_98548_, p_98549_)) {
            if (!Objects.equals(s, this.f_98510_.m_94155_())) {
                this.m_98630_();
            }
            return true;
        }
        return this.f_98510_.m_93696_() && this.f_98510_.m_94213_() && p_98547_ != 256 ? true : super.m_7933_(p_98547_, p_98548_, p_98549_);
    }

    public boolean m_7920_(int p_98612_, int p_98613_, int p_98614_) {
        this.f_98514_ = false;
        return super.m_7920_(p_98612_, p_98613_, p_98614_);
    }

    private void m_98630_() {
        if (!f_98507_.hasSearchBar()) {
            return;
        }
        ((ItemPickerMenu)this.f_97732_).f_98639_.clear();
        this.f_98516_.clear();
        String s = this.f_98510_.m_94155_();
        if (s.isEmpty()) {
            ((ItemPickerMenu)this.f_97732_).f_98639_.addAll(f_98507_.m_260957_());
        } else {
            SearchTree searchtree;
            if (s.startsWith("#")) {
                s = s.substring(1);
                searchtree = this.f_96541_.m_231372_(CreativeModeTabSearchRegistry.getTagSearchKey((CreativeModeTab)f_98507_));
                this.m_98619_(s);
            } else {
                searchtree = this.f_96541_.m_231372_(CreativeModeTabSearchRegistry.getNameSearchKey((CreativeModeTab)f_98507_));
            }
            ((ItemPickerMenu)this.f_97732_).f_98639_.addAll((Collection)searchtree.m_6293_(s.toLowerCase(Locale.ROOT)));
        }
        this.f_98508_ = 0.0f;
        ((ItemPickerMenu)this.f_97732_).m_98642_(0.0f);
    }

    private void m_98619_(String p_98620_) {
        Predicate<ResourceLocation> predicate;
        int i = p_98620_.indexOf(58);
        if (i == -1) {
            predicate = p_98609_ -> p_98609_.m_135815_().contains(p_98620_);
        } else {
            String s = p_98620_.substring(0, i).trim();
            String s1 = p_98620_.substring(i + 1).trim();
            predicate = p_98606_ -> p_98606_.m_135827_().contains(s) && p_98606_.m_135815_().contains(s1);
        }
        BuiltInRegistries.f_257033_.m_203613_().filter(p_205410_ -> predicate.test(p_205410_.f_203868_())).forEach(this.f_98516_::add);
    }

    @Override
    protected void m_7027_(PoseStack p_98616_, int p_98617_, int p_98618_) {
        if (f_98507_.m_40789_()) {
            RenderSystem.m_69461_();
            this.f_96547_.m_92889_(p_98616_, f_98507_.m_40786_(), 8.0f, 6.0f, f_98507_.getLabelColor());
        }
    }

    @Override
    public boolean m_6375_(double p_98531_, double p_98532_, int p_98533_) {
        if (p_98533_ == 0) {
            double d0 = p_98531_ - (double)this.f_97735_;
            double d1 = p_98532_ - (double)this.f_97736_;
            for (CreativeModeTab creativemodetab : this.currentPage.getVisibleTabs()) {
                if (!this.m_98562_(creativemodetab, d0, d1)) continue;
                return true;
            }
            if (f_98507_.m_257962_() != CreativeModeTab.Type.INVENTORY && this.m_98523_(p_98531_, p_98532_)) {
                this.f_98509_ = this.m_98631_();
                return true;
            }
        }
        return super.m_6375_(p_98531_, p_98532_, p_98533_);
    }

    @Override
    public boolean m_6348_(double p_98622_, double p_98623_, int p_98624_) {
        if (p_98624_ == 0) {
            double d0 = p_98622_ - (double)this.f_97735_;
            double d1 = p_98623_ - (double)this.f_97736_;
            this.f_98509_ = false;
            for (CreativeModeTab creativemodetab : this.currentPage.getVisibleTabs()) {
                if (!this.m_98562_(creativemodetab, d0, d1)) continue;
                this.m_98560_(creativemodetab);
                return true;
            }
        }
        return super.m_6348_(p_98622_, p_98623_, p_98624_);
    }

    private boolean m_98631_() {
        return f_98507_.m_40791_() && ((ItemPickerMenu)this.f_97732_).m_98654_();
    }

    private void m_98560_(CreativeModeTab p_98561_) {
        CreativeModeTab creativemodetab = f_98507_;
        f_98507_ = p_98561_;
        this.slotColor = p_98561_.getSlotColor();
        this.f_97737_.clear();
        ((ItemPickerMenu)this.f_97732_).f_98639_.clear();
        this.m_238391_();
        if (f_98507_.m_257962_() == CreativeModeTab.Type.HOTBAR) {
            HotbarManager hotbarmanager = this.f_96541_.m_91303_();
            for (int i = 0; i < 9; ++i) {
                Hotbar hotbar = hotbarmanager.m_90806_(i);
                if (hotbar.isEmpty()) {
                    for (int j = 0; j < 9; ++j) {
                        if (j == i) {
                            ItemStack itemstack = new ItemStack(Items.f_42516_);
                            itemstack.m_41698_(f_169736_);
                            Component component = this.f_96541_.f_91066_.f_92056_[i].m_90863_();
                            Component component1 = this.f_96541_.f_91066_.f_92057_.m_90863_();
                            itemstack.m_41714_((Component)Component.m_237110_((String)"inventory.hotbarInfo", (Object[])new Object[]{component1, component}));
                            ((ItemPickerMenu)this.f_97732_).f_98639_.add((Object)itemstack);
                            continue;
                        }
                        ((ItemPickerMenu)this.f_97732_).f_98639_.add((Object)ItemStack.f_41583_);
                    }
                    continue;
                }
                ((ItemPickerMenu)this.f_97732_).f_98639_.addAll((Collection)hotbar);
            }
        } else if (f_98507_.m_257962_() == CreativeModeTab.Type.CATEGORY) {
            ((ItemPickerMenu)this.f_97732_).f_98639_.addAll(f_98507_.m_260957_());
        }
        if (f_98507_.m_257962_() == CreativeModeTab.Type.INVENTORY) {
            InventoryMenu abstractcontainermenu = this.f_96541_.f_91074_.f_36095_;
            if (this.f_98511_ == null) {
                this.f_98511_ = ImmutableList.copyOf((Collection)((ItemPickerMenu)this.f_97732_).f_38839_);
            }
            ((ItemPickerMenu)this.f_97732_).f_38839_.clear();
            for (int k = 0; k < abstractcontainermenu.f_38839_.size(); ++k) {
                int i1;
                int l;
                if (k >= 5 && k < 9) {
                    int k1 = k - 5;
                    int i2 = k1 / 2;
                    int k2 = k1 % 2;
                    l = 54 + i2 * 54;
                    i1 = 6 + k2 * 27;
                } else if (k >= 0 && k < 5) {
                    l = -2000;
                    i1 = -2000;
                } else if (k == 45) {
                    l = 35;
                    i1 = 20;
                } else {
                    int j1 = k - 9;
                    int l1 = j1 % 9;
                    int j2 = j1 / 9;
                    l = 9 + l1 * 18;
                    i1 = k >= 36 ? 112 : 54 + j2 * 18;
                }
                SlotWrapper slot = new SlotWrapper((Slot)abstractcontainermenu.f_38839_.get(k), k, l, i1);
                ((ItemPickerMenu)this.f_97732_).f_38839_.add((Object)slot);
            }
            this.f_98512_ = new Slot((Container)f_98505_, 0, 173, 112);
            ((ItemPickerMenu)this.f_97732_).f_38839_.add((Object)this.f_98512_);
        } else if (creativemodetab.m_257962_() == CreativeModeTab.Type.INVENTORY) {
            ((ItemPickerMenu)this.f_97732_).f_38839_.clear();
            ((ItemPickerMenu)this.f_97732_).f_38839_.addAll(this.f_98511_);
            this.f_98511_ = null;
        }
        if (f_98507_.hasSearchBar()) {
            this.f_98510_.m_94194_(true);
            this.f_98510_.m_94190_(false);
            this.f_98510_.m_93692_(true);
            if (creativemodetab != p_98561_) {
                this.f_98510_.m_94144_("");
            }
            this.f_98510_.m_93674_(f_98507_.getSearchBarWidth());
            this.f_98510_.m_252865_(this.f_97735_ + 171 - this.f_98510_.m_5711_());
            this.m_98630_();
        } else {
            this.f_98510_.m_94194_(false);
            this.f_98510_.m_94190_(true);
            this.f_98510_.m_93692_(false);
            this.f_98510_.m_94144_("");
        }
        this.f_98508_ = 0.0f;
        ((ItemPickerMenu)this.f_97732_).m_98642_(0.0f);
    }

    public boolean m_6050_(double p_98527_, double p_98528_, double p_98529_) {
        if (!this.m_98631_()) {
            return false;
        }
        this.f_98508_ = ((ItemPickerMenu)this.f_97732_).m_258092_(this.f_98508_, p_98529_);
        ((ItemPickerMenu)this.f_97732_).m_98642_(this.f_98508_);
        return true;
    }

    @Override
    protected boolean m_7467_(double p_98541_, double p_98542_, int p_98543_, int p_98544_, int p_98545_) {
        boolean flag = p_98541_ < (double)p_98543_ || p_98542_ < (double)p_98544_ || p_98541_ >= (double)(p_98543_ + this.f_97726_) || p_98542_ >= (double)(p_98544_ + this.f_97727_);
        this.f_98515_ = flag && !this.m_98562_(f_98507_, p_98541_, p_98542_);
        return this.f_98515_;
    }

    protected boolean m_98523_(double p_98524_, double p_98525_) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        return p_98524_ >= (double)k && p_98525_ >= (double)l && p_98524_ < (double)i1 && p_98525_ < (double)j1;
    }

    @Override
    public boolean m_7979_(double p_98535_, double p_98536_, int p_98537_, double p_98538_, double p_98539_) {
        if (this.f_98509_) {
            int i = this.f_97736_ + 18;
            int j = i + 112;
            this.f_98508_ = ((float)p_98536_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.f_98508_ = Mth.m_14036_((float)this.f_98508_, (float)0.0f, (float)1.0f);
            ((ItemPickerMenu)this.f_97732_).m_98642_(this.f_98508_);
            return true;
        }
        return super.m_7979_(p_98535_, p_98536_, p_98537_, p_98538_, p_98539_);
    }

    @Override
    public void m_86412_(PoseStack p_98577_, int p_98578_, int p_98579_, float p_98580_) {
        CreativeModeTab creativemodetab;
        this.m_7333_(p_98577_);
        super.m_86412_(p_98577_, p_98578_, p_98579_, p_98580_);
        Iterator iterator = this.currentPage.getVisibleTabs().iterator();
        while (iterator.hasNext() && !this.m_98584_(p_98577_, creativemodetab = (CreativeModeTab)iterator.next(), p_98578_, p_98579_)) {
        }
        if (this.f_98512_ != null && f_98507_.m_257962_() == CreativeModeTab.Type.INVENTORY && this.m_6774_(this.f_98512_.f_40220_, this.f_98512_.f_40221_, 16, 16, p_98578_, p_98579_)) {
            this.m_96602_(p_98577_, f_98506_, p_98578_, p_98579_);
        }
        if (this.pages.size() != 1) {
            MutableComponent page = Component.m_237113_((String)String.format("%d / %d", this.pages.indexOf(this.currentPage) + 1, this.pages.size()));
            p_98577_.m_85836_();
            p_98577_.m_252880_(0.0f, 0.0f, 300.0f);
            this.f_96547_.m_92744_(p_98577_, page.m_7532_(), (float)this.f_97735_ + (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)page) / 2.0f, this.f_97736_ - 44, -1);
            p_98577_.m_85849_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_7025_(p_98577_, p_98578_, p_98579_);
    }

    @Override
    protected void m_6057_(PoseStack p_98590_, ItemStack p_98591_, int p_98592_, int p_98593_) {
        List<Object> list1;
        boolean flag = this.f_97734_ != null && this.f_97734_ instanceof CustomCreativeSlot;
        boolean flag1 = f_98507_.m_257962_() == CreativeModeTab.Type.CATEGORY;
        boolean flag2 = f_98507_.hasSearchBar();
        TooltipFlag.Default tooltipflag$default = this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        TooltipFlag.Default tooltipflag = flag ? tooltipflag$default.m_257777_() : tooltipflag$default;
        List<Component> list = p_98591_.m_41651_(this.f_96541_.f_91074_, (TooltipFlag)tooltipflag);
        if (flag1 && flag) {
            list1 = list;
        } else {
            list1 = Lists.newArrayList(list);
            if (flag2 && flag) {
                this.f_98516_.forEach(p_205407_ -> {
                    if (p_98591_.m_204117_((TagKey<Item>)p_205407_)) {
                        list1.add(1, Component.m_237113_((String)("#" + p_205407_.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE));
                    }
                });
            }
            int i = 1;
            for (CreativeModeTab creativemodetab : this.currentPage.getVisibleTabs()) {
                if (creativemodetab.hasSearchBar() || !creativemodetab.m_257694_(p_98591_)) continue;
                list1.add(i++, creativemodetab.m_40786_().m_6881_().m_130940_(ChatFormatting.BLUE));
            }
        }
        this.renderTooltip(p_98590_, (List<Component>)list1, p_98591_.m_150921_(), p_98592_, p_98593_, null, p_98591_);
    }

    @Override
    protected void m_7286_(PoseStack p_98572_, float p_98573_, int p_98574_, int p_98575_) {
        for (CreativeModeTab creativemodetab : this.currentPage.getVisibleTabs()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_98504_);
            if (creativemodetab == f_98507_) continue;
            this.m_98581_(p_98572_, creativemodetab);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_98507_.getBackgroundLocation());
        CreativeModeInventoryScreen.m_93228_((PoseStack)p_98572_, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        this.f_98510_.m_86412_(p_98572_, p_98574_, p_98575_, p_98573_);
        int j = this.f_97735_ + 175;
        int k = this.f_97736_ + 18;
        int i = k + 112;
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_98507_.getTabsImage());
        if (f_98507_.m_40791_()) {
            CreativeModeInventoryScreen.m_93228_((PoseStack)p_98572_, (int)j, (int)(k + (int)((float)(i - k - 17) * this.f_98508_)), (int)(232 + (this.m_98631_() ? 0 : 12)), (int)0, (int)12, (int)15);
        }
        if (this.currentPage.getVisibleTabs().contains(f_98507_)) {
            this.m_98581_(p_98572_, f_98507_);
        }
        if (f_98507_.m_257962_() == CreativeModeTab.Type.INVENTORY) {
            InventoryScreen.m_274545_(p_98572_, this.f_97735_ + 88, this.f_97736_ + 45, 20, this.f_97735_ + 88 - p_98574_, this.f_97736_ + 45 - 30 - p_98575_, this.f_96541_.f_91074_);
        }
    }

    private int m_258094_(CreativeModeTab p_260136_) {
        int i = this.currentPage.getColumn(p_260136_);
        int j = 27;
        int k = 27 * i;
        if (p_260136_.m_6563_()) {
            k = this.f_97726_ - 27 * (7 - i) + 1;
        }
        return k;
    }

    private int m_257995_(CreativeModeTab p_260181_) {
        int i = 0;
        i = this.currentPage.isTop(p_260181_) ? (i -= 32) : (i += this.f_97727_);
        return i;
    }

    protected boolean m_98562_(CreativeModeTab p_98563_, double p_98564_, double p_98565_) {
        int i = this.m_258094_(p_98563_);
        int j = this.m_257995_(p_98563_);
        return p_98564_ >= (double)i && p_98564_ <= (double)(i + 26) && p_98565_ >= (double)j && p_98565_ <= (double)(j + 32);
    }

    protected boolean m_98584_(PoseStack p_98585_, CreativeModeTab p_98586_, int p_98587_, int p_98588_) {
        int j;
        int i = this.m_258094_(p_98586_);
        if (this.m_6774_(i + 3, (j = this.m_257995_(p_98586_)) + 3, 21, 27, p_98587_, p_98588_)) {
            this.m_96602_(p_98585_, p_98586_.m_40786_(), p_98587_, p_98588_);
            return true;
        }
        return false;
    }

    protected void m_98581_(PoseStack p_98582_, CreativeModeTab p_98583_) {
        boolean flag = p_98583_ == f_98507_;
        boolean flag1 = this.currentPage.isTop(p_98583_);
        int i = this.currentPage.getColumn(p_98583_);
        int j = i * 26;
        int k = 0;
        int l = this.f_97735_ + this.m_258094_(p_98583_);
        int i1 = this.f_97736_;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.f_97727_ - 4;
        }
        RenderSystem.m_69478_();
        CreativeModeInventoryScreen.m_93228_((PoseStack)p_98582_, (int)l, (int)i1, (int)j, (int)k, (int)26, (int)32);
        p_98582_.m_85836_();
        p_98582_.m_252880_(0.0f, 0.0f, 100.0f);
        int n = flag1 ? 1 : -1;
        ItemStack itemstack = p_98583_.m_40787_();
        this.f_96542_.m_274369_(p_98582_, itemstack, l += 5, i1 += 8 + n);
        this.f_96542_.m_274412_(p_98582_, this.f_96547_, itemstack, l, i1);
        p_98582_.m_85849_();
    }

    public boolean m_258017_() {
        return f_98507_.m_257962_() == CreativeModeTab.Type.INVENTORY;
    }

    public static void m_98598_(Minecraft p_98599_, int p_98600_, boolean p_98601_, boolean p_98602_) {
        LocalPlayer localplayer = p_98599_.f_91074_;
        HotbarManager hotbarmanager = p_98599_.m_91303_();
        Hotbar hotbar = hotbarmanager.m_90806_(p_98600_);
        if (p_98601_) {
            for (int i = 0; i < Inventory.m_36059_(); ++i) {
                ItemStack itemstack = (ItemStack)((Object)hotbar.get(i));
                ItemStack itemstack1 = itemstack.m_246617_(localplayer.f_19853_.m_246046_()) ? itemstack.m_41777_() : ItemStack.f_41583_;
                localplayer.m_150109_().m_6836_(i, itemstack1);
                p_98599_.f_91072_.m_105241_(itemstack1, 36 + i);
            }
            localplayer.f_36095_.m_38946_();
        } else if (p_98602_) {
            for (int j = 0; j < Inventory.m_36059_(); ++j) {
                hotbar.set(j, (Object)localplayer.m_150109_().m_8020_(j).m_41777_());
            }
            Component component = p_98599_.f_91066_.f_92056_[p_98600_].m_90863_();
            Component component1 = p_98599_.f_91066_.f_92058_.m_90863_();
            MutableComponent component2 = Component.m_237110_((String)"inventory.hotbarSaved", (Object[])new Object[]{component1, component});
            p_98599_.f_91065_.m_93063_((Component)component2, false);
            p_98599_.m_240477_().m_168785_((Component)component2);
            hotbarmanager.m_90805_();
        }
    }

    public CreativeTabsScreenPage getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(CreativeTabsScreenPage currentPage) {
        this.currentPage = currentPage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemPickerMenu
    extends AbstractContainerMenu {
        public final NonNullList<ItemStack> f_98639_ = NonNullList.m_122779_();
        private final AbstractContainerMenu f_169749_;

        public ItemPickerMenu(Player p_98641_) {
            super(null, 0);
            this.f_169749_ = p_98641_.f_36095_;
            Inventory inventory = p_98641_.m_150109_();
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new CustomCreativeSlot((Container)f_98505_, i * 9 + j, 9 + j * 18, 18 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot(inventory, k, 9 + k * 18, 112));
            }
            this.m_98642_(0.0f);
        }

        @Override
        public boolean m_6875_(Player p_98645_) {
            return true;
        }

        protected int m_257935_() {
            return Mth.m_184652_((int)this.f_98639_.size(), (int)9) - 5;
        }

        protected int m_257485_(float p_259664_) {
            return Math.max((int)((double)(p_259664_ * (float)this.m_257935_()) + 0.5), 0);
        }

        protected float m_257538_(int p_259315_) {
            return Mth.m_14036_((float)((float)p_259315_ / (float)this.m_257935_()), (float)0.0f, (float)1.0f);
        }

        protected float m_258092_(float p_259841_, double p_260358_) {
            return Mth.m_14036_((float)(p_259841_ - (float)(p_260358_ / (double)this.m_257935_())), (float)0.0f, (float)1.0f);
        }

        public void m_98642_(float p_98643_) {
            int i = this.m_257485_(p_98643_);
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 9; ++k) {
                    int l = k + (j + i) * 9;
                    if (l >= 0 && l < this.f_98639_.size()) {
                        f_98505_.m_6836_(k + j * 9, (ItemStack)((Object)this.f_98639_.get(l)));
                        continue;
                    }
                    f_98505_.m_6836_(k + j * 9, ItemStack.f_41583_);
                }
            }
        }

        public boolean m_98654_() {
            return this.f_98639_.size() > 45;
        }

        @Override
        public ItemStack m_7648_(Player p_98650_, int p_98651_) {
            Slot slot;
            if (p_98651_ >= this.f_38839_.size() - 9 && p_98651_ < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(p_98651_)) != null && slot.m_6657_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public boolean m_5882_(ItemStack p_98647_, Slot p_98648_) {
            return p_98648_.f_40218_ != f_98505_;
        }

        @Override
        public boolean m_5622_(Slot p_98653_) {
            return p_98653_.f_40218_ != f_98505_;
        }

        @Override
        public ItemStack m_142621_() {
            return this.f_169749_.m_142621_();
        }

        @Override
        public void m_142503_(ItemStack p_169751_) {
            this.f_169749_.m_142503_(p_169751_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SlotWrapper
    extends Slot {
        final Slot f_98655_;

        public SlotWrapper(Slot p_98657_, int p_98658_, int p_98659_, int p_98660_) {
            super(p_98657_.f_40218_, p_98658_, p_98659_, p_98660_);
            this.f_98655_ = p_98657_;
        }

        @Override
        public void m_142406_(Player p_169754_, ItemStack p_169755_) {
            this.f_98655_.m_142406_(p_169754_, p_169755_);
        }

        @Override
        public boolean m_5857_(ItemStack p_98670_) {
            return this.f_98655_.m_5857_(p_98670_);
        }

        @Override
        public ItemStack m_7993_() {
            return this.f_98655_.m_7993_();
        }

        @Override
        public boolean m_6657_() {
            return this.f_98655_.m_6657_();
        }

        @Override
        public void m_269060_(ItemStack p_271008_) {
            this.f_98655_.m_269060_(p_271008_);
        }

        @Override
        public void m_5852_(ItemStack p_98679_) {
            this.f_98655_.m_5852_(p_98679_);
        }

        @Override
        public void m_6654_() {
            this.f_98655_.m_6654_();
        }

        @Override
        public int m_6641_() {
            return this.f_98655_.m_6641_();
        }

        @Override
        public int m_5866_(ItemStack p_98675_) {
            return this.f_98655_.m_5866_(p_98675_);
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.f_98655_.m_7543_();
        }

        @Override
        public ItemStack m_6201_(int p_98663_) {
            return this.f_98655_.m_6201_(p_98663_);
        }

        @Override
        public boolean m_6659_() {
            return this.f_98655_.m_6659_();
        }

        @Override
        public boolean m_8010_(Player p_98665_) {
            return this.f_98655_.m_8010_(p_98665_);
        }

        @Override
        public int getSlotIndex() {
            return this.f_98655_.getSlotIndex();
        }

        @Override
        public boolean isSameInventory(Slot other) {
            return this.f_98655_.isSameInventory(other);
        }

        @Override
        public Slot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
            this.f_98655_.setBackground(atlas, sprite);
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CustomCreativeSlot
    extends Slot {
        public CustomCreativeSlot(Container p_98633_, int p_98634_, int p_98635_, int p_98636_) {
            super(p_98633_, p_98634_, p_98635_, p_98636_);
        }

        @Override
        public boolean m_8010_(Player p_98638_) {
            ItemStack itemstack = this.m_7993_();
            if (super.m_8010_(p_98638_) && !itemstack.m_41619_()) {
                return itemstack.m_246617_(p_98638_.f_19853_.m_246046_()) && itemstack.m_41737_(CreativeModeInventoryScreen.f_169736_) == null;
            }
            return itemstack.m_41619_();
        }
    }
}

