/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> f_117070_ = Maps.newHashMap();
    private final A f_117071_;
    private final A f_117072_;
    private final TextureAtlas f_266073_;

    public HumanoidArmorLayer(RenderLayerParent<T, M> p_267286_, A p_267110_, A p_267150_, ModelManager p_267238_) {
        super(p_267286_);
        this.f_117071_ = p_267110_;
        this.f_117072_ = p_267150_;
        this.f_266073_ = p_267238_.m_119428_(Sheets.f_265912_);
    }

    public void m_6494_(PoseStack p_117096_, MultiBufferSource p_117097_, int p_117098_, T p_117099_, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.m_117118_(p_117096_, p_117097_, p_117099_, EquipmentSlot.CHEST, p_117098_, this.m_117078_(EquipmentSlot.CHEST));
        this.m_117118_(p_117096_, p_117097_, p_117099_, EquipmentSlot.LEGS, p_117098_, this.m_117078_(EquipmentSlot.LEGS));
        this.m_117118_(p_117096_, p_117097_, p_117099_, EquipmentSlot.FEET, p_117098_, this.m_117078_(EquipmentSlot.FEET));
        this.m_117118_(p_117096_, p_117097_, p_117099_, EquipmentSlot.HEAD, p_117098_, this.m_117078_(EquipmentSlot.HEAD));
    }

    private void m_117118_(PoseStack p_117119_, MultiBufferSource p_117120_, T p_117121_, EquipmentSlot p_117122_, int p_117123_, A p_117124_) {
        ArmorItem armoritem;
        ItemStack itemstack = ((LivingEntity)((Object)p_117121_)).m_6844_(p_117122_);
        Item $$9 = itemstack.m_41720_();
        if ($$9 instanceof ArmorItem && (armoritem = (ArmorItem)$$9).m_40402_() == p_117122_) {
            ((HumanoidModel)this.m_117386_()).m_102872_(p_117124_);
            this.m_117125_(p_117124_, p_117122_);
            Model model = this.getArmorModelHook(p_117121_, itemstack, p_117122_, p_117124_);
            boolean flag1 = this.m_117128_(p_117122_);
            boolean flag = itemstack.m_41790_();
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(p_117119_, p_117120_, p_117123_, flag, model, f, f1, f2, this.getArmorResource((Entity)((Object)p_117121_), itemstack, p_117122_, null));
                this.renderModel(p_117119_, p_117120_, p_117123_, flag, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)p_117121_), itemstack, p_117122_, "overlay"));
            } else {
                this.renderModel(p_117119_, p_117120_, p_117123_, flag, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)p_117121_), itemstack, p_117122_, null));
            }
            if (((LivingEntity)((Object)p_117121_)).f_19853_.m_246046_().m_245372_(FeatureFlags.f_244168_)) {
                ArmorTrim.m_266285_((RegistryAccess)((LivingEntity)((Object)p_117121_)).f_19853_.m_9598_(), (ItemStack)itemstack).ifPresent(p_267897_ -> this.m_267623_(armoritem.m_40401_(), p_117119_, p_117120_, p_117123_, (ArmorTrim)p_267897_, flag, p_117124_, flag1, 1.0f, 1.0f, 1.0f));
            }
        }
    }

    protected void m_117125_(A p_117126_, EquipmentSlot p_117127_) {
        ((HumanoidModel)((Object)p_117126_)).m_8009_(false);
        switch (p_117127_) {
            case HEAD: {
                ((HumanoidModel)((Object)p_117126_)).f_102808_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)((Object)p_117126_)).f_102810_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102811_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)((Object)p_117126_)).f_102810_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102813_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)((Object)p_117126_)).f_102813_.f_104207_ = true;
                ((HumanoidModel)((Object)p_117126_)).f_102814_.f_104207_ = true;
            }
        }
    }

    private void m_117106_(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, ArmorItem p_117110_, boolean p_117111_, A p_117112_, boolean p_117113_, float p_117114_, float p_117115_, float p_117116_, @Nullable String p_117117_) {
        this.renderModel(p_117107_, p_117108_, p_117109_, p_117111_, (Model)p_117112_, p_117114_, p_117115_, p_117116_, this.m_117080_(p_117110_, p_117113_, p_117117_));
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, boolean p_117111_, Model p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_(p_117108_, RenderType.m_110431_(armorResource), false, p_117111_);
        p_117112_.m_7695_(p_117107_, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private void m_267623_(ArmorMaterial p_267946_, PoseStack p_268019_, MultiBufferSource p_268023_, int p_268190_, ArmorTrim p_267984_, boolean p_267965_, A p_267949_, boolean p_268259_, float p_268337_, float p_268095_, float p_268305_) {
        TextureAtlasSprite textureatlassprite = this.f_266073_.m_118316_(p_268259_ ? p_267984_.m_267774_(p_267946_) : p_267984_.m_267606_(p_267946_));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(ItemRenderer.m_115222_(p_268023_, Sheets.m_266442_(), true, p_267965_));
        p_267949_.m_7695_(p_268019_, vertexconsumer, p_268190_, OverlayTexture.f_118083_, p_268337_, p_268095_, p_268305_, 1.0f);
    }

    private A m_117078_(EquipmentSlot p_117079_) {
        return this.m_117128_(p_117079_) ? this.f_117071_ : this.f_117072_;
    }

    private boolean m_117128_(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation m_117080_(ArmorItem p_117081_, boolean p_117082_, @Nullable String p_117083_) {
        String s = "textures/models/armor/" + p_117081_.m_40401_().m_6082_() + "_layer_" + (p_117082_ ? 2 : 1) + (String)(p_117083_ == null ? "" : "_" + p_117083_) + ".png";
        return f_117070_.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.m_117128_(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = f_117070_.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            f_117070_.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

