/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagAppender;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    protected final PackOutput.PathProvider f_236439_;
    private final CompletableFuture<HolderLookup.Provider> f_275752_;
    private final CompletableFuture<Void> f_275754_ = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> f_273855_;
    protected final ResourceKey<? extends Registry<T>> f_254716_;
    protected final Map<ResourceLocation, TagBuilder> f_126543_ = Maps.newLinkedHashMap();
    protected final String modId;
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    private final ExistingFileHelper.IResourceType elementResourceType;

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, "vanilla", null);
    }

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this(p_256596_, p_255886_, p_256513_, CompletableFuture.completedFuture(TagLookup.m_274566_()), modId, existingFileHelper);
    }

    @Deprecated
    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_) {
        this(p_275432_, p_275476_, p_275222_, p_275565_, "vanilla", null);
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.f_236439_ = p_275432_.m_245269_(PackOutput.Target.DATA_PACK, TagManager.m_203918_(p_275476_));
        this.f_254716_ = p_275476_;
        this.f_273855_ = p_275565_;
        this.f_275752_ = p_275222_;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", TagManager.m_203918_(p_275476_));
        this.elementResourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", ForgeHooks.prefixNamespace((ResourceLocation)p_275476_.m_135782_()));
    }

    @Nullable
    protected Path getPath(ResourceLocation id) {
        return this.f_236439_.m_245731_(id);
    }

    public String m_6055_() {
        return "Tags for " + this.f_254716_.m_135782_() + " mod id " + this.modId;
    }

    protected abstract void m_6577_(HolderLookup.Provider var1);

    public CompletableFuture<?> m_213708_(CachedOutput p_253684_) {
        record CombinedData<T>(HolderLookup.Provider f_273893_, TagLookup<T> f_273819_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this);
            }

            @Override
            public final boolean equals(Object p_275663_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CombinedData.class, "contents;parent", "f_273893_", "f_273819_"}, this, p_275663_);
            }
        }
        return ((CompletableFuture)((CompletableFuture)this.m_274574_().thenApply(p_275895_ -> {
            this.f_275754_.complete(null);
            return p_275895_;
        })).thenCombineAsync(this.f_273855_, (p_274778_, p_274779_) -> new CombinedData((HolderLookup.Provider)p_274778_, p_274779_))).thenCompose(p_274774_ -> {
            HolderLookup.RegistryLookup registrylookup = (HolderLookup.RegistryLookup)p_274774_.f_273893_.m_254861_(this.f_254716_).orElseThrow(() -> {
                if (RegistryManager.ACTIVE.getRegistry(this.f_254716_) != null) {
                    return new IllegalStateException("Forge registry " + this.f_254716_.m_135782_() + " does not have support for tags");
                }
                return new IllegalStateException("Registry " + this.f_254716_.m_135782_() + " not found");
            });
            Predicate<ResourceLocation> predicate = p_255496_ -> registrylookup.m_254902_(ResourceKey.m_135785_(this.f_254716_, p_255496_)).isPresent();
            Predicate<ResourceLocation> predicate1 = p_274776_ -> this.f_126543_.containsKey(p_274776_) || p_274774_.f_273819_.m_274455_(TagKey.m_203882_(this.f_254716_, (ResourceLocation)p_274776_));
            return CompletableFuture.allOf((CompletableFuture[])this.f_126543_.entrySet().stream().map(p_255499_ -> {
                ResourceLocation resourcelocation = (ResourceLocation)p_255499_.getKey();
                TagBuilder tagbuilder = (TagBuilder)p_255499_.getValue();
                List<TagEntry> list = tagbuilder.m_215904_();
                List<TagEntry> list1 = list.stream().filter(p_274771_ -> !p_274771_.m_215940_(predicate, predicate1)).filter(this::missing).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourcelocation, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement jsonelement = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(list, tagbuilder.isReplace())).getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
                Path path = this.getPath(resourcelocation);
                if (path == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return DataProvider.m_253162_((CachedOutput)p_253684_, (JsonElement)jsonelement, (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private boolean missing(TagEntry reference) {
        if (reference.isRequired()) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.getId(), reference.isTag() ? this.resourceType : this.elementResourceType);
        }
        return false;
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        TagBuilder tagbuilder = this.m_236451_(p_206425_);
        return new TagAppender(tagbuilder, this.modId);
    }

    protected TagBuilder m_236451_(TagKey<T> p_236452_) {
        return this.f_126543_.computeIfAbsent(p_236452_.f_203868_(), p_236442_ -> {
            this.existingFileHelper.trackGenerated(p_236442_, this.resourceType);
            return TagBuilder.m_215899_();
        });
    }

    public CompletableFuture<TagLookup<T>> m_274426_() {
        return this.f_275754_.thenApply(p_276016_ -> p_274772_ -> Optional.ofNullable(this.f_126543_.get(p_274772_.f_203868_())));
    }

    protected CompletableFuture<HolderLookup.Provider> m_274574_() {
        return this.f_275752_.thenApply(p_274768_ -> {
            this.f_126543_.clear();
            this.m_6577_((HolderLookup.Provider)p_274768_);
            return p_274768_;
        });
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> TagLookup<T> m_274566_() {
            return p_275247_ -> Optional.empty();
        }

        default public boolean m_274455_(TagKey<T> p_275413_) {
            return ((Optional)this.apply(p_275413_)).isPresent();
        }
    }

    public static class TagAppender<T>
    implements IForgeTagAppender<T> {
        private final TagBuilder f_126568_;
        private final String modId;

        protected TagAppender(TagBuilder p_236454_, String modId) {
            this.f_126568_ = p_236454_;
            this.modId = modId;
        }

        public final TagAppender<T> m_255204_(ResourceKey<T> p_256138_) {
            this.f_126568_.m_215900_(p_256138_.m_135782_());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> resourcekey : p_211102_) {
                this.f_126568_.m_215900_(resourcekey.m_135782_());
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_215905_(p_176840_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_215907_(p_206429_.f_203868_());
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_215909_(p_176842_);
            return this;
        }

        public TagAppender<T> add(TagEntry tag) {
            this.f_126568_.m_215902_(tag);
            return this;
        }

        public TagBuilder getInternalBuilder() {
            return this.f_126568_;
        }

        public String getModID() {
            return this.modId;
        }
    }
}

