/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class EndDragonFight {
    private static final Logger f_64058_ = LogUtils.getLogger();
    private static final int f_156737_ = 1200;
    private static final int f_156738_ = 100;
    private static final int f_156739_ = 20;
    private static final int f_156740_ = 8;
    public static final int f_156735_ = 9;
    private static final int f_156741_ = 20;
    private static final int f_156742_ = 96;
    public static final int f_156736_ = 128;
    private static final Predicate<Entity> f_64059_ = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final ServerBossEvent f_64060_ = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.minecraft.ender_dragon"), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true).m_7006_(true);
    private final ServerLevel f_64061_;
    private final ObjectArrayList<Integer> f_64062_ = new ObjectArrayList();
    private final BlockPattern f_64063_;
    private int f_64064_;
    private int f_64065_;
    private int f_64066_;
    private int f_64067_;
    private boolean f_64068_;
    private boolean f_64069_;
    @Nullable
    private UUID f_64070_;
    private boolean f_64071_ = true;
    @Nullable
    private BlockPos f_64072_;
    @Nullable
    private DragonRespawnAnimation f_64073_;
    private int f_64074_;
    @Nullable
    private List<EndCrystal> f_64075_;

    public EndDragonFight(ServerLevel p_64078_, long p_64079_, CompoundTag p_64080_) {
        this.f_64061_ = p_64078_;
        if (p_64080_.m_128441_("NeedsStateScanning")) {
            this.f_64071_ = p_64080_.m_128471_("NeedsStateScanning");
        }
        if (p_64080_.m_128425_("DragonKilled", 99)) {
            if (p_64080_.m_128403_("Dragon")) {
                this.f_64070_ = p_64080_.m_128342_("Dragon");
            }
            this.f_64068_ = p_64080_.m_128471_("DragonKilled");
            this.f_64069_ = p_64080_.m_128471_("PreviouslyKilled");
            boolean bl = this.f_64071_ = !p_64080_.m_128471_("LegacyScanPerformed");
            if (p_64080_.m_128471_("IsRespawning")) {
                this.f_64073_ = DragonRespawnAnimation.START;
            }
            if (p_64080_.m_128425_("ExitPortalLocation", 10)) {
                this.f_64072_ = NbtUtils.m_129239_((CompoundTag)p_64080_.m_128469_("ExitPortalLocation"));
            }
        } else {
            this.f_64068_ = true;
            this.f_64069_ = true;
        }
        if (p_64080_.m_128425_("Gateways", 9)) {
            ListTag listtag = p_64080_.m_128437_("Gateways", 3);
            for (int i = 0; i < listtag.size(); ++i) {
                this.f_64062_.add((Object)listtag.m_128763_(i));
            }
        } else {
            this.f_64062_.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Util.m_214673_(this.f_64062_, RandomSource.m_216335_((long)p_64079_));
        }
        this.f_64063_ = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).m_61247_(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).m_61247_(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).m_61247_(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).m_61247_(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockPredicate.m_61275_((Block)Blocks.f_50752_))).m_61249_();
    }

    public CompoundTag m_64081_() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128379_("NeedsStateScanning", this.f_64071_);
        if (this.f_64070_ != null) {
            compoundtag.m_128362_("Dragon", this.f_64070_);
        }
        compoundtag.m_128379_("DragonKilled", this.f_64068_);
        compoundtag.m_128379_("PreviouslyKilled", this.f_64069_);
        compoundtag.m_128379_("LegacyScanPerformed", !this.f_64071_);
        if (this.f_64072_ != null) {
            compoundtag.m_128365_("ExitPortalLocation", NbtUtils.m_129224_((BlockPos)this.f_64072_));
        }
        ListTag listtag = new ListTag();
        ObjectListIterator objectListIterator = this.f_64062_.iterator();
        while (objectListIterator.hasNext()) {
            int i = (Integer)objectListIterator.next();
            listtag.add(IntTag.m_128679_((int)i));
        }
        compoundtag.m_128365_("Gateways", (Tag)listtag);
        return compoundtag;
    }

    public void m_64095_() {
        this.f_64060_.m_8321_(!this.f_64068_);
        if (++this.f_64067_ >= 20) {
            this.m_64107_();
            this.f_64067_ = 0;
        }
        if (!this.f_64060_.m_8324_().isEmpty()) {
            this.f_64061_.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, Unit.INSTANCE);
            boolean flag = this.m_64106_();
            if (this.f_64071_ && flag) {
                this.m_64102_();
                this.f_64071_ = false;
            }
            if (this.f_64073_ != null) {
                if (this.f_64075_ == null && flag) {
                    this.f_64073_ = null;
                    this.m_64100_();
                }
                this.f_64073_.m_6363_(this.f_64061_, this, this.f_64075_, this.f_64074_++, this.f_64072_);
            }
            if (!this.f_64068_) {
                if ((this.f_64070_ == null || ++this.f_64064_ >= 1200) && flag) {
                    this.m_64103_();
                    this.f_64064_ = 0;
                }
                if (++this.f_64066_ >= 100 && flag) {
                    this.m_64108_();
                    this.f_64066_ = 0;
                }
            }
        } else {
            this.f_64061_.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void m_64102_() {
        f_64058_.info("Scanning for legacy world dragon fight...");
        boolean flag = this.m_64104_();
        if (flag) {
            f_64058_.info("Found that the dragon has been killed in this world already.");
            this.f_64069_ = true;
        } else {
            f_64058_.info("Found that the dragon has not yet been killed in this world.");
            this.f_64069_ = false;
            if (this.m_64105_() == null) {
                this.m_64093_(false);
            }
        }
        List<? extends EnderDragon> list = this.f_64061_.m_8857_();
        if (list.isEmpty()) {
            this.f_64068_ = true;
        } else {
            EnderDragon enderdragon = list.get(0);
            this.f_64070_ = enderdragon.m_20148_();
            f_64058_.info("Found that there's a dragon still alive ({})", (Object)enderdragon);
            this.f_64068_ = false;
            if (!flag) {
                f_64058_.info("But we didn't have a portal, let's remove it.");
                enderdragon.m_146870_();
                this.f_64070_ = null;
            }
        }
        if (!this.f_64069_ && this.f_64068_) {
            this.f_64068_ = false;
        }
    }

    private void m_64103_() {
        List<? extends EnderDragon> list = this.f_64061_.m_8857_();
        if (list.isEmpty()) {
            f_64058_.debug("Haven't seen the dragon, respawning it");
            this.m_64110_();
        } else {
            f_64058_.debug("Haven't seen our dragon, but found another one to use.");
            this.f_64070_ = list.get(0).m_20148_();
        }
    }

    protected void m_64087_(DragonRespawnAnimation p_64088_) {
        if (this.f_64073_ == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.f_64074_ = 0;
        if (p_64088_ == DragonRespawnAnimation.END) {
            this.f_64073_ = null;
            this.f_64068_ = false;
            EnderDragon enderdragon = this.m_64110_();
            if (enderdragon != null) {
                for (ServerPlayer serverplayer : this.f_64060_.m_8324_()) {
                    CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)enderdragon);
                }
            }
        } else {
            this.f_64073_ = p_64088_;
        }
    }

    private boolean m_64104_() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                LevelChunk levelchunk = this.f_64061_.m_6325_(i, j);
                for (BlockEntity blockentity : levelchunk.m_62954_().values()) {
                    if (!(blockentity instanceof TheEndPortalBlockEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.BlockPatternMatch m_64105_() {
        int k;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                LevelChunk levelchunk = this.f_64061_.m_6325_(i, j);
                for (BlockEntity blockentity : levelchunk.m_62954_().values()) {
                    BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch;
                    if (!(blockentity instanceof TheEndPortalBlockEntity) || (blockpattern$blockpatternmatch = this.f_64063_.m_61184_((LevelReader)((Object)this.f_64061_), blockentity.m_58899_())) == null) continue;
                    BlockPos blockpos = blockpattern$blockpatternmatch.m_61229_(3, 3, 3).m_61176_();
                    if (this.f_64072_ == null) {
                        this.f_64072_ = blockpos;
                    }
                    return blockpattern$blockpatternmatch;
                }
            }
        }
        for (int l = k = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.f_65714_).m_123342_(); l >= this.f_64061_.m_141937_(); --l) {
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch1 = this.f_64063_.m_61184_((LevelReader)((Object)this.f_64061_), new BlockPos(EndPodiumFeature.f_65714_.m_123341_(), l, EndPodiumFeature.f_65714_.m_123343_()));
            if (blockpattern$blockpatternmatch1 == null) continue;
            if (this.f_64072_ == null) {
                this.f_64072_ = blockpattern$blockpatternmatch1.m_61229_(3, 3, 3).m_61176_();
            }
            return blockpattern$blockpatternmatch1;
        }
        return null;
    }

    private boolean m_64106_() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = 8; j <= 8; ++j) {
                ChunkAccess chunkaccess = this.f_64061_.m_6522_(i, j, ChunkStatus.f_62326_, false);
                if (!(chunkaccess instanceof LevelChunk)) {
                    return false;
                }
                ChunkHolder.FullChunkStatus chunkholder$fullchunkstatus = ((LevelChunk)chunkaccess).m_6708_();
                if (chunkholder$fullchunkstatus.m_140114_(ChunkHolder.FullChunkStatus.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void m_64107_() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayer serverplayer : this.f_64061_.m_8795_(f_64059_)) {
            this.f_64060_.m_6543_(serverplayer);
            set.add(serverplayer);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.f_64060_.m_8324_());
        set1.removeAll(set);
        for (ServerPlayer serverplayer1 : set1) {
            this.f_64060_.m_6539_(serverplayer1);
        }
    }

    private void m_64108_() {
        this.f_64066_ = 0;
        this.f_64065_ = 0;
        for (SpikeFeature.EndSpike spikefeature$endspike : SpikeFeature.m_66858_((WorldGenLevel)this.f_64061_)) {
            this.f_64065_ += this.f_64061_.m_45976_(EndCrystal.class, spikefeature$endspike.m_66905_()).size();
        }
        f_64058_.debug("Found {} end crystals still alive", (Object)this.f_64065_);
    }

    public void m_64085_(EnderDragon p_64086_) {
        if (p_64086_.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(0.0f);
            this.f_64060_.m_8321_(false);
            this.m_64093_(true);
            this.m_64109_();
            if (!this.f_64069_) {
                this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.f_65714_), Blocks.f_50260_.m_49966_());
            }
            this.f_64069_ = true;
            this.f_64068_ = true;
        }
    }

    private void m_64109_() {
        if (!this.f_64062_.isEmpty()) {
            int i = (Integer)this.f_64062_.remove(this.f_64062_.size() - 1);
            int j = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int k = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            this.m_64089_(new BlockPos(j, 75, k));
        }
    }

    private void m_64089_(BlockPos p_64090_) {
        this.f_64061_.m_46796_(3000, p_64090_, 0);
        this.f_64061_.m_9598_().m_6632_(Registries.f_256911_).flatMap(p_258993_ -> p_258993_.m_203636_(EndFeatures.f_194984_)).ifPresent(p_256486_ -> ((ConfiguredFeature)p_256486_.m_203334_()).m_224953_((WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), p_64090_));
    }

    private void m_64093_(boolean p_64094_) {
        EndPodiumFeature endpodiumfeature = new EndPodiumFeature(p_64094_);
        if (this.f_64072_ == null) {
            this.f_64072_ = this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_).m_7495_();
            while (this.f_64061_.m_8055_(this.f_64072_).m_60713_(Blocks.f_50752_) && this.f_64072_.m_123342_() > this.f_64061_.m_5736_()) {
                this.f_64072_ = this.f_64072_.m_7495_();
            }
        }
        endpodiumfeature.m_225028_((FeatureConfiguration)FeatureConfiguration.f_67737_, (WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), this.f_64072_);
    }

    @Nullable
    private EnderDragon m_64110_() {
        this.f_64061_.m_46745_(new BlockPos(0, 128, 0));
        EnderDragon enderdragon = EntityType.f_20565_.m_20615_(this.f_64061_);
        if (enderdragon != null) {
            enderdragon.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            enderdragon.m_7678_(0.0, 128.0, 0.0, this.f_64061_.f_46441_.m_188501_() * 360.0f, 0.0f);
            this.f_64061_.m_7967_(enderdragon);
            this.f_64070_ = enderdragon.m_20148_();
        }
        return enderdragon;
    }

    public void m_64096_(EnderDragon p_64097_) {
        if (p_64097_.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(p_64097_.m_21223_() / p_64097_.m_21233_());
            this.f_64064_ = 0;
            if (p_64097_.m_8077_()) {
                this.f_64060_.m_6456_(p_64097_.m_5446_());
            }
        }
    }

    public int m_64098_() {
        return this.f_64065_;
    }

    public void m_64082_(EndCrystal p_64083_, DamageSource p_64084_) {
        if (this.f_64073_ != null && this.f_64075_.contains(p_64083_)) {
            f_64058_.debug("Aborting respawn sequence");
            this.f_64073_ = null;
            this.f_64074_ = 0;
            this.m_64101_();
            this.m_64093_(true);
        } else {
            this.m_64108_();
            Entity entity = this.f_64061_.m_8791_(this.f_64070_);
            if (entity instanceof EnderDragon) {
                ((EnderDragon)entity).m_31124_(p_64083_, p_64083_.m_20183_(), p_64084_);
            }
        }
    }

    public boolean m_64099_() {
        return this.f_64069_;
    }

    public void m_64100_() {
        if (this.f_64068_ && this.f_64073_ == null) {
            BlockPos blockpos = this.f_64072_;
            if (blockpos == null) {
                f_64058_.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.m_64105_();
                if (blockpattern$blockpatternmatch == null) {
                    f_64058_.debug("Couldn't find a portal, so we made one.");
                    this.m_64093_(true);
                } else {
                    f_64058_.debug("Found the exit portal & saved its location for next time.");
                }
                blockpos = this.f_64072_;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.m_6630_(1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.f_64061_.m_45976_(EndCrystal.class, new AABB(blockpos1.m_5484_(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            f_64058_.debug("Found all crystals, respawning dragon.");
            this.m_64091_(list1);
        }
    }

    private void m_64091_(List<EndCrystal> p_64092_) {
        if (this.f_64068_ && this.f_64073_ == null) {
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.m_64105_();
            while (blockpattern$blockpatternmatch != null) {
                for (int i = 0; i < this.f_64063_.m_61203_(); ++i) {
                    for (int j = 0; j < this.f_64063_.m_61202_(); ++j) {
                        for (int k = 0; k < this.f_64063_.m_61183_(); ++k) {
                            BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(i, j, k);
                            if (!blockinworld.m_61168_().m_60713_(Blocks.f_50752_) && !blockinworld.m_61168_().m_60713_(Blocks.f_50257_)) continue;
                            this.f_64061_.m_46597_(blockinworld.m_61176_(), Blocks.f_50259_.m_49966_());
                        }
                    }
                }
                blockpattern$blockpatternmatch = this.m_64105_();
            }
            this.f_64073_ = DragonRespawnAnimation.START;
            this.f_64074_ = 0;
            this.m_64093_(false);
            this.f_64075_ = p_64092_;
        }
    }

    public void m_64101_() {
        for (SpikeFeature.EndSpike spikefeature$endspike : SpikeFeature.m_66858_((WorldGenLevel)this.f_64061_)) {
            for (EndCrystal endcrystal : this.f_64061_.m_45976_(EndCrystal.class, spikefeature$endspike.m_66905_())) {
                endcrystal.m_20331_(false);
                endcrystal.m_31052_((BlockPos)null);
            }
        }
    }

    public void addPlayer(ServerPlayer player) {
        this.f_64060_.m_6543_(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.f_64060_.m_6539_(player);
    }
}

