/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod.api;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.INameMappingService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.script.ScriptException;
import net.minecraftforge.coremod.CoreModEngine;
import net.minecraftforge.coremod.CoreModTracker;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ASMAPI {
    public static InsnList listOf(AbstractInsnNode ... nodes) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    public static boolean insertInsn(MethodNode method, AbstractInsnNode insn, AbstractInsnNode toInsert, InsertMode mode) {
        if (!method.instructions.contains(insn)) {
            return false;
        }
        switch (mode) {
            case INSERT_BEFORE: {
                method.instructions.insertBefore(insn, toInsert);
                break;
            }
            case INSERT_AFTER: {
                method.instructions.insert(insn, toInsert);
                break;
            }
            case REMOVE_ORIGINAL: {
                method.instructions.set(insn, toInsert);
            }
        }
        return true;
    }

    public static boolean insertInsn(MethodNode method, MethodType type, String owner, String name, String desc, AbstractInsnNode toInsert, InsertMode mode) {
        MethodInsnNode insn = ASMAPI.findFirstMethodCall(method, type, owner, name, desc);
        if (insn == null) {
            return false;
        }
        return ASMAPI.insertInsn(method, (AbstractInsnNode)insn, toInsert, mode);
    }

    public static boolean insertInsnList(MethodNode method, AbstractInsnNode insn, InsnList list, InsertMode mode) {
        if (!method.instructions.contains(insn)) {
            return false;
        }
        if (mode == InsertMode.INSERT_BEFORE) {
            method.instructions.insertBefore(insn, list);
        } else {
            method.instructions.insert(insn, list);
        }
        if (mode == InsertMode.REMOVE_ORIGINAL) {
            method.instructions.remove(insn);
        }
        return true;
    }

    public static boolean insertInsnList(MethodNode method, MethodType type, String owner, String name, String desc, InsnList list, InsertMode mode) {
        MethodInsnNode insn = ASMAPI.findFirstMethodCall(method, type, owner, name, desc);
        if (insn == null) {
            return false;
        }
        return ASMAPI.insertInsnList(method, (AbstractInsnNode)insn, list, mode);
    }

    public static void injectMethodCall(MethodNode method, MethodInsnNode insn) {
        method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)insn);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static void appendMethodCall(MethodNode method, MethodInsnNode insn) {
        ASMAPI.injectMethodCall(method, insn);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstruction(MethodNode method, int opcode) {
        return ASMAPI.findFirstInstructionAfter(method, opcode, null, 0);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstruction(MethodNode method, InsnType type) {
        return ASMAPI.findFirstInstructionAfter(method, -2, type, 0);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstruction(MethodNode method, int opcode, InsnType type) {
        return ASMAPI.findFirstInstructionAfter(method, opcode, type, 0);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionAfter(MethodNode method, int opcode, int startIndex) {
        return ASMAPI.findFirstInstructionAfter(method, opcode, null, startIndex);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionAfter(MethodNode method, InsnType type, int startIndex) {
        return ASMAPI.findFirstInstructionAfter(method, -2, type, startIndex);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionAfter(MethodNode method, int opcode, @Nullable InsnType type, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            boolean typeMatch;
            AbstractInsnNode ain = method.instructions.get(i);
            boolean opcodeMatch = opcode < -1 || ain.getOpcode() == opcode;
            boolean bl = typeMatch = type == null || type.get() == ain.getType();
            if (!opcodeMatch || !typeMatch) continue;
            return ain;
        }
        return null;
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opcode, int startIndex) {
        return ASMAPI.findFirstInstructionBefore(method, opcode, null, startIndex);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, InsnType type, int startIndex) {
        return ASMAPI.findFirstInstructionBefore(method, -2, type, startIndex);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, int startIndex, boolean fixLogic) {
        return ASMAPI.findFirstInstructionBefore(method, opCode, null, startIndex, fixLogic);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, InsnType type, int startIndex, boolean fixLogic) {
        return ASMAPI.findFirstInstructionBefore(method, -2, type, startIndex, fixLogic);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, @Nullable InsnType type, int startIndex) {
        return ASMAPI.findFirstInstructionBefore(method, opCode, type, startIndex, !CoreModEngine.DO_NOT_FIX_INSNBEFORE);
    }

    @Nullable
    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, @Nullable InsnType type, int startIndex, boolean fixLogic) {
        int i;
        int n = i = fixLogic ? Math.min(method.instructions.size() - 1, startIndex) : startIndex;
        while (i >= 0) {
            boolean typeMatch;
            AbstractInsnNode ain = method.instructions.get(i);
            boolean opcodeMatch = opCode < -1 || ain.getOpcode() == opCode;
            boolean bl = typeMatch = type == null || type.get() == ain.getType();
            if (opcodeMatch && typeMatch) {
                return ain;
            }
            --i;
        }
        return null;
    }

    @Nullable
    public static MethodInsnNode findFirstMethodCall(MethodNode method, MethodType type, String owner, String name, String descriptor) {
        return ASMAPI.findFirstMethodCallAfter(method, type, owner, name, descriptor, 0);
    }

    @Nullable
    public static MethodInsnNode findFirstMethodCallAfter(MethodNode method, MethodType type, String owner, String name, String descriptor, int index) {
        for (int i = Math.max(0, index); i < method.instructions.size(); ++i) {
            MethodInsnNode insn;
            AbstractInsnNode abstractInsnNode = method.instructions.get(i);
            if (!(abstractInsnNode instanceof MethodInsnNode) || (insn = (MethodInsnNode)abstractInsnNode).getOpcode() != type.toOpcode() || !Objects.equals(insn.owner, owner) || !Objects.equals(insn.name, name) || !Objects.equals(insn.desc, descriptor)) continue;
            return insn;
        }
        return null;
    }

    @Nullable
    public static MethodInsnNode findFirstMethodCallBefore(MethodNode method, MethodType type, String owner, String name, String descriptor, int index) {
        for (int i = Math.min(method.instructions.size() - 1, index); i >= 0; --i) {
            MethodInsnNode insn;
            AbstractInsnNode abstractInsnNode = method.instructions.get(i);
            if (!(abstractInsnNode instanceof MethodInsnNode) || (insn = (MethodInsnNode)abstractInsnNode).getOpcode() != type.toOpcode() || !Objects.equals(insn.owner, owner) || !Objects.equals(insn.name, name) || !Objects.equals(insn.desc, descriptor)) continue;
            return insn;
        }
        return null;
    }

    @Nullable
    public static FieldInsnNode findFirstFieldCall(MethodNode method, int opcode, String owner, String name, String descriptor) {
        return ASMAPI.findFirstFieldCallAfter(method, opcode, owner, name, descriptor, 0);
    }

    @Nullable
    public static FieldInsnNode findFirstFieldCallAfter(MethodNode method, int opcode, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            FieldInsnNode insn;
            AbstractInsnNode abstractInsnNode = method.instructions.get(i);
            if (!(abstractInsnNode instanceof FieldInsnNode) || (insn = (FieldInsnNode)abstractInsnNode).getOpcode() != opcode || !insn.owner.equals(owner) || !insn.name.equals(name) || !insn.desc.equals(descriptor)) continue;
            return insn;
        }
        return null;
    }

    @Nullable
    public static FieldInsnNode findFirstFieldCallBefore(MethodNode method, int opcode, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.min(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            FieldInsnNode insn;
            AbstractInsnNode abstractInsnNode = method.instructions.get(i);
            if (!(abstractInsnNode instanceof FieldInsnNode) || (insn = (FieldInsnNode)abstractInsnNode).getOpcode() != opcode || !insn.owner.equals(owner) || !insn.name.equals(name) || !insn.desc.equals(descriptor)) continue;
            return insn;
        }
        return null;
    }

    public static MethodNode getMethodNode() {
        MethodNode method = new MethodNode(589824);
        method.exceptions = new ArrayList();
        return method;
    }

    public static MethodNode getMethodNode(int access, String name, String descriptor) {
        return new MethodNode(589824, access, name, descriptor, null, null);
    }

    public static MethodNode getMethodNode(int access, String name, String descriptor, @Nullable String signature) {
        return new MethodNode(589824, access, name, descriptor, signature, null);
    }

    public static MethodNode getMethodNode(int access, String name, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        return new MethodNode(589824, access, name, descriptor, signature, exceptions);
    }

    @Nullable
    public static MethodNode findMethodNode(ClassNode clazz, String name, String desc) {
        return ASMAPI.findMethodNode(clazz, name, desc, null, false);
    }

    @Nullable
    public static MethodNode findMethodNode(ClassNode clazz, String name, String desc, @Nullable String signature) {
        return ASMAPI.findMethodNode(clazz, name, desc, signature, true);
    }

    @Nullable
    private static MethodNode findMethodNode(ClassNode clazz, String name, String desc, @Nullable String signature, boolean checkSignature) {
        for (MethodNode method : clazz.methods) {
            if (!Objects.equals(method.name, name) || !Objects.equals(method.desc, desc) || checkSignature && !Objects.equals(method.signature, signature)) continue;
            return method;
        }
        return null;
    }

    public static FieldNode getFieldNode(int access, String name, String descriptor) {
        return new FieldNode(589824, access, name, descriptor, null, null);
    }

    public static FieldNode getFieldNode(int access, String name, String descriptor, @Nullable String signature) {
        return new FieldNode(589824, access, name, descriptor, signature, null);
    }

    public static FieldNode getFieldNode(int access, String name, String descriptor, @Nullable String signature, String value) {
        return new FieldNode(589824, access, name, descriptor, signature, (Object)value);
    }

    public static FieldNode getFieldNode(int access, String name, String descriptor, @Nullable String signature, Number value, NumberType valueType) {
        return new FieldNode(589824, access, name, descriptor, signature, ASMAPI.castNumber(value, valueType));
    }

    @Nullable
    public static FieldNode findFieldNode(ClassNode clazz, String name, String desc) {
        return ASMAPI.findFieldNode(clazz, name, desc, null, false);
    }

    @Nullable
    public static FieldNode findFieldNode(ClassNode clazz, String name, String desc, @Nullable String signature) {
        return ASMAPI.findFieldNode(clazz, name, desc, signature, true);
    }

    @Nullable
    private static FieldNode findFieldNode(ClassNode clazz, String name, String desc, @Nullable String signature, boolean checkSignature) {
        for (FieldNode field : clazz.fields) {
            if (!Objects.equals(field.name, name) || !Objects.equals(field.desc, desc) || checkSignature && !Objects.equals(field.signature, signature)) continue;
            return field;
        }
        return null;
    }

    public static MethodInsnNode buildMethodCall(MethodType type, String ownerName, String methodName, String methodDescriptor) {
        return new MethodInsnNode(type.toOpcode(), ownerName, methodName, methodDescriptor, type == MethodType.INTERFACE);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static MethodInsnNode buildMethodCall(String ownerName, String methodName, String methodDescriptor, MethodType type) {
        return new MethodInsnNode(type.toOpcode(), ownerName, methodName, methodDescriptor, type == MethodType.INTERFACE);
    }

    public static FieldInsnNode buildFieldCall(int opcode, String owner, String name, String desc) {
        return new FieldInsnNode(opcode, owner, name, desc);
    }

    public static Object castNumber(Number value, NumberType type) {
        return type.mapper.apply(value);
    }

    public static LdcInsnNode buildNumberLdcInsnNode(Number value, NumberType type) {
        return new LdcInsnNode(ASMAPI.castNumber(value, type));
    }

    public static void redirectFieldToMethod(ClassNode classNode, String fieldName, @Nullable String methodName) {
        MethodNode foundMethod = null;
        FieldNode foundField = null;
        for (FieldNode fieldNode : classNode.fields) {
            if (!Objects.equals(fieldNode.name, fieldName)) continue;
            if (foundField == null) {
                foundField = fieldNode;
                continue;
            }
            throw new IllegalStateException("Found multiple fields with name " + fieldName);
        }
        if (foundField == null) {
            throw new IllegalStateException("No field with name " + fieldName + " found");
        }
        if (!Modifier.isPrivate(foundField.access) || Modifier.isStatic(foundField.access)) {
            throw new IllegalStateException("Field " + fieldName + " is not private and an instance field");
        }
        String methodSignature = "()" + foundField.desc;
        for (MethodNode methodNode : classNode.methods) {
            if (!Objects.equals(methodNode.desc, methodSignature)) continue;
            if (foundMethod == null && Objects.equals(methodNode.name, methodName)) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null && methodName == null) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null || methodName != null && !Objects.equals(methodNode.name, methodName)) continue;
            throw new IllegalStateException("Found duplicate method with signature " + methodSignature);
        }
        if (foundMethod == null) {
            throw new IllegalStateException("Unable to find method " + methodSignature);
        }
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode == foundMethod || Objects.equals(methodNode.desc, methodSignature)) continue;
            ListIterator iterator = methodNode.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                if (insnNode.getOpcode() != 180) continue;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
                if (!Objects.equals(fieldInsnNode.name, fieldName)) continue;
                iterator.remove();
                MethodInsnNode replace = new MethodInsnNode(182, classNode.name, foundMethod.name, foundMethod.desc, false);
                iterator.add(replace);
            }
        }
    }

    public static String mapMethod(String name) {
        return ASMAPI.map(name, INameMappingService.Domain.METHOD);
    }

    public static String mapField(String name) {
        return ASMAPI.map(name, INameMappingService.Domain.FIELD);
    }

    private static String map(String name, INameMappingService.Domain domain) {
        return Optional.ofNullable(Launcher.INSTANCE).map(Launcher::environment).flatMap(env -> env.findNameMapping("srg")).map(f -> (String)f.apply(domain, name)).orElse(name);
    }

    public static boolean getSystemPropertyFlag(String propertyName) {
        return Boolean.getBoolean(propertyName) || Boolean.getBoolean("coremod." + propertyName) || Boolean.getBoolean(System.getProperty("coremod." + propertyName, "TRUE"));
    }

    public static boolean loadFile(String file) throws ScriptException, IOException {
        return CoreModTracker.loadFileByName(file);
    }

    @Nullable
    public static Object loadData(String file) throws ScriptException, IOException {
        return CoreModTracker.loadDataByName(file);
    }

    public static void log(String level, String message, Object ... args) {
        CoreModTracker.log(level, message, args);
    }

    public static String classNodeToString(ClassNode node) {
        Textifier text = new Textifier();
        node.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)text, null));
        return ASMAPI.toString(text);
    }

    public static String methodNodeToString(MethodNode node) {
        Textifier text = new Textifier();
        node.accept((MethodVisitor)new TraceMethodVisitor((Printer)text));
        return ASMAPI.toString(text);
    }

    public static String fieldNodeToString(FieldNode node) {
        Textifier text = new Textifier();
        node.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)text, null));
        return ASMAPI.toString(text);
    }

    public static String insnListToString(InsnList list) {
        Textifier text = new Textifier();
        list.accept((MethodVisitor)new TraceMethodVisitor((Printer)text));
        return ASMAPI.toString(text);
    }

    public static String insnToString(AbstractInsnNode insn) {
        Textifier text = new Textifier();
        insn.accept((MethodVisitor)new TraceMethodVisitor((Printer)text));
        return ASMAPI.toString(text);
    }

    public static String ldcInsnClassToString(LdcInsnNode insn) {
        return insn.cst.getClass().toString();
    }

    private static String toString(Textifier text) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        text.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static enum InsertMode {
        INSERT_BEFORE,
        INSERT_AFTER,
        REMOVE_ORIGINAL;

    }

    public static enum MethodType {
        VIRTUAL(182),
        SPECIAL(183),
        STATIC(184),
        INTERFACE(185),
        DYNAMIC(186);

        private final int opcode;

        private MethodType(int opcode) {
            this.opcode = opcode;
        }

        public int toOpcode() {
            return this.opcode;
        }
    }

    public static enum InsnType {
        INSN(0),
        INT_INSN(1),
        VAR_INSN(2),
        TYPE_INSN(3),
        FIELD_INSN(4),
        METHOD_INSN(5),
        INVOKE_DYNAMIC_INSN(6),
        JUMP_INSN(7),
        LABEL(8),
        LDC_INSN(9),
        IINC_INSN(10),
        TABLESWITCH_INSN(11),
        LOOKUPSWITCH_INSN(12),
        MULTIANEWARRAY_INSN(13),
        FRAME(14),
        LINE(15);

        private final int type;

        private InsnType(int type) {
            this.type = type;
        }

        public int get() {
            return this.type;
        }
    }

    public static enum NumberType {
        INTEGER(Number::intValue),
        FLOAT(Number::floatValue),
        LONG(Number::longValue),
        DOUBLE(Number::doubleValue);

        private final Function<Number, Object> mapper;

        private NumberType(Function<Number, Object> mapper) {
            this.mapper = mapper;
        }
    }
}

