/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] $$0) {
        aa.a();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$14 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$15 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$34;
            boolean $$29;
            OptionSet $$17 = $$1.parse($$0);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$18 = (Path)$$17.valueOf((OptionSpec)$$15);
            if ($$18 != null) {
                Main.a($$18);
            }
            o.h();
            if ($$17.has((OptionSpec)$$14)) {
                bdv.e.a(bdt.b);
            }
            aey.a();
            aey.c();
            ac.l();
            Path $$19 = Paths.get("server.properties", new String[0]);
            ajp $$20 = new ajp($$19);
            $$20.b();
            Path $$21 = Paths.get("eula.txt", new String[0]);
            afc $$22 = new afc($$21);
            if ($$17.has((OptionSpec)$$3)) {
                a.info("Initialized '{}' and '{}'", (Object)$$19.toAbsolutePath(), (Object)$$21.toAbsolutePath());
                return;
            }
            if (!$$22.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$23 = new File((String)$$17.valueOf((OptionSpec)$$10));
            afo $$24 = afo.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$23);
            String $$25 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$11)).orElse($$20.a().m);
            ecg $$26 = ecg.b($$23.toPath());
            ecg.c $$27 = $$26.d($$25);
            ech $$28 = $$27.d();
            if ($$28 != null) {
                if ($$28.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$28.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if ($$29 = $$17.has((OptionSpec)$$8)) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ane $$30 = anh.a($$27);
            try {
                afq.c $$31 = Main.a($$20.a(), $$27, $$29, $$30);
                afr $$32 = (afr)ac.c(arg_0 -> Main.a($$31, $$27, $$17, (OptionSpec)$$4, $$20, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$33) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$33);
                return;
            }
            hr.b $$35 = $$34.c().a();
            if ($$17.has((OptionSpec)$$6)) {
                Main.a($$27, atb.a(), $$17.has((OptionSpec)$$7), () -> true, $$35.d(jc.aI));
            }
            ecm $$36 = $$34.d();
            $$27.a($$35, $$36);
            final ajn $$37 = MinecraftServer.a(arg_0 -> Main.a($$27, $$30, (afr)$$34, $$20, $$24, $$17, (OptionSpec)$$12, (OptionSpec)$$4, (OptionSpec)$$13, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$38 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$37.a(true);
                }
            };
            $$38.setUncaughtExceptionHandler(new r(a));
            Runtime.getRuntime().addShutdownHook($$38);
        }
        catch (Exception $$39) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$39);
        }
    }

    private static void a(Path $$0) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString($$0, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static afq.c a(ajo $$0, ecg.c $$1, boolean $$2, ane $$3) {
        cqo $$8;
        boolean $$7;
        cqo $$4 = $$1.e();
        if ($$4 != null) {
            boolean $$5 = false;
            cqo $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new cqo($$0.T, cee.g);
        }
        afq.d $$9 = new afq.d($$3, $$8, $$2, $$7);
        return new afq.c($$9, du.a.b, $$0.B);
    }

    private static void a(ecg.c $$0, DataFixer $$1, boolean $$2, BooleanSupplier $$3, hq<dit> $$4) {
        a.info("Forcing world upgrade!");
        bgm $$5 = new bgm($$0, $$1, $$4, $$2);
        tl $$6 = null;
        while (!$$5.b()) {
            int $$8;
            tl $$7 = $$5.h();
            if ($$6 != $$7) {
                $$6 = $$7;
                a.info($$5.h().getString());
            }
            if (($$8 = $$5.e()) > 0) {
                int $$9 = $$5.f() + $$5.g();
                a.info("{}% completed ({} / {} chunks)...", new Object[]{arw.d((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!$$3.getAsBoolean()) {
                $$5.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ ajn a(ecg.c $$0, ane $$1, afr $$2, ajp $$3, afo $$4, OptionSet $$5, OptionSpec $$6, OptionSpec $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, Thread $$11) {
        boolean $$13;
        ajn $$12 = new ajn($$11, $$0, $$1, $$2, $$3, atb.a(), $$4, alb::new);
        $$12.a((Integer)$$5.valueOf($$6));
        $$12.c($$5.has($$7));
        $$12.b((String)$$5.valueOf($$8));
        boolean bl2 = $$13 = !$$5.has($$9) && !$$5.valuesOf($$10).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.bh();
        }
        return $$12;
    }

    private static /* synthetic */ CompletableFuture a(afq.c $$0, ecg.c $$1, OptionSet $$2, OptionSpec $$3, ajp $$4, OptionSpec $$52, Executor $$6) {
        return afq.a($$0, (afq.a $$5) -> {
            dln $$15;
            dlq $$14;
            cpz $$13;
            hq<dit> $$6 = $$5.d().d(jc.aI);
            aeu<rq> $$7 = aeu.a(ri.a, $$5.c());
            Pair<ecm, dln.b> $$8 = $$1.a($$7, $$5.b(), $$6, $$5.c().d());
            if ($$8 != null) {
                return new afq.b<ecm>((ecm)$$8.getFirst(), ((dln.b)$$8.getSecond()).b());
            }
            if ($$2.has($$3)) {
                cpz $$9 = MinecraftServer.f;
                dlq $$10 = dlq.b;
                dln $$11 = duy.a($$5.c());
            } else {
                ajo $$12 = $$4.a();
                $$13 = new cpz($$12.m, $$12.l, $$12.u, $$12.k, false, new cpr(), $$5.b());
                $$14 = $$2.has($$52) ? $$12.Y.a(true) : $$12.Y;
                $$15 = $$12.a($$5.c());
            }
            dln.b $$16 = $$15.a($$6);
            Lifecycle $$17 = $$16.a().add($$5.c().d());
            return new afq.b<eck>(new eck($$13, $$14, $$16.d(), $$17), $$16.b());
        }, afr::new, ac.f(), $$6);
    }
}

