/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;

public record Advancement(Optional<ResourceLocation> f_138298_, Optional<DisplayInfo> f_138299_, AdvancementRewards f_138300_, Map<String, Criterion<?>> f_138302_, AdvancementRequirements f_138303_, boolean f_285575_, Optional<Component> f_291795_) {
    public Advancement(Optional<ResourceLocation> p_299284_, Optional<DisplayInfo> p_301017_, AdvancementRewards p_286389_, Map<String, Criterion<?>> p_286635_, AdvancementRequirements p_300504_, boolean p_286478_) {
        this(p_299284_, p_301017_, p_286389_, Map.copyOf(p_286635_), p_300504_, p_286478_, p_301017_.map(Advancement::m_294861_));
    }

    private static Component m_294861_(DisplayInfo p_300038_) {
        Component component = p_300038_.m_14977_();
        ChatFormatting chatformatting = p_300038_.m_14992_().m_15552_();
        MutableComponent component1 = ComponentUtils.m_130750_((MutableComponent)component.m_6881_(), (Style)Style.f_131099_.m_131140_(chatformatting)).m_130946_("\n").m_7220_(p_300038_.m_14985_());
        MutableComponent component2 = component.m_6881_().m_130938_(arg_0 -> Advancement.m_138314_((Component)component1, arg_0));
        return ComponentUtils.m_130748_((Component)component2).m_130940_(chatformatting);
    }

    public static Component m_292915_(AdvancementHolder p_297556_) {
        return p_297556_.f_290952_().f_291795_().orElseGet(() -> Component.m_237113_((String)p_297556_.f_291758_().toString()));
    }

    public JsonObject m_294498_() {
        JsonObject jsonobject = new JsonObject();
        this.f_138298_.ifPresent(p_296095_ -> jsonobject.addProperty("parent", p_296095_.toString()));
        this.f_138299_.ifPresent(p_296097_ -> jsonobject.add("display", p_296097_.m_14998_()));
        jsonobject.add("rewards", this.f_138300_.m_9997_());
        JsonObject jsonobject1 = new JsonObject();
        for (Map.Entry<String, Criterion<?>> entry : this.f_138302_.entrySet()) {
            jsonobject1.add(entry.getKey(), entry.getValue().m_11425_());
        }
        jsonobject.add("criteria", (JsonElement)jsonobject1);
        jsonobject.add("requirements", (JsonElement)this.f_138303_.m_292918_());
        jsonobject.addProperty("sends_telemetry_event", Boolean.valueOf(this.f_285575_));
        return jsonobject;
    }

    @Deprecated
    public static Advancement m_294730_(JsonObject p_300691_, DeserializationContext p_300053_) {
        return Advancement.fromJson(p_300691_, p_300053_, ICondition.IContext.EMPTY);
    }

    public static Advancement fromJson(JsonObject p_300691_, DeserializationContext p_300053_, ICondition.IContext context) {
        if ((p_300691_ = ForgeHooks.readConditionalAdvancement((ICondition.IContext)context, (JsonObject)p_300691_)) == null) {
            return null;
        }
        Optional<ResourceLocation> optional = p_300691_.has("parent") ? Optional.of(new ResourceLocation(GsonHelper.m_13906_((JsonObject)p_300691_, (String)"parent"))) : Optional.empty();
        Optional<DisplayInfo> optional1 = p_300691_.has("display") ? Optional.of(DisplayInfo.m_14981_((JsonObject)GsonHelper.m_13930_((JsonObject)p_300691_, (String)"display"))) : Optional.empty();
        AdvancementRewards advancementrewards = p_300691_.has("rewards") ? AdvancementRewards.m_9991_(GsonHelper.m_13930_((JsonObject)p_300691_, (String)"rewards")) : AdvancementRewards.f_9978_;
        Map map = Criterion.m_11426_((JsonObject)GsonHelper.m_13930_((JsonObject)p_300691_, (String)"criteria"), (DeserializationContext)p_300053_);
        if (map.isEmpty()) {
            throw new JsonSyntaxException("Advancement criteria cannot be empty");
        }
        JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)p_300691_, (String)"requirements", (JsonArray)new JsonArray());
        AdvancementRequirements advancementrequirements = jsonarray.isEmpty() ? AdvancementRequirements.m_295902_(map.keySet()) : AdvancementRequirements.m_293244_((JsonArray)jsonarray, map.keySet());
        boolean flag = GsonHelper.m_13855_((JsonObject)p_300691_, (String)"sends_telemetry_event", (boolean)false);
        return new Advancement(optional, optional1, advancementrewards, map, advancementrequirements, flag);
    }

    public void m_295649_(FriendlyByteBuf p_299393_) {
        p_299393_.m_236835_(this.f_138298_, FriendlyByteBuf::m_130085_);
        p_299393_.m_236835_(this.f_138299_, (p_296098_, p_296099_) -> p_296099_.m_14983_(p_296098_));
        this.f_138303_.m_292869_(p_299393_);
        p_299393_.writeBoolean(this.f_285575_);
    }

    public static Advancement m_293151_(FriendlyByteBuf p_300670_) {
        return new Advancement(p_300670_.m_236860_(FriendlyByteBuf::m_130281_), p_300670_.m_236860_(DisplayInfo::m_14988_), AdvancementRewards.f_9978_, Map.of(), new AdvancementRequirements(p_300670_), p_300670_.readBoolean());
    }

    public boolean m_295578_() {
        return this.f_138298_.isEmpty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this);
    }

    @Override
    public final boolean equals(Object p_138324_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this, p_138324_);
    }

    private static /* synthetic */ Style m_138314_(Component p_138315_, Style p_138316_) {
        return p_138316_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)p_138315_));
    }

    public static class Builder {
        private Optional<ResourceLocation> f_138333_ = Optional.empty();
        private Optional<DisplayInfo> f_138334_ = Optional.empty();
        private AdvancementRewards f_138335_ = AdvancementRewards.f_9978_;
        private final ImmutableMap.Builder<String, Criterion<?>> f_138336_ = ImmutableMap.builder();
        private Optional<AdvancementRequirements> f_138337_ = Optional.empty();
        private AdvancementRequirements.Strategy f_138338_ = AdvancementRequirements.Strategy.f_290313_;
        private boolean f_285655_;

        public static Builder m_138353_() {
            return new Builder().m_293041_();
        }

        public static Builder m_285878_() {
            return new Builder();
        }

        public Builder m_138398_(AdvancementHolder p_300513_) {
            this.f_138333_ = Optional.of(p_300513_.f_291758_());
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder m_138396_(ResourceLocation p_138397_) {
            this.f_138333_ = Optional.of(p_138397_);
            return this;
        }

        public Builder m_138362_(ItemStack p_138363_, Component p_138364_, Component p_138365_, @Nullable ResourceLocation p_138366_, FrameType p_138367_, boolean p_138368_, boolean p_138369_, boolean p_138370_) {
            return this.m_138358_(new DisplayInfo(p_138363_, p_138364_, p_138365_, p_138366_, p_138367_, p_138368_, p_138369_, p_138370_));
        }

        public Builder m_138371_(ItemLike p_138372_, Component p_138373_, Component p_138374_, @Nullable ResourceLocation p_138375_, FrameType p_138376_, boolean p_138377_, boolean p_138378_, boolean p_138379_) {
            return this.m_138358_(new DisplayInfo(new ItemStack(p_138372_.m_5456_()), p_138373_, p_138374_, p_138375_, p_138376_, p_138377_, p_138378_, p_138379_));
        }

        public Builder m_138358_(DisplayInfo p_138359_) {
            this.f_138334_ = Optional.of(p_138359_);
            return this;
        }

        public Builder m_138354_(AdvancementRewards.Builder p_138355_) {
            return this.m_138356_(p_138355_.m_10004_());
        }

        public Builder m_138356_(AdvancementRewards p_138357_) {
            this.f_138335_ = p_138357_;
            return this;
        }

        public Builder m_138383_(String p_138384_, Criterion<?> p_138385_) {
            this.f_138336_.put((Object)p_138384_, p_138385_);
            return this;
        }

        public Builder m_138360_(AdvancementRequirements.Strategy p_298091_) {
            this.f_138338_ = p_298091_;
            return this;
        }

        public Builder m_143951_(AdvancementRequirements p_300756_) {
            this.f_138337_ = Optional.of(p_300756_);
            return this;
        }

        public Builder m_293041_() {
            this.f_285655_ = true;
            return this;
        }

        public AdvancementHolder m_138403_(ResourceLocation p_138404_) {
            ImmutableMap map = this.f_138336_.buildOrThrow();
            AdvancementRequirements advancementrequirements = this.f_138337_.orElseGet(() -> this.m_291968_((Map)map));
            return new AdvancementHolder(p_138404_, new Advancement(this.f_138333_, this.f_138334_, this.f_138335_, (Map<String, Criterion<?>>)map, advancementrequirements, this.f_285655_));
        }

        public AdvancementHolder m_138389_(Consumer<AdvancementHolder> p_138390_, String p_138391_) {
            return this.save(p_138390_, new ResourceLocation(p_138391_));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> p_138390_, ResourceLocation id) {
            AdvancementHolder advancementholder = this.m_138403_(id);
            p_138390_.accept(advancementholder);
            return advancementholder;
        }

        private /* synthetic */ AdvancementRequirements m_291968_(Map p_296100_) {
            return this.f_138338_.m_294843_(p_296100_.keySet());
        }
    }
}

