/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.ForcedUsernameChangeException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientRegistryLayer;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.util.Crypt;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.ICustomPacket;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandshakePacketListenerImpl
implements ClientLoginPacketListener {
    private static final Logger f_104518_ = LogUtils.getLogger();
    private final Minecraft f_104519_;
    @Nullable
    private final ServerData f_243717_;
    @Nullable
    private final Screen f_104520_;
    private final Consumer<Component> f_104521_;
    private final Connection f_104522_;
    private final boolean f_260722_;
    @Nullable
    private final Duration f_260612_;
    @Nullable
    private String f_285614_;
    private final AtomicReference<State> f_301427_ = new AtomicReference<State>(State.CONNECTING);

    public ClientHandshakePacketListenerImpl(Connection p_261697_, Minecraft p_261835_, @Nullable ServerData p_261938_, @Nullable Screen p_261783_, boolean p_261562_, @Nullable Duration p_261673_, Consumer<Component> p_261945_) {
        this.f_104522_ = p_261697_;
        this.f_104519_ = p_261835_;
        this.f_243717_ = p_261938_;
        this.f_104520_ = p_261783_;
        this.f_104521_ = p_261945_;
        this.f_260722_ = p_261562_;
        this.f_260612_ = p_261673_;
    }

    private void m_301503_(State p_301608_) {
        State clienthandshakepacketlistenerimpl$state = this.f_301427_.updateAndGet(p_301527_ -> {
            if (!p_301526_.f_301420_.contains(p_301527_)) {
                throw new IllegalStateException("Tried to switch to " + p_301608_ + " from " + p_301527_ + ", but expected one of " + p_301526_.f_301420_);
            }
            return p_301608_;
        });
        this.f_104521_.accept(clienthandshakepacketlistenerimpl$state.f_301424_);
    }

    public void m_7318_(ClientboundHelloPacket p_104549_) {
        ServerboundKeyPacket serverboundkeypacket;
        Cipher cipher1;
        Cipher cipher;
        String s;
        this.m_301503_(State.AUTHORIZING);
        try {
            SecretKey secretkey = Crypt.m_13578_();
            PublicKey publickey = p_104549_.m_134794_();
            s = new BigInteger(Crypt.m_13590_((String)p_104549_.m_134791_(), (PublicKey)publickey, (SecretKey)secretkey)).toString(16);
            cipher = Crypt.m_13583_((int)2, (Key)secretkey);
            cipher1 = Crypt.m_13583_((int)1, (Key)secretkey);
            byte[] abyte = p_104549_.m_252784_();
            serverboundkeypacket = new ServerboundKeyPacket(secretkey, publickey, abyte);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Protocol error", exception);
        }
        HttpUtil.f_13936_.submit(() -> {
            Component component = this.m_104531_(s);
            if (component != null) {
                if (this.f_243717_ == null || !this.f_243717_.m_105389_()) {
                    this.f_104522_.m_129507_(component);
                    return;
                }
                f_104518_.warn(component.getString());
            }
            this.m_301503_(State.ENCRYPTING);
            this.f_104522_.m_243124_((Packet<?>)serverboundkeypacket, PacketSendListener.m_243092_(() -> this.f_104522_.m_129495_(cipher, cipher1)));
        });
    }

    @Nullable
    private Component m_104531_(String p_104532_) {
        try {
            this.m_104554_().joinServer(this.f_104519_.m_91094_().m_240411_(), this.f_104519_.m_91094_().m_92547_(), p_104532_);
            return null;
        }
        catch (AuthenticationUnavailableException authenticationunavailableexception) {
            return Component.m_237110_((String)"disconnect.loginFailedInfo", (Object[])new Object[]{Component.m_237115_((String)"disconnect.loginFailedInfo.serversUnavailable")});
        }
        catch (InvalidCredentialsException invalidcredentialsexception) {
            return Component.m_237110_((String)"disconnect.loginFailedInfo", (Object[])new Object[]{Component.m_237115_((String)"disconnect.loginFailedInfo.invalidSession")});
        }
        catch (InsufficientPrivilegesException insufficientprivilegesexception) {
            return Component.m_237110_((String)"disconnect.loginFailedInfo", (Object[])new Object[]{Component.m_237115_((String)"disconnect.loginFailedInfo.insufficientPrivileges")});
        }
        catch (ForcedUsernameChangeException | UserBannedException userbannedexception) {
            return Component.m_237110_((String)"disconnect.loginFailedInfo", (Object[])new Object[]{Component.m_237115_((String)"disconnect.loginFailedInfo.userBanned")});
        }
        catch (AuthenticationException authenticationexception) {
            return Component.m_237110_((String)"disconnect.loginFailedInfo", (Object[])new Object[]{authenticationexception.getMessage()});
        }
    }

    private MinecraftSessionService m_104554_() {
        return this.f_104519_.m_91108_();
    }

    public void m_7056_(ClientboundGameProfilePacket p_104547_) {
        this.m_301503_(State.JOINING);
        GameProfile gameprofile = p_104547_.m_134774_();
        this.f_104522_.m_129512_((Packet<?>)new ServerboundLoginAcknowledgedPacket());
        this.f_104522_.m_129505_((PacketListener)new ClientConfigurationPacketListenerImpl(this.f_104519_, this.f_104522_, new CommonListenerCookie(gameprofile, this.f_104519_.m_261007_().m_285995_(this.f_260722_, this.f_260612_, this.f_285614_), ClientRegistryLayer.m_245874_().m_247579_(), FeatureFlags.f_244332_, (String)null, this.f_243717_, this.f_104520_)));
        this.f_104522_.m_129512_(new ServerboundCustomPayloadPacket((CustomPacketPayload)new BrandPayload(ClientBrandRetriever.getClientModName())));
        this.f_104522_.m_129512_((Packet<?>)new ServerboundClientInformationPacket(this.f_104519_.f_91066_.m_294596_()));
    }

    public void m_7026_(Component p_104543_) {
        if (this.f_243717_ != null && this.f_243717_.m_295074_()) {
            this.f_104519_.m_91152_((Screen)new DisconnectedRealmsScreen(this.f_104520_, CommonComponents.f_130661_, p_104543_));
        } else if (!ForgeHooksClient.onClientDisconnect((Connection)this.f_104522_, (Minecraft)this.f_104519_, (Screen)this.f_104520_, (Component)p_104543_)) {
            this.f_104519_.m_91152_((Screen)new DisconnectedScreen(this.f_104520_, CommonComponents.f_130661_, p_104543_));
        }
    }

    public boolean m_6198_() {
        return this.f_104522_.m_129536_();
    }

    public void m_5800_(ClientboundLoginDisconnectPacket p_104553_) {
        this.f_104522_.m_129507_(p_104553_.m_134819_());
    }

    public void m_5693_(ClientboundLoginCompressionPacket p_104551_) {
        if (!this.f_104522_.m_129531_()) {
            this.f_104522_.m_129484_(p_104551_.m_134806_(), false);
        }
    }

    public void m_7254_(ClientboundCustomQueryPacket p_104545_) {
        if (ForgeHooks.onCustomPayload((ICustomPacket)p_104545_, (Connection)this.f_104522_)) {
            return;
        }
        this.f_104521_.accept((Component)Component.m_237115_((String)"connect.negotiating"));
        this.f_104522_.m_129512_(new ServerboundCustomQueryAnswerPacket(p_104545_.f_134745_(), null));
    }

    public void m_285854_(String p_286653_) {
        this.f_285614_ = p_286653_;
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class State
    extends Enum<State> {
        public static final /* enum */ State CONNECTING = new State((Component)Component.m_237115_((String)"connect.connecting"), Set.of());
        public static final /* enum */ State AUTHORIZING = new State((Component)Component.m_237115_((String)"connect.authorizing"), Set.of(CONNECTING));
        public static final /* enum */ State ENCRYPTING = new State((Component)Component.m_237115_((String)"connect.encrypting"), Set.of(AUTHORIZING));
        public static final /* enum */ State JOINING = new State((Component)Component.m_237115_((String)"connect.joining"), Set.of(ENCRYPTING, CONNECTING));
        final Component f_301424_;
        final Set<State> f_301420_;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_301610_) {
            return Enum.valueOf(State.class, p_301610_);
        }

        private State(Component p_301605_, Set<State> p_301615_) {
            this.f_301424_ = p_301605_;
            this.f_301420_ = p_301615_;
        }

        private static /* synthetic */ State[] m_301492_() {
            return new State[]{CONNECTING, AUTHORIZING, ENCRYPTING, JOINING};
        }

        static {
            $VALUES = State.m_301492_();
        }
    }
}

