/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LootPool {
    public static final Codec<LootPool> f_290497_ = RecordCodecBuilder.create(p_297005_ -> p_297005_.group((App)LootPoolEntries.f_291877_.listOf().fieldOf("entries").forGetter(p_297007_ -> p_297007_.f_79023_), (App)ExtraCodecs.m_295827_((Codec)LootItemConditions.f_290534_.listOf(), (String)"conditions", List.of()).forGetter(p_297008_ -> p_297008_.f_79024_), (App)ExtraCodecs.m_295827_((Codec)LootItemFunctions.f_291699_.listOf(), (String)"functions", List.of()).forGetter(p_297009_ -> p_297009_.f_79026_), (App)NumberProviders.f_291751_.fieldOf("rolls").forGetter(p_297004_ -> p_297004_.f_79028_), (App)NumberProviders.f_291751_.fieldOf("bonus_rolls").orElse((Object)ConstantValue.m_165692_((float)0.0f)).forGetter(p_297006_ -> p_297006_.f_79029_), (App)Codec.STRING.optionalFieldOf("name").forGetter(p -> p.name.filter(n -> !n.startsWith("custom#"))), (App)ICondition.OPTIONAL_FEILD_CODEC.forGetter(p -> p.forge_condition)).apply((Applicative)p_297005_, LootPool::new));
    public static final Codec<LootPool> CONDITIONAL_CODEC = ConditionCodec.checkingDecode(f_290497_, () -> LootPool.m_79043_().m_79082_());
    private final List<LootPoolEntryContainer> f_79023_;
    private final List<LootItemCondition> f_79024_;
    private final Predicate<LootContext> f_79025_;
    private final List<LootItemFunction> f_79026_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79027_;
    private NumberProvider f_79028_;
    private NumberProvider f_79029_;
    private Optional<String> name;
    private Optional<ICondition> forge_condition;
    private boolean isFrozen = false;

    LootPool(List<LootPoolEntryContainer> p_298341_, List<LootItemCondition> p_297697_, List<LootItemFunction> p_299722_, NumberProvider p_165131_, NumberProvider p_165132_) {
        this(p_298341_, p_297697_, p_299722_, p_165131_, p_165132_, Optional.empty(), Optional.empty());
    }

    LootPool(List<LootPoolEntryContainer> p_298341_, List<LootItemCondition> p_297697_, List<LootItemFunction> p_299722_, NumberProvider p_165131_, NumberProvider p_165132_, Optional<String> name, Optional<ICondition> forge_conditions) {
        this.f_79023_ = p_298341_;
        this.f_79024_ = p_297697_;
        this.f_79025_ = LootItemConditions.m_81834_(p_297697_);
        this.f_79026_ = p_299722_;
        this.f_79027_ = LootItemFunctions.m_80770_(p_299722_);
        this.f_79028_ = p_165131_;
        this.f_79029_ = p_165132_;
        this.name = name;
        this.forge_condition = forge_conditions;
    }

    private void m_79058_(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        RandomSource randomsource = p_79060_.m_230907_();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        for (LootPoolEntryContainer lootpoolentrycontainer : this.f_79023_) {
            lootpoolentrycontainer.m_6562_(p_79060_, p_79048_ -> {
                int k = p_79048_.m_7067_(p_79060_.m_78945_());
                if (k > 0) {
                    list.add(p_79048_);
                    mutableint.add(k);
                }
            });
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((LootPoolEntry)list.get(0)).m_6941_(p_79059_, p_79060_);
            } else {
                int j = randomsource.m_188503_(mutableint.intValue());
                for (LootPoolEntry lootpoolentry : list) {
                    if ((j -= lootpoolentry.m_7067_(p_79060_.m_78945_())) >= 0) continue;
                    lootpoolentry.m_6941_(p_79059_, p_79060_);
                    return;
                }
            }
        }
    }

    public void m_79053_(Consumer<ItemStack> p_79054_, LootContext p_79055_) {
        if (this.f_79025_.test(p_79055_)) {
            Consumer consumer = LootItemFunction.m_80724_(this.f_79027_, p_79054_, (LootContext)p_79055_);
            int i = this.f_79028_.m_142683_(p_79055_) + Mth.m_14143_((float)(this.f_79029_.m_142688_(p_79055_) * p_79055_.m_78945_()));
            for (int j = 0; j < i; ++j) {
                this.m_79058_(consumer, p_79055_);
            }
        }
    }

    public void m_79051_(ValidationContext p_79052_) {
        for (int i = 0; i < this.f_79024_.size(); ++i) {
            this.f_79024_.get(i).m_6169_(p_79052_.m_79365_(".condition[" + i + "]"));
        }
        for (int j = 0; j < this.f_79026_.size(); ++j) {
            this.f_79026_.get(j).m_6169_(p_79052_.m_79365_(".functions[" + j + "]"));
        }
        for (int k = 0; k < this.f_79023_.size(); ++k) {
            this.f_79023_.get(k).m_6165_(p_79052_.m_79365_(".entries[" + k + "]"));
        }
        this.f_79028_.m_6169_(p_79052_.m_79365_(".rolls"));
        this.f_79029_.m_6169_(p_79052_.m_79365_(".bonusRolls"));
    }

    public static Builder m_79043_() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    @Nullable
    public String getName() {
        return this.name.orElse(null);
    }

    void setName(String name) {
        if (this.name.isPresent()) {
            throw new UnsupportedOperationException("Cannot change the name of a pool when it has a name set!");
        }
        this.name = Optional.of(name);
    }

    public NumberProvider getRolls() {
        return this.f_79028_;
    }

    public NumberProvider getBonusRolls() {
        return this.f_79029_;
    }

    public void setRolls(NumberProvider v) {
        this.checkFrozen();
        this.f_79028_ = v;
    }

    public void setBonusRolls(NumberProvider v) {
        this.checkFrozen();
        this.f_79029_ = v;
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> f_79067_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> f_79068_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> f_79069_ = ImmutableList.builder();
        private NumberProvider f_79070_ = ConstantValue.m_165692_((float)1.0f);
        private NumberProvider f_79071_ = ConstantValue.m_165692_((float)0.0f);
        @Nullable
        private String name;
        @Nullable
        private ICondition forge_condition;

        public Builder m_165133_(NumberProvider p_165134_) {
            this.f_79070_ = p_165134_;
            return this;
        }

        public Builder m_79073_() {
            return this;
        }

        public Builder m_165135_(NumberProvider p_165136_) {
            this.f_79071_ = p_165136_;
            return this;
        }

        public Builder m_79076_(LootPoolEntryContainer.Builder<?> p_79077_) {
            this.f_79067_.add((Object)p_79077_.m_7512_());
            return this;
        }

        public Builder m_79080_(LootItemCondition.Builder p_79081_) {
            this.f_79068_.add((Object)p_79081_.m_6409_());
            return this;
        }

        public Builder m_79078_(LootItemFunction.Builder p_79079_) {
            this.f_79069_.add((Object)p_79079_.m_7453_());
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder when(ICondition value) {
            this.forge_condition = value;
            return this;
        }

        public LootPool m_79082_() {
            return new LootPool((List<LootPoolEntryContainer>)this.f_79067_.build(), (List<LootItemCondition>)this.f_79068_.build(), (List<LootItemFunction>)this.f_79069_.build(), this.f_79070_, this.f_79071_, Optional.ofNullable(this.name), Optional.ofNullable(this.forge_condition));
        }
    }
}

