/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformerAuditTrail;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.util.List;

public class TransformingClassLoader
extends ModuleClassLoader {
    private final ClassTransformer classTransformer;

    private static ModuleLayer get(ModuleLayerHandler layers, IModuleLayerManager.Layer layer) {
        return layers.getLayer(layer).orElseThrow(() -> new NullPointerException("Failed to find " + layer.name() + " layer"));
    }

    public TransformingClassLoader(TransformStore transformStore, LaunchPluginHandler pluginHandler, ModuleLayerHandler layers) {
        super("TRANSFORMER", TransformingClassLoader.get(layers, IModuleLayerManager.Layer.GAME).configuration(), List.of(TransformingClassLoader.get(layers, IModuleLayerManager.Layer.SERVICE)));
        this.classTransformer = new ClassTransformer(transformStore, pluginHandler, this);
    }

    TransformingClassLoader(String name, ClassLoader parent, Configuration config, List<ModuleLayer> parentLayers, List<ClassLoader> parentLoaders, TransformStore transformStore, LaunchPluginHandler pluginHandler, Environment environment) {
        super(name, parent, config, parentLayers, parentLoaders, true);
        TransformerAuditTrail tat = new TransformerAuditTrail();
        environment.computePropertyIfAbsent(IEnvironment.Keys.AUDITTRAIL.get(), v -> tat);
        this.classTransformer = new ClassTransformer(transformStore, pluginHandler, this, tat);
    }

    protected byte[] maybeTransformClassBytes(byte[] bytes, String name, String context) {
        return this.classTransformer.transform(bytes, name, context != null ? context : "classloading");
    }

    public Class<?> getLoadedClass(String name) {
        return this.findLoadedClass(name);
    }

    byte[] buildTransformedClassNodeFor(String className, String reason) throws ClassNotFoundException {
        return super.getMaybeTransformedClassBytes(className, reason);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

