/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record AdvancementRewards(int experience, List<ResourceKey<LootTable>> loot, List<ResourceLocation> recipes, Optional<CacheableFunction> function) {
    public static final Codec<AdvancementRewards> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.INT.optionalFieldOf("experience", (Object)0).forGetter(AdvancementRewards::experience), (App)ResourceKey.codec(Registries.LOOT_TABLE).listOf().optionalFieldOf("loot", List.of()).forGetter(AdvancementRewards::loot), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("recipes", List.of()).forGetter(AdvancementRewards::recipes), (App)CacheableFunction.CODEC.optionalFieldOf("function").forGetter(AdvancementRewards::function)).apply((Applicative)$$0, AdvancementRewards::new));
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, List.of(), List.of(), Optional.empty());

    public void grant(ServerPlayer $$0) {
        $$0.giveExperiencePoints(this.experience);
        LootParams $$12 = new LootParams.Builder($$0.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, $$0).withParameter(LootContextParams.ORIGIN, $$0.position()).create(LootContextParamSets.ADVANCEMENT_REWARD);
        boolean $$22 = false;
        for (ResourceKey<LootTable> $$3 : this.loot) {
            for (ItemStack $$4 : $$0.server.reloadableRegistries().getLootTable($$3).getRandomItems($$12)) {
                if ($$0.addItem($$4)) {
                    $$0.level().playSound(null, $$0.getX(), $$0.getY(), $$0.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (($$0.getRandom().nextFloat() - $$0.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    $$22 = true;
                    continue;
                }
                ItemEntity $$5 = $$0.drop($$4, false);
                if ($$5 == null) continue;
                $$5.setNoPickUpDelay();
                $$5.setTarget($$0.getUUID());
            }
        }
        if ($$22) {
            $$0.containerMenu.broadcastChanges();
        }
        if (!this.recipes.isEmpty()) {
            $$0.awardRecipesByKey(this.recipes);
        }
        MinecraftServer $$6 = $$0.server;
        this.function.flatMap($$1 -> $$1.get($$6.getFunctions())).ifPresent($$2 -> $$6.getFunctions().execute((CommandFunction<CommandSourceStack>)$$2, $$0.createCommandSourceStack().withSuppressedOutput().withPermission(2)));
    }

    public static class Builder {
        private int experience;
        private final ImmutableList.Builder<ResourceKey<LootTable>> loot = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceLocation> recipes = ImmutableList.builder();
        private Optional<ResourceLocation> function = Optional.empty();

        public static Builder experience(int $$0) {
            return new Builder().addExperience($$0);
        }

        public Builder addExperience(int $$0) {
            this.experience += $$0;
            return this;
        }

        public static Builder loot(ResourceKey<LootTable> $$0) {
            return new Builder().addLootTable($$0);
        }

        public Builder addLootTable(ResourceKey<LootTable> $$0) {
            this.loot.add($$0);
            return this;
        }

        public static Builder recipe(ResourceLocation $$0) {
            return new Builder().addRecipe($$0);
        }

        public Builder addRecipe(ResourceLocation $$0) {
            this.recipes.add((Object)$$0);
            return this;
        }

        public static Builder function(ResourceLocation $$0) {
            return new Builder().runs($$0);
        }

        public Builder runs(ResourceLocation $$0) {
            this.function = Optional.of($$0);
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, (List<ResourceKey<LootTable>>)this.loot.build(), (List<ResourceLocation>)this.recipes.build(), this.function.map(CacheableFunction::new));
        }
    }
}

