/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record EntityFlagsPredicate(Optional<Boolean> isOnFire, Optional<Boolean> isCrouching, Optional<Boolean> isSprinting, Optional<Boolean> isSwimming, Optional<Boolean> isBaby) {
    public static final Codec<EntityFlagsPredicate> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.BOOL.optionalFieldOf("is_on_fire").forGetter(EntityFlagsPredicate::isOnFire), (App)Codec.BOOL.optionalFieldOf("is_sneaking").forGetter(EntityFlagsPredicate::isCrouching), (App)Codec.BOOL.optionalFieldOf("is_sprinting").forGetter(EntityFlagsPredicate::isSprinting), (App)Codec.BOOL.optionalFieldOf("is_swimming").forGetter(EntityFlagsPredicate::isSwimming), (App)Codec.BOOL.optionalFieldOf("is_baby").forGetter(EntityFlagsPredicate::isBaby)).apply((Applicative)$$0, EntityFlagsPredicate::new));

    public boolean matches(Entity $$0) {
        LivingEntity $$1;
        if (this.isOnFire.isPresent() && $$0.isOnFire() != this.isOnFire.get().booleanValue()) {
            return false;
        }
        if (this.isCrouching.isPresent() && $$0.isCrouching() != this.isCrouching.get().booleanValue()) {
            return false;
        }
        if (this.isSprinting.isPresent() && $$0.isSprinting() != this.isSprinting.get().booleanValue()) {
            return false;
        }
        if (this.isSwimming.isPresent() && $$0.isSwimming() != this.isSwimming.get().booleanValue()) {
            return false;
        }
        return !this.isBaby.isPresent() || !($$0 instanceof LivingEntity) || ($$1 = (LivingEntity)$$0).isBaby() == this.isBaby.get().booleanValue();
    }

    public static class Builder {
        private Optional<Boolean> isOnFire = Optional.empty();
        private Optional<Boolean> isCrouching = Optional.empty();
        private Optional<Boolean> isSprinting = Optional.empty();
        private Optional<Boolean> isSwimming = Optional.empty();
        private Optional<Boolean> isBaby = Optional.empty();

        public static Builder flags() {
            return new Builder();
        }

        public Builder setOnFire(Boolean $$0) {
            this.isOnFire = Optional.of($$0);
            return this;
        }

        public Builder setCrouching(Boolean $$0) {
            this.isCrouching = Optional.of($$0);
            return this;
        }

        public Builder setSprinting(Boolean $$0) {
            this.isSprinting = Optional.of($$0);
            return this;
        }

        public Builder setSwimming(Boolean $$0) {
            this.isSwimming = Optional.of($$0);
            return this;
        }

        public Builder setIsBaby(Boolean $$0) {
            this.isBaby = Optional.of($$0);
            return this;
        }

        public EntityFlagsPredicate build() {
            return new EntityFlagsPredicate(this.isOnFire, this.isCrouching, this.isSprinting, this.isSwimming, this.isBaby);
        }
    }
}

