/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SlotsPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public record EntityPredicate(Optional<EntityTypePredicate> entityType, Optional<DistancePredicate> distanceToPlayer, Optional<LocationPredicate> location, Optional<LocationPredicate> steppingOnLocation, Optional<MobEffectsPredicate> effects, Optional<NbtPredicate> nbt, Optional<EntityFlagsPredicate> flags, Optional<EntityEquipmentPredicate> equipment, Optional<EntitySubPredicate> subPredicate, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger, Optional<EntityPredicate> targetedEntity, Optional<String> team, Optional<SlotsPredicate> slots) {
    public static final Codec<EntityPredicate> CODEC = Codec.recursive((String)"EntityPredicate", $$0 -> RecordCodecBuilder.create($$1 -> $$1.group((App)EntityTypePredicate.CODEC.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(EntityPredicate::distanceToPlayer), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(EntityPredicate::location), (App)LocationPredicate.CODEC.optionalFieldOf("stepping_on").forGetter(EntityPredicate::steppingOnLocation), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(EntityPredicate::nbt), (App)EntityFlagsPredicate.CODEC.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)EntityEquipmentPredicate.CODEC.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)EntitySubPredicate.CODEC.optionalFieldOf("type_specific").forGetter(EntityPredicate::subPredicate), (App)$$0.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)$$0.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger), (App)$$0.optionalFieldOf("targeted_entity").forGetter(EntityPredicate::targetedEntity), (App)Codec.STRING.optionalFieldOf("team").forGetter(EntityPredicate::team), (App)SlotsPredicate.CODEC.optionalFieldOf("slots").forGetter(EntityPredicate::slots)).apply((Applicative)$$1, EntityPredicate::new)));
    public static final Codec<ContextAwarePredicate> ADVANCEMENT_CODEC = Codec.withAlternative(ContextAwarePredicate.CODEC, CODEC, EntityPredicate::wrap);

    public static ContextAwarePredicate wrap(Builder $$0) {
        return EntityPredicate.wrap($$0.build());
    }

    public static Optional<ContextAwarePredicate> wrap(Optional<EntityPredicate> $$0) {
        return $$0.map(EntityPredicate::wrap);
    }

    public static List<ContextAwarePredicate> wrap(Builder ... $$0) {
        return Stream.of($$0).map(EntityPredicate::wrap).toList();
    }

    public static ContextAwarePredicate wrap(EntityPredicate $$0) {
        LootItemCondition $$1 = LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.THIS, $$0).build();
        return new ContextAwarePredicate(List.of($$1));
    }

    public boolean matches(ServerPlayer $$0, @Nullable Entity $$1) {
        return this.matches($$0.serverLevel(), $$0.position(), $$1);
    }

    public boolean matches(ServerLevel $$0, @Nullable Vec3 $$1, @Nullable Entity $$22) {
        PlayerTeam $$4;
        if ($$22 == null) {
            return false;
        }
        if (this.entityType.isPresent() && !this.entityType.get().matches($$22.getType())) {
            return false;
        }
        if ($$1 == null ? this.distanceToPlayer.isPresent() : this.distanceToPlayer.isPresent() && !this.distanceToPlayer.get().matches($$1.x, $$1.y, $$1.z, $$22.getX(), $$22.getY(), $$22.getZ())) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().matches($$0, $$22.getX(), $$22.getY(), $$22.getZ())) {
            return false;
        }
        if (this.steppingOnLocation.isPresent()) {
            Vec3 $$3 = Vec3.atCenterOf($$22.getOnPos());
            if (!this.steppingOnLocation.get().matches($$0, $$3.x(), $$3.y(), $$3.z())) {
                return false;
            }
        }
        if (this.effects.isPresent() && !this.effects.get().matches($$22)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches($$22)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().matches($$22)) {
            return false;
        }
        if (this.subPredicate.isPresent() && !this.subPredicate.get().matches($$22, $$0, $$1)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().matches($$0, $$1, $$22.getVehicle())) {
            return false;
        }
        if (this.passenger.isPresent() && $$22.getPassengers().stream().noneMatch($$2 -> this.passenger.get().matches($$0, $$1, (Entity)$$2))) {
            return false;
        }
        if (this.targetedEntity.isPresent() && !this.targetedEntity.get().matches($$0, $$1, $$22 instanceof Mob ? ((Mob)$$22).getTarget() : null)) {
            return false;
        }
        if (this.team.isPresent() && (($$4 = $$22.getTeam()) == null || !this.team.get().equals(((Team)$$4).getName()))) {
            return false;
        }
        if (this.slots.isPresent() && !this.slots.get().matches($$22)) {
            return false;
        }
        return !this.nbt.isPresent() || this.nbt.get().matches($$22);
    }

    public static LootContext createContext(ServerPlayer $$0, Entity $$1) {
        LootParams $$2 = new LootParams.Builder($$0.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, $$1).withParameter(LootContextParams.ORIGIN, $$0.position()).create(LootContextParamSets.ADVANCEMENT_ENTITY);
        return new LootContext.Builder($$2).create(Optional.empty());
    }

    public static class Builder {
        private Optional<EntityTypePredicate> entityType = Optional.empty();
        private Optional<DistancePredicate> distanceToPlayer = Optional.empty();
        private Optional<LocationPredicate> location = Optional.empty();
        private Optional<LocationPredicate> steppingOnLocation = Optional.empty();
        private Optional<MobEffectsPredicate> effects = Optional.empty();
        private Optional<NbtPredicate> nbt = Optional.empty();
        private Optional<EntityFlagsPredicate> flags = Optional.empty();
        private Optional<EntityEquipmentPredicate> equipment = Optional.empty();
        private Optional<EntitySubPredicate> subPredicate = Optional.empty();
        private Optional<EntityPredicate> vehicle = Optional.empty();
        private Optional<EntityPredicate> passenger = Optional.empty();
        private Optional<EntityPredicate> targetedEntity = Optional.empty();
        private Optional<String> team = Optional.empty();
        private Optional<SlotsPredicate> slots = Optional.empty();

        public static Builder entity() {
            return new Builder();
        }

        public Builder of(EntityType<?> $$0) {
            this.entityType = Optional.of(EntityTypePredicate.of($$0));
            return this;
        }

        public Builder of(TagKey<EntityType<?>> $$0) {
            this.entityType = Optional.of(EntityTypePredicate.of($$0));
            return this;
        }

        public Builder entityType(EntityTypePredicate $$0) {
            this.entityType = Optional.of($$0);
            return this;
        }

        public Builder distance(DistancePredicate $$0) {
            this.distanceToPlayer = Optional.of($$0);
            return this;
        }

        public Builder located(LocationPredicate.Builder $$0) {
            this.location = Optional.of($$0.build());
            return this;
        }

        public Builder steppingOn(LocationPredicate.Builder $$0) {
            this.steppingOnLocation = Optional.of($$0.build());
            return this;
        }

        public Builder effects(MobEffectsPredicate.Builder $$0) {
            this.effects = $$0.build();
            return this;
        }

        public Builder nbt(NbtPredicate $$0) {
            this.nbt = Optional.of($$0);
            return this;
        }

        public Builder flags(EntityFlagsPredicate.Builder $$0) {
            this.flags = Optional.of($$0.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate.Builder $$0) {
            this.equipment = Optional.of($$0.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate $$0) {
            this.equipment = Optional.of($$0);
            return this;
        }

        public Builder subPredicate(EntitySubPredicate $$0) {
            this.subPredicate = Optional.of($$0);
            return this;
        }

        public Builder vehicle(Builder $$0) {
            this.vehicle = Optional.of($$0.build());
            return this;
        }

        public Builder passenger(Builder $$0) {
            this.passenger = Optional.of($$0.build());
            return this;
        }

        public Builder targetedEntity(Builder $$0) {
            this.targetedEntity = Optional.of($$0.build());
            return this;
        }

        public Builder team(String $$0) {
            this.team = Optional.of($$0);
            return this;
        }

        public Builder slots(SlotsPredicate $$0) {
            this.slots = Optional.of($$0);
            return this;
        }

        public EntityPredicate build() {
            return new EntityPredicate(this.entityType, this.distanceToPlayer, this.location, this.steppingOnLocation, this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.vehicle, this.passenger, this.targetedEntity, this.team, this.slots);
        }
    }
}

