/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class ResourceLocationArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ADVANCEMENT = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("advancement.advancementNotFound", $$0));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_RECIPE = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("recipe.notFound", $$0));

    public static ResourceLocationArgument id() {
        return new ResourceLocationArgument();
    }

    public static AdvancementHolder getAdvancement(CommandContext<CommandSourceStack> $$0, String $$1) throws CommandSyntaxException {
        ResourceLocation $$2 = ResourceLocationArgument.getId($$0, $$1);
        AdvancementHolder $$3 = ((CommandSourceStack)$$0.getSource()).getServer().getAdvancements().get($$2);
        if ($$3 == null) {
            throw ERROR_UNKNOWN_ADVANCEMENT.create((Object)$$2);
        }
        return $$3;
    }

    public static RecipeHolder<?> getRecipe(CommandContext<CommandSourceStack> $$0, String $$1) throws CommandSyntaxException {
        RecipeManager $$2 = ((CommandSourceStack)$$0.getSource()).getServer().getRecipeManager();
        ResourceLocation $$3 = ResourceLocationArgument.getId($$0, $$1);
        return $$2.byKey($$3).orElseThrow(() -> ERROR_UNKNOWN_RECIPE.create((Object)$$3));
    }

    public static ResourceLocation getId(CommandContext<CommandSourceStack> $$0, String $$1) {
        return (ResourceLocation)$$0.getArgument($$1, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader $$0) throws CommandSyntaxException {
        return ResourceLocation.read($$0);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

