/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.EncoderCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;

public class DataComponents {
    static final EncoderCache ENCODER_CACHE = new EncoderCache(512);
    public static final DataComponentType<CustomData> CUSTOM_DATA = DataComponents.register("custom_data", $$0 -> $$0.persistent(CustomData.CODEC));
    public static final DataComponentType<Integer> MAX_STACK_SIZE = DataComponents.register("max_stack_size", $$0 -> $$0.persistent(ExtraCodecs.intRange(1, 99)).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MAX_DAMAGE = DataComponents.register("max_damage", $$0 -> $$0.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> DAMAGE = DataComponents.register("damage", $$0 -> $$0.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unbreakable> UNBREAKABLE = DataComponents.register("unbreakable", $$0 -> $$0.persistent(Unbreakable.CODEC).networkSynchronized(Unbreakable.STREAM_CODEC));
    public static final DataComponentType<Component> CUSTOM_NAME = DataComponents.register("custom_name", $$0 -> $$0.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Component> ITEM_NAME = DataComponents.register("item_name", $$0 -> $$0.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemLore> LORE = DataComponents.register("lore", $$0 -> $$0.persistent(ItemLore.CODEC).networkSynchronized(ItemLore.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Rarity> RARITY = DataComponents.register("rarity", $$0 -> $$0.persistent(Rarity.CODEC).networkSynchronized(Rarity.STREAM_CODEC));
    public static final DataComponentType<ItemEnchantments> ENCHANTMENTS = DataComponents.register("enchantments", $$0 -> $$0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_PLACE_ON = DataComponents.register("can_place_on", $$0 -> $$0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_BREAK = DataComponents.register("can_break", $$0 -> $$0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = DataComponents.register("attribute_modifiers", $$0 -> $$0.persistent(ItemAttributeModifiers.CODEC).networkSynchronized(ItemAttributeModifiers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<CustomModelData> CUSTOM_MODEL_DATA = DataComponents.register("custom_model_data", $$0 -> $$0.persistent(CustomModelData.CODEC).networkSynchronized(CustomModelData.STREAM_CODEC));
    public static final DataComponentType<Unit> HIDE_ADDITIONAL_TOOLTIP = DataComponents.register("hide_additional_tooltip", $$0 -> $$0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Unit> HIDE_TOOLTIP = DataComponents.register("hide_tooltip", $$0 -> $$0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Integer> REPAIR_COST = DataComponents.register("repair_cost", $$0 -> $$0.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unit> CREATIVE_SLOT_LOCK = DataComponents.register("creative_slot_lock", $$0 -> $$0.networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = DataComponents.register("enchantment_glint_override", $$0 -> $$0.persistent(Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<Unit> INTANGIBLE_PROJECTILE = DataComponents.register("intangible_projectile", $$0 -> $$0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))));
    public static final DataComponentType<FoodProperties> FOOD = DataComponents.register("food", $$0 -> $$0.persistent(FoodProperties.DIRECT_CODEC).networkSynchronized(FoodProperties.DIRECT_STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Unit> FIRE_RESISTANT = DataComponents.register("fire_resistant", $$0 -> $$0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Tool> TOOL = DataComponents.register("tool", $$0 -> $$0.persistent(Tool.CODEC).networkSynchronized(Tool.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemEnchantments> STORED_ENCHANTMENTS = DataComponents.register("stored_enchantments", $$0 -> $$0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DyedItemColor> DYED_COLOR = DataComponents.register("dyed_color", $$0 -> $$0.persistent(DyedItemColor.CODEC).networkSynchronized(DyedItemColor.STREAM_CODEC));
    public static final DataComponentType<MapItemColor> MAP_COLOR = DataComponents.register("map_color", $$0 -> $$0.persistent(MapItemColor.CODEC).networkSynchronized(MapItemColor.STREAM_CODEC));
    public static final DataComponentType<MapId> MAP_ID = DataComponents.register("map_id", $$0 -> $$0.persistent(MapId.CODEC).networkSynchronized(MapId.STREAM_CODEC));
    public static final DataComponentType<MapDecorations> MAP_DECORATIONS = DataComponents.register("map_decorations", $$0 -> $$0.persistent(MapDecorations.CODEC).cacheEncoding());
    public static final DataComponentType<MapPostProcessing> MAP_POST_PROCESSING = DataComponents.register("map_post_processing", $$0 -> $$0.networkSynchronized(MapPostProcessing.STREAM_CODEC));
    public static final DataComponentType<ChargedProjectiles> CHARGED_PROJECTILES = DataComponents.register("charged_projectiles", $$0 -> $$0.persistent(ChargedProjectiles.CODEC).networkSynchronized(ChargedProjectiles.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BundleContents> BUNDLE_CONTENTS = DataComponents.register("bundle_contents", $$0 -> $$0.persistent(BundleContents.CODEC).networkSynchronized(BundleContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<PotionContents> POTION_CONTENTS = DataComponents.register("potion_contents", $$0 -> $$0.persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<SuspiciousStewEffects> SUSPICIOUS_STEW_EFFECTS = DataComponents.register("suspicious_stew_effects", $$0 -> $$0.persistent(SuspiciousStewEffects.CODEC).networkSynchronized(SuspiciousStewEffects.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WritableBookContent> WRITABLE_BOOK_CONTENT = DataComponents.register("writable_book_content", $$0 -> $$0.persistent(WritableBookContent.CODEC).networkSynchronized(WritableBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WrittenBookContent> WRITTEN_BOOK_CONTENT = DataComponents.register("written_book_content", $$0 -> $$0.persistent(WrittenBookContent.CODEC).networkSynchronized(WrittenBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ArmorTrim> TRIM = DataComponents.register("trim", $$0 -> $$0.persistent(ArmorTrim.CODEC).networkSynchronized(ArmorTrim.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DebugStickState> DEBUG_STICK_STATE = DataComponents.register("debug_stick_state", $$0 -> $$0.persistent(DebugStickState.CODEC).cacheEncoding());
    public static final DataComponentType<CustomData> ENTITY_DATA = DataComponents.register("entity_data", $$0 -> $$0.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<CustomData> BUCKET_ENTITY_DATA = DataComponents.register("bucket_entity_data", $$0 -> $$0.persistent(CustomData.CODEC).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<CustomData> BLOCK_ENTITY_DATA = DataComponents.register("block_entity_data", $$0 -> $$0.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<Holder<Instrument>> INSTRUMENT = DataComponents.register("instrument", $$0 -> $$0.persistent(Instrument.CODEC).networkSynchronized(Instrument.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Integer> OMINOUS_BOTTLE_AMPLIFIER = DataComponents.register("ominous_bottle_amplifier", $$0 -> $$0.persistent(ExtraCodecs.intRange(0, 4)).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<List<ResourceLocation>> RECIPES = DataComponents.register("recipes", $$0 -> $$0.persistent(ResourceLocation.CODEC.listOf()).cacheEncoding());
    public static final DataComponentType<LodestoneTracker> LODESTONE_TRACKER = DataComponents.register("lodestone_tracker", $$0 -> $$0.persistent(LodestoneTracker.CODEC).networkSynchronized(LodestoneTracker.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<FireworkExplosion> FIREWORK_EXPLOSION = DataComponents.register("firework_explosion", $$0 -> $$0.persistent(FireworkExplosion.CODEC).networkSynchronized(FireworkExplosion.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Fireworks> FIREWORKS = DataComponents.register("fireworks", $$0 -> $$0.persistent(Fireworks.CODEC).networkSynchronized(Fireworks.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ResolvableProfile> PROFILE = DataComponents.register("profile", $$0 -> $$0.persistent(ResolvableProfile.CODEC).networkSynchronized(ResolvableProfile.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ResourceLocation> NOTE_BLOCK_SOUND = DataComponents.register("note_block_sound", $$0 -> $$0.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DataComponentType<BannerPatternLayers> BANNER_PATTERNS = DataComponents.register("banner_patterns", $$0 -> $$0.persistent(BannerPatternLayers.CODEC).networkSynchronized(BannerPatternLayers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DyeColor> BASE_COLOR = DataComponents.register("base_color", $$0 -> $$0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<PotDecorations> POT_DECORATIONS = DataComponents.register("pot_decorations", $$0 -> $$0.persistent(PotDecorations.CODEC).networkSynchronized(PotDecorations.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemContainerContents> CONTAINER = DataComponents.register("container", $$0 -> $$0.persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BlockItemStateProperties> BLOCK_STATE = DataComponents.register("block_state", $$0 -> $$0.persistent(BlockItemStateProperties.CODEC).networkSynchronized(BlockItemStateProperties.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<List<BeehiveBlockEntity.Occupant>> BEES = DataComponents.register("bees", $$0 -> $$0.persistent(BeehiveBlockEntity.Occupant.LIST_CODEC).networkSynchronized(BeehiveBlockEntity.Occupant.STREAM_CODEC.apply(ByteBufCodecs.list())).cacheEncoding());
    public static final DataComponentType<LockCode> LOCK = DataComponents.register("lock", $$0 -> $$0.persistent(LockCode.CODEC));
    public static final DataComponentType<SeededContainerLoot> CONTAINER_LOOT = DataComponents.register("container_loot", $$0 -> $$0.persistent(SeededContainerLoot.CODEC));
    public static final DataComponentMap COMMON_ITEM_COMPONENTS = DataComponentMap.builder().set(MAX_STACK_SIZE, 64).set(LORE, ItemLore.EMPTY).set(ENCHANTMENTS, ItemEnchantments.EMPTY).set(REPAIR_COST, 0).set(ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY).set(RARITY, Rarity.COMMON).build();

    public static DataComponentType<?> bootstrap(Registry<DataComponentType<?>> $$0) {
        return CUSTOM_DATA;
    }

    private static <T> DataComponentType<T> register(String $$0, UnaryOperator<DataComponentType.Builder<T>> $$1) {
        return Registry.register(BuiltInRegistries.DATA_COMPONENT_TYPE, $$0, ((DataComponentType.Builder)$$1.apply(DataComponentType.builder())).build());
    }
}

