/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class RecipeProvider
implements DataProvider {
    final PackOutput.PathProvider recipePathProvider;
    final PackOutput.PathProvider advancementPathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, ($$0, $$1) -> RecipeProvider.buttonBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.CHISELED, ($$0, $$1) -> RecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, $$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.CUT, ($$0, $$1) -> RecipeProvider.cutBuilder(RecipeCategory.BUILDING_BLOCKS, $$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.DOOR, ($$0, $$1) -> RecipeProvider.doorBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, ($$0, $$1) -> RecipeProvider.fenceBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.FENCE, ($$0, $$1) -> RecipeProvider.fenceBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, ($$0, $$1) -> RecipeProvider.fenceGateBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.FENCE_GATE, ($$0, $$1) -> RecipeProvider.fenceGateBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.SIGN, ($$0, $$1) -> RecipeProvider.signBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.SLAB, ($$0, $$1) -> RecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, $$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.STAIRS, ($$0, $$1) -> RecipeProvider.stairBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, ($$0, $$1) -> RecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, $$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.POLISHED, ($$0, $$1) -> RecipeProvider.polishedBuilder(RecipeCategory.BUILDING_BLOCKS, $$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.TRAPDOOR, ($$0, $$1) -> RecipeProvider.trapdoorBuilder($$0, Ingredient.of($$1))).put((Object)BlockFamily.Variant.WALL, ($$0, $$1) -> RecipeProvider.wallBuilder(RecipeCategory.DECORATIONS, $$0, Ingredient.of($$1))).build();

    public RecipeProvider(PackOutput $$0, CompletableFuture<HolderLookup.Provider> $$1) {
        this.recipePathProvider = $$0.createPathProvider(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = $$0.createPathProvider(PackOutput.Target.DATA_PACK, "advancements");
        this.registries = $$1;
    }

    @Override
    public final CompletableFuture<?> run(CachedOutput $$0) {
        return this.registries.thenCompose($$1 -> this.run($$0, (HolderLookup.Provider)$$1));
    }

    protected CompletableFuture<?> run(final CachedOutput $$0, final HolderLookup.Provider $$1) {
        final HashSet $$2 = Sets.newHashSet();
        final ArrayList $$3 = new ArrayList();
        this.buildRecipes(new RecipeOutput(){

            @Override
            public void accept(ResourceLocation $$02, Recipe<?> $$12, @Nullable AdvancementHolder $$22) {
                if (!$$2.add($$02)) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf($$02));
                }
                $$3.add(DataProvider.saveStable($$0, $$1, Recipe.CODEC, $$12, RecipeProvider.this.recipePathProvider.json($$02)));
                if ($$22 != null) {
                    $$3.add(DataProvider.saveStable($$0, $$1, Advancement.CODEC, $$22.value(), RecipeProvider.this.advancementPathProvider.json($$22.id())));
                }
            }

            @Override
            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])$$3.toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<?> buildAdvancement(CachedOutput $$0, HolderLookup.Provider $$1, AdvancementHolder $$2) {
        return DataProvider.saveStable($$0, $$1, Advancement.CODEC, $$2.value(), this.advancementPathProvider.json($$2.id()));
    }

    protected abstract void buildRecipes(RecipeOutput var1);

    protected static void generateForEnabledBlockFamilies(RecipeOutput $$0, FeatureFlagSet $$1) {
        BlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach($$2 -> RecipeProvider.generateRecipes($$0, $$2, $$1));
    }

    protected static void oneToOneConversionRecipe(RecipeOutput $$0, ItemLike $$1, ItemLike $$2, @Nullable String $$3) {
        RecipeProvider.oneToOneConversionRecipe($$0, $$1, $$2, $$3, 1);
    }

    protected static void oneToOneConversionRecipe(RecipeOutput $$0, ItemLike $$1, ItemLike $$2, @Nullable String $$3, int $$4) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, $$1, $$4).requires($$2).group($$3).unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0, RecipeProvider.getConversionRecipeName($$1, $$2));
    }

    protected static void oreSmelting(RecipeOutput $$0, List<ItemLike> $$1, RecipeCategory $$2, ItemLike $$3, float $$4, int $$5, String $$6) {
        RecipeProvider.oreCooking($$0, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, $$1, $$2, $$3, $$4, $$5, $$6, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput $$0, List<ItemLike> $$1, RecipeCategory $$2, ItemLike $$3, float $$4, int $$5, String $$6) {
        RecipeProvider.oreCooking($$0, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, $$1, $$2, $$3, $$4, $$5, $$6, "_from_blasting");
    }

    private static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput $$0, RecipeSerializer<T> $$1, AbstractCookingRecipe.Factory<T> $$2, List<ItemLike> $$3, RecipeCategory $$4, ItemLike $$5, float $$6, int $$7, String $$8, String $$9) {
        for (ItemLike $$10 : $$3) {
            SimpleCookingRecipeBuilder.generic(Ingredient.of($$10), $$4, $$5, $$6, $$7, $$1, $$2).group($$8).unlockedBy(RecipeProvider.getHasName($$10), (Criterion)RecipeProvider.has($$10)).save($$0, RecipeProvider.getItemName($$5) + $$9 + "_" + RecipeProvider.getItemName($$10));
        }
    }

    protected static void netheriteSmithing(RecipeOutput $$0, Item $$1, RecipeCategory $$2, Item $$3) {
        SmithingTransformRecipeBuilder.smithing(Ingredient.of(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), Ingredient.of($$1), Ingredient.of(Items.NETHERITE_INGOT), $$2, $$3).unlocks("has_netherite_ingot", RecipeProvider.has(Items.NETHERITE_INGOT)).save($$0, RecipeProvider.getItemName($$3) + "_smithing");
    }

    protected static void trimSmithing(RecipeOutput $$0, Item $$1, ResourceLocation $$2) {
        SmithingTrimRecipeBuilder.smithingTrim(Ingredient.of($$1), Ingredient.of(ItemTags.TRIMMABLE_ARMOR), Ingredient.of(ItemTags.TRIM_MATERIALS), RecipeCategory.MISC).unlocks("has_smithing_trim_template", RecipeProvider.has($$1)).save($$0, $$2);
    }

    protected static void twoByTwoPacker(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        ShapedRecipeBuilder.shaped($$1, $$2, 1).define(Character.valueOf('#'), $$3).pattern("##").pattern("##").unlockedBy(RecipeProvider.getHasName($$3), (Criterion)RecipeProvider.has($$3)).save($$0);
    }

    protected static void threeByThreePacker(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3, String $$4) {
        ShapelessRecipeBuilder.shapeless($$1, $$2).requires($$3, 9).unlockedBy($$4, (Criterion)RecipeProvider.has($$3)).save($$0);
    }

    protected static void threeByThreePacker(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.threeByThreePacker($$0, $$1, $$2, $$3, RecipeProvider.getHasName($$3));
    }

    protected static void planksFromLog(RecipeOutput $$0, ItemLike $$1, TagKey<Item> $$2, int $$3) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, $$1, $$3).requires($$2).group("planks").unlockedBy("has_log", (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void planksFromLogs(RecipeOutput $$0, ItemLike $$1, TagKey<Item> $$2, int $$3) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, $$1, $$3).requires($$2).group("planks").unlockedBy("has_logs", (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void woodFromLogs(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, $$1, 3).define(Character.valueOf('#'), $$2).pattern("##").pattern("##").group("bark").unlockedBy("has_log", (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void woodenBoat(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, $$1).define(Character.valueOf('#'), $$2).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", (Criterion)RecipeProvider.insideOf(Blocks.WATER)).save($$0);
    }

    protected static void chestBoat(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.TRANSPORTATION, $$1).requires(Blocks.CHEST).requires($$2).group("chest_boat").unlockedBy("has_boat", (Criterion)RecipeProvider.has(ItemTags.BOATS)).save($$0);
    }

    private static RecipeBuilder buttonBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapelessRecipeBuilder.shapeless(RecipeCategory.REDSTONE, $$0).requires($$1);
    }

    protected static RecipeBuilder doorBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, $$0, 3).define(Character.valueOf('#'), $$1).pattern("##").pattern("##").pattern("##");
    }

    private static RecipeBuilder fenceBuilder(ItemLike $$0, Ingredient $$1) {
        int $$2 = $$0 == Blocks.NETHER_BRICK_FENCE ? 6 : 3;
        Item $$3 = $$0 == Blocks.NETHER_BRICK_FENCE ? Items.NETHER_BRICK : Items.STICK;
        return ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$0, $$2).define(Character.valueOf('W'), $$1).define(Character.valueOf('#'), $$3).pattern("W#W").pattern("W#W");
    }

    private static RecipeBuilder fenceGateBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, $$0).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('W'), $$1).pattern("#W#").pattern("#W#");
    }

    protected static void pressurePlate(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        RecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, $$1, Ingredient.of($$2)).unlockedBy(RecipeProvider.getHasName($$2), RecipeProvider.has($$2)).save($$0);
    }

    private static RecipeBuilder pressurePlateBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1).define(Character.valueOf('#'), $$2).pattern("##");
    }

    protected static void slab(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.slabBuilder($$1, $$2, Ingredient.of($$3)).unlockedBy(RecipeProvider.getHasName($$3), RecipeProvider.has($$3)).save($$0);
    }

    protected static RecipeBuilder slabBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1, 6).define(Character.valueOf('#'), $$2).pattern("###");
    }

    protected static RecipeBuilder stairBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, $$0, 4).define(Character.valueOf('#'), $$1).pattern("#  ").pattern("## ").pattern("###");
    }

    private static RecipeBuilder trapdoorBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, $$0, 2).define(Character.valueOf('#'), $$1).pattern("###").pattern("###");
    }

    private static RecipeBuilder signBuilder(ItemLike $$0, Ingredient $$1) {
        return ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$0, 3).group("sign").define(Character.valueOf('#'), $$1).define(Character.valueOf('X'), Items.STICK).pattern("###").pattern("###").pattern(" X ");
    }

    protected static void hangingSign(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1, 6).group("hanging_sign").define(Character.valueOf('#'), $$2).define(Character.valueOf('X'), Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void colorBlockWithDye(RecipeOutput $$0, List<Item> $$12, List<Item> $$2, String $$3) {
        for (int $$4 = 0; $$4 < $$12.size(); ++$$4) {
            Item $$5 = $$12.get($$4);
            Item $$6 = $$2.get($$4);
            ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, $$6).requires($$5).requires(Ingredient.of($$2.stream().filter($$1 -> !$$1.equals($$6)).map(ItemStack::new))).group($$3).unlockedBy("has_needed_dye", (Criterion)RecipeProvider.has($$5)).save($$0, "dye_" + RecipeProvider.getItemName($$6));
        }
    }

    protected static void carpet(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1, 3).define(Character.valueOf('#'), $$2).pattern("##").group("carpet").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void bedFromPlanksAndWool(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1).define(Character.valueOf('#'), $$2).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("###").pattern("XXX").group("bed").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void banner(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1).define(Character.valueOf('#'), $$2).define(Character.valueOf('|'), Items.STICK).pattern("###").pattern("###").pattern(" | ").group("banner").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void stainedGlassFromGlassAndDye(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, $$1, 8).define(Character.valueOf('#'), Blocks.GLASS).define(Character.valueOf('X'), $$2).pattern("###").pattern("#X#").pattern("###").group("stained_glass").unlockedBy("has_glass", (Criterion)RecipeProvider.has(Blocks.GLASS)).save($$0);
    }

    protected static void stainedGlassPaneFromStainedGlass(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1, 16).define(Character.valueOf('#'), $$2).pattern("###").pattern("###").group("stained_glass_pane").unlockedBy("has_glass", (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void stainedGlassPaneFromGlassPaneAndDye(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, $$1, 8).define(Character.valueOf('#'), Blocks.GLASS_PANE).define(Character.valueOf('$'), $$2).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", (Criterion)RecipeProvider.has(Blocks.GLASS_PANE))).unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0, RecipeProvider.getConversionRecipeName($$1, Blocks.GLASS_PANE));
    }

    protected static void coloredTerracottaFromTerracottaAndDye(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, $$1, 8).define(Character.valueOf('#'), Blocks.TERRACOTTA).define(Character.valueOf('X'), $$2).pattern("###").pattern("#X#").pattern("###").group("stained_terracotta").unlockedBy("has_terracotta", (Criterion)RecipeProvider.has(Blocks.TERRACOTTA)).save($$0);
    }

    protected static void concretePowder(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, $$1, 8).requires($$2).requires(Blocks.SAND, 4).requires(Blocks.GRAVEL, 4).group("concrete_powder").unlockedBy("has_sand", (Criterion)RecipeProvider.has(Blocks.SAND))).unlockedBy("has_gravel", (Criterion)RecipeProvider.has(Blocks.GRAVEL)).save($$0);
    }

    protected static void candle(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.DECORATIONS, $$1).requires(Blocks.CANDLE).requires($$2).group("dyed_candle").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void wall(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.wallBuilder($$1, $$2, Ingredient.of($$3)).unlockedBy(RecipeProvider.getHasName($$3), RecipeProvider.has($$3)).save($$0);
    }

    private static RecipeBuilder wallBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1, 6).define(Character.valueOf('#'), $$2).pattern("###").pattern("###");
    }

    protected static void polished(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.polishedBuilder($$1, $$2, Ingredient.of($$3)).unlockedBy(RecipeProvider.getHasName($$3), RecipeProvider.has($$3)).save($$0);
    }

    private static RecipeBuilder polishedBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1, 4).define(Character.valueOf('S'), $$2).pattern("SS").pattern("SS");
    }

    protected static void cut(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.cutBuilder($$1, $$2, Ingredient.of($$3)).unlockedBy(RecipeProvider.getHasName($$3), (Criterion)RecipeProvider.has($$3)).save($$0);
    }

    private static ShapedRecipeBuilder cutBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1, 4).define(Character.valueOf('#'), $$2).pattern("##").pattern("##");
    }

    protected static void chiseled(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.chiseledBuilder($$1, $$2, Ingredient.of($$3)).unlockedBy(RecipeProvider.getHasName($$3), (Criterion)RecipeProvider.has($$3)).save($$0);
    }

    protected static void mosaicBuilder(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        ShapedRecipeBuilder.shaped($$1, $$2).define(Character.valueOf('#'), $$3).pattern("#").pattern("#").unlockedBy(RecipeProvider.getHasName($$3), (Criterion)RecipeProvider.has($$3)).save($$0);
    }

    protected static ShapedRecipeBuilder chiseledBuilder(RecipeCategory $$0, ItemLike $$1, Ingredient $$2) {
        return ShapedRecipeBuilder.shaped($$0, $$1).define(Character.valueOf('#'), $$2).pattern("#").pattern("#");
    }

    protected static void stonecutterResultFromBase(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3) {
        RecipeProvider.stonecutterResultFromBase($$0, $$1, $$2, $$3, 1);
    }

    protected static void stonecutterResultFromBase(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, ItemLike $$3, int $$4) {
        SingleItemRecipeBuilder.stonecutting(Ingredient.of($$3), $$1, $$2, $$4).unlockedBy(RecipeProvider.getHasName($$3), (Criterion)RecipeProvider.has($$3)).save($$0, RecipeProvider.getConversionRecipeName($$2, $$3) + "_stonecutting");
    }

    private static void smeltingResultFromBase(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        SimpleCookingRecipeBuilder.smelting(Ingredient.of($$2), RecipeCategory.BUILDING_BLOCKS, $$1, 0.1f, 200).unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void nineBlockStorageRecipes(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, RecipeCategory $$3, ItemLike $$4) {
        RecipeProvider.nineBlockStorageRecipes($$0, $$1, $$2, $$3, $$4, RecipeProvider.getSimpleRecipeName($$4), null, RecipeProvider.getSimpleRecipeName($$2), null);
    }

    protected static void nineBlockStorageRecipesWithCustomPacking(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, RecipeCategory $$3, ItemLike $$4, String $$5, String $$6) {
        RecipeProvider.nineBlockStorageRecipes($$0, $$1, $$2, $$3, $$4, $$5, $$6, RecipeProvider.getSimpleRecipeName($$2), null);
    }

    protected static void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, RecipeCategory $$3, ItemLike $$4, String $$5, String $$6) {
        RecipeProvider.nineBlockStorageRecipes($$0, $$1, $$2, $$3, $$4, RecipeProvider.getSimpleRecipeName($$4), null, $$5, $$6);
    }

    private static void nineBlockStorageRecipes(RecipeOutput $$0, RecipeCategory $$1, ItemLike $$2, RecipeCategory $$3, ItemLike $$4, String $$5, @Nullable String $$6, String $$7, @Nullable String $$8) {
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless($$1, $$2, 9).requires($$4).group($$8).unlockedBy(RecipeProvider.getHasName($$4), (Criterion)RecipeProvider.has($$4))).save($$0, new ResourceLocation($$7));
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped($$3, $$4).define(Character.valueOf('#'), $$2).pattern("###").pattern("###").pattern("###").group($$6).unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2))).save($$0, new ResourceLocation($$5));
    }

    protected static void copySmithingTemplate(RecipeOutput $$0, ItemLike $$1, TagKey<Item> $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, $$1, 2).define(Character.valueOf('#'), Items.DIAMOND).define(Character.valueOf('C'), $$2).define(Character.valueOf('S'), $$1).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName($$1), (Criterion)RecipeProvider.has($$1)).save($$0);
    }

    protected static void copySmithingTemplate(RecipeOutput $$0, ItemLike $$1, ItemLike $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, $$1, 2).define(Character.valueOf('#'), Items.DIAMOND).define(Character.valueOf('C'), $$2).define(Character.valueOf('S'), $$1).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName($$1), (Criterion)RecipeProvider.has($$1)).save($$0);
    }

    protected static <T extends AbstractCookingRecipe> void cookRecipes(RecipeOutput $$0, String $$1, RecipeSerializer<T> $$2, AbstractCookingRecipe.Factory<T> $$3, int $$4) {
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.BEEF, Items.COOKED_BEEF, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.CHICKEN, Items.COOKED_CHICKEN, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.COD, Items.COOKED_COD, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.KELP, Items.DRIED_KELP, 0.1f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.SALMON, Items.COOKED_SALMON, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.MUTTON, Items.COOKED_MUTTON, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.PORKCHOP, Items.COOKED_PORKCHOP, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.POTATO, Items.BAKED_POTATO, 0.35f);
        RecipeProvider.simpleCookingRecipe($$0, $$1, $$2, $$3, $$4, Items.RABBIT, Items.COOKED_RABBIT, 0.35f);
    }

    private static <T extends AbstractCookingRecipe> void simpleCookingRecipe(RecipeOutput $$0, String $$1, RecipeSerializer<T> $$2, AbstractCookingRecipe.Factory<T> $$3, int $$4, ItemLike $$5, ItemLike $$6, float $$7) {
        SimpleCookingRecipeBuilder.generic(Ingredient.of($$5), RecipeCategory.FOOD, $$6, $$7, $$4, $$2, $$3).unlockedBy(RecipeProvider.getHasName($$5), (Criterion)RecipeProvider.has($$5)).save($$0, RecipeProvider.getItemName($$6) + "_from_" + $$1);
    }

    protected static void waxRecipes(RecipeOutput $$0, FeatureFlagSet $$1) {
        HoneycombItem.WAXABLES.get().forEach(($$2, $$3) -> {
            if (!$$3.requiredFeatures().isSubsetOf($$1)) {
                return;
            }
            ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, $$3).requires((ItemLike)$$2).requires(Items.HONEYCOMB).group(RecipeProvider.getItemName($$3)).unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0, RecipeProvider.getConversionRecipeName($$3, Items.HONEYCOMB));
        });
    }

    protected static void grate(RecipeOutput $$0, Block $$1, Block $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, $$1, 4).define(Character.valueOf('M'), $$2).pattern(" M ").pattern("M M").pattern(" M ").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void copperBulb(RecipeOutput $$0, Block $$1, Block $$2) {
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, $$1, 4).define(Character.valueOf('C'), $$2).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('B'), Items.BLAZE_ROD).pattern(" C ").pattern("CBC").pattern(" R ").unlockedBy(RecipeProvider.getHasName($$2), (Criterion)RecipeProvider.has($$2)).save($$0);
    }

    protected static void generateRecipes(RecipeOutput $$0, BlockFamily $$1, FeatureFlagSet $$2) {
        $$1.getVariants().forEach(($$3, $$4) -> {
            if (!$$4.requiredFeatures().isSubsetOf($$2)) {
                return;
            }
            BiFunction<ItemLike, ItemLike, RecipeBuilder> $$5 = SHAPE_BUILDERS.get($$3);
            Block $$6 = RecipeProvider.getBaseBlock($$1, $$3);
            if ($$5 != null) {
                RecipeBuilder $$7 = $$5.apply((ItemLike)$$4, $$6);
                $$1.getRecipeGroupPrefix().ifPresent($$2 -> $$7.group($$2 + (String)($$3 == BlockFamily.Variant.CUT ? "" : "_" + $$3.getRecipeGroup())));
                $$7.unlockedBy($$1.getRecipeUnlockedBy().orElseGet(() -> RecipeProvider.getHasName($$6)), RecipeProvider.has($$6));
                $$7.save($$0);
            }
            if ($$3 == BlockFamily.Variant.CRACKED) {
                RecipeProvider.smeltingResultFromBase($$0, $$4, $$6);
            }
        });
    }

    private static Block getBaseBlock(BlockFamily $$0, BlockFamily.Variant $$1) {
        if ($$1 == BlockFamily.Variant.CHISELED) {
            if (!$$0.getVariants().containsKey((Object)BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return $$0.get(BlockFamily.Variant.SLAB);
        }
        return $$0.getBaseBlock();
    }

    private static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block $$0) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion(new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of($$0.builtInRegistryHolder()), Optional.empty()));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints $$0, ItemLike $$1) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of($$1).withCount($$0));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike $$0) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of($$0));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> $$0) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of($$0));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... $$0) {
        return RecipeProvider.inventoryTrigger((ItemPredicate[])Arrays.stream($$0).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... $$0) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion(new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of($$0)));
    }

    protected static String getHasName(ItemLike $$0) {
        return "has_" + RecipeProvider.getItemName($$0);
    }

    protected static String getItemName(ItemLike $$0) {
        return BuiltInRegistries.ITEM.getKey($$0.asItem()).getPath();
    }

    protected static String getSimpleRecipeName(ItemLike $$0) {
        return RecipeProvider.getItemName($$0);
    }

    protected static String getConversionRecipeName(ItemLike $$0, ItemLike $$1) {
        return RecipeProvider.getItemName($$0) + "_from_" + RecipeProvider.getItemName($$1);
    }

    protected static String getSmeltingRecipeName(ItemLike $$0) {
        return RecipeProvider.getItemName($$0) + "_from_smelting";
    }

    protected static String getBlastingRecipeName(ItemLike $$0) {
        return RecipeProvider.getItemName($$0) + "_from_blasting";
    }

    @Override
    public final String getName() {
        return "Recipes";
    }
}

