/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    private final ConnectionProtocol protocol;
    private final PacketFlow flow;
    private final List<CodecEntry<T, ?, B>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(ConnectionProtocol $$0, PacketFlow $$1) {
        this.protocol = $$0;
        this.flow = $$1;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> addPacket(PacketType<P> $$0, StreamCodec<? super B, P> $$1) {
        this.codecs.add(new CodecEntry($$0, $$1));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> withBundlePacket(PacketType<P> $$0, Function<Iterable<Packet<? super T>>, P> $$1, D $$2) {
        StreamCodec $$3 = StreamCodec.unit($$2);
        PacketType<BundleDelimiterPacket<? super T>> $$4 = $$2.type();
        this.codecs.add(new CodecEntry($$4, $$3));
        this.bundlerInfo = BundlerInfo.createForPacket($$0, $$1, $$2);
        return this;
    }

    private StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> $$0, List<CodecEntry<T, ?, B>> $$1) {
        ProtocolCodecBuilder $$2 = new ProtocolCodecBuilder(this.flow);
        for (CodecEntry codecEntry : $$1) {
            codecEntry.addToBuilder($$2, $$0);
        }
        return $$2.build();
    }

    public ProtocolInfo<T> build(Function<ByteBuf, B> $$0) {
        return new Implementation(this.protocol, this.flow, this.buildPacketCodec($$0, this.codecs), this.bundlerInfo);
    }

    public ProtocolInfo.Unbound<T, B> buildUnbound() {
        List<CodecEntry<T, ?, B>> $$0 = List.copyOf(this.codecs);
        BundlerInfo $$1 = this.bundlerInfo;
        return $$2 -> new Implementation(this.protocol, this.flow, this.buildPacketCodec($$2, $$0), $$1);
    }

    private static <L extends PacketListener> ProtocolInfo<L> protocol(ConnectionProtocol $$0, PacketFlow $$1, Consumer<ProtocolInfoBuilder<L, FriendlyByteBuf>> $$2) {
        ProtocolInfoBuilder $$3 = new ProtocolInfoBuilder($$0, $$1);
        $$2.accept($$3);
        return $$3.build(FriendlyByteBuf::new);
    }

    public static <T extends ServerboundPacketListener> ProtocolInfo<T> serverboundProtocol(ConnectionProtocol $$0, Consumer<ProtocolInfoBuilder<T, FriendlyByteBuf>> $$1) {
        return ProtocolInfoBuilder.protocol($$0, PacketFlow.SERVERBOUND, $$1);
    }

    public static <T extends ClientboundPacketListener> ProtocolInfo<T> clientboundProtocol(ConnectionProtocol $$0, Consumer<ProtocolInfoBuilder<T, FriendlyByteBuf>> $$1) {
        return ProtocolInfoBuilder.protocol($$0, PacketFlow.CLIENTBOUND, $$1);
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.Unbound<L, B> protocolUnbound(ConnectionProtocol $$0, PacketFlow $$1, Consumer<ProtocolInfoBuilder<L, B>> $$2) {
        ProtocolInfoBuilder $$3 = new ProtocolInfoBuilder($$0, $$1);
        $$2.accept($$3);
        return $$3.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> serverboundProtocolUnbound(ConnectionProtocol $$0, Consumer<ProtocolInfoBuilder<T, B>> $$1) {
        return ProtocolInfoBuilder.protocolUnbound($$0, PacketFlow.SERVERBOUND, $$1);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> clientboundProtocolUnbound(ConnectionProtocol $$0, Consumer<ProtocolInfoBuilder<T, B>> $$1) {
        return ProtocolInfoBuilder.protocolUnbound($$0, PacketFlow.CLIENTBOUND, $$1);
    }

    record CodecEntry<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> $$0, Function<ByteBuf, B> $$1) {
            StreamCodec<ByteBuf, P> $$2 = this.serializer.mapStream($$1);
            $$0.add(this.type, $$2);
        }
    }

    record Implementation<L extends PacketListener>(ConnectionProtocol id, PacketFlow flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

