/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> load(InitConfig $$0, WorldDataSupplier<D> $$12, ResultFactory<D, R> $$22, Executor $$3, Executor $$42) {
        try {
            Pair<WorldDataConfiguration, CloseableResourceManager> $$5 = $$0.packConfig.createResourceManager();
            CloseableResourceManager $$6 = (CloseableResourceManager)$$5.getSecond();
            LayeredRegistryAccess<RegistryLayer> $$7 = RegistryLayer.createRegistryAccess();
            LayeredRegistryAccess<RegistryLayer> $$8 = WorldLoader.loadAndReplaceLayer($$6, $$7, RegistryLayer.WORLDGEN, RegistryDataLoader.WORLDGEN_REGISTRIES);
            RegistryAccess.Frozen $$9 = $$8.getAccessForLoading(RegistryLayer.DIMENSIONS);
            RegistryAccess.Frozen $$10 = RegistryDataLoader.load($$6, (RegistryAccess)$$9, RegistryDataLoader.DIMENSION_REGISTRIES);
            WorldDataConfiguration $$11 = (WorldDataConfiguration)$$5.getFirst();
            DataLoadOutput<D> $$122 = $$12.get(new DataLoadContext($$6, $$11, $$9, $$10));
            LayeredRegistryAccess<RegistryLayer> $$13 = $$8.replaceFrom(RegistryLayer.DIMENSIONS, $$122.finalDimensions);
            return ((CompletableFuture)ReloadableServerResources.loadResources($$6, $$13, $$11.enabledFeatures(), $$0.commandSelection(), $$0.functionCompilationLevel(), $$3, $$42).whenComplete(($$1, $$2) -> {
                if ($$2 != null) {
                    $$6.close();
                }
            })).thenApplyAsync($$4 -> {
                $$4.updateRegistryTags();
                return $$22.create($$6, (ReloadableServerResources)$$4, $$13, $$3.cookie);
            }, $$42);
        }
        catch (Exception $$14) {
            return CompletableFuture.failedFuture($$14);
        }
    }

    private static RegistryAccess.Frozen loadLayer(ResourceManager $$0, LayeredRegistryAccess<RegistryLayer> $$1, RegistryLayer $$2, List<RegistryDataLoader.RegistryData<?>> $$3) {
        RegistryAccess.Frozen $$4 = $$1.getAccessForLoading($$2);
        return RegistryDataLoader.load($$0, (RegistryAccess)$$4, $$3);
    }

    private static LayeredRegistryAccess<RegistryLayer> loadAndReplaceLayer(ResourceManager $$0, LayeredRegistryAccess<RegistryLayer> $$1, RegistryLayer $$2, List<RegistryDataLoader.RegistryData<?>> $$3) {
        RegistryAccess.Frozen $$4 = WorldLoader.loadLayer($$0, $$1, $$2, $$3);
        return $$1.replaceFrom($$2, $$4);
    }

    public record InitConfig(PackConfig packConfig, Commands.CommandSelection commandSelection, int functionCompilationLevel) {
    }

    public record PackConfig(PackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean safeMode, boolean initMode) {
        public Pair<WorldDataConfiguration, CloseableResourceManager> createResourceManager() {
            WorldDataConfiguration $$0 = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataConfig, this.initMode, this.safeMode);
            List<PackResources> $$1 = this.packRepository.openAllSelected();
            MultiPackResourceManager $$2 = new MultiPackResourceManager(PackType.SERVER_DATA, $$1);
            return Pair.of((Object)$$0, (Object)$$2);
        }
    }

    public record DataLoadContext(ResourceManager resources, WorldDataConfiguration dataConfiguration, RegistryAccess.Frozen datapackWorldgen, RegistryAccess.Frozen datapackDimensions) {
    }

    @FunctionalInterface
    public static interface WorldDataSupplier<D> {
        public DataLoadOutput<D> get(DataLoadContext var1);
    }

    public record DataLoadOutput<D>(D cookie, RegistryAccess.Frozen finalDimensions) {
    }

    @FunctionalInterface
    public static interface ResultFactory<D, R> {
        public R create(CloseableResourceManager var1, ReloadableServerResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

