/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class RandomSequences
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long worldSeed;
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<ResourceLocation, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public static SavedData.Factory<RandomSequences> factory(long $$0) {
        return new SavedData.Factory<RandomSequences>(() -> new RandomSequences($$0), ($$1, $$2) -> RandomSequences.load($$0, $$1), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    }

    public RandomSequences(long $$0) {
        this.worldSeed = $$0;
    }

    public RandomSource get(ResourceLocation $$0) {
        RandomSource $$1 = this.sequences.computeIfAbsent($$0, this::createSequence).random();
        return new DirtyMarkingRandomSource($$1);
    }

    private RandomSequence createSequence(ResourceLocation $$0) {
        return this.createSequence($$0, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(ResourceLocation $$0, int $$1, boolean $$2, boolean $$3) {
        long $$4 = ($$2 ? this.worldSeed : 0L) ^ (long)$$1;
        return new RandomSequence($$4, $$3 ? Optional.of($$0) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<ResourceLocation, RandomSequence> $$0) {
        this.sequences.forEach($$0);
    }

    public void setSeedDefaults(int $$0, boolean $$1, boolean $$2) {
        this.salt = $$0;
        this.includeWorldSeed = $$1;
        this.includeSequenceId = $$2;
    }

    @Override
    public CompoundTag save(CompoundTag $$0, HolderLookup.Provider $$12) {
        $$0.putInt("salt", this.salt);
        $$0.putBoolean("include_world_seed", this.includeWorldSeed);
        $$0.putBoolean("include_sequence_id", this.includeSequenceId);
        CompoundTag $$22 = new CompoundTag();
        this.sequences.forEach(($$1, $$2) -> $$22.put($$1.toString(), (Tag)RandomSequence.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, $$2).result().orElseThrow()));
        $$0.put("sequences", $$22);
        return $$0;
    }

    private static boolean getBooleanWithDefault(CompoundTag $$0, String $$1, boolean $$2) {
        if ($$0.contains($$1, 1)) {
            return $$0.getBoolean($$1);
        }
        return $$2;
    }

    public static RandomSequences load(long $$0, CompoundTag $$1) {
        RandomSequences $$2 = new RandomSequences($$0);
        $$2.setSeedDefaults($$1.getInt("salt"), RandomSequences.getBooleanWithDefault($$1, "include_world_seed", true), RandomSequences.getBooleanWithDefault($$1, "include_sequence_id", true));
        CompoundTag $$3 = $$1.getCompound("sequences");
        Set<String> $$4 = $$3.getAllKeys();
        for (String $$5 : $$4) {
            try {
                RandomSequence $$6 = (RandomSequence)((Pair)RandomSequence.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)$$3.get($$5)).result().get()).getFirst();
                $$2.sequences.put(new ResourceLocation($$5), $$6);
            }
            catch (Exception $$7) {
                LOGGER.error("Failed to load random sequence {}", (Object)$$5, (Object)$$7);
            }
        }
        return $$2;
    }

    public int clear() {
        int $$0 = this.sequences.size();
        this.sequences.clear();
        return $$0;
    }

    public void reset(ResourceLocation $$0) {
        this.sequences.put($$0, this.createSequence($$0));
    }

    public void reset(ResourceLocation $$0, int $$1, boolean $$2, boolean $$3) {
        this.sequences.put($$0, this.createSequence($$0, $$1, $$2, $$3));
    }

    class DirtyMarkingRandomSource
    implements RandomSource {
        private final RandomSource random;

        DirtyMarkingRandomSource(RandomSource $$0) {
            this.random = $$0;
        }

        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        public void setSeed(long $$0) {
            RandomSequences.this.setDirty();
            this.random.setSeed($$0);
        }

        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int $$0) {
            RandomSequences.this.setDirty();
            return this.random.nextInt($$0);
        }

        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        public boolean equals(Object $$0) {
            if (this == $$0) {
                return true;
            }
            if ($$0 instanceof DirtyMarkingRandomSource) {
                DirtyMarkingRandomSource $$1 = (DirtyMarkingRandomSource)$$0;
                return this.random.equals($$1.random);
            }
            return false;
        }
    }
}

