/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHurtingProjectile
extends Projectile {
    public static final double ATTACK_DEFLECTION_SCALE = 0.1;
    public static final double BOUNCE_DEFLECTION_SCALE = 0.05;
    public double xPower;
    public double yPower;
    public double zPower;

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> $$0, Level $$1) {
        super((EntityType<? extends Projectile>)$$0, $$1);
    }

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> $$0, double $$1, double $$2, double $$3, Level $$4) {
        this($$0, $$4);
        this.setPos($$1, $$2, $$3);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> $$0, double $$1, double $$2, double $$3, double $$4, double $$5, double $$6, Level $$7) {
        this($$0, $$7);
        this.moveTo($$1, $$2, $$3, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignPower($$4, $$5, $$6);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> $$0, LivingEntity $$1, double $$2, double $$3, double $$4, Level $$5) {
        this($$0, $$1.getX(), $$1.getY(), $$1.getZ(), $$2, $$3, $$4, $$5);
        this.setOwner($$1);
        this.setRot($$1.getYRot(), $$1.getXRot());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double $$0) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return $$0 < ($$1 *= 64.0) * $$1;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    @Override
    public void tick() {
        float $$9;
        HitResult $$1;
        Entity $$0 = this.getOwner();
        if (!this.level().isClientSide && ($$0 != null && $$0.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard();
            return;
        }
        super.tick();
        if (this.shouldBurn()) {
            this.igniteForSeconds(1);
        }
        if (($$1 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType())).getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$1);
        }
        this.checkInsideBlocks();
        Vec3 $$2 = this.getDeltaMovement();
        double $$3 = this.getX() + $$2.x;
        double $$4 = this.getY() + $$2.y;
        double $$5 = this.getZ() + $$2.z;
        ProjectileUtil.rotateTowardsMovement(this, 0.2f);
        if (this.isInWater()) {
            for (int $$6 = 0; $$6 < 4; ++$$6) {
                float $$7 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$3 - $$2.x * 0.25, $$4 - $$2.y * 0.25, $$5 - $$2.z * 0.25, $$2.x, $$2.y, $$2.z);
            }
            float $$8 = this.getLiquidInertia();
        } else {
            $$9 = this.getInertia();
        }
        this.setDeltaMovement($$2.add(this.xPower, this.yPower, this.zPower).scale($$9));
        ParticleOptions $$10 = this.getTrailParticle();
        if ($$10 != null) {
            this.level().addParticle($$10, $$3, $$4 + 0.5, $$5, 0.0, 0.0, 0.0);
        }
        this.setPos($$3, $$4, $$5);
    }

    @Override
    public boolean hurt(DamageSource $$0, float $$1) {
        return !this.isInvulnerableTo($$0);
    }

    @Override
    protected boolean canHitEntity(Entity $$0) {
        return super.canHitEntity($$0) && !$$0.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag $$0) {
        super.addAdditionalSaveData($$0);
        $$0.put("power", this.newDoubleList(this.xPower, this.yPower, this.zPower));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag $$0) {
        ListTag $$1;
        super.readAdditionalSaveData($$0);
        if ($$0.contains("power", 9) && ($$1 = $$0.getList("power", 6)).size() == 3) {
            this.xPower = $$1.getDouble(0);
            this.yPower = $$1.getDouble(1);
            this.zPower = $$1.getDouble(2);
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        Entity $$0 = this.getOwner();
        int $$1 = $$0 == null ? 0 : $$0.getId();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getType(), $$1, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket $$0) {
        super.recreateFromPacket($$0);
        double $$1 = $$0.getXa();
        double $$2 = $$0.getYa();
        double $$3 = $$0.getZa();
        this.assignPower($$1, $$2, $$3);
    }

    private void assignPower(double $$0, double $$1, double $$2) {
        double $$3 = Math.sqrt($$0 * $$0 + $$1 * $$1 + $$2 * $$2);
        if ($$3 != 0.0) {
            this.xPower = $$0 / $$3 * 0.1;
            this.yPower = $$1 / $$3 * 0.1;
            this.zPower = $$2 / $$3 * 0.1;
        }
    }

    @Override
    protected void onDeflection(@Nullable Entity $$0, boolean $$1) {
        super.onDeflection($$0, $$1);
        if ($$1) {
            this.xPower = this.getDeltaMovement().x * 0.1;
            this.yPower = this.getDeltaMovement().y * 0.1;
            this.zPower = this.getDeltaMovement().z * 0.1;
        } else {
            this.xPower = this.getDeltaMovement().x * 0.05;
            this.yPower = this.getDeltaMovement().y * 0.05;
            this.zPower = this.getDeltaMovement().z * 0.05;
        }
    }
}

