/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodConstants;

public record FoodProperties(int nutrition, float saturation, boolean canAlwaysEat, float eatSeconds, List<PossibleEffect> effects) {
    private static final float DEFAULT_EAT_SECONDS = 1.6f;
    public static final Codec<FoodProperties> DIRECT_CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("nutrition").forGetter(FoodProperties::nutrition), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodProperties::saturation), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodProperties::canAlwaysEat), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("eat_seconds", (Object)Float.valueOf(1.6f)).forGetter(FoodProperties::eatSeconds), (App)PossibleEffect.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodProperties::effects)).apply((Applicative)$$0, FoodProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodProperties> DIRECT_STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, FoodProperties::nutrition, ByteBufCodecs.FLOAT, FoodProperties::saturation, ByteBufCodecs.BOOL, FoodProperties::canAlwaysEat, ByteBufCodecs.FLOAT, FoodProperties::eatSeconds, PossibleEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), FoodProperties::effects, FoodProperties::new);

    public int eatDurationTicks() {
        return (int)(this.eatSeconds * 20.0f);
    }

    public record PossibleEffect(MobEffectInstance effect, float probability) {
        private final MobEffectInstance effect;
        public static final Codec<PossibleEffect> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)MobEffectInstance.CODEC.fieldOf("effect").forGetter(PossibleEffect::effect), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(PossibleEffect::probability)).apply((Applicative)$$0, PossibleEffect::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PossibleEffect> STREAM_CODEC = StreamCodec.composite(MobEffectInstance.STREAM_CODEC, PossibleEffect::effect, ByteBufCodecs.FLOAT, PossibleEffect::probability, PossibleEffect::new);

        public MobEffectInstance effect() {
            return new MobEffectInstance(this.effect);
        }
    }

    public static class Builder {
        private int nutrition;
        private float saturationModifier;
        private boolean canAlwaysEat;
        private float eatSeconds = 1.6f;
        private final ImmutableList.Builder<PossibleEffect> effects = ImmutableList.builder();

        public Builder nutrition(int $$0) {
            this.nutrition = $$0;
            return this;
        }

        public Builder saturationModifier(float $$0) {
            this.saturationModifier = $$0;
            return this;
        }

        public Builder alwaysEdible() {
            this.canAlwaysEat = true;
            return this;
        }

        public Builder fast() {
            this.eatSeconds = 0.8f;
            return this;
        }

        public Builder effect(MobEffectInstance $$0, float $$1) {
            this.effects.add((Object)new PossibleEffect($$0, $$1));
            return this;
        }

        public FoodProperties build() {
            float $$0 = FoodConstants.saturationByModifier(this.nutrition, this.saturationModifier);
            return new FoodProperties(this.nutrition, $$0, this.canAlwaysEat, this.eatSeconds, (List<PossibleEffect>)this.effects.build());
        }
    }
}

