/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public interface Equipable {
    public EquipmentSlot getEquipmentSlot();

    default public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GENERIC;
    }

    default public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item $$0, Level $$1, Player $$2, InteractionHand $$3) {
        ItemStack $$4 = $$2.getItemInHand($$3);
        EquipmentSlot $$5 = Mob.getEquipmentSlotForItem($$4);
        if (!$$2.canUseSlot($$5)) {
            return InteractionResultHolder.pass($$4);
        }
        ItemStack $$6 = $$2.getItemBySlot($$5);
        if (EnchantmentHelper.hasBindingCurse($$6) && !$$2.isCreative() || ItemStack.matches($$4, $$6)) {
            return InteractionResultHolder.fail($$4);
        }
        if (!$$1.isClientSide()) {
            $$2.awardStat(Stats.ITEM_USED.get($$0));
        }
        ItemStack $$7 = $$6.isEmpty() ? $$4 : $$6.copyAndClear();
        ItemStack $$8 = $$2.isCreative() ? $$4.copy() : $$4.copyAndClear();
        $$2.setItemSlot($$5, $$8);
        return InteractionResultHolder.sidedSuccess($$7, $$1.isClientSide());
    }

    @Nullable
    public static Equipable get(ItemStack $$0) {
        BlockItem $$2;
        Item item = $$0.getItem();
        if (item instanceof Equipable) {
            Equipable $$1 = (Equipable)((Object)item);
            return $$1;
        }
        FeatureElement featureElement = $$0.getItem();
        if (featureElement instanceof BlockItem && (featureElement = ($$2 = (BlockItem)featureElement).getBlock()) instanceof Equipable) {
            Equipable $$3 = (Equipable)((Object)featureElement);
            return $$3;
        }
        return null;
    }
}

