/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> $$0, Item.Properties $$1) {
        super($$1);
        this.type = $$0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        void $$11;
        BlockPos $$1 = $$0.getClickedPos();
        Direction $$2 = $$0.getClickedFace();
        BlockPos $$3 = $$1.relative($$2);
        Player $$4 = $$0.getPlayer();
        ItemStack $$5 = $$0.getItemInHand();
        if ($$4 != null && !this.mayPlace($$4, $$2, $$5, $$3)) {
            return InteractionResult.FAIL;
        }
        Level $$6 = $$0.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> $$7 = Painting.create($$6, $$3, $$2);
            if ($$7.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            HangingEntity $$8 = $$7.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            ItemFrame $$9 = new ItemFrame($$6, $$3, $$2);
        } else if (this.type == EntityType.GLOW_ITEM_FRAME) {
            GlowItemFrame $$10 = new GlowItemFrame($$6, $$3, $$2);
        } else {
            return InteractionResult.sidedSuccess($$6.isClientSide);
        }
        CustomData $$12 = $$5.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!$$12.isEmpty()) {
            EntityType.updateCustomEntityTag($$6, $$4, (Entity)$$11, $$12);
        }
        if ($$11.survives()) {
            if (!$$6.isClientSide) {
                $$11.playPlacementSound();
                $$6.gameEvent((Entity)$$4, GameEvent.ENTITY_PLACE, $$11.position());
                $$6.addFreshEntity((Entity)$$11);
            }
            $$5.shrink(1);
            return InteractionResult.sidedSuccess($$6.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player $$0, Direction $$1, ItemStack $$2, BlockPos $$3) {
        return !$$1.getAxis().isVertical() && $$0.mayUseItemAt($$3, $$1, $$2);
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        super.appendHoverText($$0, $$1, $$2, $$3);
        if (this.type == EntityType.PAINTING) {
            CustomData $$4 = $$0.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
            if (!$$4.isEmpty()) {
                $$4.read(Painting.VARIANT_MAP_CODEC).result().ifPresentOrElse($$12 -> {
                    $$12.unwrapKey().ifPresent($$1 -> {
                        $$2.add(Component.translatable($$1.location().toLanguageKey("painting", "title")).withStyle(ChatFormatting.YELLOW));
                        $$2.add(Component.translatable($$1.location().toLanguageKey("painting", "author")).withStyle(ChatFormatting.GRAY));
                    });
                    $$2.add(Component.translatable("painting.dimensions", Mth.positiveCeilDiv(((PaintingVariant)$$12.value()).getWidth(), 16), Mth.positiveCeilDiv(((PaintingVariant)$$12.value()).getHeight(), 16)));
                }, () -> $$2.add(TOOLTIP_RANDOM_VARIANT));
            } else if ($$3.isCreative()) {
                $$2.add(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

