/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SimpleCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    private final AbstractCookingRecipe.Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public SimpleCookingSerializer(AbstractCookingRecipe.Factory<T> $$0, int $$1) {
        this.factory = $$0;
        this.codec = RecordCodecBuilder.mapCodec($$2 -> $$2.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter($$0 -> $$0.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter($$0 -> $$0.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter($$0 -> $$0.ingredient), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter($$0 -> $$0.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter($$0 -> Float.valueOf($$0.experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)$$1).forGetter($$0 -> $$0.cookingTime)).apply((Applicative)$$2, $$0::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @Override
    public MapCodec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf $$0) {
        String $$1 = $$0.readUtf();
        CookingBookCategory $$2 = $$0.readEnum(CookingBookCategory.class);
        Ingredient $$3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
        ItemStack $$4 = (ItemStack)ItemStack.STREAM_CODEC.decode($$0);
        float $$5 = $$0.readFloat();
        int $$6 = $$0.readVarInt();
        return this.factory.create($$1, $$2, $$3, $$4, $$5, $$6);
    }

    private void toNetwork(RegistryFriendlyByteBuf $$0, T $$1) {
        $$0.writeUtf(((AbstractCookingRecipe)$$1).group);
        $$0.writeEnum(((AbstractCookingRecipe)$$1).category());
        Ingredient.CONTENTS_STREAM_CODEC.encode($$0, ((AbstractCookingRecipe)$$1).ingredient);
        ItemStack.STREAM_CODEC.encode($$0, ((AbstractCookingRecipe)$$1).result);
        $$0.writeFloat(((AbstractCookingRecipe)$$1).experience);
        $$0.writeVarInt(((AbstractCookingRecipe)$$1).cookingTime);
    }

    public AbstractCookingRecipe create(String $$0, CookingBookCategory $$1, Ingredient $$2, ItemStack $$3, float $$4, int $$5) {
        return this.factory.create($$0, $$1, $$2, $$3, $$4, $$5);
    }
}

