/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Enchantment
implements FeatureElement {
    private final EnchantmentDefinition definition;
    @Nullable
    protected String descriptionId;
    private final Holder.Reference<Enchantment> builtInRegistryHolder = BuiltInRegistries.ENCHANTMENT.createIntrusiveHolder(this);

    public static Cost constantCost(int $$0) {
        return new Cost($$0, 0);
    }

    public static Cost dynamicCost(int $$0, int $$1) {
        return new Cost($$0, $$1);
    }

    public static EnchantmentDefinition definition(TagKey<Item> $$0, TagKey<Item> $$1, int $$2, int $$3, Cost $$4, Cost $$5, int $$6, EquipmentSlot ... $$7) {
        return new EnchantmentDefinition($$0, Optional.of($$1), $$2, $$3, $$4, $$5, $$6, FeatureFlags.DEFAULT_FLAGS, $$7);
    }

    public static EnchantmentDefinition definition(TagKey<Item> $$0, int $$1, int $$2, Cost $$3, Cost $$4, int $$5, EquipmentSlot ... $$6) {
        return new EnchantmentDefinition($$0, Optional.empty(), $$1, $$2, $$3, $$4, $$5, FeatureFlags.DEFAULT_FLAGS, $$6);
    }

    public static EnchantmentDefinition definition(TagKey<Item> $$0, int $$1, int $$2, Cost $$3, Cost $$4, int $$5, FeatureFlagSet $$6, EquipmentSlot ... $$7) {
        return new EnchantmentDefinition($$0, Optional.empty(), $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    @Nullable
    public static Enchantment byId(int $$0) {
        return (Enchantment)BuiltInRegistries.ENCHANTMENT.byId($$0);
    }

    public Enchantment(EnchantmentDefinition $$0) {
        this.definition = $$0;
    }

    public Map<EquipmentSlot, ItemStack> getSlotItems(LivingEntity $$0) {
        EnumMap $$1 = Maps.newEnumMap(EquipmentSlot.class);
        for (EquipmentSlot $$2 : this.definition.slots()) {
            ItemStack $$3 = $$0.getItemBySlot($$2);
            if ($$3.isEmpty()) continue;
            $$1.put($$2, $$3);
        }
        return $$1;
    }

    public final TagKey<Item> getSupportedItems() {
        return this.definition.supportedItems();
    }

    public final boolean isPrimaryItem(ItemStack $$0) {
        return this.definition.primaryItems.isEmpty() || $$0.is(this.definition.primaryItems.get());
    }

    public final int getWeight() {
        return this.definition.weight();
    }

    public final int getAnvilCost() {
        return this.definition.anvilCost();
    }

    public final int getMinLevel() {
        return 1;
    }

    public final int getMaxLevel() {
        return this.definition.maxLevel();
    }

    public final int getMinCost(int $$0) {
        return this.definition.minCost().calculate($$0);
    }

    public final int getMaxCost(int $$0) {
        return this.definition.maxCost().calculate($$0);
    }

    public int getDamageProtection(int $$0, DamageSource $$1) {
        return 0;
    }

    public float getDamageBonus(int $$0, @Nullable EntityType<?> $$1) {
        return 0.0f;
    }

    public final boolean isCompatibleWith(Enchantment $$0) {
        return this.checkCompatibility($$0) && $$0.checkCompatibility(this);
    }

    protected boolean checkCompatibility(Enchantment $$0) {
        return this != $$0;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId("enchantment", BuiltInRegistries.ENCHANTMENT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullname(int $$0) {
        MutableComponent $$1 = Component.translatable(this.getDescriptionId());
        if (this.isCurse()) {
            $$1.withStyle(ChatFormatting.RED);
        } else {
            $$1.withStyle(ChatFormatting.GRAY);
        }
        if ($$0 != 1 || this.getMaxLevel() != 1) {
            $$1.append(CommonComponents.SPACE).append(Component.translatable("enchantment.level." + $$0));
        }
        return $$1;
    }

    public boolean canEnchant(ItemStack $$0) {
        return $$0.getItem().builtInRegistryHolder().is(this.definition.supportedItems());
    }

    public void doPostAttack(LivingEntity $$0, Entity $$1, int $$2) {
    }

    public void doPostHurt(LivingEntity $$0, Entity $$1, int $$2) {
    }

    public void doPostItemStackHurt(LivingEntity $$0, Entity $$1, int $$2) {
    }

    public boolean isTreasureOnly() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean isTradeable() {
        return true;
    }

    public boolean isDiscoverable() {
        return true;
    }

    @Deprecated
    public Holder.Reference<Enchantment> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.definition.requiredFeatures();
    }

    public record Cost(int base, int perLevel) {
        public int calculate(int $$0) {
            return this.base + this.perLevel * ($$0 - 1);
        }
    }

    public record EnchantmentDefinition(TagKey<Item> supportedItems, Optional<TagKey<Item>> primaryItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, FeatureFlagSet requiredFeatures, EquipmentSlot[] slots) {
    }
}

