/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.ToFullChunk;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkStatus {
    public static final int MAX_STRUCTURE_DISTANCE = 8;
    private static final EnumSet<Heightmap.Types> PRE_FEATURES = EnumSet.of(Heightmap.Types.OCEAN_FLOOR_WG, Heightmap.Types.WORLD_SURFACE_WG);
    public static final EnumSet<Heightmap.Types> POST_FEATURES = EnumSet.of(Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    public static final ChunkStatus EMPTY = ChunkStatus.register("empty", null, -1, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateEmpty, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus STRUCTURE_STARTS = ChunkStatus.register("structure_starts", EMPTY, 0, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateStructureStarts, ChunkStatusTasks::loadStructureStarts);
    public static final ChunkStatus STRUCTURE_REFERENCES = ChunkStatus.register("structure_references", STRUCTURE_STARTS, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateStructureReferences, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus BIOMES = ChunkStatus.register("biomes", STRUCTURE_REFERENCES, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateBiomes, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus NOISE = ChunkStatus.register("noise", BIOMES, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateNoise, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus SURFACE = ChunkStatus.register("surface", NOISE, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateSurface, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus CARVERS = ChunkStatus.register("carvers", SURFACE, 8, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateCarvers, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus FEATURES = ChunkStatus.register("features", CARVERS, 8, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateFeatures, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus INITIALIZE_LIGHT = ChunkStatus.register("initialize_light", FEATURES, 0, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateInitializeLight, ChunkStatusTasks::loadInitializeLight);
    public static final ChunkStatus LIGHT = ChunkStatus.register("light", INITIALIZE_LIGHT, 1, true, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateLight, ChunkStatusTasks::loadLight);
    public static final ChunkStatus SPAWN = ChunkStatus.register("spawn", LIGHT, 1, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateSpawn, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus FULL = ChunkStatus.register("full", SPAWN, 0, false, POST_FEATURES, ChunkType.LEVELCHUNK, ChunkStatusTasks::generateFull, ChunkStatusTasks::loadFull);
    private static final List<ChunkStatus> STATUS_BY_RANGE = ImmutableList.of((Object)FULL, (Object)INITIALIZE_LIGHT, (Object)CARVERS, (Object)BIOMES, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object[])new ChunkStatus[0]);
    private static final IntList RANGE_BY_STATUS = (IntList)Util.make(new IntArrayList(ChunkStatus.getStatusList().size()), $$0 -> {
        int $$1 = 0;
        for (int $$2 = ChunkStatus.getStatusList().size() - 1; $$2 >= 0; --$$2) {
            while ($$1 + 1 < STATUS_BY_RANGE.size() && $$2 <= STATUS_BY_RANGE.get($$1 + 1).getIndex()) {
                ++$$1;
            }
            $$0.add(0, $$1);
        }
    });
    private final int index;
    private final ChunkStatus parent;
    private final GenerationTask generationTask;
    private final LoadingTask loadingTask;
    private final int range;
    private final boolean hasLoadDependencies;
    private final ChunkType chunkType;
    private final EnumSet<Heightmap.Types> heightmapsAfter;

    private static ChunkStatus register(String $$0, @Nullable ChunkStatus $$1, int $$2, boolean $$3, EnumSet<Heightmap.Types> $$4, ChunkType $$5, GenerationTask $$6, LoadingTask $$7) {
        return Registry.register(BuiltInRegistries.CHUNK_STATUS, $$0, new ChunkStatus($$1, $$2, $$3, $$4, $$5, $$6, $$7));
    }

    public static List<ChunkStatus> getStatusList() {
        ChunkStatus $$1;
        ArrayList $$0 = Lists.newArrayList();
        for ($$1 = FULL; $$1.getParent() != $$1; $$1 = $$1.getParent()) {
            $$0.add($$1);
        }
        $$0.add($$1);
        Collections.reverse($$0);
        return $$0;
    }

    public static ChunkStatus getStatusAroundFullChunk(int $$0) {
        if ($$0 >= STATUS_BY_RANGE.size()) {
            return EMPTY;
        }
        if ($$0 < 0) {
            return FULL;
        }
        return STATUS_BY_RANGE.get($$0);
    }

    public static int maxDistance() {
        return STATUS_BY_RANGE.size();
    }

    public static int getDistance(ChunkStatus $$0) {
        return RANGE_BY_STATUS.getInt($$0.getIndex());
    }

    ChunkStatus(@Nullable ChunkStatus $$0, int $$1, boolean $$2, EnumSet<Heightmap.Types> $$3, ChunkType $$4, GenerationTask $$5, LoadingTask $$6) {
        this.parent = $$0 == null ? this : $$0;
        this.generationTask = $$5;
        this.loadingTask = $$6;
        this.range = $$1;
        this.hasLoadDependencies = $$2;
        this.chunkType = $$4;
        this.heightmapsAfter = $$3;
        this.index = $$0 == null ? 0 : $$0.getIndex() + 1;
    }

    public int getIndex() {
        return this.index;
    }

    public ChunkStatus getParent() {
        return this.parent;
    }

    public CompletableFuture<ChunkAccess> generate(WorldGenContext $$0, Executor $$12, ToFullChunk $$2, List<ChunkAccess> $$3) {
        ChunkAccess $$4 = $$3.get($$3.size() / 2);
        ProfiledDuration $$5 = JvmProfiler.INSTANCE.onChunkGenerate($$4.getPos(), $$0.level().dimension(), this.toString());
        return this.generationTask.doWork($$0, this, $$12, $$2, $$3, $$4).thenApply($$1 -> {
            ProtoChunk $$2;
            if ($$1 instanceof ProtoChunk && !($$2 = (ProtoChunk)$$1).getStatus().isOrAfter(this)) {
                $$2.setStatus(this);
            }
            if ($$5 != null) {
                $$5.finish();
            }
            return $$1;
        });
    }

    public CompletableFuture<ChunkAccess> load(WorldGenContext $$0, ToFullChunk $$1, ChunkAccess $$2) {
        return this.loadingTask.doWork($$0, this, $$1, $$2);
    }

    public int getRange() {
        return this.range;
    }

    public boolean hasLoadDependencies() {
        return this.hasLoadDependencies;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public static ChunkStatus byName(String $$0) {
        return BuiltInRegistries.CHUNK_STATUS.get(ResourceLocation.tryParse($$0));
    }

    public EnumSet<Heightmap.Types> heightmapsAfter() {
        return this.heightmapsAfter;
    }

    public boolean isOrAfter(ChunkStatus $$0) {
        return this.getIndex() >= $$0.getIndex();
    }

    public String toString() {
        return BuiltInRegistries.CHUNK_STATUS.getKey(this).toString();
    }

    @FunctionalInterface
    protected static interface GenerationTask {
        public CompletableFuture<ChunkAccess> doWork(WorldGenContext var1, ChunkStatus var2, Executor var3, ToFullChunk var4, List<ChunkAccess> var5, ChunkAccess var6);
    }

    @FunctionalInterface
    protected static interface LoadingTask {
        public CompletableFuture<ChunkAccess> doWork(WorldGenContext var1, ChunkStatus var2, ToFullChunk var3, ChunkAccess var4);
    }
}

