/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ToFullChunk;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkStatusTasks {
    private static boolean isLighted(ChunkAccess $$0) {
        return $$0.getStatus().isOrAfter(ChunkStatus.LIGHT) && $$0.isLightCorrect();
    }

    static CompletableFuture<ChunkAccess> generateEmpty(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> loadPassThrough(WorldGenContext $$0, ChunkStatus $$1, ToFullChunk $$2, ChunkAccess $$3) {
        return CompletableFuture.completedFuture($$3);
    }

    static CompletableFuture<ChunkAccess> generateStructureStarts(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        if ($$6.getServer().getWorldData().worldGenOptions().generateStructures()) {
            $$0.generator().createStructures($$6.registryAccess(), $$6.getChunkSource().getGeneratorState(), $$6.structureManager(), $$5, $$0.structureManager());
        }
        $$6.onStructureStartsAvailable($$5);
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> loadStructureStarts(WorldGenContext $$0, ChunkStatus $$1, ToFullChunk $$2, ChunkAccess $$3) {
        $$0.level().onStructureStartsAvailable($$3);
        return CompletableFuture.completedFuture($$3);
    }

    static CompletableFuture<ChunkAccess> generateStructureReferences(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, -1);
        $$0.generator().createReferences($$7, $$6.structureManager().forWorldGenRegion($$7), $$5);
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> generateBiomes(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, -1);
        return $$0.generator().createBiomes($$2, $$6.getChunkSource().randomState(), Blender.of($$7), $$6.structureManager().forWorldGenRegion($$7), $$5);
    }

    static CompletableFuture<ChunkAccess> generateNoise(WorldGenContext $$02, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$02.level();
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, 0);
        return $$02.generator().fillFromNoise($$2, Blender.of($$7), $$6.getChunkSource().randomState(), $$6.structureManager().forWorldGenRegion($$7), $$5).thenApply($$0 -> {
            ProtoChunk $$1;
            BelowZeroRetrogen $$2;
            if ($$0 instanceof ProtoChunk && ($$2 = ($$1 = (ProtoChunk)$$0).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock($$1);
                if ($$2.hasBedrockHoles()) {
                    $$2.applyBedrockMask($$1);
                }
            }
            return $$0;
        });
    }

    static CompletableFuture<ChunkAccess> generateSurface(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, 0);
        $$0.generator().buildSurface($$7, $$6.structureManager().forWorldGenRegion($$7), $$6.getChunkSource().randomState(), $$5);
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> generateCarvers(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, 0);
        if ($$5 instanceof ProtoChunk) {
            ProtoChunk $$8 = (ProtoChunk)$$5;
            Blender.addAroundOldChunksCarvingMaskFilter($$7, $$8);
        }
        $$0.generator().applyCarvers($$7, $$6.getSeed(), $$6.getChunkSource().randomState(), $$6.getBiomeManager(), $$6.structureManager().forWorldGenRegion($$7), $$5, GenerationStep.Carving.AIR);
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> generateFeatures(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        ServerLevel $$6 = $$0.level();
        Heightmap.primeHeightmaps($$5, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
        WorldGenRegion $$7 = new WorldGenRegion($$6, $$4, $$1, 1);
        $$0.generator().applyBiomeDecoration($$7, $$5, $$6.structureManager().forWorldGenRegion($$7));
        Blender.generateBorderTicks($$7, $$5);
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> generateInitializeLight(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        return ChunkStatusTasks.initializeLight($$0.lightEngine(), $$5);
    }

    static CompletableFuture<ChunkAccess> loadInitializeLight(WorldGenContext $$0, ChunkStatus $$1, ToFullChunk $$2, ChunkAccess $$3) {
        return ChunkStatusTasks.initializeLight($$0.lightEngine(), $$3);
    }

    private static CompletableFuture<ChunkAccess> initializeLight(ThreadedLevelLightEngine $$0, ChunkAccess $$1) {
        $$1.initializeLightSources();
        ((ProtoChunk)$$1).setLightEngine($$0);
        boolean $$2 = ChunkStatusTasks.isLighted($$1);
        return $$0.initializeLight($$1, $$2);
    }

    static CompletableFuture<ChunkAccess> generateLight(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        return ChunkStatusTasks.lightChunk($$0.lightEngine(), $$5);
    }

    static CompletableFuture<ChunkAccess> loadLight(WorldGenContext $$0, ChunkStatus $$1, ToFullChunk $$2, ChunkAccess $$3) {
        return ChunkStatusTasks.lightChunk($$0.lightEngine(), $$3);
    }

    private static CompletableFuture<ChunkAccess> lightChunk(ThreadedLevelLightEngine $$0, ChunkAccess $$1) {
        boolean $$2 = ChunkStatusTasks.isLighted($$1);
        return $$0.lightChunk($$1, $$2);
    }

    static CompletableFuture<ChunkAccess> generateSpawn(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        if (!$$5.isUpgrading()) {
            $$0.generator().spawnOriginalMobs(new WorldGenRegion($$0.level(), $$4, $$1, -1));
        }
        return CompletableFuture.completedFuture($$5);
    }

    static CompletableFuture<ChunkAccess> generateFull(WorldGenContext $$0, ChunkStatus $$1, Executor $$2, ToFullChunk $$3, List<ChunkAccess> $$4, ChunkAccess $$5) {
        return $$3.apply($$5);
    }

    static CompletableFuture<ChunkAccess> loadFull(WorldGenContext $$0, ChunkStatus $$1, ToFullChunk $$2, ChunkAccess $$3) {
        return $$2.apply($$3);
    }
}

