/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext $$02, Holder<StructureTemplatePool> $$1, Optional<ResourceLocation> $$22, int $$3, BlockPos $$4, boolean $$5, Optional<Heightmap.Types> $$6, int $$7, PoolAliasLookup $$8) {
        int $$29;
        BlockPos $$21;
        RegistryAccess $$9 = $$02.registryAccess();
        ChunkGenerator $$10 = $$02.chunkGenerator();
        StructureTemplateManager $$11 = $$02.structureTemplateManager();
        LevelHeightAccessor $$12 = $$02.heightAccessor();
        WorldgenRandom $$13 = $$02.random();
        Registry<StructureTemplatePool> $$14 = $$9.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation $$152 = Rotation.getRandom($$13);
        StructureTemplatePool $$16 = $$1.unwrapKey().flatMap($$2 -> $$14.getOptional($$8.lookup((ResourceKey<StructureTemplatePool>)$$2))).orElse($$1.value());
        StructurePoolElement $$17 = $$16.getRandomTemplate($$13);
        if ($$17 == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if ($$22.isPresent()) {
            ResourceLocation $$18 = $$22.get();
            Optional<BlockPos> $$19 = JigsawPlacement.getRandomNamedJigsaw($$17, $$18, $$4, $$152, $$11, $$13);
            if ($$19.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)$$18, (Object)$$1.unwrapKey().map($$0 -> $$0.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPos $$20 = $$19.get();
        } else {
            $$21 = $$4;
        }
        BlockPos $$222 = $$21.subtract($$4);
        BlockPos $$23 = $$4.subtract($$222);
        PoolElementStructurePiece $$24 = new PoolElementStructurePiece($$11, $$17, $$23, $$17.getGroundLevelDelta(), $$152, $$17.getBoundingBox($$11, $$23, $$152));
        BoundingBox $$25 = $$24.getBoundingBox();
        int $$26 = ($$25.maxX() + $$25.minX()) / 2;
        int $$27 = ($$25.maxZ() + $$25.minZ()) / 2;
        if ($$6.isPresent()) {
            int $$28 = $$4.getY() + $$10.getFirstFreeHeight($$26, $$27, $$6.get(), $$12, $$02.randomState());
        } else {
            $$29 = $$23.getY();
        }
        int $$30 = $$25.minY() + $$24.getGroundLevelDelta();
        $$24.move(0, $$29 - $$30, 0);
        int $$31 = $$29 + $$222.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos($$26, $$31, $$27), $$15 -> {
            ArrayList $$16 = Lists.newArrayList();
            $$16.add($$24);
            if ($$3 <= 0) {
                return;
            }
            AABB $$17 = new AABB($$26 - $$7, $$31 - $$7, $$27 - $$7, $$26 + $$7 + 1, $$31 + $$7 + 1, $$27 + $$7 + 1);
            VoxelShape $$18 = Shapes.join(Shapes.create($$17), Shapes.create(AABB.of($$25)), BooleanOp.ONLY_FIRST);
            JigsawPlacement.addPieces($$02.randomState(), $$3, $$5, $$10, $$11, $$12, $$13, $$14, $$24, $$16, $$18, $$8);
            $$16.forEach($$15::addPiece);
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement $$0, ResourceLocation $$1, BlockPos $$2, Rotation $$3, StructureTemplateManager $$4, WorldgenRandom $$5) {
        List<StructureTemplate.StructureBlockInfo> $$6 = $$0.getShuffledJigsawBlocks($$4, $$2, $$3, $$5);
        Optional<BlockPos> $$7 = Optional.empty();
        for (StructureTemplate.StructureBlockInfo $$8 : $$6) {
            ResourceLocation $$9 = ResourceLocation.tryParse(Objects.requireNonNull($$8.nbt(), () -> String.valueOf($$8) + " nbt was null").getString("name"));
            if (!$$1.equals($$9)) continue;
            $$7 = Optional.of($$8.pos());
            break;
        }
        return $$7;
    }

    private static void addPieces(RandomState $$0, int $$1, boolean $$2, ChunkGenerator $$3, StructureTemplateManager $$4, LevelHeightAccessor $$5, RandomSource $$6, Registry<StructureTemplatePool> $$7, PoolElementStructurePiece $$8, List<PoolElementStructurePiece> $$9, VoxelShape $$10, PoolAliasLookup $$11) {
        Placer $$12 = new Placer($$7, $$1, $$3, $$4, $$9, $$6);
        $$12.tryPlacingChildren($$8, (MutableObject<VoxelShape>)new MutableObject((Object)$$10), 0, $$2, $$5, $$0, $$11);
        while ($$12.placing.hasNext()) {
            PieceState $$13 = (PieceState)$$12.placing.next();
            $$12.tryPlacingChildren($$13.piece, $$13.free, $$13.depth, $$2, $$5, $$0, $$11);
        }
    }

    public static boolean generateJigsaw(ServerLevel $$02, Holder<StructureTemplatePool> $$1, ResourceLocation $$2, int $$3, BlockPos $$4, boolean $$5) {
        ChunkGenerator $$6 = $$02.getChunkSource().getGenerator();
        StructureTemplateManager $$7 = $$02.getStructureManager();
        StructureManager $$8 = $$02.structureManager();
        RandomSource $$9 = $$02.getRandom();
        Structure.GenerationContext $$10 = new Structure.GenerationContext($$02.registryAccess(), $$6, $$6.getBiomeSource(), $$02.getChunkSource().randomState(), $$7, $$02.getSeed(), new ChunkPos($$4), $$02, $$0 -> true);
        Optional<Structure.GenerationStub> $$11 = JigsawPlacement.addPieces($$10, $$1, Optional.of($$2), $$3, $$4, false, Optional.empty(), 128, PoolAliasLookup.EMPTY);
        if ($$11.isPresent()) {
            StructurePiecesBuilder $$12 = $$11.get().getPiecesBuilder();
            for (StructurePiece $$13 : $$12.build().pieces()) {
                if (!($$13 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece $$14 = (PoolElementStructurePiece)$$13;
                $$14.place($$02, $$8, $$6, $$9, BoundingBox.infinite(), $$4, $$5);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> $$0, int $$1, ChunkGenerator $$2, StructureTemplateManager $$3, List<? super PoolElementStructurePiece> $$4, RandomSource $$5) {
            this.pools = $$0;
            this.maxDepth = $$1;
            this.chunkGenerator = $$2;
            this.structureTemplateManager = $$3;
            this.pieces = $$4;
            this.random = $$5;
        }

        void tryPlacingChildren(PoolElementStructurePiece $$02, MutableObject<VoxelShape> $$1, int $$22, boolean $$3, LevelHeightAccessor $$4, RandomState $$5, PoolAliasLookup $$6) {
            StructurePoolElement $$7 = $$02.getElement();
            BlockPos $$8 = $$02.getPosition();
            Rotation $$9 = $$02.getRotation();
            StructureTemplatePool.Projection $$10 = $$7.getProjection();
            boolean $$11 = $$10 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$12 = new MutableObject();
            BoundingBox $$13 = $$02.getBoundingBox();
            int $$14 = $$13.minY();
            block0: for (StructureTemplate.StructureBlockInfo $$15 : $$7.getShuffledJigsawBlocks(this.structureTemplateManager, $$8, $$9, this.random)) {
                StructurePoolElement $$30;
                MutableObject<VoxelShape> $$27;
                Direction $$16 = JigsawBlock.getFrontFacing($$15.state());
                BlockPos $$17 = $$15.pos();
                BlockPos $$18 = $$17.relative($$16);
                int $$19 = $$17.getY() - $$14;
                int $$20 = -1;
                ResourceKey<StructureTemplatePool> $$21 = Placer.readPoolKey($$15, $$6);
                Optional<Holder.Reference<StructureTemplatePool>> $$222 = this.pools.getHolder($$21);
                if ($$222.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$21.location());
                    continue;
                }
                Holder $$23 = $$222.get();
                if (((StructureTemplatePool)$$23.value()).size() == 0 && !$$23.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$21.location());
                    continue;
                }
                Holder<StructureTemplatePool> $$24 = ((StructureTemplatePool)$$23.value()).getFallback();
                if ($$24.value().size() == 0 && !$$24.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)$$24.unwrapKey().map($$0 -> $$0.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean $$25 = $$13.isInside($$18);
                if ($$25) {
                    MutableObject $$26 = $$12;
                    if ($$12.getValue() == null) {
                        $$12.setValue((Object)Shapes.create(AABB.of($$13)));
                    }
                } else {
                    $$27 = $$1;
                }
                ArrayList $$28 = Lists.newArrayList();
                if ($$22 != this.maxDepth) {
                    $$28.addAll(((StructureTemplatePool)$$23.value()).getShuffledTemplates(this.random));
                }
                $$28.addAll($$24.value().getShuffledTemplates(this.random));
                int $$29 = $$15.nbt() != null ? $$15.nbt().getInt("placement_priority") : 0;
                Iterator iterator = $$28.iterator();
                while (iterator.hasNext() && ($$30 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation $$31 : Rotation.getShuffled(this.random)) {
                        int $$35;
                        List<StructureTemplate.StructureBlockInfo> $$32 = $$30.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, $$31, this.random);
                        BoundingBox $$33 = $$30.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, $$31);
                        if (!$$3 || $$33.getYSpan() > 16) {
                            boolean $$34 = false;
                        } else {
                            $$35 = $$32.stream().mapToInt($$2 -> {
                                if (!$$33.isInside($$2.pos().relative(JigsawBlock.getFrontFacing($$2.state())))) {
                                    return 0;
                                }
                                ResourceKey<StructureTemplatePool> $$3 = Placer.readPoolKey($$2, $$6);
                                Optional<Holder.Reference<StructureTemplatePool>> $$4 = this.pools.getHolder($$3);
                                Optional<Holder> $$5 = $$4.map($$0 -> ((StructureTemplatePool)$$0.value()).getFallback());
                                int $$6 = $$4.map($$0 -> ((StructureTemplatePool)$$0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                int $$7 = $$5.map($$0 -> ((StructureTemplatePool)$$0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                return Math.max($$6, $$7);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.StructureBlockInfo $$36 : $$32) {
                            int $$57;
                            int $$53;
                            int $$46;
                            if (!JigsawBlock.canAttach($$15, $$36)) continue;
                            BlockPos $$37 = $$36.pos();
                            BlockPos $$38 = $$18.subtract($$37);
                            BoundingBox $$39 = $$30.getBoundingBox(this.structureTemplateManager, $$38, $$31);
                            int $$40 = $$39.minY();
                            StructureTemplatePool.Projection $$41 = $$30.getProjection();
                            boolean $$42 = $$41 == StructureTemplatePool.Projection.RIGID;
                            int $$43 = $$37.getY();
                            int $$44 = $$19 - $$43 + JigsawBlock.getFrontFacing($$15.state()).getStepY();
                            if ($$11 && $$42) {
                                int $$45 = $$14 + $$44;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.chunkGenerator.getFirstFreeHeight($$17.getX(), $$17.getZ(), Heightmap.Types.WORLD_SURFACE_WG, $$4, $$5);
                                }
                                $$46 = $$20 - $$43;
                            }
                            int $$47 = $$46 - $$40;
                            BoundingBox $$48 = $$39.moved(0, $$47, 0);
                            BlockPos $$49 = $$38.offset(0, $$47, 0);
                            if ($$35 > 0) {
                                int $$50 = Math.max($$35 + 1, $$48.maxY() - $$48.minY());
                                $$48.encapsulate(new BlockPos($$48.minX(), $$48.minY() + $$50, $$48.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)$$27.getValue(), Shapes.create(AABB.of($$48).deflate(0.25)), BooleanOp.ONLY_SECOND)) continue;
                            $$27.setValue((Object)Shapes.joinUnoptimized((VoxelShape)$$27.getValue(), Shapes.create(AABB.of($$48)), BooleanOp.ONLY_FIRST));
                            int $$51 = $$02.getGroundLevelDelta();
                            if ($$42) {
                                int $$52 = $$51 - $$44;
                            } else {
                                $$53 = $$30.getGroundLevelDelta();
                            }
                            PoolElementStructurePiece $$54 = new PoolElementStructurePiece(this.structureTemplateManager, $$30, $$49, $$53, $$31, $$48);
                            if ($$11) {
                                int $$55 = $$14 + $$19;
                            } else if ($$42) {
                                int $$56 = $$46 + $$43;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.chunkGenerator.getFirstFreeHeight($$17.getX(), $$17.getZ(), Heightmap.Types.WORLD_SURFACE_WG, $$4, $$5);
                                }
                                $$57 = $$20 + $$44 / 2;
                            }
                            $$02.addJunction(new JigsawJunction($$18.getX(), (int)($$57 - $$19 + $$51), $$18.getZ(), $$44, $$41));
                            $$54.addJunction(new JigsawJunction($$17.getX(), $$57 - $$43 + $$53, $$17.getZ(), -$$44, $$10));
                            this.pieces.add($$54);
                            if ($$22 + 1 > this.maxDepth) continue block0;
                            PieceState $$58 = new PieceState($$54, $$27, $$22 + 1);
                            this.placing.add($$58, $$29);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolKey(StructureTemplate.StructureBlockInfo $$0, PoolAliasLookup $$1) {
            CompoundTag $$2 = Objects.requireNonNull($$0.nbt(), () -> String.valueOf($$0) + " nbt was null");
            ResourceKey<StructureTemplatePool> $$3 = Pools.createKey($$2.getString("pool"));
            return $$1.lookup($$3);
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

