/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = Maps.newHashMap();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage $$0) {
        this.storage = $$0;
    }

    private Container newStorage(String $$0) {
        Container $$1 = new Container();
        this.namespaces.put($$0, $$1);
        return $$1;
    }

    private SavedData.Factory<Container> factory(String $$0) {
        return new SavedData.Factory<Container>(() -> this.newStorage($$0), ($$1, $$2) -> this.newStorage($$0).load((CompoundTag)$$1), DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    }

    public CompoundTag get(ResourceLocation $$0) {
        String $$1 = $$0.getNamespace();
        Container $$2 = this.storage.get(this.factory($$1), CommandStorage.createId($$1));
        return $$2 != null ? $$2.get($$0.getPath()) : new CompoundTag();
    }

    public void set(ResourceLocation $$0, CompoundTag $$1) {
        String $$2 = $$0.getNamespace();
        this.storage.computeIfAbsent(this.factory($$2), CommandStorage.createId($$2)).put($$0.getPath(), $$1);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap($$0 -> ((Container)$$0.getValue()).getKeys((String)$$0.getKey()));
    }

    private static String createId(String $$0) {
        return ID_PREFIX + $$0;
    }

    static class Container
    extends SavedData {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, CompoundTag> storage = Maps.newHashMap();

        Container() {
        }

        Container load(CompoundTag $$0) {
            CompoundTag $$1 = $$0.getCompound(TAG_CONTENTS);
            for (String $$2 : $$1.getAllKeys()) {
                this.storage.put($$2, $$1.getCompound($$2));
            }
            return this;
        }

        @Override
        public CompoundTag save(CompoundTag $$0, HolderLookup.Provider $$12) {
            CompoundTag $$22 = new CompoundTag();
            this.storage.forEach(($$1, $$2) -> $$22.put((String)$$1, $$2.copy()));
            $$0.put(TAG_CONTENTS, $$22);
            return $$0;
        }

        public CompoundTag get(String $$0) {
            CompoundTag $$1 = this.storage.get($$0);
            return $$1 != null ? $$1 : new CompoundTag();
        }

        public void put(String $$0, CompoundTag $$1) {
            if ($$1.isEmpty()) {
                this.storage.remove($$0);
            } else {
                this.storage.put($$0, $$1);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String $$0) {
            return this.storage.keySet().stream().map($$1 -> new ResourceLocation($$0, (String)$$1));
        }
    }
}

