/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class EnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<HolderSet<Enchantment>> ENCHANTMENT_SET_CODEC = BuiltInRegistries.ENCHANTMENT.holderByNameCodec().listOf().xmap(HolderSet::direct, $$0 -> $$0.stream().toList());
    public static final MapCodec<EnchantRandomlyFunction> CODEC = RecordCodecBuilder.mapCodec($$02 -> EnchantRandomlyFunction.commonFields($$02).and((App)ENCHANTMENT_SET_CODEC.optionalFieldOf("enchantments").forGetter($$0 -> $$0.enchantments)).apply((Applicative)$$02, EnchantRandomlyFunction::new));
    private final Optional<HolderSet<Enchantment>> enchantments;

    EnchantRandomlyFunction(List<LootItemCondition> $$0, Optional<HolderSet<Enchantment>> $$1) {
        super($$0);
        this.enchantments = $$1;
    }

    public LootItemFunctionType<EnchantRandomlyFunction> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack $$0, LootContext $$12) {
        RandomSource $$2 = $$12.getRandom();
        Optional $$3 = this.enchantments.flatMap($$1 -> $$1.getRandomElement($$2)).or(() -> {
            boolean $$3 = $$0.is(Items.BOOK);
            List<Holder.Reference> $$4 = BuiltInRegistries.ENCHANTMENT.holders().filter($$1 -> ((Enchantment)$$1.value()).isEnabled($$12.getLevel().enabledFeatures())).filter($$0 -> ((Enchantment)$$0.value()).isDiscoverable()).filter($$2 -> $$3 || ((Enchantment)$$2.value()).canEnchant($$0)).toList();
            return Util.getRandomSafe($$4, $$2);
        });
        if ($$3.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)$$0);
            return $$0;
        }
        return EnchantRandomlyFunction.enchantItem($$0, (Enchantment)((Holder)$$3.get()).value(), $$2);
    }

    private static ItemStack enchantItem(ItemStack $$0, Enchantment $$1, RandomSource $$2) {
        int $$3 = Mth.nextInt($$2, $$1.getMinLevel(), $$1.getMaxLevel());
        if ($$0.is(Items.BOOK)) {
            $$0 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        $$0.enchant($$1, $$3);
        return $$0;
    }

    public static Builder randomEnchantment() {
        return new Builder();
    }

    public static LootItemConditionalFunction.Builder<?> randomApplicableEnchantment() {
        return EnchantRandomlyFunction.simpleBuilder($$0 -> new EnchantRandomlyFunction((List<LootItemCondition>)$$0, Optional.empty()));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment $$0) {
            this.enchantments.add($$0.builtInRegistryHolder());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantRandomlyFunction(this.getConditions(), this.enchantments.isEmpty() ? Optional.empty() : Optional.of(HolderSet.direct(this.enchantments)));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

