/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootingEnchantFunction
extends LootItemConditionalFunction {
    public static final int NO_LIMIT = 0;
    public static final MapCodec<LootingEnchantFunction> CODEC = RecordCodecBuilder.mapCodec($$02 -> LootingEnchantFunction.commonFields($$02).and($$02.group((App)NumberProviders.CODEC.fieldOf("count").forGetter($$0 -> $$0.value), (App)Codec.INT.optionalFieldOf("limit", (Object)0).forGetter($$0 -> $$0.limit))).apply((Applicative)$$02, LootingEnchantFunction::new));
    private final NumberProvider value;
    private final int limit;

    LootingEnchantFunction(List<LootItemCondition> $$0, NumberProvider $$1, int $$2) {
        super($$0);
        this.value = $$1;
        this.limit = $$2;
    }

    public LootItemFunctionType<LootingEnchantFunction> getType() {
        return LootItemFunctions.LOOTING_ENCHANT;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)ImmutableSet.of(LootContextParams.KILLER_ENTITY), this.value.getReferencedContextParams());
    }

    private boolean hasLimit() {
        return this.limit > 0;
    }

    @Override
    public ItemStack run(ItemStack $$0, LootContext $$1) {
        Entity $$2 = $$1.getParamOrNull(LootContextParams.KILLER_ENTITY);
        if ($$2 instanceof LivingEntity) {
            int $$3 = EnchantmentHelper.getMobLooting((LivingEntity)$$2);
            if ($$3 == 0) {
                return $$0;
            }
            float $$4 = (float)$$3 * this.value.getFloat($$1);
            $$0.grow(Math.round($$4));
            if (this.hasLimit()) {
                $$0.limitSize(this.limit);
            }
        }
        return $$0;
    }

    public static Builder lootingMultiplier(NumberProvider $$0) {
        return new Builder($$0);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider count;
        private int limit = 0;

        public Builder(NumberProvider $$0) {
            this.count = $$0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setLimit(int $$0) {
            this.limit = $$0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootingEnchantFunction(this.getConditions(), this.count, this.limit);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

